!----------------------------------------------------------------------
!     Copyright (c) 2009--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  tee_module ƥȥץ (, ^2  դ)
!
!  2009/12/19  ݹ
!      2012/07/09  ݹ
!
program tee_module_polvelbcTau_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use tee_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32, km=16       ! ʻ(X,Y)
  integer, parameter :: lm=10, mm=10, nm=16       ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: zyx_Polvel(0:km,0:jm-1,0:im-1)      ! ʻҥǡ
  real(8)            :: zyx_Polvel_orig(0:km,0:jm-1,0:im-1) ! ʻҥǡ
  real(8)            :: zyx_LaplaPolvel(0:km,0:jm-1,0:im-1) ! ʻҥǡ
  real(8)            :: zyx_LaplaPolvel_orig(0:km,0:jm-1,0:im-1) ! ʻҥǡ
  real(8)            :: zyx_DPolvel(0:km,0:jm-1,0:im-1)     ! ʻҥǡ
  real(8)            :: tee_Polvel(0:nm,-mm:mm,-lm:lm)      ! ڥȥǡ

  real(8)            :: zyx_Null(0:km,0:jm-1,0:im-1) =0.0D0 ! ʻҥǡ

  integer            :: l=2, m=5

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = 0.0d0, xmax=2.0d0
  real(8), parameter :: ymin = 0.0d0, ymax=2.0d0
  real(8), parameter :: zmin = -1.0d0, zmax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','tee_module_PolvelbcTau_test', &
       'tee_module poloidal velocity potential B.C. function tests')

 !---------------- ɸͤ ---------------------
  ! ڥȥ
  call tee_initial(im,jm,km,lm,mm,nm,xmin,xmax,ymin,ymax,zmin,zmax) 

 !-------------------BC-FF(Tau) ----------------------
  zyx_Polvel_orig = cos(l*pi*zyx_X) * cos(m*pi*zyx_Y) * (zyx_Z-zmin)**3 * (zyx_Z-zmax)**3
  zyx_LaplaPolvel_orig = zyx_tee(tee_Lapla_tee(tee_zyx(zyx_Polvel_orig)))

  tee_Polvel = tee_LaplaPol2PolTau_tee(tee_zyx(zyx_LaplaPolvel_orig),&
       cond='FF',new=.true.)

  zyx_Polvel = zyx_tee(tee_Polvel)
  zyx_LaplaPolvel = zyx_tee(tee_Lapla_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,poloidal]',             &
    answer = zyx_Polvel_orig,                                    &
    check = zyx_Polvel,                                          &
    significant_digits = check_digits, ignore_digits = ignore    &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,laplapol]',             &
    answer = zyx_LaplaPolvel_orig,                               &
    check = zyx_LaplaPolvel,                                     &
    significant_digits = check_digits, ignore_digits = ignore    &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,Top]',                  &
    answer = zyx_Polvel(0,:,:),                                  &
    check = zyx_Null(0,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore    &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,Bottom]',               &
    answer = zyx_Polvel(km,:,:),                                 &
    check = zyx_Null(km,:,:),                                    &
    significant_digits = check_digits, ignore_digits = ignore    &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Dz_tee(tee_Polvel)))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,Top,deriv]',            &
    answer = zyx_DPolvel(0,:,:),                                 &
    check = zyx_Null(0,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore    &
    )

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FF,Bottom,deriv]',         &
    answer = zyx_DPolvel(km,:,:),                                &
    check = zyx_Null(km,:,:),                                    &
    significant_digits = check_digits, ignore_digits = ignore    &
    )

 !-------------------BC-RR(Tau) ----------------------
  zyx_Polvel_orig = cos(l*pi*zyx_X) * cos(m*pi*zyx_Y) * (zyx_Z-zmin)**2 * (zyx_Z-zmax)**2
  zyx_LaplaPolvel_orig = zyx_tee(tee_Lapla_tee(tee_zyx(zyx_Polvel_orig)))

  tee_Polvel = tee_LaplaPol2PolTau_tee(tee_zyx(zyx_LaplaPolvel_orig),&
       cond='RR',new=.true.)

  zyx_Polvel = zyx_tee(tee_Polvel)
  zyx_LaplaPolvel = zyx_tee(tee_Lapla_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,poloidal]',              &
    answer = zyx_Polvel_orig,                                     &
    check = zyx_Polvel,                                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,laplapol]',              &
    answer = zyx_LaplaPolvel_orig,                                &
    check = zyx_LaplaPolvel,                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,Top]',                   &
    answer = zyx_Polvel(0,:,:),                                   &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,Bottom]',                &
    answer = zyx_Polvel(km,:,:),                                  &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,Top,deriv]',             &
    answer = zyx_DPolvel(0,:,:),                                  &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RR,Bottom,deriv]',          &
    answer = zyx_DPolvel(km,:,:),                                 &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

 !-------------------BC-RF(Tau) ----------------------
  zyx_Polvel_orig = cos(l*pi*zyx_X) * cos(m*pi*zyx_Y) * (zyx_Z-zmin)**3 * (zyx_Z-zmax)**2
  zyx_LaplaPolvel_orig = zyx_tee(tee_Lapla_tee(tee_zyx(zyx_Polvel_orig)))

  tee_Polvel = tee_LaplaPol2PolTau_tee(tee_zyx(zyx_LaplaPolvel_orig),&
       cond='RF',new=.true.)

  zyx_Polvel = zyx_tee(tee_Polvel)
  zyx_LaplaPolvel = zyx_tee(tee_Lapla_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,poloidal]',              &
    answer = zyx_Polvel_orig,                                     &
    check = zyx_Polvel,                                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,laplapol]',              &
    answer = zyx_LaplaPolvel_orig,                                &
    check = zyx_LaplaPolvel,                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,Top]',                   &
    answer = zyx_Polvel(0,:,:),                                   &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,Bottom]',                &
    answer = zyx_Polvel(km,:,:),                                  &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,Top,deriv]',             &
    answer = zyx_DPolvel(0,:,:),                                  &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Dz_tee(tee_Polvel)))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,Bottom,deriv]',          &
    answer = zyx_DPolvel(km,:,:),                                 &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

 !-------------------BC-FR(Tau) ----------------------
  zyx_Polvel_orig = cos(l*pi*zyx_X) * cos(m*pi*zyx_Y) * (zyx_Z-zmin)**2 * (zyx_Z-zmax)**3
  zyx_LaplaPolvel_orig = zyx_tee(tee_Lapla_tee(tee_zyx(zyx_Polvel_orig)))

  tee_Polvel = tee_LaplaPol2PolTau_tee(tee_zyx(zyx_LaplaPolvel_orig),&
       cond='FR',new=.true.)

  zyx_Polvel = zyx_tee(tee_Polvel)
  zyx_LaplaPolvel = zyx_tee(tee_Lapla_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FR,poloidal]',              &
    answer = zyx_Polvel_orig,                                     &
    check = zyx_Polvel,                                           &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FR,laplapol]',              &
    answer = zyx_LaplaPolvel_orig,                                &
    check = zyx_LaplaPolvel,                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FR,Top]',                   &
    answer = zyx_Polvel(0,:,:),                                   &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FR,Bottom]',                &
    answer = zyx_Polvel(km,:,:),                                  &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Dz_tee(tee_Polvel)))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [FR,Top,deriv]',             &
    answer = zyx_DPolvel(0,:,:),                                  &
    check = zyx_Null(0,:,:),                                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  zyx_DPolvel = zyx_tee(tee_Dz_tee(tee_Polvel))

  call AssertEqual(&
    message='tee_LaplaPol2PolTau_tee [RF,Bottom,deriv]',          &
    answer = zyx_DPolvel(km,:,:),                                 &
    check = zyx_Null(km,:,:),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','tee_module_PolvelbcTau_test', &
       'tee_module poloidal velocity potential B.C. function tests succeeded!')

end program tee_module_polvelbcTau_test

