!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_module ƥȥץ :: wq_module ѴؿΥƥ
!
!  2012/04/03  ݹ
!
program wtq_module_base_wq_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8), allocatable ::  xyr_data(:,:,:)

  real(8) :: pi

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wtq_module_wq_base_test', &
                         'wtq_module wq-basic transformation functions tests') 

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  allocate(xyr_data(0:im-1,jm,kmi))

  !---- Y_1^* Υƥ ----
  xyr_data = sqrt(3.0D0)*sin(xyr_Lat)*xyr_Rad        ! r Y_1^0 
  call AssertEqual(&
    message='xyr_wq with r Y_1^0',                                &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xyr_data = sqrt(3.0D0/2)*cos(xyr_Lat)*cos(xyr_Lon)*xyr_Rad**3   ! r^3Y_1^1 
  call AssertEqual(&
    message='xyr_wq with r^3 Y_1^1',                              &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xyr_data = -sqrt(3.0D0/2)*cos(xyr_Lat)*sin(xyr_Lon) * xyr_Rad**5  !r^5Y_1^{-1}
  call AssertEqual(&
    message='xyr_wq with r^5 Y_1^-1',                             &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^* Υƥ ----
  !r^2 Y_2^0
  xyr_data = sqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1/2.0) * xyr_Rad**2
  call AssertEqual(&
    message='xyr_wq with r^2 Y_2^0',                              &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^4 Y_2^1 
  xyr_data = sqrt(5.0D0/6)*3.0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
            * xyr_Rad**4
  call AssertEqual(&
    message='xyr_wq with r^4 Y_2^1',                              &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^6 Y_2^-2
  xyr_data = -sqrt(5.0D0/24)*3.0*cos(xyr_Lat)**2*sin(2*xyr_Lon)* xyr_Rad**6
  call AssertEqual(&
    message='xyr_wq with r^6 Y_2^-2',                             &
    answer = xyr_data,                                            &
    check = xyr_wq(wq_xyr(xyr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wtq_module_base_wq_test', &
                         'wtq_module wq-basic functions tests succeeded!') 


end program wtq_module_base_wq_test
