#
# umpk01.rb
#
# $Id: umpk01.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


np = 14

#-- data ---
ntr =           [10,   11,   12,   13,   14,   15,   20,
                 21,   22,   23,   30,   31,   32,   33]
fct = NArray[0.12, 0.12, 0.14, 0.14, 0.14, 0.14, 0.11,
               0.16, 0.12, 0.12, 0.40, 0.12, 0.12, 0.17]

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn(-(iws.abs))

DCL::slrat(2.0, 3.0)
DCL::sldiv('Y', 2, 3)

DCL::sgrset('STLAT1', 45.0)
DCL::sgrset('STLAT2', 30.0)

DCL::umlset('LGRIDMN', false)
DCL::umiset('INDEXMJ', 1)

for i in 0..np-1
  DCL::sgfrm
  DCL::sgssim(fct[i], 0.0, 0.0)
  DCL::sgsmpl(0.0, 90.0, 0.0)
  DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)

  if ( ntr[i] == 30 )
    DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
  else
    DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
  end
  DCL::sgstrn(ntr[i])
  DCL::sgstrf

  DCL::sglset('LCLIP', true)
  DCL::slpwwr(1)
  DCL::slpvpr(1)
  cttl = DCL::sgtrnl(ntr[i])
  DCL::sgtxzr(0.5, 0.95, cttl, 0.03, 0, 0, 3)

  DCL::umpmap('coast_world')
  DCL::umpglb

  if ( ntr[i] == 23 )
    DCL::sgfrm
    DCL::sgfrm
  end
end

DCL::sgcls

