require "mkmf"
require "rbconfig"
begin
  require "fileutils"
rescue LoadError
  require "ftools"
  module FileUtils
    def copy(src, dst); File.copy(src, dst); end
    module_function :copy
  end
end

dir_config('narray',$sitearchdir,$sitearchdir)
if ( ! ( have_header("narray.h") && have_header("narray_config.h") ) ) then
   print <<-EOS
   ** configure error **  
   Header narray.h or narray_config.h is not found. If you have these files in 
   /narraydir/include, try the following:

   % ruby extconf.rb --with-narray-include=/narraydir/include

   EOS
   exit(-1)
end

initcfile_default = "init.c.default"
initcfile = "init.c"

if(xsystem("which cdclconfig"))
  cflags = `cdclconfig --cflags`.gsub(/\n/, " ")
  ldflags = `cdclconfig --ldflags`.gsub(/\n/, " ")
  ldlibs = `cdclconfig --ldlibs`.gsub(/-R.*?\s/, " ").gsub(/\n/, " ")
  print "checking DCL version... "
  dclversion = `cdclconfig --dclversion`.strip
  print "DCL Version: #{dclversion}\n"
  dclver = dclversion.gsub(/\./,'')
  dclver = dclver+'0' if dclver.length <= 2   # 53 --> 530 etc
  if dclversion < "5.2"
    raise "Supported DCL version is 5.2 or later, while you have #{dclversion}"
  end
  dclversionmacro = ' -DDCLVER='+dclver

  $CFLAGS += ' '+cflags  + dclversionmacro
  $LOCAL_LIBS += ' ' + ldflags
  $LOCAL_LIBS += ldlibs

  fin = File.open(initcfile_default)
  fout = File.open(initcfile,'w')
  while(line = fin.gets)
    fout.puts(line.sub(/DCLVersion/,'"'+dclversion+'"'))
  end
  fout.close
  fin.close

else
  print "**Warning** cdclconfig is not found. Assume C version of DCL 5.2\n"
  dcllibname = "cdcl52"
  f2clibname = "f2c4dcl"
  xlibname = "X11"
  dcllibdir = "-L/usr/local/lib"
  f2clibdir = "-L/usr/local/lib"
  xlibdir = "-L/usr/local/X11R6/lib"
  f2cincdir = "-I/usr/local/include"
  $CFLAGS += f2cincdir
  if(dcllibdir != f2clibdir)
    libdir = " "+dcllibdir
  else
    libdir = " "+dcllibdir+" "+f2clibdir
  end
  $LOCAL_LIBS += " "+libdir+" "+xlibdir
  $LOCAL_LIBS += " -l"+dcllibname+" -l"+f2clibname+" -l"+xlibname+" -lsocket -lnsl"

  FileUtils.copy(initcfile_default, initcfile)
end

if /cygwin|mingw/ =~ RUBY_PLATFORM
   have_library("narray") || raise("ERROR: narray import library is not found")
end

create_makefile("numru/dcl_raw")

######  Modify Makefile: #######
File.rename("Makefile","Makefile.orig")
oldmkfl = File.open("Makefile.orig")
newmkfl = File.open("Makefile","w")
oldmkfl.each_line{ |line|
   case(line)
   when /^distclean:/
      newmkfl.puts(line)
      newmkfl.puts("\t\t@$(RM) Makefile.orig")
      newmkfl.puts("\t\t@$(RM) init.c")
   else
      newmkfl.puts(line)
   end
}
newmkfl.close
