/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_cladj(obj, chr)
    VALUE obj, chr;
{
    char *io_chr;

    if (TYPE(chr) != T_STRING) {
      chr = rb_funcall(chr, rb_intern("to_str"), 0);
    }

    io_chr = ALLOCA_N(char, strlen(StringValuePtr(chr))+1);
    strcpy(io_chr, StringValuePtr(chr));


    cladj_(io_chr, (ftnlen)strlen(io_chr));

    chr = rb_str_new2(io_chr);


    return chr;

}

static VALUE
dcl_lenb(obj, c)
    VALUE obj, c;
{
    char *i_c;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(c) != T_STRING) {
      c = rb_funcall(c, rb_intern("to_str"), 0);
    }

    i_c = StringValuePtr(c);


    o_rtn_val = lenb_(i_c, (ftnlen)strlen(i_c));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_lenc(obj, c)
    VALUE obj, c;
{
    char *i_c;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(c) != T_STRING) {
      c = rb_funcall(c, rb_intern("to_str"), 0);
    }

    i_c = StringValuePtr(c);


    o_rtn_val = lenc_(i_c, (ftnlen)strlen(i_c));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_leny(obj, c)
    VALUE obj, c;
{
    char *i_c;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(c) != T_STRING) {
      c = rb_funcall(c, rb_intern("to_str"), 0);
    }

    i_c = StringValuePtr(c);


    o_rtn_val = leny_(i_c, (ftnlen)strlen(i_c));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_lenz(obj, c)
    VALUE obj, c;
{
    char *i_c;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(c) != T_STRING) {
      c = rb_funcall(c, rb_intern("to_str"), 0);
    }

    i_c = StringValuePtr(c);


    o_rtn_val = lenz_(i_c, (ftnlen)strlen(i_c));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_cradj(obj, chr)
    VALUE obj, chr;
{
    char *io_chr;

    if (TYPE(chr) != T_STRING) {
      chr = rb_funcall(chr, rb_intern("to_str"), 0);
    }

    io_chr = ALLOCA_N(char, strlen(StringValuePtr(chr))+1);
    strcpy(io_chr, StringValuePtr(chr));


    cradj_(io_chr, (ftnlen)strlen(io_chr));

    chr = rb_str_new2(io_chr);


    return chr;

}

static VALUE
dcl_crvrs(obj, chr)
    VALUE obj, chr;
{
    char *io_chr;

    if (TYPE(chr) != T_STRING) {
      chr = rb_funcall(chr, rb_intern("to_str"), 0);
    }

    io_chr = ALLOCA_N(char, strlen(StringValuePtr(chr))+1);
    strcpy(io_chr, StringValuePtr(chr));


    crvrs_(io_chr, (ftnlen)strlen(io_chr));

    chr = rb_str_new2(io_chr);


    return chr;

}
void
init_math1_chrlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "cladj", dcl_cladj, 1);
    rb_define_module_function(mDCL, "lenb", dcl_lenb, 1);
    rb_define_module_function(mDCL, "lenc", dcl_lenc, 1);
    rb_define_module_function(mDCL, "leny", dcl_leny, 1);
    rb_define_module_function(mDCL, "lenz", dcl_lenz, 1);
    rb_define_module_function(mDCL, "cradj", dcl_cradj, 1);
    rb_define_module_function(mDCL, "crvrs", dcl_crvrs, 1);
}
