#!/usr/bin/perl
# config.pl: OS dependent Makefile generator
# Copyright (C) TOYODA Eizi, 1998.  All rights reserved.

$MSDOS = &MSDOS;
if ($MSDOS) {
	$BASEDIR = undef;
	$BINDIR = 'C:\\WINDOWS\\COMMAND';
	$BINDIR = 'C:\\TOOLS' if -d 'C:\\TOOLS';
	$OSTYPE = 'dos';
	$CP = 'copy';
	$INSTALL = 'copy';
	$INSTALLBIN = 'copy';
	$INSTALLDIR = 'mkdir';
	$INSTALLDEP = 'install.bin';
	$CAT = 'type';
	$UUDECODE = 'uudecode';
	$EXE = '.com';
} else {
	# UNIX
	$BASEDIR = '/usr/local';
	$OSTYPE = 'ux';
	$CP = 'cp';
	$INSTALL = 'install';
	$INSTALLBIN = 'install -m 0755';
	$INSTALLDIR = 'install -d';
	$INSTALLDEP = 'install.bin install.doc';
	$CAT = 'cat';
	$UUDECODE = 'uudecode';
	$EXE = '';
}

while ($_ = shift) {
	/^BASEDIR=(.*)/ && ($BASEDIR = $1, next);
}

if (defined $BASEDIR) {
	$BINDIR = "$BASEDIR/bin";
	$MANDIR = "$BASEDIR/man";
	$DOCDIR = "$BASEDIR/doc";
}

&GenerateMakefile("Makefile.src", "Makefile");
&GenerateMakefile("doc/Makefile.src", "doc/Makefile");
	
exit 0;

sub GenerateMakefile {
	($input, $output) = @_;
	print "<$input >$output\n";
	open($input, "<$input") || die "$0: $input";
	open($output, ">$output") || die "$0: $output";
	
	print $output "# Makefile generated by config.pl.\n";
	print $output "CP         = $CP\n";
	print $output "CAT        = $CAT\n";
	print $output "EXE        = $EXE\n";
	print $output "OSTYPE     = $OSTYPE\n";
	print $output "BINDIR     = $BINDIR\n";
	print $output "MANDIR     = $MANDIR\n";
	print $output "DOCDIR     = $DOCDIR\n";
	print $output "INSTALL    = $INSTALL\n";
	print $output "INSTALLBIN = $INSTALLBIN\n";
	print $output "INSTALLDIR = $INSTALLDIR\n";
	print $output "INSTALLDEP = $INSTALLDEP\n";
	print $output "UUDECODE = $UUDECODE\n";
	while (<$input>) {
		if (/\t\/\/(.*)\/\/\s*(.*)/) {
			if ($MSDOS) {
				print $output "\tcd $1\n\t$2\n\tcd ..\n";
			} else {
				print $output "\tcd $1; $2\n";
			}
			next;
		}
		if ($MSDOS) {
			s/^-d//;
			s/^-./#/;
		} else {
			s/^-d/#/;
			s/^-.//;
		}
		print $output $_;
	}
}

	# it's not complete....
sub MSDOS {
	# MS-DOS has no /dev/null.
	return 0 if ( -c '/dev/null' );
	# MS-DOS has /DEV/CON even in drive without /DEV.
	return 1 if ( -f '/DEV/CoN' && ! -d '/DEV' );
	# MS-DOS allows CON or NUL have extension.
	return 2 if ( -f '/coN.3b7' && -f '/NuL.j0Q' && -f '/nUl.!#$' );
	0;
}

