!= ˴ؤ
!
!= Settings of array for atmospheric composition
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: composition.f90,v 1.2 2009-09-01 15:37:30 yot Exp $ 
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module composition
  !
  != ˴ؤ
  !
  != Settings of array for atmospheric composition
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ˴ؤ
  !
  ! Settings of array for atmospheric composition
  !
  !== Variables List
  !
  ! ncmax        :: ʬο
  ! ------------ :: ------------
  ! ncmax        :: Number of minor comstituents
  !
  !== Procedures List
  !
  ! CompositionInit :: ˴ؤ
  ! --------------  :: ------------
  ! CompositionInit :: Settings of parameters for array for composition
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#composition_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP,     & ! ټ¿. Double precision. 
                      STRING    ! ʸ. Strings.

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: CompositionInit

  ! ѿ
  ! Public variables
  !
  logical          , save, public             :: composition_inited = .false.
                              ! ե饰. 
                              ! Initialization flag
  integer          , save, public             :: ncmax
                              ! ʬο
                              ! Number of composition
  character(STRING), save, public, allocatable:: QMixName(:)
                              ! ʬѿ̾
                              ! Name of variables for composition
  character(STRING), save, public, allocatable:: QMixLongName(:)
                              ! ʬĹѿ̾
                              ! Long name of variables for composition
  integer          , save, public             :: IndexH2OVap
                              ! Υǥå
                              ! Index for water vapor

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'composition'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: composition.f90,v 1.2 2009-09-01 15:37:30 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface CompositionInit
    module procedure CompositionInit
  end interface

contains

  subroutine CompositionInit
    !
    ! composition ⥸塼νԤޤ. 
    ! NAMELIST#composition_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "composition" module is initialized. 
    ! NAMELIST#composition_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /composition_nml/ ncmax, IndexH2OVap
          !
          ! ǥեͤˤĤƤϽ³ "composition#CompositionInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "composition#CompositionInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( composition_inited ) return
!!$    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    ncmax       = 1
    IndexH2OVap = 1

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,            & ! (in)
        & nml = composition_nml, & ! (out)
        & iostat = iostat_nml    & ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = composition_nml )
    end if

    ! 󥵥Υå
    ! Check number of array size
    !
    if ( ncmax < 1 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of composition has to be greater than 0. ' // &
        & 'ncmax=%d' , &
        & i = (/ ncmax /) )
    end if

    ! ΥǥåΥå
    ! Check index for water vapor
    !
    if ( ( IndexH2OVap < 1 ) .or. ( IndexH2OVap > ncmax ) ) then
      call MessageNotify( 'E', module_name, &
        & 'IndexH2OVap has to be greater than or equal to 1 and less than or equal to ncmax. ' // &
        & 'IndexH2OVap=%d' , &
        & i = (/ IndexH2OVap /) )
    end if


    ! Set variable name of constituents for ouptut
    !
    allocate( QMixName    ( ncmax ) )
    allocate( QMixLongName( ncmax ) )
    if ( ncmax > 99 ) then
      call MessageNotify( 'E', module_name, &
        & 'number of composition greater than 99 is inappropriate for current version. ' // &
        & 'ncmax=%d' , &
        & i = (/ ncmax /) )
    end if
    do n = 1, IndexH2OVap-1
      write( QMixName(n), '(a,i3.3)' ) "QMix", n
      QMixLongName(n) = QMixName(n)
    end do
    n = IndexH2OVap
    QMixName    (n) = "QVap"
    QMixLongName(n) = "specific humidity"
    do n = IndexH2OVap+1, ncmax
      write( QMixName(n), '(a,i3.3)' ) "QMix", n
      QMixLongName(n) = QMixName(n)
    end do

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '    ncmax              = %d', i = (/ ncmax /) )
    call MessageNotify( 'M', module_name, '    IndexH2OVap        = %d', i = (/ IndexH2OVap /) )
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    QMixName(%d)     = %c', i = (/ n /), c1 = trim(QMixName(n)) )
    end do
    do n = 1, ncmax
      call MessageNotify( 'M', module_name, '    QMixLongName(%d) = %c', i = (/ n /), c1 = trim(QMixLongName(n)) )
    end do
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    composition_inited = .true.
  end subroutine CompositionInit

  !-------------------------------------------------------------------

!!$  subroutine InitCheck
!!$    !
!!$    ! ¸⥸塼νå
!!$    !
!!$    ! Check initialization of dependency modules
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_util_inited
!!$
!!$    ! å
!!$    ! Message output
!!$    !
!!$    use dc_message, only: MessageNotify
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. namelist_util_inited ) &
!!$      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
!!$
!!$  end subroutine InitCheck

end module composition
