!= ɽ̥ǡ
!
!= Setting planetary surface properties
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: surface_properties.F90,v 1.3 2010-01-22 05:26:49 yot Exp $ 
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_properties
  !
  != ɽ
  !
  != Setting planetary surface properties
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤ɽ̤̽ꤷޤ. 
  !
  ! Data about sea surface temperature (SST) or various values on surface
  ! are set. 
  !
  !== Procedures List
  ! SetSurfaceProperties  :: ɽ
  !--
!!$  ! GroundFileOpen   :: ɽ̥ǡեΥץ
!!$  ! GroundFileOutput :: ɽ̥ǡեؤΥǡ
!!$  ! GroundFileClose  :: ɽ̥ǡեΥ
  !++
  ! ------------     :: ------------
  ! SetSurfaceProperties  :: Setting surface properties
  !--
!!$  ! GroundFileOpen   :: Open ground data file
!!$  ! GroundFileOutput :: Data output to ground data file
!!$  ! GroundFileClose  :: Close ground data file
  !++
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_properties_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gtool_history, only: GT_HISTORY

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
!!$  public:: GroundFileOpen, GroundFileClose, GroundFileOutPut
  public:: SetSurfaceProperties

  ! ѿ
  ! Public variables
  !
  logical, save, public:: surface_properties_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

!!$  logical, save, public:: ground_file_opened = .false.
!!$                              ! ɽ̥ǡեΥץ˴ؤե饰. 
!!$                              ! Flag of ground data file open

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: SurfTempSetting
                              ! ɽ̲٤ˡ
                              ! Setting of surface temperature
  character(STRING), save:: SurfTempFile
                              ! ɽ̲٤Υե̾. 
                              ! File name of surface temperature
  character(TOKEN) , save:: SurfTempName
                              ! ɽ̲٤ѿ̾. 
                              ! Variable name of surface temperature

  character(STRING), save:: SeaIceSetting
                              ! ɹ̩٤ˡ
                              ! Setting of sea ice concentration
  character(STRING), save:: SeaIceFile
                              ! ɹ̩٤Υե̾. 
                              ! File name of sea ice concentration
  character(TOKEN) , save:: SeaIceName
                              ! ɹ̩٤ѿ̾. 
                              ! Variable name of sea ice concentration

  character(STRING), save:: AlbedoSetting
                              ! ɽ٥ɤˡ
                              ! Settingof surface albedo
  character(STRING), save:: AlbedoFile
                              ! ɽ٥ɤΥե̾. 
                              ! File name of surface albedo
  character(TOKEN) , save:: AlbedoName
                              ! ɽ٥ɤѿ̾. 
                              ! Variable name of surface albedo

  character(STRING), save:: HumidCoefSetting
                              ! ɽ٤ˡ
                              ! Setting of surface humidity coefficient
  character(STRING), save:: HumidCoefFile
                              ! ɽ٤Υե̾. 
                              ! File name of surface humidity coefficient
  character(TOKEN) , save:: HumidCoefName
                              ! ɽ٤ѿ̾. 
                              ! Variable name of surface humidity coefficient

  character(STRING), save:: RoughLengthSetting
                              ! ɽĹˡ
                              ! Setting of surface rough length
  character(STRING), save:: RoughLengthFile
                              ! ɽĹΥե̾. 
                              ! File name of surface rough length
  character(TOKEN) , save:: RoughLengthName
                              ! ɽĹѿ̾. 
                              ! Variable name of surface rough length

  character(STRING), save:: HeatCapacitySetting
                              ! ɽǮ̤ˡ
                              ! Setting of surface heat capacity
  character(STRING), save:: HeatCapacityFile
                              ! ɽǮ̤Υե̾. 
                              ! File name of surface heat capacity
  character(TOKEN) , save:: HeatCapacityName
                              ! ɽǮ̤ѿ̾. 
                              ! Variable name of surface heat capacity

  character(STRING), save:: TempFluxSetting
                              ! Ǯեåˡ
                              ! Setting of ground temperature flux
  character(STRING), save:: TempFluxFile
                              ! ǮեåΥե̾. 
                              ! File name of ground temperature flux
  character(TOKEN) , save:: TempFluxName
                              ! Ǯեåѿ̾. 
                              ! Variable name of ground temperature flux

  character(STRING), save:: SurfCondSetting
                              ! ɽ֤ˡ
                              ! Setting of surface condition
  character(STRING), save:: SurfCondFile
                              ! ɽ֤Υե̾. 
                              ! File name of surface condition
  character(TOKEN) , save:: SurfCondName
                              ! ɽ֤ѿ̾. 
                              ! Variable name of surface condition

  character(STRING), save:: SurfHeightSetting
                              ! ɽ̹٤ˡ
                              ! Setting of surface height
  character(STRING), save:: SurfHeightFile
                              ! ɽ̹٤Υե̾. 
                              ! File name of surface height
  character(TOKEN) , save:: SurfHeightName
                              ! ɽ̹٤ѿ̾. 
                              ! Variable name of surface height


!!$  character(STRING), save:: OutputFile
!!$                              ! Ϥɽ̥ǡΥե̾
!!$                              ! filename of output ground data
!!$  real(DP), save:: IntValue
!!$                              ! ɽ̥ǡνϴֳ. 
!!$                              ! Interval of ground data output
!!$  character(TOKEN):: IntUnit
!!$                              ! ɽ̥ǡνϴֳ֤ñ. 
!!$                              ! Unit for interval of ground data output
!!$
!!$  type(GT_HISTORY), save:: gthst_grd
!!$                              ! ɽ̥ǡ gtool_history#GT_HISTORY ѿ
!!$                              ! "gtool_history#GT_HISTORY" variable for ground data
!!$
!!$
!!$  type(DC_DIFFTIME), save:: PrevOutputTime
!!$                              ! νϻ. 
!!$                              ! Previous output time
!!$
!!$  type(DC_DIFFTIME), save:: IntTime
!!$                              ! ꥹȥǡνϻ. 
!!$                              ! Time interval of restart data output

  character(*), parameter:: module_name = 'surface_properties'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: surface_properties.F90,v 1.3 2010-01-22 05:26:49 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
!!$  interface GroundFileOpen
!!$    module procedure GroundFileOpen
!!$  end interface
!!$
!!$  interface GroundFileClose
!!$    module procedure GroundFileClose
!!$  end interface
!!$
!!$  interface GroundFileOutput
!!$    module procedure GroundFileOutput
!!$  end interface

  interface SetSurfaceProperties
    module procedure SetSurfaceProperties
  end interface

contains

  subroutine SetSurfaceProperties(                  &
    & FlagSSModelSO,                                & ! (in)    optional
    & xy_SoilMoistB, xy_SurfSnowB,                  & ! (in)    optional
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef, & ! (inout) optional
    & xy_SurfRoughLength, xy_SurfHeatCapacity,      & ! (inout) optional
    & xy_GroundTempFlux, xy_SurfCond,               & ! (inout) optional
    & xy_SurfHeight,                                & ! (inout) optional
    & xy_SeaIceConc                                 & ! (inout) optional
    & )
    !
    ! ɽꤷޤ. 
    !
    ! Set surface properties. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: SeaIceThreshold

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    use surface_data, only: SetSurfData

    ! Matthews Υǡ˴Ťɽ̥٥
    ! set surface albedo based on data by Matthews
    !
    use albedo_Matthews, only: SetAlbedoMathews

    ! Хĥǥ
    ! Bucket model
    !
    use Bucket_Model, only : BucketModHumidCoef

    ! ȳɹˤ륢٥Ѳ
    ! modification of surface albedo on the snow covered ground and on the sea ice
    !
    use modify_albedo_snowseaice, only: ModAlbedoDueToSnowSeaIce

    ! Ĺ, Φ̤ȳΤκΤ߹θ
    ! Set roughness length, only considering land-ocean contrast
    !
    use roughlen_landoceancontrast, only: SetRoughLenLandOceanContrast

    ! Matthews Υǡ˴Ť٤
    ! set roughness length on land surface based on data by Matthews
    !
    use roughlen_Matthews, only: SetRoughLenLandMatthews

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    use read_time_series, only: SetValuesFromTimeSeriesWrapper

    ! ʸ ; Declaration statements
    !
    implicit none
    logical , intent(in   ), optional:: FlagSSModelSO
                              ! ֥ 󡿥.
                              ! flag for use of slab ocean on/off
    real(DP), intent(in   ), optional:: xy_SoilMoistB(0:imax-1, 1:jmax)
                              ! $ M_ws (t-\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
    real(DP), intent(in   ), optional:: xy_SurfSnowB(0:imax-1, 1:jmax)
                              ! $ M_ss (t-\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
    real(DP), intent(inout), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(inout), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(inout), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(inout), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(inout), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(inout), optional:: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer , intent(inout), optional:: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ (0: , 1: ). 
                              ! Surface condition (0: fixed, 1: variable)
    real(DP), intent(inout), optional:: xy_SurfHeight (0:imax-1, 1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(inout), optional:: xy_SeaIceConc(0:imax-1,1:jmax)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1)

    ! ѿ
    ! Work variables
    !
    real(DP), allocatable, save:: xy_SurfTempSave (:,:)
                              ! ɽ̲٤¸ (K)
                              ! Saved values of surface temperature (K)
    real(DP), allocatable, save:: xy_SeaIceConcSave(:,:)
                              ! ɹ̩٤¸
                              ! Saved values of sea ice concentration
    real(DP), allocatable, save:: xy_SurfAlbedoSave(:,:)
                              ! ٥ɤ¸
                              ! Saved values of albedo

    logical, save:: flag_first_SurfCond = .true.
                              ! 򼨤ե饰. 
                              ! Flag that indicates first loop
                              !
    logical, save:: flag_first_SeaIceConc       = .true.
    logical, save:: flag_first_SurfTemp         = .true.
    logical, save:: flag_first_SurfHeight       = .true.
    logical, save:: flag_first_SurfAlbedo       = .true.
    logical, save:: flag_first_SurfHumidCoef    = .true.
    logical, save:: flag_first_SurfRoughLength  = .true.
    logical, save:: flag_first_SurfHeatCapacity = .true.
    logical, save:: flag_first_GroundTempFlux   = .true.

    logical:: flag_mpi_init
#ifdef LIB_MPI
    integer:: err_mpi
#endif

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude


    ! ¹ʸ ; Executable statement
    !

    if ( .not. surface_properties_inited ) call SurfacePropertiesInit


#ifdef LIB_MPI
    ! MPI ˤԤƤ뤫ǧ. 
    ! Confirm initialization of MPI
    !
    call MPI_Initialized(flag_mpi_init, err_mpi)
#else
    flag_mpi_init = .false.
#endif


    ! NOTICE:
    ! The surface condition has to be set, before other fields are set.
    !
    ! ɽ
    ! Surface condition
    !
    if ( present(xy_SurfCond) ) then

      if ( SurfCondSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfCond ) then
          call HistoryGet( &
            & SurfCondFile, SurfCondName, &     ! (in)
            & xy_SurfCond, &                    ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( SurfCondSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfCond ) then
          call SetSurfData( &
            & xy_SurfCond = xy_SurfCond &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfCondSetting = %c is not appropriate.', &
          & c1 = trim(SurfCondSetting) )
      end if

      flag_first_SurfCond = .false.

    end if


    ! NOTICE:
    ! The sea ice distribution has to be set, before set surface temperature. 
    !
    ! ɹ̩
    ! Sea ice concentration
    !
    if ( present(xy_SeaIceConc) ) then

      if ( flag_first_SeaIceConc ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SeaIceConcSave(0:imax-1, 1:jmax) )
      end if
      if ( SeaIceSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SeaIceConc ) then
          call HistoryGet( &
            & SeaIceFile, SeaIceName,          & ! (in)
            & xy_SeaIceConcSave,               & ! (out)
            & flag_mpi_split = flag_mpi_init )   ! (in) optional
        end if
        call SetValuesFromTimeSeriesWrapper(    &
          & SeaIceFile, SeaIceName,             &
          & xy_SeaIceConcSave,                  &               ! (inout)
          & 'SIC'                               &
          & )
      else if ( SeaIceSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SeaIceConc ) then
          call SetSurfData( &
            & xy_SeaIceConc = xy_SeaIceConcSave &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SeaIceSetting = %c is not appropriate.', &
          & c1 = trim(SeaIceSetting) )
      end if
      ! ɹ̩٤ ( xy_SurfCond == 0 ξΤ )
      ! Setting of sea ice concentration ( where xy_SurfCond == 0 only )
      !
      xy_SeaIceConc = xy_SeaIceConcSave

      flag_first_SeaIceConc = .false.

    end if


    ! NOTICE:
    ! Before set surface temperature, sea ice distribution has to be set.
    !
    ! ɽ̲
    ! surface temperature
    !
    if ( present(xy_SurfTemp) ) then

      if ( flag_first_SurfTemp ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SurfTempSave  (0:imax-1, 1:jmax) )
      end if
      if ( SurfTempSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfTemp ) then
          call HistoryGet( &
            & SurfTempFile, SurfTempName, &    ! (in)
            & xy_SurfTempSave, &               ! (out)
            & flag_mpi_split = flag_mpi_init ) ! (in) optional
        end if
        call SetValuesFromTimeSeriesWrapper(    &
          & SurfTempFile, SurfTempName,         &
          & xy_SurfTempSave,                    &               ! (inout)
          & 'SST'                               &
          & )
      else if ( SurfTempSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfTemp ) then
          call SetSurfData( &
            & xy_SurfTemp = xy_SurfTempSave & ! (out) optional
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfTempSetting = %c is not appropriate.', &
          & c1 = trim(SurfTempSetting) )
      end if
      ! ɽ̲٤ SST ֤ ( xy_SurfCond <=0 ξΤ )
      ! Surface temperature is replaced with SST ( only xy_SurfCond <=0 )
      !
      if ( present(xy_SurfTemp) ) then
        do j = 1, jmax
          do i = 0, imax-1
            if ( ( xy_SurfCond(i,j)     <= 0              ) .and. &
              &  ( xy_SurfTempSave(i,j) >  0.0_DP         ) .and. &
              &  ( xy_SeaIceConc(i,j)   < SeaIceThreshold ) ) then

              if ( ( .not. present( FlagSSModelSO ) ) .or. &
                &  ( .not. FlagSSModelSO ) ) then
                xy_SurfTemp(i,j) = xy_SurfTempSave(i,j)
              end if

            end if
          end do
        end do
      end if

      flag_first_SurfTemp = .false.
    end if


    ! Ϸ
    ! Topography
    !
    if ( present(xy_SurfHeight) ) then

      if ( SurfHeightSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHeight ) then
          call HistoryGet( &
            & SurfHeightFile, SurfHeightName, &  ! (in)
            & xy_SurfHeight, &                   ! (out)
            & flag_mpi_split = flag_mpi_init )   ! (in) optional
        end if
      else if ( SurfHeightSetting == 'generate_internally' ) then
        if ( flag_first_SurfHeight ) then
          xy_SurfHeight = 0.0_DP
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' SurfHeightSetting = %c is not appropriate.', &
          & c1 = trim(SurfHeightSetting) )
      end if

      flag_first_SurfHeight = .false.
    end if


    ! NOTICE:
    ! The surface condition and sea ice concentration have to be set, before albedo 
    ! is set.
    !
    ! ٥
    ! Albedo
    !
    if ( present(xy_SurfAlbedo) ) then

      if ( flag_first_SurfAlbedo ) then
        ! ¸ѿγ
        ! Allocate a variable for save
        !
        allocate( xy_SurfAlbedoSave(0:imax-1, 1:jmax) )
      end if
      if ( AlbedoSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfAlbedo ) then
          call HistoryGet( &
            & AlbedoFile, AlbedoName, &        ! (in)
            & xy_SurfAlbedoSave,      &        ! (out)
            & flag_mpi_split = flag_mpi_init ) ! (in) optional
        end if

      else if ( AlbedoSetting == 'Matthews' ) then
        ! ٥ɤ Matthews ΥǡȤ
        ! Surface albedo is set based on Matthews' data
        !
        call SetAlbedoMathews( &
          & xy_SurfCond,      &
          & xy_SurfAlbedoSave &
          & )
      else if ( AlbedoSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        ! 
        if ( flag_first_SurfAlbedo ) then
          call SetSurfData( &
            & xy_SurfAlbedo = xy_SurfAlbedoSave  & ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' AlbedoSetting = %c is not appropriate.', &
          & c1 = trim(AlbedoSetting) )
      end if
      ! ٥ɤ
      ! Setting of albedo
      !
      xy_SurfAlbedo = xy_SurfAlbedoSave


      if ( present( xy_SurfCond ) ) then
        ! ȳɹˤ륢٥Ѳ
        ! modification of surface albedo on the snow covered ground and on the sea ice
        !
        call ModAlbedoDueToSnowSeaIce(                &
          & xy_SurfCond,                              &
          & xy_SurfSnowB, xy_SeaIceConc,              & ! (in   ) optional
          & xy_SurfAlbedo                             & ! (inout)
          & )
      else
        call MessageNotify( 'E', module_name, &
          & ' xy_SurfCond has to be present to modify albedo due to snow and sea ice.' )
      end if

      flag_first_SurfAlbedo = .false.
    end if


    ! NOTICE:
    ! The surface condition has to be set, before humidity coefficient is set.
    !
    ! ɽ̼
    ! Surface humidity coefficient
    !
    if ( present(xy_SurfHumidCoef) ) then

      if ( HumidCoefSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHumidCoef ) then
          call HistoryGet( &
            & HumidcoefFile, HumidcoefName, &  ! (in)
            & xy_SurfHumidcoef, &              ! (out)
            & flag_mpi_split = flag_mpi_init ) ! (in) optional
        end if
      else if ( HumidCoefSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfHumidCoef ) then
          call SetSurfData( &
            & xy_SurfHumidCoef = xy_SurfHumidCoef  & ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' HumidCoefSetting = %c is not appropriate.', &
          & c1 = trim(HumidCoefSetting) )
      end if

      if ( &
        & ( present( xy_SurfCond   ) ) .and. &
        & ( present( xy_SoilMoistB ) ) .and. &
        & ( present( xy_SurfSnowB  ) )       &
        & ) then

        ! Хĥǥ˴ؤɽ̼٤
        ! Setting of surface humidity coefficient
        !
        call BucketModHumidCoef(                      &
          & xy_SurfCond, xy_SoilMoistB, xy_SurfSnowB, & ! (in   )
          & xy_SurfHumidCoef                          & ! (inout)
          & )
      else
        call MessageNotify( 'E', module_name, &
          & ' xy_SurfCond and xy_SoilMoistB and Xy_SurfSnowB have to be present to modify humidity coefficient with bucket model.' )
      end if

      flag_first_SurfHumidCoef = .false.
    end if


    ! Ĺ
    ! Roughness length
    !
    if ( present(xy_SurfRoughLength) ) then

      if ( RoughLengthSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfRoughLength ) then
          call HistoryGet( &
            & RoughLengthFile, RoughLengthName, & ! (in)
            & xy_SurfRoughLength, &               ! (out)
            & flag_mpi_split = flag_mpi_init )    ! (in) optional
        end if
      else if ( RoughLengthSetting == 'LOContrast' ) then
        ! Ĺ, Φ̤ȳΤκΤ߹θ
        ! Set roughness length, only considering land-ocean contrast
        !
        call SetRoughLenLandOceanContrast( &
          & xy_SurfCond,       &
          & xy_SurfRoughLength &
          & )
      else if ( RoughLengthSetting == 'Matthews' ) then
        ! Ĺ, Matthews Υǡ˴Ť
        ! Set roughness length based on Matthews dataset
        !
        call SetRoughLenLandMatthews( &
          & xy_SurfCond,       &
          & xy_SurfRoughLength &
          & )
      else if ( RoughLengthSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfRoughLength ) then
          call SetSurfData( &
            & xy_SurfRoughLength = xy_SurfRoughLength &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' RoughLengthSetting = %c is not appropriate.', &
          & c1 = trim(RoughLengthSetting) )
      end if

      flag_first_SurfRoughLength = .false.
    end if


    ! ɽǮ
    ! Surface heat capacity
    !
    if ( present(xy_SurfHeatCapacity) ) then

      if ( HeatCapacitySetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_SurfHeatCapacity ) then
          call HistoryGet( &
            & HeatCapacityFile, HeatCapacityName, & ! (in)
            & xy_SurfHeatCapacity, &                ! (out)
            & flag_mpi_split = flag_mpi_init )      ! (in) optional
        end if
      else if ( HeatCapacitySetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_SurfHeatCapacity ) then
          call SetSurfData( &
            & xy_SurfHeatCapacity = xy_SurfHeatCapacity &          ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' HeatCapacitySetting = %c is not appropriate.', &
          & c1 = trim(HeatCapacitySetting) )
      end if

      flag_first_SurfHeatCapacity = .false.
    end if


    ! Ǯեå
    ! Ground temperature flux
    !
    if ( present(xy_GroundTempFlux) ) then

      if ( TempFluxSetting == 'file' ) then
        ! ǡե뤫
        ! Data is input from files
        !
        if ( flag_first_GroundTempFlux ) then
          call HistoryGet( &
            & TempFluxFile, TempFluxName, &     ! (in)
            & xy_GroundTempFlux, &              ! (out)
            & flag_mpi_split = flag_mpi_init )  ! (in) optional
        end if
      else if ( TempFluxSetting == 'generate_internally' ) then
        ! ǡ (ǥե)  surface_data ⥸塼뤫
        ! Data (default values) is input from "surface_data" module
        !
        if ( flag_first_GroundTempFlux ) then
          call SetSurfData( &
            & xy_GroundTempFlux = xy_GroundTempFlux &                   ! (out)
            & )
        end if
      else
        call MessageNotify( 'E', module_name, &
          & ' TempFluxSetting = %c is not appropriate.', &
          & c1 = trim(TempFluxSetting) )
      end if

      flag_first_GroundTempFlux = .false.
    end if


  end subroutine SetSurfaceProperties

  !-------------------------------------------------------------------

!!$  subroutine GroundFileOpen
!!$    !
!!$    ! ɽ̥ǡե򥪡ץ󤷤ޤ. 
!!$    !
!!$    ! A ground data file is opened. 
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ϥեδܾ
!!$    ! Basic information for output files
!!$    ! 
!!$    use fileset, only: &
!!$      & FileTitle, &
!!$                              ! ϥǡեɽ.
!!$                              ! Title of output data files
!!$      & FileSource, &
!!$                              ! ǡեμ. 
!!$                              ! Source of data file
!!$      & FileInstitution
!!$                              ! ǡեǽŪѹȿ/Ŀ. 
!!$                              ! Institution or person that changes data files for the last time
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: PI   ! $ \pi $ .
!!$                              ! ߼Ψ.  Circular constant
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    use axesset, only: &
!!$      & x_Lon, &
!!$                              ! $ \lambda $ [rad.] . . Longitude
!!$      & x_Lon_Weight, &
!!$                              ! $ \Delta \lambda $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of longitude
!!$      & y_Lat, &
!!$                              ! $ \varphi $ [rad.] . . Latitude
!!$      & y_Lat_Weight, &
!!$                              ! $ \Delta \varphi $ [rad.] . 
!!$                              ! ٺɸŤ. 
!!$                              ! Weight of latitude
!!$      & z_Sigma, &
!!$                              ! $ \sigma $ ٥ (). 
!!$                              ! Full $ \sigma $ level
!!$      & r_Sigma, &
!!$                              ! $ \sigma $ ٥ (Ⱦ). 
!!$                              ! Half $ \sigma $ level
!!$      & z_DelSigma
!!$                              ! $ \Delta \sigma $ (). 
!!$                              ! $ \Delta \sigma $ (Full)
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: &
!!$      & DelTime, &            ! $ \Delta t $ [s]
!!$      & StartTime, &          ! ׻ϻ. 
!!$                              ! Start time of calculation
!!$      & StartDate, &          ! ׻. 
!!$                              ! Start date of calculation
!!$      & StartDateValid        ! ׻ͭ. 
!!$                              ! Validation of start date of calculation
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
!!$      & HistoryPut, HistoryAddAttr
!!$
!!$    ! ʸ
!!$    ! Character handling
!!$    !
!!$    use dc_string, only: StoA
!!$
!!$    ! դӻμ갷
!!$    ! Date and time handler
!!$    !
!!$    use dc_date, only: toChar, EvalByUnit
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP):: origin_time
!!$                              ! ׻ϻ. 
!!$                              ! Start time of calculation
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. ground_file_io_inited ) call GroundFileInit
!!$    if ( ground_file_opened ) return
!!$
!!$    ! μ
!!$    ! Get time information
!!$    !
!!$    origin_time = EvalByUnit( StartTime, IntUnit )
!!$
!!$    ! ɽ̥ǡեΥץ
!!$    ! Open a ground data file
!!$    !
!!$    call HistoryCreate( &
!!$      &      file = OutputFile,   &
!!$      &     title = trim(FileTitle) // ' ground data', &          ! (in)
!!$      &    source = FileSource, institution = FileInstitution, &   ! (in)
!!$      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
!!$      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
!!$      & longnames = StoA( 'longitude', 'latitude', &
!!$      &                   'sigma at layer midpoints', &
!!$      &                   'sigma at layer end-points (half level)', &
!!$      &                   'time' ), &                              ! (in)
!!$      &     units = StoA( 'degree_east', 'degree_north', &
!!$      &                   '1', '1', IntUnit ), &                   ! (in)
!!$      &    origin = real( origin_time ), &                         ! (in)
!!$      &  interval = real( IntValue ), &                            ! (in)
!!$      &   history = gthst_grd )                                    ! (out)
!!$
!!$    ! $ \Delta t $ ˴ؤɲ
!!$    ! Add information about $ \Delta t $
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & dims = StoA(''), &                ! (in)
!!$      & longname = 'delta time', &        ! (in)
!!$      & units = 's', xtype = 'float', &   ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'deltime', &            ! (in)
!!$      & array = (/ DelTime /), &          ! (in)
!!$      & history = gthst_grd )             ! (inout)
!!$
!!$    ! ɸǡ
!!$    ! Axes data settings
!!$    !
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'standard_name', &   ! (in)
!!$      & value = 'longitude', &                           ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'standard_name', &   ! (in)
!!$      & value = 'latitude', &                            ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'standard_name', &   ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
!!$      & value = 'atmosphere_sigma_coordinate', &         ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'time', attrname = 'standard_name', &  ! (in)
!!$      & value = 'time', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'positive', &        ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sigm', attrname = 'positive', &       ! (in)
!!$      & value = 'down', &                                ! (in)
!!$      & history = gthst_grd )                            ! (inout)
!!$
!!$    call HistoryPut( &
!!$      & varname = 'lon', &               ! (in)
!!$      & array = x_Lon / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat', &               ! (in)
!!$      & array = y_Lat / PI * 180.0_DP, & ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig', &               ! (in)
!!$      & array = z_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$    call HistoryPut( & 
!!$      & varname = 'sigm', &              ! (in)
!!$      & array = r_Sigma, &               ! (in)
!!$      & history = gthst_grd )            ! (inout)
!!$
!!$    ! ɸŤߤ
!!$    ! Axes weights settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'lon_weight', &                           ! (in)
!!$      & dims = StoA('lon'), &                               ! (in)
!!$      & longname = 'weight for integration in longitude', & ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lon_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'lat_weight', &                           ! (in)
!!$      & dims = StoA('lat'), &                               ! (in)
!!$      & longname = 'weight for integration in latitude', &  ! (in)
!!$      & units = 'radian', xtype = 'double', &               ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'lat_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'sig_weight', &                           ! (in)
!!$      & dims = StoA('sig'), &                               ! (in)
!!$      & longname = 'weight for integration in sigma', &     ! (in)
!!$      & units = '1', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddAttr( &
!!$      & varname = 'sig', attrname = 'gt_calc_weight', &     ! (in)
!!$      & value = 'sig_weight', &                             ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryPut( &
!!$      & varname = 'sig_weight', array = z_DelSigma, &       ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ! ͽѿ
!!$    ! Predictional variables settings
!!$    !
!!$    call HistoryAddVariable( &
!!$      & varname = 'UB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t-\Delta t)', &       ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VB', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t-\Delta t)', &      ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t-\Delta t)', &         ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapB', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t-\Delta t)', &   ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsB', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t-\Delta t)', &    ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    call HistoryAddVariable( &
!!$      & varname = 'UN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'eastward wind (at t)', &                ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'VN', &                                   ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'northward wind (at t)', &               ! (in)
!!$      & units = 'm s-1', xtype = 'double', &                ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'TempN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'temperature (at t)', &                  ! (in)
!!$      & units = 'K', xtype = 'double', &                    ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'QVapN', &                                ! (in)
!!$      & dims = StoA('lon', 'lat', 'sig', 'time'), &         ! (in)
!!$      & longname = 'specific humidity (at t)', &            ! (in)
!!$      & units = 'kg kg-1', xtype = 'double', &              ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$    call HistoryAddVariable( &
!!$      & varname = 'PsN', &                                  ! (in)
!!$      & dims = StoA('lon', 'lat', 'time'), &                ! (in)
!!$      & longname = 'surface pressure (at t)', &             ! (in)
!!$      & units = 'Pa', xtype = 'double', &                   ! (in)
!!$      & history = gthst_grd )                               ! (inout)
!!$
!!$    ground_file_opened = .true.
!!$  end subroutine GroundFileOpen
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileOutput( &
!!$    & xyz_UB, xyz_VB, xyz_TempB, xyz_QVapB, xy_PsB, &   ! (in)
!!$    & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN  &   ! (in)
!!$    & )
!!$    !
!!$    ! ɽ̥ǡνϤԤޤ. 
!!$    !
!!$    ! Output ground data
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryPut
!!$
!!$    ! 
!!$    ! Time control
!!$    !
!!$    use timeset, only: TimeN  ! ƥå $ t $ λ. 
!!$                              ! Time of step $ t $. 
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$    real(DP), intent(in):: xyz_UB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t-\Delta t) $ .   ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t-\Delta t) $ .   . Temperature
!!$    real(DP), intent(in):: xyz_QVapB  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsB (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure
!!$    real(DP), intent(in):: xyz_UN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ u (t) $ .     ®. Eastward wind
!!$    real(DP), intent(in):: xyz_VN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ v (t) $ .     ®. Northward wind
!!$    real(DP), intent(in):: xyz_TempN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T (t) $ .     . Temperature
!!$    real(DP), intent(in):: xyz_QVapN  (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ q (t) $ .     漾. Specific humidity
!!$    real(DP), intent(in):: xy_PsN (0:imax-1, 1:jmax)
!!$                              ! $ p_s (t) $ .   ɽ̵. Surface pressure
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    if ( .not. ground_file_opened ) call GroundFileOpen
!!$
!!$    ! ϥߥ󥰤Υå
!!$    ! Check output timing
!!$    !
!!$    if ( TimeN - PrevOutputTime < IntTime ) return
!!$    PrevOutputTime = TimeN
!!$
!!$    ! ǡ
!!$    ! Data output
!!$    !
!!$    call HistoryPut( &
!!$      & 'UB', xyz_UB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VB', xyz_VB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempB', xyz_TempB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapB', xyz_QVapB, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsB', xy_PsB, history = gthst_grd ) ! (in)
!!$
!!$    call HistoryPut( &
!!$      & 'UN', xyz_UN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'VN', xyz_VN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'TempN', xyz_TempN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'QVapN', xyz_QVapN, history = gthst_grd ) ! (in)
!!$    call HistoryPut( &
!!$      & 'PsN', xy_PsN, history = gthst_grd ) ! (in)
!!$
!!$  end subroutine GroundFileOutput
!!$
!!$  !-------------------------------------------------------------------
!!$
!!$  subroutine GroundFileClose
!!$    !
!!$    ! ɽ̥ǡեϤνλԤޤ. 
!!$    !
!!$    ! Terminate ground data files output. 
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! gtool4 ǡ
!!$    ! Gtool4 data output
!!$    !
!!$    use gtool_history, only: HistoryClose
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$    implicit none
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$    if ( .not. ground_file_opened ) return
!!$
!!$    call HistoryClose( history = gthst_grd ) ! (inout)
!!$
!!$    ground_file_opened = .false.
!!$  end subroutine GroundFileClose

  !-------------------------------------------------------------------

  subroutine SurfacePropertiesInit
    !
    ! surface_properties ⥸塼νԤޤ. 
    ! NAMELIST#surface_properties_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "surface_properties" module is initialized. 
    ! "NAMELIST#surface_properties_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime  ! $ \Delta t $ [s]

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_properties_nml/ &
      & SurfTempSetting,     &
      & SurfTempFile,        &
      & SurfTempName,        &
      & SeaIceSetting,       &
      & SeaIceFile,          &
      & SeaIceName,          &
      & AlbedoSetting,       &
      & AlbedoFile,          &
      & AlbedoName,          &
      & HumidCoefSetting,    &
      & HumidCoefFile,       &
      & HumidCoefName,       &
      & RoughLengthSetting,  &
      & RoughLengthFile,     &
      & RoughLengthName,     &
      & HeatCapacitySetting, &
      & HeatCapacityFile,    &
      & HeatCapacityName,    &
      & TempFluxSetting,     &
      & TempFluxFile,        &
      & TempFluxName,        &
      & SurfCondSetting,     &
      & SurfCondFile,        &
      & SurfCondName,        &
      & SurfHeightSetting,   &
      & SurfHeightFile,      &
      & SurfHeightName

          ! ǥեͤˤĤƤϽ³ "surface_properties#SurfacePropertiesInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_properties#SurfacePropertiesInit" for the default values. 
          !

!!$      & OutputFile, &
!!$      & IntValue, IntUnit


    ! ¹ʸ ; Executable statement
    !

    if ( surface_properties_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    SurfTempSetting     = 'generate_internally'
    SurfTempFile        = ''
    SurfTempName        = ''
    SeaIceSetting       = 'generate_internally'
    SeaIceFile          = ''
    SeaIceName          = ''
    AlbedoSetting       = 'generate_internally'
    AlbedoFile          = ''
    AlbedoName          = ''
    HumidCoefSetting    = 'generate_internally'
    HumidCoefFile       = ''
    HumidCoefName       = ''
    RoughLengthSetting  = 'generate_internally'
    RoughLengthFile     = ''
    RoughLengthName     = ''
    HeatCapacitySetting = 'generate_internally'
    HeatCapacityFile    = ''
    HeatCapacityName    = ''
    TempFluxSetting     = 'generate_internally'
    TempFluxFile        = ''
    TempFluxName        = ''
    SurfCondSetting     = 'generate_internally'
    SurfCondFile        = ''
    SurfCondName        = ''
    SurfHeightSetting   = 'generate_internally'
    SurfHeightFile      = ''
    SurfHeightName      = ''

!!$    OutputFile = 'sst.nc'
!!$    IntValue   = 1.0_DP
!!$    IntUnit    = 'day'

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                   &  ! (in)
        & nml = surface_properties_nml, &  ! (out)
        & iostat = iostat_nml           &  ! (out)
        & )
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = surface_properties_nml )
    end if

!!$    ! ϻֳִ֤
!!$    ! Configure time interval of output 
!!$    !
!!$    call DCDiffTimeCreate( PrevOutputTime, & ! (out)
!!$      & sec = 0.0_DP )                       ! (in)
!!$    call DCDiffTimeCreate( IntTime, & ! (out)
!!$      & IntValue, IntUnit )           ! (in)

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    call MessageNotify( 'M', module_name, '  SurfTempSetting     = %c', c1 = trim(SurfTempSetting) )
    call MessageNotify( 'M', module_name, '  SurfTempFile        = %c', c1 = trim(SurfTempFile) )
    call MessageNotify( 'M', module_name, '  SurfTempName        = %c', c1 = trim(SurfTempName        ) )
    call MessageNotify( 'M', module_name, '  SeaIceSetting       = %c', c1 = trim(SeaIceSetting) )
    call MessageNotify( 'M', module_name, '  SeaIceFile          = %c', c1 = trim(SeaIceFile) )
    call MessageNotify( 'M', module_name, '  SeaIceName          = %c', c1 = trim(SeaIceName        ) )
    call MessageNotify( 'M', module_name, '  AlbedoSetting       = %c', c1 = trim(AlbedoSetting      ) )
    call MessageNotify( 'M', module_name, '  AlbedoFile          = %c', c1 = trim(AlbedoFile      ) )
    call MessageNotify( 'M', module_name, '  AlbedoName          = %c', c1 = trim(AlbedoName      ) )
    call MessageNotify( 'M', module_name, '  HumidCoefSetting    = %c', c1 = trim(HumidCoefSetting ) )
    call MessageNotify( 'M', module_name, '  HumidCoefFile       = %c', c1 = trim(HumidCoefFile  ) )
    call MessageNotify( 'M', module_name, '  HumidCoefName       = %c', c1 = trim(HumidCoefName  ) )
    call MessageNotify( 'M', module_name, '  RoughLengthSetting  = %c', c1 = trim(RoughLengthSetting ) )
    call MessageNotify( 'M', module_name, '  RoughLengthFile     = %c', c1 = trim(RoughLengthFile ) )
    call MessageNotify( 'M', module_name, '  RoughLengthName     = %c', c1 = trim(RoughLengthName ) )
    call MessageNotify( 'M', module_name, '  HeatCapacitySetting = %c', c1 = trim(HeatCapacitySetting) )
    call MessageNotify( 'M', module_name, '  HeatCapacityFile    = %c', c1 = trim(HeatCapacityFile) )
    call MessageNotify( 'M', module_name, '  HeatCapacityName    = %c', c1 = trim(HeatCapacityName) )
    call MessageNotify( 'M', module_name, '  TempFluxSetting     = %c', c1 = trim(TempFluxSetting  ) )
    call MessageNotify( 'M', module_name, '  TempFluxFile        = %c', c1 = trim(TempFluxFile  ) )
    call MessageNotify( 'M', module_name, '  TempFluxName        = %c', c1 = trim(TempFluxName  ) )
    call MessageNotify( 'M', module_name, '  SurfCondSetting     = %c', c1 = trim(SurfCondSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfCondFile        = %c', c1 = trim(SurfCondFile   ) )
    call MessageNotify( 'M', module_name, '  SurfCondName        = %c', c1 = trim(SurfCondName   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightSetting   = %c', c1 = trim(SurfHeightSetting   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightFile      = %c', c1 = trim(SurfHeightFile   ) )
    call MessageNotify( 'M', module_name, '  SurfHeightName      = %c', c1 = trim(SurfHeightName   ) )


!!$    call MessageNotify( 'M', module_name, 'Output:: ' )
!!$    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
!!$    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_properties_inited = .true.
  end subroutine SurfacePropertiesInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited


    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )


  end subroutine InitCheck

end module surface_properties
