!= Subroutine BasicEnv
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: basicenv.f90,v 1.1 2009-03-05 05:39:40 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!   * ή׻
!
!== Future Plans
!

subroutine BasicEnv()
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset,  only: DimXMin,       &! X β
    &                 RegXMin,       &! X β
    &                 DimXMax,       &! X ξ
    &                 RegXMax,       &! X ξ
    &                 DimZMin,       &! Z β
    &                 RegZMin,       &! Z β
    &                 DimZMax,       &! Z ξ
    &                 RegZMax,       &! X ξ
    &                 SpcNum,        &!Žʬο
    &                 s_Z,           &!顼ʻǤι
    &                 DelZ            !Z γʻֳ
  use basicset, only: BasicSetArray_Init, &!
    &                 PressBasis,    &!̤δవ
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 CvDry,         &!ʬǮ
    &                 MolWtDry,      &!ʬʬ
    &                 Grav,          &!ϲ®
    &                 SpcWetMolFr,   &!Žʬν
    &                 MolWtWet,      &!Žʬʬ
    &                 EnvType,       &!ܾ
    &                 Tropopause,    &!ή̹
    &                 GasRUniv,      &!
    &                 Humidity,      &!ܾм
    &                 TempStrat,     &!طβ [k]
    &                 Dhight,        & !ŤߴؿΥѥ᡼ [m]
    &                 TempSfc,       &
    &                 PressSfc
  use Boundary, only: BoundaryXCyc_xz,  &!
    &                 BoundaryZSym_xz,  &!  
    &                 BoundaryXCyc_xza, &!
    &                 BoundaryZSym_xza   !  
  use ECCM,     only: ECCM_Dry,         &!
    &                 ECCM_Wet
  use cloudset, only: SatRtWetAdia
  use ChemData, only: ChemData_SVapPress_AntoineA, &
    &                 ChemData_SVapPress_AntoineB
  
  !ۤηػ
  implicit none

  !ѿ
  real(8) :: xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: z_TempBasicZ(DimZMin:DimZMax)
  real(8) :: z_PressBasicZ(DimZMin:DimZMax)
  real(8) :: MolFrIni(SpcNum)
  real(8) :: xza_MolFr(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: za_MolFr(DimZMin:DimZMax, SpcNum)
  real(8) :: xza_MixRtDivMolWt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: z_DTempDZ(DimZMin:DimZMax)
  real(8) :: z_MolWtMean(DimZMin:DimZMax)
  real(8) :: DTempDZ
  real(8) :: Weight
  real(8) :: xz_TempAdia(DimXMin:DimXMax, DimZMin:DimZMax)
                                     ! Ǯ˱ä
  real(8) :: xz_TempSat(DimXMin:DimXMax, DimZMin:DimZMax)
                                     ! ŷ˱ä
  real(8) :: xz_TempIso(DimXMin:DimXMax, DimZMin:DimZMax)
                                     ! ˱ä
  real(8) :: xz_Z(DimXMin:DimXMax, DimZMin:DimZMax)
                                     ! 2D ɸ
  real(8) :: Temp_0, Temp_1, Press_0, Press_1
                 ! ǮȼǮȤ٤ȿˡǵ
                 ! ݤѤѿ
  real(8) :: Work
  real(8) :: LCL ! ǮȼǮ
  real(8) :: LTP ! Ǯ
  integer :: i, k, s

  !---------------------------------------------------------------
  ! ν
  !---------------------------------------------------------------
  xz_PressBasicZ    = 0.0d0
  xz_ExnerBasicZ    = 0.0d0
  xz_TempBasicZ     = 0.0d0
  xz_PotTempBasicZ  = 0.0d0
  xz_VelSoundBasicZ = 0.0d0
  xza_MixRtBasicZ   = 0.0d0
  xz_EffMolWtBasicZ = 0.0d0
!  z_TempBasicZ      = 0.0d0
  z_TempBasicZ      = TempSfc
  z_PressBasicZ     = 0.0d0
  za_MolFr          = 0.0d0

  ! ɸν
    do k = DimZMin, DimZMax
       xz_Z(:,k) = s_Z(k)
    end do

  !---------------------------------------------------------------
  ! EnvType 򸵤, , , 
  !---------------------------------------------------------------
  MolFrIni = SpcWetMolFr(1:SpcNum) 

  !ʬ. Dry ʤ鴥ǮŪ, Wet ʤ鼾ǮŪʽ
  select case(EnvType)
  case("Dry")
    call ECCM_Dry( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )
  case("Wet")
    call ECCM_Wet( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )

  end select

!  do k = RegZMin+1, DimZMax-1     
!    z_DTempDZ(k) = (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ
!  end do
!  
!  ! ή̤ΰ
!  !   ̤絤Ȥ. 絤絤ؤܤ 
!  !   tanh ѤƤʤ餫ˤĤʤ
!  do k = RegZMin+1, DimZMax
!    
!    !ŤߤĤδؿѰ. tanh Ѥ
!    Weight = ( tanh( (s_Z(k) - tropopause ) / Dhight ) + 1.0d0 ) * 5.0d-1
!    
!    !ͤȤƲ٤׻. ̤Ǥ TempStrat 絤˶Ť
!    z_TempBasicZ(k) = z_TempBasicZ(k) * ( 1.0d0 - Weight ) + TempStrat * Weight
!    
!    !ٸΨǮٸΨ꾮ʤʤ褦
!    DTempDZ = &
!      & max( z_DTempDZ(k), (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ )
!
!    !ܾβ٤
!    !z_TempBasicZ(k) = z_TempBasicZ(k-1) + DTempDZ * DelZ 
!    !z_TempBasicZ(k) = z_TempBasicZ(k-1) - (Grav / CpDry) * DelZ
!    !z_TempBasicZ(k) = 300.0d0
!    !z_TempBasicZ(k) = 280.0d0 + 0.8d0 * tanh((s_Z(k) - 250.0d0 )/ 25.0d0)
!
!    !Ϥſ尵ʿդ׻
!    z_PressBasicZ(k) =                                                    &
!      &  z_PressBasicZ(k-1) * ( ( z_TempBasicZ(k-1) / z_TempBasicZ(k) )   &
!      &    ** (Grav * z_MolWtMean(k) / ( DTempDZ * GasRUniv ) ) )
!     z_PressBasicZ(k) =                                                     &
!       &  PressBasis * exp(- Grav * s_Z(k) / (GasRDry * z_TempBasicZ(k) ) )
!    ! 
!    ! z_PressBasicZ(k) =                                                     &
!    !   &  PressBasis * exp(- Grav * s_Z(k) /                                &
!    !  ((CpDry - CvDry) * z_TempBasicZ(k) ) )
!  end do





! ̼齤׻δܾ(˴ǤŵŪ٥ץե)

       xz_TempAdia = TempSfc - Grav * xz_Z / CpDry
       xz_TempIso  = 135.0d0

       Work = Grav / CpDry
       write(*,*) Work, CpDry

       !--- Ǯ, Ǯ, ٤׻,
       !--- ΰΩļѤƲ, Ϥ׻

       !--- ǮȼǮ(LCL)ȿˡǷ׻
       Press_0 = PressSfc
       Temp_0 = TempSfc
       do
         Temp_1 = ChemData_SVapPress_AntoineB(12) / &
              & (ChemData_SVapPress_AntoineA(12) - dlog(Press_0/SatRtWetAdia))
         Press_1 = PressSfc*(Temp_1/TempSfc)**(CpDry / GasRDry)
         if (abs(Temp_1 - Temp_0) < epsilon(0.0d0)) then
            LCL = TempSfc * CpDry / Grav &
              &   * (1.0d0 - (Press_1/PressSfc)**( GasRDry/CpDry ))
           exit
         else
           Temp_0 = Temp_1
           Press_0 = Press_1
         end if
       end do

       !--- Ǯ(LTP)׻
       LTP = LCL + GasRDry * ChemData_SVapPress_AntoineB(12) &
              & / Grav * dlog(Temp_1/xz_TempIso(1,1))

       !--- LCL, LTP ͤɽ.
        write(*,*) 'LCL', LCL
        write(*,*) 'LTP', LTP

       !--- , (), ̵ʬۤ׻
!      do k = DimZMin, DimZMax
       do k = RegZMin, RegZMax
         if (s_Z(k) < LCL) then           ! Ǯ
           xz_TempBasicZ(:,k) = TempSfc - Grav/CpDry * xz_Z (:,k)
           xz_PressBasicZ(:,k) =  &
             &  PressSfc*(xz_TempBasicZ(:,k)/TempSfc)**(CpDry /GasRDry)
           xz_ExnerBasicZ(:,k) =  &
             &  xz_TempBasicZ(:,k)/TempSfc
         else if (s_Z(k) > LTP) then      ! 
           xz_TempBasicZ(:,k) = xz_TempIso(:,k)
           xz_PressBasicZ(:,k) =   &
             &    exp(ChemData_SVapPress_AntoineA(12) &
             & - ChemData_SVapPress_AntoineB(12)/xz_TempIso(:,k))  &
            &  * exp(-Grav*(xz_Z(:,k) - LTP)/(GasRDry*xz_TempIso(:,k)))
           xz_ExnerBasicZ(:,k) =  &
             &    exp(GasRDry/CpDry  &
             &        *(ChemData_SVapPress_AntoineA(12) - &
             &        ChemData_SVapPress_AntoineB(12)/xz_TempIso(:,k)))  &
             &  * exp(-Grav*(xz_Z(:,k) - LTP)  &
             &        /(CpDry*xz_TempIso(:,k))) &
             &  / PressSfc**(GasRDry/CpDry)
         else                             ! Ǯ
           xz_TempBasicZ(:,k) =  &
             &  Temp_1 * exp(-Grav * (xz_Z(:,k) - LCL) &
             & /(GasRDry*ChemData_SVapPress_AntoineB(12)))
           xz_PressBasicZ(:,k) =   &
             &  SatRtWetAdia*exp(ChemData_SVapPress_AntoineA(12) &
             & - ChemData_SVapPress_AntoineB(12)/xz_TempBasicZ(:,k))
           xz_ExnerBasicZ(:,k) =   &
             &  (SatRtWetAdia/PressSfc)**(GasRDry/CpDry ) &
             &  * exp(GasRDry/CpDry &
             &        *(ChemData_SVapPress_AntoineA(12) &
             &        - ChemData_SVapPress_AntoineB(12)/xz_TempBasicZ(:,k)))
         end if
       end do


!! 夫鲼ޤǴǮ
!
!       do k = RegZMin, RegZMax
!           xz_TempBasicZ(:,k) = TempSfc - Grav/CpDry * xz_Z (:,k)
!           xz_PressBasicZ(:,k) =  &
!             &  PressSfc*(xz_TempBasicZ(:,k)/TempSfc)**(CpDry /GasRDry)
!           xz_ExnerBasicZ(:,k) =  &
!             &  xz_TempBasicZ(:,k)/TempSfc
!       end do


  !ǧΤ
  call MessageNotify( "M", "BasicEnv", "Basic State Atmospheric Profiles." )
  do k = RegZMin+1, DimZMax-1     
    write(*,*) "temp", k, s_Z(k), xz_TempBasicZ(1,k), xz_PressBasicZ(1,k)
  end do

  ! 2 ˳Ǽ
!  do i = DimXMin, DimXMax
!    xz_TempBasicZ(i,:)  = z_TempBasicZ  
!    xz_PressBasicZ(i,:) = z_PressBasicZ  
!  end do

  !
  call BoundaryXCyc_xz( xz_TempBasicZ )
  call BoundaryZSym_xz( xz_TempBasicZ )
  call BoundaryXCyc_xz( xz_PressBasicZ )
  call BoundaryZSym_xz( xz_PressBasicZ )
  
  !---------------------------------------------------------------
  ! 
  !---------------------------------------------------------------
  !ʿˤϰ
  do i = DimXMin, DimXMax      
    xza_MolFr(i,:,:) = za_MolFr
  end do    

  !Υ򺮹Ѵ
  do s = 1, SpcNum
    xza_MixRtBasicZ(:,:,s) = xza_MolFr(:,:,s) * MolWtWet(s) / MolWtDry
  end do

!  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRtBasicZ <= 1.0d-20 )
!    xza_MixRtBasicZ = 1.0d-20
!  end where
  
  !
  call BoundaryXCyc_xza( xza_MixRtBasicZ )
  call BoundaryZSym_xza( xza_MixRtBasicZ )
      
  !---------------------------------------------------------------
  ! ʬ̤θ
  !---------------------------------------------------------------
  do s = 1, SpcNum
    xza_MixRtDivMolWt(:,:,s) = xza_MixRtBasicZ(:,:,s) / MolWtWet(s)
  end do
  
  xz_EffMolWtBasicZ = &
    & (1.0d0 + sum(xza_MixRtBasicZ,3) ) &
    & / ( MolWtDry * ((1.0d0 / MolWtDry) + sum(xza_MixRtDivMolWt,3)) )

  !  
  call BoundaryXCyc_xz( xz_EffMolWtBasicZ )
  call BoundaryZSym_xz( xz_EffMolWtBasicZ )  

  !---------------------------------------------------------------    
  ! 
  !---------------------------------------------------------------
  xz_PotTempBasicZ = &
    & xz_TempBasicZ * (PressBasis / xz_PressBasicZ) ** (GasRDry / CpDry) 

  !  
  call BoundaryXCyc_xz( xz_PotTempBasicZ )
  call BoundaryZSym_xz( xz_PotTempBasicZ )

  !---------------------------------------------------------------    
  ! ʡؿ
  !---------------------------------------------------------------
  xz_ExnerBasicZ = xz_TempBasicZ / xz_PotTempBasicZ    

  !
  call BoundaryXCyc_xz( xz_ExnerBasicZ )
  call BoundaryZSym_xz( xz_ExnerBasicZ )
  
  !---------------------------------------------------------------    
  ! ̩
  !---------------------------------------------------------------
  xz_DensBasicZ = &
    & PressBasis * (xz_ExnerBasicZ ** (CvDry / GasRDry)) &
    &  / (GasRDry * xz_PotTempBasicZ / xz_EffMolWtBasicZ)

  !
  call BoundaryXCyc_xz( xz_DensBasicZ )
  call BoundaryZSym_xz( xz_DensBasicZ )

  !---------------------------------------------------------------    
  ! ®
  !---------------------------------------------------------------
  xz_VelSoundBasicZ = &
    & sqrt ( &
    &   CpDry * GasRDry * xz_ExnerBasicZ * xz_PotTempBasicZ &
    &   / (CvDry * xz_EffMolWtBasicZ) &
    & )

  !
  call BoundaryXCyc_xz( xz_VelSoundBasicZ )
  call BoundaryZSym_xz( xz_VelSoundBasicZ )
 
  !----------------------------------------------------------
  ! BasicSet ⥸塼ͤ
  !----------------------------------------------------------
  call BasicSetArray_Init(                                  &
    & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
    & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
    & xza_MixRtBasicZ, xz_EffMolWtBasicZ )


end subroutine BasicEnv
