!= deepconv/arare 絤ή׻Ѽץ ()
!
!= deepconv/arare main program for dry atmospheric convection (3D)
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare_3d_dry.f90,v 1.5 2009-02-28 08:19:10 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program arare
  !
  ! ϳإǥ deepconv/arare 絤ή׻Ѽץ ()
  !

  ! ⥸塼  use statement 
  !

  ! gtool5 Ϣ 
  ! gtool5 modules
  !
  use dc_types,      only: STRING, DP
  use dc_message,    only: MessageNotify

  ! ⥸塼
  ! Initialize module
  !
  use argset,        only: argset_init
  use fileset_3d,    only: fileset_init, InitFile
  use timeset,       only: timeset_init, DelTimeLong, DelTimeShort, &
    &                        NstepLong, NstepShort, NstepDisp
  use gridset_3d,    only: gridset_init, DimXMin, DimXMax, DimYMin, DimYMax, &
    &                      DimZMin, DimZMax, SpcNum
  use basicset_3d,   only: basicset_init, xyza_MixRtBasicZ, xyz_DensBasicZ, &
    &                      xyz_PotTempBasicZ, xyz_VelSoundBasicZ

  ! ̷׻⥸塼 
  ! Chemical calculation modules
  !
  use ChemCalc_3d,   only: ChemCalc_init
  use chemdata,      only: chemdata_init

  ! ϳز׻Ѵؿ⥸塼
  ! Dynamical processes module
  !
  use DynFunc_3d,    only: xyz_AdvScalar, xyz_AdvKm, pyz_AdvVelX, xqz_AdvVelY,&
    &                      xyr_Buoy, xyr_AdvVelZ, pyz_GradPi, xqz_GradPi
  use DynImpFunc_3d, only: xyz_Exner_init, xyz_Exner, xyr_GradPi

  ! ήȻ׻ѥ⥸塼
  ! Turbulent diffusion module
  !
  use Turbulence_3d, only: Turbulence_Init, xyz_BuoyKm, &
    &                      xyz_TurbScalar, xyza_TurbScalar, pyz_TurbVelX,  &
    &                      xyr_TurbVelZ  , xyz_ShearKm    , xyz_DispKm,    &
    &                      xyz_DispHeat  , xqz_TurbVelY   , EddyViscosity 

  ! Υեå׻ѥ⥸塼
  ! Surface flux module
  !
  use HeatFlux_3d,   only: xyz_HeatFluxBulk, pyz_MomFluxBulk, xqz_MomFluxBulk

  ! Ͷ׻ѥ⥸塼
  ! Radiative forceing module
  !
  use Radiation_3d,  only: Radiation_init, xyz_RadHeatConst, xyz_NewtonCool

  ! ׻ѥ⥸塼
  ! Moist processes modules
  !
  use moistset,      only: moistset_init

  ! ͳȻ/໤׻ѥ⥸塼
  ! Numerical diffussion /dumping module
  !
  use NumDiffusion_3d, only: NumDiffusion_Init, xyz_NumDiffScalar, &
    &                        xyz_NumDiffKm, pyz_NumDiffVelX,       &
    &                        xqz_NumDiffVelY, xyr_NumDiffVelZ 
  use damping_3d,    only: damping_init, &
    &                      xyz_DampSponge, pyz_DampSponge, xyr_DampSponge, &
    &                      xqz_DampSponge

  ! ѻʹ⥸塼
  ! Monitor variables setup modules
  !
  use StorePotTemp_3d, only: StorePotTemp_init, StorePotTempClean, &
    &                        StorePotTempCond

  ! եϥ⥸塼
  ! File I/O module
  !
  use RestartFileIO_3d_dry,only: ReStartFile_Open, ReStartFile_OutPut, &
    &                            ReStartFile_Close, ReStartFile_Get
  use HistoryFileIO_3d_dry,only: HistoryFile_Open, HistoryFile_OutPut, &
    &                            HistoryFile_Close

  ! ⥸塼
  ! Utility modules
  !
  use cflcheck_3d,   only: CFLCheckTimeShort, &
    &                      CFLCheckTimeLongVelX, &
    &                      CFLCheckTimeLongVelY, &
    &                      CFLCheckTimeLongVelZ
  use timefilter_3d, only: AsselinFilter
  use xyz_bc_module, only: BoundaryXCyc_xyz, BoundaryYCyc_xyz, &
    &                      BoundaryZSym_xyz, BoundaryZCyc_xyz, &
    &                      BoundaryXCyc_pyz, BoundaryYCyc_pyz, &
    &                      BoundaryZSym_pyz, BoundaryZCyc_pyz, &
    &                      BoundaryXCyc_xqz, BoundaryYCyc_xqz, &
    &                      BoundaryZSym_xqz, BoundaryZCyc_xqz, &
    &                      BoundaryXCyc_xyr, BoundaryYCyc_xyr, &
    &                      BoundaryZSym_xyr, BoundaryZCyc_xyr, &
    &                      BoundaryZAsym_xyr

  implicit none

  ! ѿ
  ! Internal variables
  !
  character(80) :: cfgfile
                             ! NAMELIST ե̾ ; NAMELIST fine name
  real(DP), allocatable :: pyz_VelXBl(:,:,:)    
                             ! $ u (t-\Delta t) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXNl(:,:,:)    
                             ! $ u (t) $           ; zonal wind
  real(DP), allocatable :: pyz_VelXAl(:,:,:)    
                             ! $ u (t+\Delta t) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXNs(:,:,:)    
                             ! $ u (\tau) $  ; zonal wind
  real(DP), allocatable :: pyz_VelXAs(:,:,:)    
                             ! $ u (\tau +\Delta \tau) $  ; zonal wind
  real(DP), allocatable :: xqz_VelYBl(:,:,:)    
                             ! $ v (t-\Delta t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYNl(:,:,:)    
                             ! $ v (t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYAl(:,:,:)    
                             ! $ v (t+\Delta t) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYNs(:,:,:)   
                             ! $ v (\tau -\tau) $  ; meridonal wind
  real(DP), allocatable :: xqz_VelYAs(:,:,:)
                             ! $ v (\tau) $  ; meridonal wind
  real(DP), allocatable :: xyr_VelZBl(:,:,:)    
                             ! $ w (t-\Delta t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZNl(:,:,:)    
                             ! $ w (t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZAl(:,:,:)    
                             ! $ w (t+\Delta t) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZNs(:,:,:)    
                             ! $ w (\tau) $ ľ ; vertical wind
  real(DP), allocatable :: xyr_VelZAs(:,:,:) 
                             ! $ w (\tau +\Delta \tau)  ľ ; vertical wind
  real(DP), allocatable :: xyz_ExnerBl(:,:,:)   
                             ! $ \pi (t-\Delta t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerNl(:,:,:)   
                             ! $ \pi (t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerAl(:,:,:)
                             ! $ \pi (t+\Delta t) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerNs(:,:,:)   
                             ! $ \pi (\tau -\Delta \tau) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_ExnerAs(:,:,:)   
                             ! $ \pi (\tau) $ ϴؿ ; Exner function
  real(DP), allocatable :: xyz_PotTempBl(:,:,:) 
                             ! $ \theta (t-\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PotTempNl(:,:,:) 
                             ! $ \theta (t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PotTempAl(:,:,:) 
                             ! $ \theta (t+\Delta t) $  ; Potential temp.
  real(DP), allocatable :: xyz_PotTempWork(:,:,:) 
                             !  $ \theta $ κ ; Work array
  real(DP), allocatable :: xyz_KmBl(:,:,:)
                             ! $ Km (t-\Delta t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KmNl(:,:,:)
                             ! $ K_m (t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KmAl(:,:,:)
                             ! $ K_m (t+\Delta t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhBl(:,:,:)      
                             ! $ K_h (t-\Delta t) $ ήȻ
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhNl(:,:,:)
                             ! $ K_h (t) $ ήȻ 
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyz_KhAl(:,:,:)
                             ! $ K_h (t+\Delta t) $ ήȻ
                             ! Turbulent diffusion coeff. 
  real(DP), allocatable :: xyza_MixRtBl(:,:,:,:) 
                             ! $ q (t-\Delta t) $ ̤κ
                             ! Mixing ratio of moist variables.
  real(DP), allocatable :: xyza_MixRtNl(:,:,:,:) 
                             ! $ q (t) $ ̤κ 
                             ! Mixing ratio of moist variables
  real(DP), allocatable :: xyza_MixRtAl(:,:,:,:) ! 
                             ! $ q (t+\Delta t) $ ̤κ 
                             !Mixing ratio of moist variables
  real(DP), allocatable :: pyz_AccelVelXNl(:,:,:) 
                             ! Ϥ $u$ ѲΨ
                             ! Tendency of $u$ except for pressure gradient term
  real(DP), allocatable :: xqz_AccelVelYNl(:,:,:) 
                             ! Ϥ $v$ ѲΨ
                             ! Tendency of $v$ except for pressure gradient term
  real(DP), allocatable :: xyr_AccelVelZNl(:,:,:) 
                             ! Ϥ $w$ ѲΨ
                             ! Tendency of $w$ except for pressure gradient term
  real(DP) :: Time           !  ; Time 
  real(DP) :: ReStartTime(2) ! ꥹȥեϻ
                             ! Output time array for restart file
  real(DP), allocatable :: DelTimeLFrog(:)      
                             ! ꡼ץեåѻֳʻҴֳ
                             ! Time interval for Leap-frog scheme
  real(DP) :: DelTimeEuler   ! 顼ѻֳʻ
                             ! Time interval for Eular scheme
  integer :: NStepLFrog      ! ꡼ץեåѻ֥ƥå׿
                             ! The number of time step for Leap-frog scheme
  integer, allocatable :: NStepEuler(:) 
                             ! 顼ѻ֥ƥå׿
                             ! The number of time step for Eular scheme
  integer :: & 
    & t,     & 
    & tau,   & ! do 롼ѿ ; do loop variable  
    & t1,    & ! do 롼ѿ ; do loop variable  
    & t2,    & ! do 롼ѿ ; do loop variable 
    & s        ! do 롼ѿ ; do loop variable 

  ! ³ ; Initialize procedure 
  !

  ! NAMELIST ե̾ɤ߹
  ! Loading NAMELIST file.
  !
  call argset_init( &
    & cfgfile       & ! (out)
    & )

  ! ν
  ! Initialization of chemical constatns.
  !
  call chemdata_init( )

  ! ʬν
  ! Initialization of time integration.
  !
  call timeset_init( &
    & cfgfile        & ! (in)
    & )

  ! ʻν
  ! Initialization of grid arrangement.
  !
  call gridset_init( &
    & cfgfile        & ! (in)
    & )

  ! ط׻롼ν
  ! Initialization of chemical routines.
  !
  call chemcalc_init( )
  
  ! ܾѿν
  ! Initialization of basic state variables.
  !
  call basicset_init( &
    & cfgfile         & ! (in)
    & )
  
  ! I/O ե̾ν
  ! Initialization of output file name. 
  !
  call fileset_init( &
    & cfgfile        & ! (in)
    & )

  ! ͭѿν
  ! Initialization of common variables for moist process.
  !
  call moistset_init( )
 
  ! ѻݴѿν
  ! Initialization of monitor variables.
  !
  call StorePotTemp_init( )
  
  ! ѿν
  ! Initialization of internal variables.
  !
  call VariableAllocate
  
  ! ͤ 
  ! * ReStartFile ꤵƤˤϥեɤ߹. 
  !   ꤵƤʤˤϥǥեȤδܾȾ. 
  !
  ! Initial value set up.
  ! * Read restartfile if it is specified. If not, make default basic
  !   state and disturbance.
  !
  call MessageNotify( "M", "main", "Initial value setup." )

  if (trim(InitFile) /= '') then    

    call ReStartFile_Get( &
      & ReStartTime,      & ! (out)
      & xyz_PotTempBl,    & ! (out)
      & xyz_ExnerBl,      & ! (out)
      & pyz_VelXBl,       & ! (out)
      & xqz_VelYBl,       & ! (out)
      & xyr_VelZBl,       & ! (out)
      & xyz_KmBl,         & ! (out)
      & xyz_KhBl,         & ! (out)
      & xyz_PotTempNl,    & ! (out)
      & xyz_ExnerNl,      & ! (out)
      & pyz_VelXNl,       & ! (out)
      & xqz_VelYBl,       & ! (out)
      & xyr_VelZNl,       & ! (out)
      & xyz_KmNl,         & ! (out)
      & xyz_KhNl          & ! (out)
      & )
  else

    call BasicEnv_3d()
    call DisturbEnv_3d( &
      & cfgfile,        & ! (in)
      & xyz_PotTempBl,  & ! (out)
      & xyz_ExnerBl,    & ! (out)
      & pyz_VelXBl,     & ! (out)
      & xqz_VelYBl,     & ! (out)
      & xyr_VelZBl,     & ! (out)
      & xyza_MixRtBl,   & ! (out)
      & xyz_KmBl,       & ! (out)
      & xyz_KhBl        & ! (out)
      & )

    call BoundaryXCyc_pyz( pyz_VelXBl ) ! (inout)
    call BoundaryYCyc_pyz( pyz_VelXBl ) ! (inout)
    call BoundaryZSym_pyz( pyz_VelXBl ) ! (inout)

    call BoundaryXCyc_xqz( xqz_VelYBl ) ! (inout)
    call BoundaryYCyc_xqz( xqz_VelYBl ) ! (inout)
    call BoundaryZSym_xqz( xqz_VelYBl ) ! (inout)

    call BoundaryXCyc_xyr( xyr_VelZBl ) ! (inout)
    call BoundaryYCyc_xyr( xyr_VelZBl ) ! (inout)
    call BoundaryZAsym_xyr( xyr_VelZBl ) ! (inout)

    call BoundaryXCyc_xyz( xyz_PotTempBl ) ! (inout)
    call BoundaryYCyc_xyz( xyz_PotTempBl ) ! (inout)
    call BoundaryZSym_xyz( xyz_PotTempBl ) ! (inout)

    do s = 1, SpcNum
       call BoundaryXCyc_xyz( xyza_MixRtBl(:,:,:,s) ) ! (inout)
       call BoundaryYCyc_xyz( xyza_MixRtBl(:,:,:,s) ) ! (inout)
       call BoundaryZSym_xyz( xyza_MixRtBl(:,:,:,s) ) ! (inout)
    end do
    
    !  $ t $ ѿͤνͤ
    ! * 1 롼ܤ $ t $ ͤ $ t-\Delta t$ ͤƱˤ. 
    !   1 ƥåܤϥ顼ˡǲɬפ뤬, 1 ƥåܤ
    !   ʳΥƥåפ̡˥ǥ󥰤ʤ
    !
    ! Set up initial value of time = "t" variables.
    !  
    xyz_PotTempNl = xyz_PotTempBl
    xyz_ExnerNl   = xyz_ExnerBl
    pyz_VelXNl    = pyz_VelXBl
    xqz_VelYNl    = xqz_VelYBl
    xyr_VelZNl    = xyr_VelZBl
    xyza_MixRtNl  = xyza_MixRtBl
    xyz_KmNl      = xyz_KmBl
    xyz_KhNl      = xyz_KhBl
   
  end if

  ! ໤ν
  ! Initialization of numerical friction coefficient.
  !
  call Damping_Init( &
    & cfgfile        & ! (in)
    & )     

  ! ͳȻν
  ! Initialization of numerical diffusion term.
  !
  call NumDiffusion_Init( )          

  ! ήȻν
  ! Initialization of turbulent diffusion term.
  !
  call Turbulence_Init( )        

  ! Ͷν
  ! Initialization of radiative forcing.
  !
  call Radiation_Init( &
    & cfgfile          & ! (in)
    & )    

  ! Ϸ׻ѷν 
  ! Initialization of coefficient matrix for exner function calculation.
  !
  call xyz_Exner_Init()             

  ! ȥ롼ײν
  ! Initialization of time integration parameters.
  !
  NstepLFrog   = NstepLong 
  NstepEuler   = NstepShort 
  DelTimeLFrog = DelTimeLong * 2.0d0 
  DelTimeEuler = DelTimeShort

  ! ׻ϻȻֳʻҴֳ֤ν
  ! * ReStartFile ꤵƤ, ե뤫ɤ߹ͤ.
  ! * ReStartFile ꤵƤʤ
  !   * ϻ 0.0
  !   * 1 ƥåܤλֳʻҴֳ֤ۤ˻
  !
  ! Setup restart time and time interval. 
  ! * Read restartfile if it is specified.
  ! * If not, 
  !   * "t" is set to be 0.
  !   * Time intervals for 1st step are specified explicitly.
  !
  if ( trim(InitFile) /= '') then    
    Time = ReStartTime(2)                 
  else
    Time = 0.0d0                          
    NstepEuler(1)   = NstepShort /2       
    DelTimeLFrog(1) = DelTimeLong         
  end if

  call MessageNotify( "M", "main", "NstepLong= %d", i=(/NstepLong/) )
  call MessageNotify( "M", "main", "NstepEuler= %d", i=(/NstepEuler/) )
  call MessageNotify( "M", "main", "DelTimeLFrog= %f", d=(/DelTimeLFrog/) )
  call MessageNotify( "M", "main", "DelTimeEuler= %f", d=(/DelTimeEuler/) )

  ! ҥȥ꡼եؤν
  ! Out put to history file.
  !
  call HistoryFile_Open( )

  if ( trim(InitFile) /= '') then    
    call HistoryFile_Output( & 
      & ReStartTime(2),      & ! (in)
      & xyz_PotTempNl,       & ! (in)
      & xyz_ExnerNl,         & ! (in)
      & pyz_VelXNl,          & ! (in)
      & xqz_VelYNl,          & ! (in)
      & xyr_VelZNl,          & ! (in)
      & xyz_KmNl,            & ! (in)
      & xyz_KhNl             & ! (in)
      & )
  end if

  if ( Time == 0 ) then
    call HistoryFile_Output( & ! (in)
      & Time,                & ! (in)
      & xyz_PotTempNl,       & ! (in)
      & xyz_ExnerNl,         & ! (in)
      & pyz_VelXNl,          & ! (in)
      & xqz_VelYNl,          & ! (in)
      & xyr_VelZNl,          & ! (in)
      & xyz_KmNl,            & ! (in)
      & xyz_KhNl             & ! (in)
      & )
  end if
  
  ! ȤФ CFL Υå
  ! CFL condtion check for sound wave.
  !
  call CFLCheckTimeShort( &
    & xyz_VelSoundBasicZ  & ! (in)
    & )

  ! ʬ ; time integration 
  !
  call MessageNotify( "M", "main", "Time Integration Start" )

  do t1 = 1, NstepLFrog / NstepDisp
    do t2 = 1, NstepDisp

      ! 
      ! Time setting.
      !
      Time = Time + DelTimeLong
      t = (t1 - 1) * NstepDisp + t2

      ! ȻΰήȻ
      ! Advection and diffusion of turbulent diffusion coefficient.
      !

      ! 1 ξ
      !
      !call EddyViscosity( &
      !  & pyz_VelXNl,     & ! (in)
      !  & xqz_VelYNl,     & ! (in)
      !  & xyr_VelZNl,     & ! (in)
      !  & xyz_PotTempNl,  & ! (in)
      !  & xyz_KmNl,       & ! (out)
      !  & xyz_KmAl        & ! (out)
      !  & )

      xyz_KmAl =                                                       &
        & xyz_KmBl                                                     &
        & + DelTimeLFrog(t)                                            &
        &   * (                                                        &
        &     + xyz_AdvKm(xyz_KmNl, pyz_VelXNl, xqz_VelYNl, xyr_VelZNl) &
        &     + xyz_BuoyKm(xyz_PotTempBl)                              &
        &     + xyz_ShearKm(xyz_KmBl, pyz_VelXBl, xqz_VelYBl, xyr_VelZBl) &   
        &     + xyz_NumDiffKm(xyz_KmBl)                                &
        &     + xyz_DispKm(xyz_KmBl)                                   &
        &    )

      !ͤξ²¤
      !  * ͤˤʤ뤳Ȥݾڤ
      !  * ͤξ¤ 800 Ȥ. (1994, ذʸ)
      !
      ! Upper and lower bound value are specified.
      !
      xyz_KmAl = max( 0.0d0, min( xyz_KmAl, 800.0d0 ) )

      !  ; Boundary condition
      !
      call BoundaryXCyc_xyz( xyz_KmAl ) ! (inout)
      call BoundaryYCyc_xyz( xyz_KmAl ) ! (inout)
      call BoundaryZSym_xyz( xyz_KmAl ) ! (inout)
      
      ! 顼Ф뱲Ȼη׻ 
      ! Specify turbulent diffusion coefficient for scalar variables.
      !
      xyz_KhAl = 3.0d0 * xyz_KmAl


      ! ̤ΰήȻη׻ 
      ! Advection and diffusion of potential temperature.
      !
      xyz_PotTempAl =                                              &
        &   xyz_PotTempBl                                          &
        & + DelTimeLFrog(t)                                        &
        &   * (                                                    &
        &     + xyz_AdvScalar( xyz_PotTempNl,                      &
        &                      pyz_VelXNl, xqz_VelYNl, xyr_VelZNl) &
        &     + xyz_AdvScalar( xyz_PotTempBasicZ,                  &
        &                      pyz_VelXNl, xqz_VelYNl, xyr_VelZNl) &
        &     + xyz_NumDiffScalar(xyz_PotTempBl)                   &
        &     + xyz_TurbScalar(xyz_PotTempBl,     xyz_KhBl)        &
        &     + xyz_TurbScalar(xyz_PotTempBasicZ, xyz_KhBl)        &
        &     + xyz_DispHeat( xyz_KmBl )                           &
!!      &     + xyz_RadHeatConst( xyz_ExnerBl )                    &
!!      &     + xyz_HeatFluxDiff( xyz_PotTempNl )                  &
!!      &     + xyz_HeatFluxBulk( xyz_PotTempBl, pyz_VelXBl, xqz_VelYBl ) &
!!      &     + xyz_NewtonCool( xyz_PotTempBl )                    &
        &   )

      !  ; Boundary condition
      !
      call BoundaryXCyc_xyz( xyz_PotTempAl ) ! (inout)
      call BoundaryYCyc_xyz( xyz_PotTempAl ) ! (inout)
      call BoundaryZSym_xyz( xyz_PotTempAl ) ! (inout)
      
      ! ®٤ΰήȻ.
      ! Advection and diffusion of velocity components.
      !
      pyz_AccelVelXNl =                                      &
        & + pyz_AdvVelX(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)  &
        & + pyz_NumDiffVelX(pyz_VelXBl)                      &
        & + pyz_TurbVelX(xyz_KmBl,   pyz_VelXBl, xqz_VelYBl, xyr_VelZBl) 
!        & + pyz_MomFluxBulk( pyz_VelXBl )

      xqz_AccelVelYNl =                                      &
        & + xqz_AdvVelY(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)  &
        & + xqz_NumDiffVelY(xqz_VelYBl)                      &
        & + xqz_TurbVelY(xyz_KmBl,   pyz_VelXBl, xqz_VelYBl, xyr_VelZBl) 
!        & + xqz_MomFluxBulk( xqz_VelYBl )

      xyr_AccelVelZNl =                                      &
        & + xyr_AdvVelZ(pyz_VelXNl, xqz_VelYNl, xyr_VelZNl)  &
        & + xyr_Buoy(xyz_PotTempNl)                          &   
        & + xyr_NumDiffVelZ(xyr_VelZBl)                      &     
        & + xyr_TurbVelZ(xyz_KmBl,   pyz_VelXBl, xqz_VelYBl, xyr_VelZBl) 


      ! û֥ƥåפνͺ.
      ! Initial values set up for time integration with short time step.
      !
      pyz_VelXNs  = pyz_VelXBl
      xqz_VelYNs  = xqz_VelYBl
      xyr_VelZNs  = xyr_VelZBl
      xyz_ExnerNs = xyz_ExnerBl

      ! û֥ƥåפνͺ.
      ! Initial values set up for time integration with short time step.
      !
      Euler: do tau = 1, NstepEuler(t)

        ! ® u η׻.
        ! Time integration horizontal velocity.
        !
        pyz_VelXAs = &
          & pyz_VelXNs                                          &
          &  + DelTimeEuler                                     &
          &    * (                                              &
          &     - pyz_GradPi(xyz_ExnerNs, pyz_VelXNs, xqz_VelYNs, xyr_VelZNs) &
          &     + pyz_AccelVelXNl                               &
          &     )

        !  ; Boundary condition
        !
        call BoundaryXCyc_pyz( pyz_VelXAs ) ! (inout)
        call BoundaryYCyc_pyz( pyz_VelXAs ) ! (inout)
        call BoundaryZSym_pyz( pyz_VelXAs ) ! (inout)
         
        ! ® v η׻.
        ! Time integration horizontal velocity.
        !
        xqz_VelYAs = &
          & xqz_VelYNs                                          &
          &  + DelTimeEuler                                     &
          &    * (                                              &
          &    - xqz_GradPi(xyz_ExnerNs, pyz_VelXNs, xqz_VelYNs, xyr_VelZNs)&
          &     + xqz_AccelVelYNl                               &
          &     )

        !  ; Boundary condition
        !
        call BoundaryXCyc_xqz( xqz_VelYAs ) ! (inout)
        call BoundaryYCyc_xqz( xqz_VelYAs ) ! (inout)
        call BoundaryZSym_xqz( xqz_VelYAs ) ! (inout)

        ! ʡؿη׻.
        ! Time integration exner function.
        !
        xyz_ExnerAs = xyz_Exner( &
          & xyr_AccelVelZNl,     &
          & pyz_VelXNs, pyz_VelXAs,      &
          & xqz_VelYNs, xqz_VelYAs,      &
          & xyr_VelZNs, xyz_ExnerNs)
         
        !  ; Boundary condition
        !
        call BoundaryXCyc_xyz( xyz_ExnerAs ) ! (iuout)
        call BoundaryYCyc_xyz( xyz_ExnerAs ) ! (iuout)
        call BoundaryZSym_xyz( xyz_ExnerAs ) ! (iuout)

        ! ® w η׻
        ! Time integration vertical velocity.
        !
        xyr_VelZAs =                                                   &
          & xyr_VelZNs                                                 &
          &  + DelTimeEuler                                            &
          &    * (                                                     &
          &     - xyr_GradPi(xyz_ExnerAs,xyz_ExnerNs,                  &
          &                  pyz_VelXNs,xqz_VelYNs, xyr_VelZNs)        &
          &     + xyr_AccelVelZNl                                      &
          &     )

        !  ; Boundary condition
        !
        call BoundaryXCyc_xyr( xyr_VelZAs ) ! (inout)
        call BoundaryYCyc_xyr( xyr_VelZAs ) ! (inout)
        call BoundaryZAsym_xyr( xyr_VelZAs )! (inout)
         
        ! û֥ƥåפΥ롼פ󤹤ν
        ! Renew prognostic variables for next short time step integration.
        !
        xyz_ExnerNs  = xyz_ExnerAs
        pyz_VelXNs   = pyz_VelXAs
        xqz_VelYNs   = xqz_VelYAs
        xyr_VelZNs   = xyr_VelZAs
         
      end do Euler
   
      ! ǽŪû֥ƥåפǤͤĹ֥ƥåפǤͤȤߤʤ
      ! Renew prognostic variables for next long time step integration.
      !
      xyz_ExnerAl  = xyz_ExnerAs
      pyz_VelXAl   = pyz_VelXAs
      xqz_VelYAl   = xqz_VelYAs
      xyr_VelZAl   = xyr_VelZAs
      
      ! ֥ե륿. 
      ! Time filter. 
      !
      call AsselinFilter( &
        &  xyz_ExnerAl,   & ! (in)
        &  xyz_ExnerNl,   & ! (inout)
        &  xyz_ExnerBl    & ! (in)
        & )         
      call AsselinFilter( &
        & pyz_VelXAl,     & ! (in)
        & pyz_VelXNl,     & ! (inout)
        & pyz_VelXBl      & ! (in)
        & )
      call AsselinFilter( &
        & xqz_VelYAl,     & ! (in)
        & xqz_VelYNl,     & ! (inout)
        & xqz_VelYBl      & ! (in)
        & )
      call AsselinFilter( &
        & xyr_VelZAl,     & ! (in)
        & xyr_VelZNl,     & ! (inout)
        & xyr_VelZBl      & ! (in)
        & )
      call AsselinFilter( &
        & xyz_PotTempAl,  & ! (in)
        & xyz_PotTempNl,  & ! (inout)
        & xyz_PotTempBl   & ! (in)
        & )
      call AsselinFilter( &
        & xyz_KmAl,       & ! (in)
        & xyz_KmNl,       & ! (inout)
        & xyz_KmBl        & ! (in)
        & )

      ! ݥ
      ! Numerical dumping.
      !
!      pyz_VelXAl = pyz_DampSponge( pyz_VelXAl, pyz_VelXBl, DelTimeLFrog(t) )
!      xqz_VelYAl = xqz_DampSponge( xqz_VelYAl, xqz_VelYBl, DelTimeLFrog(t) )
!      xyr_VelZAl = xyr_DampSponge( xyr_VelZAl, xyr_VelZBl, DelTimeLFrog(t) )


      ! Ĺ֥ƥåפΥ롼פ󤹤ν.
      ! Renew prognostic variables for next long time step integration.
      !
      xyz_PotTempBl = xyz_PotTempNl
      xyz_ExnerBl   = xyz_ExnerNl
      pyz_VelXBl    = pyz_VelXNl
      xqz_VelYBl    = xqz_VelYNl
      xyr_VelZBl    = xyr_VelZNl
      xyz_KmBl      = xyz_KmNl
      xyz_KhBl      = xyz_KhNl
    
      xyz_PotTempNl = xyz_PotTempAl
      xyz_ExnerNl   = xyz_ExnerAl
      pyz_VelXNl    = pyz_VelXAl
      xqz_VelYNl    = xqz_VelYAl
      xyr_VelZNl    = xyr_VelZAl
      xyz_KmNl      = xyz_KmAl
      xyz_KhNl      = xyz_KhAl

    end do

    
    ! ҥȥ꡼եؤν.
    ! Out put to history file.
    !
    call MessageNotify( "M", "main", "Time = %f", d=(/Time/) )

    ! ήФ CFL Υå 
    ! CFL condtion check for advection
    !
    call CFLCheckTimeLongVelX( &
      & pyz_VelXNl             & ! (in)
      & )
    call CFLCheckTimeLongVelY( &
      & xqz_VelYNl             & ! (in)
      & )
    call CFLCheckTimeLongVelZ( &
      & xyr_VelZNl             & ! (in)
      & )
   
    !ҥȥե.
    ! Out put to history file.
    !
    call HistoryFile_Output(  &
      &  Time,                & ! (in)
      &  xyz_PotTempNl,       & ! (in)
      &  xyz_ExnerNl,         & ! (in)
      &  pyz_VelXNl,          & ! (in)
      &  xqz_VelYNl,          & ! (in)
      &  xyr_VelZNl,          & ! (in)
      &  xyz_KmNl,            & ! (in)
      &  xyz_KhNl             & ! (in)
      & )

    ! ѻͤΥꥢ.
    ! Clear monitor variables.
    !
    call StorePotTempClean
    
  end do

  call MessageNotify( "M", "main", "Time Integration is finished." )

  ! ϥեΥ
  ! Close out put files.
  !
  call HistoryFile_Close

  ! ꥹȥեκ
  ! Out put to restart file.
  !
  call ReStartFile_Open( )
  call ReStartFile_OutPut( &
    & Time - DelTimeLong,  & ! (in)
    & xyz_PotTempBl,       & ! (in)
    & xyz_ExnerBl,         & ! (in)
    & pyz_VelXBl,          & ! (in)
    & xqz_VelYBl,          & ! (in)
    & xyr_VelZBl,          & ! (in)
    & xyz_KmBl,            & ! (in)
    & xyz_KhBl             & ! (in)
    & )

  call ReStartFile_OutPut( & ! (in)
    & Time,                & ! (in)
    & xyz_PotTempNl,       & ! (in)
    & xyz_ExnerNl,         & ! (in)
    & pyz_VelXNl,          & ! (in)
    & xqz_VelYNl,          & ! (in)
    & xyr_VelZNl,          & ! (in)
    & xyz_KmNl,            & ! (in)
    & xyz_KhNl             & ! (in)
    & )

  call ReStartFile_Close
  

contains
!-----------------------------------------------------------------------
  subroutine VariableAllocate
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate(                                                   &
      & pyz_VelXBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & pyz_VelXNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & pyz_VelXAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & pyz_VelXNs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & pyz_VelXAs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xqz_VelYBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xqz_VelYNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xqz_VelYAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xqz_VelYNs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xqz_VelYAs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyr_VelZBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyr_VelZNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyr_VelZAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyr_VelZNs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyr_VelZAs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyz_ExnerBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_ExnerNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_ExnerAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_ExnerNs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_ExnerAs(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyz_PotTempWork(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_PotTempBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_PotTempNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_PotTempAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyz_KmBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_KmNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_KmAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyz_KhBl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_KhNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyz_KhAl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
!
      & xyza_MixRtBl  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum), &
      & xyza_MixRtNl  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum), &
      & xyza_MixRtAl  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum), &
!
      & pyz_AccelVelXNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xqz_AccelVelYNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),&
      & xyr_AccelVelZNl(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax),& 
      & DelTimeLFrog(NstepLong), NStepEuler(NStepLong)               ) 

    pyz_VelXNs  = 0.0d0;    pyz_VelXAs = 0.0d0    
    xqz_VelYNs  = 0.0d0;    xqz_VelYAs = 0.0d0    
    xyr_VelZNs  = 0.0d0;    xyr_VelZAs = 0.0d0
    xyz_ExnerNs = 0.0d0;    xyz_ExnerAs = 0.0d0

    pyz_VelXBl  = 0.0d0;    pyz_VelXNl  = 0.0d0;    pyz_VelXAl  = 0.0d0
    xqz_VelYBl  = 0.0d0;    xqz_VelYNl  = 0.0d0;    xqz_VelYAl  = 0.0d0
    xyr_VelZBl  = 0.0d0;    xyr_VelZNl  = 0.0d0;    xyr_VelZAl  = 0.0d0
    xyz_ExnerBl = 0.0d0;    xyz_ExnerNl = 0.0d0;    xyz_ExnerAl = 0.0d0
    xyz_KmBl    = 0.0d0;    xyz_KmNl    = 0.0d0;    xyz_KmAl    = 0.0d0
    xyz_KhBl    = 0.0d0;    xyz_KhNl    = 0.0d0;    xyz_KhAl    = 0.0d0
    xyz_PotTempBl = 0.0d0;  xyz_PotTempNl = 0.0d0;  xyz_PotTempAl = 0.0d0
    xyza_MixRtBl = 0.0d0;   xyza_MixRtNl = 0.0d0;   xyza_MixRtAl = 0.0d0

    pyz_AccelVelXNl = 0.0d0
    xqz_AccelVelYNl = 0.0d0
    xyr_AccelVelZNl = 0.0d0

    DelTimeEuler = 0.0d0
    DelTimeLFrog = 0.0d0; 
    NStepEuler = 0.0d0
    NstepLFrog = 0.0d0

  end subroutine VariableAllocate
!-----------------------------------------------------------------------
end program arare
