!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (z ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : r_Z , z_r, r_z ̾򸵤᤹
!  * 2006/06/17 () : IntZ_*, AvrZ_* ɲ
!  * 2006/06/02 () : x_base_module 
!
module z_base_module
  != 1  (z ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
  !
  !== 
  !
  ! z_base_module , 1  (z ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤδŪ Fortran90 ץप
  ! ؿ󶡤. Υ⥸塼 z_module β̥⥸塼Ǥ.
  !
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤

  use dc_types, only : DBKIND => DP
  implicit none

  private
  public :: km, zmargin, kmin, kmax, z_Z, r_Z, z_dz, r_dz
  public :: z_axis_init, z_avr_r, r_avr_z, IntZ_r, IntZ_z, AvrZ_r, AvrZ_z

  integer         :: km      = 10 ! ʻ
  integer         :: zmargin = 2  ! ʻ
  integer         :: kmin         ! źβ
  integer         :: kmax         ! źξ

  real(DBKIND),allocatable :: z_Z(:)       ! ȾʻҺɸ
  real(DBKIND),allocatable :: r_Z(:)       ! ʻҺɸ
  real(DBKIND),allocatable :: z_dz(:)       ! ȾʻҺɸ
  real(DBKIND),allocatable :: r_dz(:)       ! ʻҺɸ

  save km, zmargin, kmin, kmax, z_Z, r_Z, z_dz, r_dz

  contains
!--------------------------------------------------------------------
    subroutine z_axis_init(k, zmg, zmin, zmax)
      ! z κɸͤȳʻֳ֤ꤹ

      integer,intent(in)      :: k    ! z ʻ
      integer,intent(in)      :: zmg  ! z ʻ
      real(DBKIND),intent(in) :: zmin ! z ɸǾ     
      real(DBKIND),intent(in) :: zmax ! z ɸ  
      integer                 :: kz   ! 롼ź
      real(DBKIND)            :: dz

      km = k
      zmargin = zmg

      kmin = 1  - zmargin
      kmax = km + zmargin

      allocate(z_Z(kmin:kmax))
      allocate(r_Z(kmin:kmax))
      allocate(z_dz(kmin:kmax))
      allocate(r_dz(kmin:kmax))

      dz = (zmax - zmin)/km

      do kz = kmin, kmax
        r_Z(kz) = dz * kz
        z_Z(kz) = dz * (kz - 0.5)
        r_dz(kz) = dz
        z_dz(kz) = dz
      end do

    end subroutine z_axis_init  
!--------------------------------------------------------------------
    function z_avr_r(r_Var)
      ! ʿԤʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: r_Var(kmin:kmax)  ! 
      real(DBKIND)            :: z_avr_r(kmin:kmax) ! 
      integer                 :: kz                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      z_avr_r = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ kmin ʻҾͤϷ׻ʤ.
      !
      do kz = kmin+1, kmax
        z_avr_r(kz) = (r_Var(kz) + r_Var(kz-1))*0.5d0 
      end do

      ! kmin ʻҤ
      z_avr_r(kmin) = z_avr_r(kmin+1)

    end function z_avr_r

!--------------------------------------------------------------------
    function r_avr_z(z_Var)
      ! ʿԤȾʻͤʻ֤
  
      real(DBKIND),intent(in) :: z_Var(kmin:kmax)  ! 
      real(DBKIND)            :: r_avr_z(kmin:kmax) ! 
      integer                 :: kz                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      r_avr_z = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ kmax ʻҾͤϷ׻ʤ.
      ! * ֳֳʻҤʤΤǽŤߤĤʿѤ.
      !    P, Q  a:b ʬ X ͤ, a*X(Q) + b*X(P) 
      !   (a+b=1 ) Ǥ뤳Ȥ, 
      !
      !     r_Var(kz) = [0.5*z_dz(kz)  /r_dz(kz)]*z_Var(kz+1) +    
      !                 [0.5*z_dz(kz+1)/r_dz(kz)]*z_Var(kz)     
      !   
      !   ѷ
      !
      !     r_Var(kz) = [z_dz(kz)*z_Var(kz+1) + z_dz(kz+1)*z_Var(kz)]
      !                 *0.5/r_dz(kz)
      ! 
      do kz = kmin, kmax-1
        r_avr_z(kz) = &
          &  (z_dz(kz)*z_Var(kz+1) + z_dz(kz+1)*z_Var(kz))*0.5d0/r_dz(kz)
      end do

      ! kmax ʻҤ
      r_avr_z(kmax) = r_avr_z(kmax-1)

    end function r_avr_z
!--------------------------------------------------------------------
    function IntZ_r(r_Var)
      ! ʻҾФ z ˽ŤդʬԤ

      real(DBKIND), intent(in) :: r_Var(kmin:kmax)  ! 
      real(DBKIND)             :: IntZ_r            ! 

      ! 
      IntZ_r = 0.0d0

      ! ʬ
      IntZ_r = sum(r_Var(1:km)*r_dz(1:km))

    end function IntZ_r
!--------------------------------------------------------------------
    function IntZ_z(z_Var)
      ! ȾʻҾФ z ˽ŤդʬԤ

      real(DBKIND), intent(in) :: z_Var(kmin:kmax)  ! 
      real(DBKIND)             :: IntZ_z            ! 

      ! 
      IntZ_z = 0.0d0

      ! ʬ
      IntZ_z = sum(z_Var(1:km)*z_dz(1:km))

    end function IntZ_z
!--------------------------------------------------------------------
    function AvrZ_r(r_Var)
      ! ʻҾФ z ʿԤ

      real(DBKIND), intent(in) :: r_Var(kmin:kmax)  ! 
      real(DBKIND)             :: AvrZ_r            ! 

      AvrZ_r = IntZ_r(r_Var)/sum(r_dz(1:km))

    end function AvrZ_r
!--------------------------------------------------------------------
    function AvrZ_z(z_Var)
      ! ȾʻҾФ z ʿԤ

      real(DBKIND), intent(in) :: z_Var(kmin:kmax)  ! 
      real(DBKIND)             :: AvrZ_z            ! 

      AvrZ_z = IntZ_z(z_Var)/sum(z_dz(1:km))

    end function AvrZ_z
!--------------------------------------------------------------------
end module z_base_module
