!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (x ) ֳָ߳ʻ ͭºʬǥ ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/05/26 () : ⥸塼̾ѹ
!  * 2006/02/02 () : 

module x_bc_module
  != 1  (x ) ֳָ߳ʻ ͭºʬǥ ⥸塼
  !
  !== 
  !
  ! x_bc_module , 1  (x ) ֳָ߳ʻҤѤͭºʬˡ
  ! ŤͥǥΤ,  Fortran 90 ץ
  ! .
  !
  ! Υ⥸塼 x_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, x_base_module ⥸塼ѤƤ. 
  !
  !
  !== ³̿̾ˡ
  !
  ! ꤹץ
  !
  !   Boundary[򼨤ʸ]_(μ)
  !
  ! Τ褦̿̾Ƥ. 򼨤ʸϰʲ 3 ĤǤ.
  !
  !   Sym  : о
  !   Asym : ȿо
  !   Cycl :  
  ! 

  use dc_types,      only : DBKIND => DP
  use x_base_module, only : im, xmargin, imin, imax
  implicit none

  private
  public :: BoundarySym_x, BoundaryAsym_x, BoundaryCyc_x
  public :: BoundarySym_p, BoundaryAsym_p, BoundaryCyc_p

  interface BoundaryCyc_x
    module procedure BoundaryCyc
  end interface 

  interface BoundaryCyc_p
    module procedure BoundaryCyc
  end interface 

  contains
!--------------------------------------------------------------------
    subroutine BoundarySym_x(x_Var)
      ! 1  (x ) оζŬѤ.

      real(DBKIND),intent(inout) :: x_Var(imin:imax) !  
      integer                    :: ix               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) im=5, xmargin=2 ξ (imin=-1, imax=7)
      !
      !   p    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   x  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    x_Var(imin:0)          x_Var(im+1,imax) ͤ򹹿
      !     
      !   x_Var(0)  = x_Var(1)
      !   x_Var(-1) = x_Var(2)
      !   x_Var(6)  = x_Var(5)
      !   x_Var(7)  = x_Var(4)
      !
      do ix = 1, xmargin
        x_Var(1-ix)  = x_Var(ix)
        x_Var(im+ix) = x_Var(im+1-ix)
      end do

    end subroutine BoundarySym_x
!--------------------------------------------------------------------
    subroutine BoundaryAsym_x(x_Var)
      ! 1  (x ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: x_Var(imin:imax) !  
      integer                    :: ix               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) im=5, xmargin=2 ξ (imin=-1, imax=7)
      !
      !   p    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   x  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    x_Var(imin:0)          x_Var(im+1,imax) ͤ򹹿
      !     
      !   x_Var(0)  = - x_Var(1)
      !   x_Var(-1) = - x_Var(2)
      !   x_Var(6)  = - x_Var(5)
      !   x_Var(7)  = - x_Var(4)
      !
      do ix = 1, xmargin
        x_Var(1-ix)  = - x_Var(ix)
        x_Var(im+ix) = - x_Var(im+1-ix)
      end do

    end subroutine BoundaryAsym_x
!--------------------------------------------------------------------
    subroutine BoundarySym_p(p_Var)
      ! 1  (x ) оζŬѤ.

      real(DBKIND),intent(inout) :: p_Var(imin:imax) !  
      integer                    :: ix               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) im=5, xmargin=2 ξ (imin=-1, imax=7)
      !
      !   p    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   x  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    p_Var(imin:-1)         p_Var(im+1:imax) ͤ򹹿
      !     
      !   p_Var(-1) = x_Var(1)
      !   p_Var(6)  = x_Var(4)
      !   p_Var(7)  = x_Var(3)
      !
      do ix = 1, xmargin-1
        p_Var(-ix)   = p_Var(ix)      
      end do

      do ix = 1, xmargin
        p_Var(im+ix) = p_Var(im+1-ix)
      end do

    end subroutine BoundarySym_p
!--------------------------------------------------------------------
    subroutine BoundaryAsym_p(p_Var)
      ! 1  (x ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: p_Var(imin:imax) !  
      integer           :: ix               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) im=5, xmargin=2 ξ (imin=-1, imax=7)
      !
      !   p    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   x  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    p_Var(imin:0)           p_Var(im,imax) ͤ򹹿
      !     
      !   x_Var(0)  = 0
      !   x_Var(-1) = - x_Var(1)
      !   x_Var(5)  = 0
      !   x_Var(6)  = - x_Var(4)
      !   x_Var(7)  = - x_Var(3)
      !
      p_Var(0) = 0.0d0
      p_Var(im) = 0.0d0
          
      do ix = 1, xmargin-1
        p_Var(-ix) = - p_Var(ix)
      end do

      do ix = 1, xmargin
        p_Var(im+ix) = - p_Var(im-ix)
      end do

    end subroutine BoundaryAsym_p
!--------------------------------------------------------------------
    subroutine BoundaryCyc(Var)
      ! 1  (x ) ˼ŬѤ.

      real(DBKIND),intent(inout) :: Var(imin:imax) !  
      integer                    :: ix             ! 롼ź

      ! ŬѤ
      ! 
      !   ex.) im=5, xmargin=2 ξ (imin=-1, imax=7)
      !
      !   p    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   x  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    x_Var(imin:0)         x_Var(im+1,imax) ͤ򹹿
      !    p_Var(imin:0)         p_Var(im+1,imax) ͤ򹹿
      !     
      !   x_Var(0)  = x_Var(5)
      !   x_Var(-1) = x_Var(4)
      !   x_Var(6)  = x_Var(1)
      !   x_Var(7)  = x_Var(2)
      !     
      !   p_Var(0)  = p_Var(5)
      !   p_Var(-1) = p_Var(4)
      !   p_Var(6)  = p_Var(1)
      !   p_Var(7)  = p_Var(2)
      !
      do ix = 1, xmargin
        Var(1-ix)  = Var(im+1-ix)
        Var(im+ix) = Var(ix)
      end do

    end subroutine BoundaryCyc
!--------------------------------------------------------------------
end module x_bc_module
