!= ѿνγǧ³
!= Check output setting of a variable
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: historyautochkoutput.f90,v 1.2 2010-12-28 09:53:09 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2010-. All rights reserved. 
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  function HistoryAutoChkOutput( varname ) result(result)
    !
    ! ѿνγǧԤޤ. 
    !
    ! *varname* ˻ꤵ줿ѿ̾Ϥ褦ꤵƤ
    ! ˤ *true* , Ϥʤ褦ꤵƤ
    ! *false* ֤ޤ. 
    ! 
    ! *HistoryAutoCreate* ˤ꤬ʤƤʤ, 
    ! *varname* ˻ꤵ줿ѿ̾ HistoryAutoAddVariable ˤä
    ! ϿƤʤ, ֤ͤ *false* ֤ޤ. 
    !
    ! Check output setting of a variable. 
    !
    ! If output setting of *varname* is valid, *true* is returned. 
    ! If output setting of *varname* is invalid, *false* is returned. 
    !
    ! If initialization with "HistoryAutoCreate" is not done yet, *false* is returned. 
    ! If *varname* is invalid, *false* is returned. 
    !
    use gtool_historyauto_internal, only: initialized, numdims, numvars, &
      & varname_vars, output_valid_vars
    use dc_types, only: DP, STRING, TOKEN

    implicit none
    logical:: result
    character(*), intent(in):: varname
                              ! ѿ̾. 
                              ! Variable name

    integer:: i, vnum
    integer, save:: svnum = 1
    character(*), parameter:: subname = "HistoryAutoChkOutput"
  continue
    ! å
    ! Check initialization
    !
    if ( .not. initialized ) then
      result = .false.
      goto 999
    end if

    ! ѿ ID Υ
    ! Search variable ID
    !
    VarSearch: do
      do i = svnum, numvars
        if ( trim( varname_vars(i) ) == trim(varname) ) then
          vnum = i
          exit VarSearch
        end if
      end do
      do i = 1, svnum - 1
        if ( trim( varname_vars(i) ) == trim(varname) ) then
          vnum = i
          exit VarSearch
        end if
      end do

      result = .false.
      goto 999
    end do VarSearch

    svnum = vnum

    ! γǧ
    ! Check output setting
    !
    result = output_valid_vars( vnum )

999 continue
  end function HistoryAutoChkOutput



  function HistoryAutoChkOutputTiming( time, varname ) result(result)
    !
    ! ѿνγǧԤޤ. 
    !
    ! *varname* ˻ꤵ줿ѿ̾*time* Υߥ󥰤ǽϤ褦
    ! ꤵƤˤ *true* , Ϥʤ褦ꤵƤ
    ! *false* ֤ޤ. 
    !
    ! ʤ, gtool_historyauto ϻ֥ƥåײѤбƤ뤿, 
    ! *time* Υߥ󥰤ǽϤ뤫ɤˤĤƤ, 
    ! ˽Ϥ줿֤˰¸ޤ. ä, Ȥ֤
    ! γǧϲΤ褦 HistoryAutoPut ǻѤƲ. 
    !
    !   if ( HistoryAutoChkOutputTiming( time, var ) ) then
    !     <some operation ...>
    !   end if 
    !
    !   call HistoryAutoPut( time, var, data )
    !
    ! ʲΤ褦˻Ѥˤ, Ԥ褦֤ͤ
    ! ʤȤˤαղ. 
    ! 
    !   do i = 1, 10 
    !     write(*,*) HistoryAutoChkOutputTiming( i * timestep, var )
    !   end do
    !
    ! *HistoryAutoCreate* ˤ꤬ʤƤʤ, 
    ! *varname* ˻ꤵ줿ѿ̾ HistoryAutoAddVariable ˤä
    ! ϿƤʤ, ֤ͤ *false* ֤ޤ. 
    !
    ! Check output setting of a variable. 
    !
    ! If *varname* is output on *time*, *true* is returned. 
    !
    ! Please use this function as follows. 
    ! 
    !   if ( HistoryAutoChkOutputTiming( time, var ) ) then
    !     <some operation ...>
    !   end if 
    !
    !   call HistoryAutoPut( time, var, data )
    !
    ! Following usage does not return correct values.
    ! 
    !   do i = 1, 10 
    !     write(*,*) HistoryAutoChkOutputTiming( i * timestep, var )
    !   end do
    !
    ! If initialization with "HistoryAutoCreate" is not done yet, *false* is returned. 
    ! If *varname* is invalid, *false* is returned. 
    !
    use gtool_historyauto_internal, only: initialized, numdims, numvars, &
      & varname_vars, output_valid_vars, origin_time_vars, histaddvar_vars, &
      & newfile_inttime_vars, newfile_createtime_vars, prev_outtime_vars, &
      & interval_time_vars, terminus_time_vars
    use dc_types, only: DP, STRING, TOKEN

    implicit none
    logical:: result
    real(DP), intent(in):: time
                              ! ǡλ. 
                              ! Time of data
    character(*), intent(in):: varname
                              ! ѿ̾. 
                              ! Variable name

    real(DP), parameter:: zero_time = 0.0_DP
    integer:: i, vnum
    integer, save:: svnum = 1
    character(*), parameter:: subname = "HistoryAutoChkOutputTiming"
  continue

    ! å
    ! Check initialization
    !
    if ( .not. initialized ) then
      result = .false.
      goto 999
    end if

    ! ѿ ID Υ
    ! Search variable ID
    !
    VarSearch: do
      do i = svnum, numvars
        if ( trim( varname_vars(i) ) == trim(varname) ) then
          vnum = i
          exit VarSearch
        end if
      end do
      do i = 1, svnum - 1
        if ( trim( varname_vars(i) ) == trim(varname) ) then
          vnum = i
          exit VarSearch
        end if
      end do

      result = .false.
      goto 999
    end do VarSearch

    svnum = vnum

    ! γǧ
    ! Check output setting
    !
    result = output_valid_vars( vnum )

    if ( .not. result ) goto 999

    if ( origin_time_vars(vnum) > time ) then
      result = .false. 
      goto 999
    end if

    if (             origin_time_vars(vnum) <= time &
      &  .and.       (      terminus_time_vars(vnum) < zero_time &
      &                .or. terminus_time_vars(vnum) >= time      ) &
      &  .and. .not. histaddvar_vars(vnum)            ) then

      result = .true.
      goto 999
    end if

    if ( terminus_time_vars(vnum) > zero_time .and. terminus_time_vars(vnum) < time ) then
      result = .false.
      goto 999
    end if

    if ( newfile_inttime_vars(vnum) > zero_time ) then
      if ( time - newfile_createtime_vars(vnum) >= newfile_inttime_vars(vnum) ) then
        result = .true.
        goto 999
      end if
    end if

    if ( time - prev_outtime_vars(vnum) >= interval_time_vars(vnum) ) then
      result = .true.
      goto 999
    end if

    result = .false.

999 continue
  end function HistoryAutoChkOutputTiming
