########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2009 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl ljlswg_
ljlswg_:

       movl   (%rdi), %edi  # : JH  rdi 
       movhpd (%rsi), %xmm0 # S1  xmm0 ξ̤
       movlpd (%rsi), %xmm0 # S1  xmm0 β̤ˤ
       movhpd 8(%rsi), %xmm6 # S2  xmm6 ξ̤
       movlpd 8(%rsi), %xmm6 # S2  xmm6 β̤ˤ
       movhpd (%rdx), %xmm1 # R  xmm1 ξ̤
       movlpd (%rdx), %xmm1 # R  xmm1 β̤ˤ
       movq  8(%rsp), %r10  # : W1 Υ١ɥ쥹
       
       shlq $3,%rdi # JH*8  rdi 
       
       movq %rcx,%rsi
       addq %rdi,%rsi
       
       movq %r10,%r11
       addq %rdi, %r11  # : W2 Υ١ɥ쥹              
       
.align 16
.L0:
       movaps (%rcx), %xmm4 # Y
       movaps (%r8), %xmm2  # QA
       movaps (%r9), %xmm3  # QB
       movaps (%r10), %xmm5 # W1
       movaps (%r11), %xmm8 # W2
       movaps %xmm0, %xmm7 # 		
       
       mulpd %xmm1,%xmm4 # Y*R
       mulpd %xmm2,%xmm4 # R*Y*QA
       addpd %xmm4,%xmm3 # 줿 QB  xmm3 
       
       mulpd %xmm2,%xmm7 # S1*QA
       addpd %xmm7,%xmm5 # 줿 W1  xmm5 	
       mulpd %xmm6,%xmm2 # S2*QA	
       addpd %xmm2,%xmm8 # 줿 W  xmm5 
       
       movaps %xmm3,(%r9)  
       movaps %xmm5,(%r10)
       movaps %xmm8,(%r11)       
       
       addq $16,%rcx
       addq $16,%r8       
       addq $16,%r9
       addq $16,%r10
       addq $16,%r11       
       cmpq %rcx,%rsi
       jne .L0
       
#------------------------------------

       ret
       
