module Alge_Solv   ! 黻Ѥʬ򤯥⥸塼

  public :: Poisson_GauSei
  public :: Poisson_Jacobi
  private :: free
  private :: fix
  private :: period

!  ¦θۤ⥼, 뤤ϻꤹ롼ɬ

contains
subroutine Poisson_GauSei(nx, ny, dx, dy, rho, eps, boundary, psi, bound_opt)
! =ǥˡˤݥε
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
                   ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξ : 
                                        ! Υޥ󶭳ξ : եå
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max

  psi = 0.0

  select case (boundary)

  case(1)
     if(present(bound_opt))then
        call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
     else
        call fix(nx,ny,dx,dy,eps,rho,psi)
     end if

  case(2)
     if(present(bound_opt))then
        call free(nx,ny,dx,dy,eps,rho,psi,bound_opt)
     else
        call free(nx,ny,dx,dy,eps,rho,psi)
     end if

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ, ǥեȤϥ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err
  real :: bnd(nx,ny)

  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

  delta=dx/dy
!-- ü ---
  psi(1,:)=bnd(1,:)
  psi(nx,:)=bnd(nx,:)
  psi(:,1)=bnd(:,1)
  psi(:,nx)=bnd(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
  end do
  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi,bound_flx)
  ! Υޥ󷿶ʤΤ, du/dx=f ζǤ, Σ¦ˤĤ
  ! if ʸ̤ν򤹤. Ūˤ,
  ! u(i,j)=u(i-1,j)+f*dx ȤطΤ,
  ! u(i-1,j) ˤ, u(i,j)-f*dx .
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in), optional :: bound_flx(nx,ny)  ! ˤΥޥۤ
        ! ǥեȤǤ, 0 Ƿ׻
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err
  real :: flx(nx,ny)

  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           flx(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           flx(i,j)=0.0
        end do
     end do
  end if

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

  do j=2,ny-1
     do i=2,nx-1
        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &            +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
        else
!-- 鲼 if ʸΥǥȤĴᤷʤ.
           if(i==2)then  ! Ǥΰ
              if(j==2)then  ! Ǥΰ.
                 tmp=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                  +(psi(i+1,j)-flx(i,j)*dx+delta**2*(psi(i,j+1)-flx(i,j)*dy)))
              else
                 if(j==ny-1)then  ! 嶭Ǥΰ.
                    tmp=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)-flx(i,j)*dx+delta**2*(psi(i,j+1)+flx(i,j)*dy)))
                 else
                    tmp=(1.0/(1.0+2.0*delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)-flx(i,j)*dx+delta**2*(psi(i,j+1)+psi(i,j-1))))
                 end if
              end if
           else
              if(i==nx-1)then  ! Ǥΰ.
                 if(j==2)then  ! Ǥΰ.
                    tmp=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+flx(i,j)*dx+delta**2*(psi(i,j+1)-flx(i,j)*dy)))
                 else
                    if(j==ny-1)then  ! 嶭Ǥΰ.
                       tmp=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(i+1,j)+flx(i,j)*dx+delta**2*(psi(i,j+1)+flx(i,j)*dy)))
                    else
                       tmp=(1.0/(1.0+2.0*delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(i+1,j)+flx(i,j)*dx+delta**2*(psi(i,j+1)+psi(i,j-1))))
                    end if
                 end if
              else
                 if(j==2)then  ! ¦Ǥΰ.
                    tmp=(1.0/(2.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)-flx(i,j)*dy)))
                 else  ! ¦Ǥΰ.
                    tmp=(1.0/(2.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+flx(i,j)*dy)))
                 end if
              end if
           end if
!-- ޤǤ if ʸΥǥȤĴᤷʤ.
        end if

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)-flx(2:nx-1,1)*dy
     psi(1,2:ny-1)=psi(2,2:ny-1)-flx(1,2:ny-1)*dx
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)+flx(2:nx-1,ny)*dy
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)+flx(1,2:ny-1)*dx
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1)-flx(1,1)*(dx+dy))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny)-flx(1,ny)*(dx-dy))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1)-flx(nx,1)*(dy-dx))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny)+flx(nx,ny)*(dx+dy))

  end do
 

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

  do j=2,ny-1
     do i=2,nx-1
        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &            +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
        else
!-- 鲼 if ʸΥǥȤĴᤷʤ.
           if(i==2)then  ! Ǥΰ
              if(j==2)then  ! Ǥΰ.
                 tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                  +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
              else
                 if(j==ny-1)then  ! 嶭Ǥΰ.
                    tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                 else
                    tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
                 end if
              end if
           else
              if(i==nx-1)then  ! Ǥΰ.
                 if(j==2)then  ! Ǥΰ.
                    tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
                 else
                    if(j==ny-1)then  ! 嶭Ǥΰ.
                       tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                    else
                       tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
                    end if
                 end if
              else
                 if(j==2)then  ! ¦Ǥΰ.
                    tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
                 else  ! ¦Ǥΰ.
                    tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                 end if
              end if
           end if
!-- ޤǤ if ʸΥǥȤĴᤷʤ.
        end if

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
write(*,*) "###########", psi(nx/2,ny/2)
  end do

  

end subroutine period

end subroutine Poisson_GauSei


subroutine Poisson_Jacobi(nx, ny, dx, dy, rho, eps, boundary, psi, bound_opt)
  ! 䥳ˡˤݥεѡʳȯopenmp
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
                    ! rho =0 ǥץ饹Ѳǽ.
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
                    ! Υޥ󶭳ξ : եå
                    ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξ : 
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max

  psi = 0.0

  select case (boundary)

  case(1)
     if(present(bound_opt))then
        call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
     else
        call fix(nx,ny,dx,dy,eps,rho,psi)
     end if

  case(2)
     if(present(bound_opt))then
        call free(nx,ny,dx,dy,eps,rho,psi,bound_opt)
     else
        call free(nx,ny,dx,dy,eps,rho,psi)
     end if

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ, ǥեȤϥ.
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err
  real :: bnd(nx,ny)

  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

  delta=dx/dy
!-- ü ---
  psi(1,:)=bnd(1,:)
  psi(nx,:)=bnd(nx,:)
  psi(:,1)=bnd(:,1)
  psi(:,nx)=bnd(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

  end do

  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi,bound_flx)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in), optional :: bound_flx(nx,ny)  ! ˤեå
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta
  real :: flx(nx,ny)

  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           flx(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           flx(i,j)=0.0
        end do
     end do
  end if

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=ny-1,2,-1
     do i=nx-1,2,-1
        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &            +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
        else
!-- 鲼 if ʸΥǥȤĴᤷʤ.
           if(i==2)then  ! Ǥΰ
              if(j==2)then  ! Ǥΰ.
                 tmp(i,j)=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                  +(psi(i+1,j)-flx(1,1)*dx+delta**2*(psi(i,j+1)-flx(1,1)*dy)))
              else
                 if(j==ny-1)then  ! 嶭Ǥΰ.
                    tmp(i,j)=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)-flx(1,ny)*dx+delta**2*(psi(i,j+1)+flx(1,ny)*dy)))
                 else
                    tmp(i,j)=(1.0/(1.0+2.0*delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)-flx(1,j)*dx+delta**2*(psi(i,j+1)+psi(i,j-1))))
                 end if
              end if
           else
              if(i==nx-1)then  ! Ǥΰ.
                 if(j==2)then  ! Ǥΰ.
                    tmp(i,j)=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+flx(nx,1)*dx+delta**2*(psi(i,j+1)-flx(nx,1)*dy)))
                 else
                    if(j==ny-1)then  ! 嶭Ǥΰ.
                       tmp(i,j)=(1.0/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(i+1,j)+flx(nx,ny)*dx+delta**2*(psi(i,j+1)+flx(nx,ny)*dy)))
                    else
                       tmp(i,j)=(1.0/(1.0+2.0*delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(i+1,j)+flx(nx,j)*dx+delta**2*(psi(i,j+1)+psi(i,j-1))))
                    end if
                 end if
              else
                 if(j==2)then  ! ¦Ǥΰ.
                    tmp(i,j)=(1.0/(2.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)-flx(i,1)*dy)))
                 else  ! ¦Ǥΰ.
                    tmp(i,j)=(1.0/(2.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+flx(i,ny)*dy)))
                 end if
              end if
           end if
!-- ޤǤ if ʸΥǥȤĴᤷʤ.
        end if
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)-flx(2:nx-1,1)*dy
     psi(1,2:ny-1)=psi(2,2:ny-1)-flx(1,2:ny-1)*dx
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)+flx(2:nx-1,ny)*dy
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)+flx(1,2:ny-1)*dx
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1)-flx(1,1)*(dx+dy))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny)-flx(1,ny)*(dx-dy))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1)-flx(nx,1)*(dy-dx))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny)+flx(nx,ny)*(dx+dy))

  end do

  

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        if(i/=2.and.i/=nx-1.and.j/=2.and.j/=nx-1)then
           !  1 ¦ʳ
           tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &            +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
        else
!-- 鲼 if ʸΥǥȤĴᤷʤ.
           if(i==2)then  ! Ǥΰ
              if(j==2)then  ! Ǥΰ.
                 tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                  +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
              else
                 if(j==ny-1)then  ! 嶭Ǥΰ.
                    tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                 else
                    tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(nx-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
                 end if
              end if
           else
              if(i==nx-1)then  ! Ǥΰ.
                 if(j==2)then  ! Ǥΰ.
                    tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
                 else
                    if(j==ny-1)then  ! 嶭Ǥΰ.
                       tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                    else
                       tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                        +(psi(2,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
                    end if
                 end if
              else
                 if(j==2)then  ! ¦Ǥΰ.
                    tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,ny-1))))
                 else  ! ¦Ǥΰ.
                    tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &                     +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,2)+psi(i,j-1))))
                 end if
              end if
           end if
!-- ޤǤ if ʸΥǥȤĴᤷʤ.
        end if
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
  end do

  

end subroutine period

end subroutine Poisson_Jacobi

end module
