module Thermo_Advanced_Routine
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Routine
use Thermo_Advanced_Function
use analy

contains

subroutine Rich_horizon( za, pta, ptg, va, qva, qvs, Ri )
! Х륯㡼ɥ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in), dimension(:,:) :: pta  ! za Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real, intent(inout), dimension(size(pta,1),size(pta,2)) :: Ri  ! 㡼ɥ
  real, dimension(size(pta,1),size(pta,2)) :: ptvg, ptva, dpt
  integer :: i, j, nx, ny

  nx=size(pta,1)
  ny=size(pta,2)

!$omp parallel default(shared)
!$omp do private(i,j)
  do j=1,ny
     do i=1,nx
        Ri(i,j)=Rich( za, pta(i,j), ptg(i,j), va(i,j), qva(i,j), qvs(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine Louis_horizon( z, z0m, richard, Lo )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), dimension(size(z0m,1),size(z0m,2)) :: richard  ! Х륯㡼ɥ
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: Lo  ! 
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

!$omp parallel default(shared)
!$omp do private(i,j)
  do j=1,ny
     do i=1,nx
        Lo(i,j)=Louis( z, z0m(i,j), richard(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine cm_horizon( z, z0m, coem, richard )
! ư̤˴ؤХ륯׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: coem  ! Х륯
  real, intent(in), dimension(size(z0m,1),size(z0m,2)), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

  if(present(richard))then
!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine cmdva_2_ust_horizon( cmd, va, velst )
! Х륯, ®٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: cmd  !  za ǤΥХ륯
  real, intent(in), dimension(size(cmd,1),size(cmd,2)) :: va  !  za Ǥοʿ [m/s]
  real, intent(inout), dimension(size(cmd,1),size(cmd,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(cmd,1)
  ny=size(cmd,2)

!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=cmdva_2_ust( cmd(i,j), va(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine taurho_2_ust_horizon( taux, tauy, rho, velst )
! ϤΥǥȿʿ 2 ʬȤι٤Ǥ̩٤໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: taux  ! ٤ǤϤΥǥ x ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: tauy  ! ٤ǤϤΥǥ y ʬ [N/m]
  real, intent(in), dimension(size(taux,1),size(taux,2)) :: rho  ! ٤Ǥ̩ [kg/m^3]
  real, intent(inout), dimension(size(taux,1),size(taux,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

  nx=size(taux,1)
  ny=size(taux,2)

!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=taurho_2_ust( (/ taux(i,j), tauy(i,j) /), rho(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine EDC_TKE( x, y, z, pt, tke, nuth, nutv, nuhh, nuhv )
  use Phys_Const
  use Statistics
  use Analy
! 1.5  TKE ѤǴ׻.
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(x),size(y),size(z))  !  [K]
  real, intent(in) :: tke(size(x),size(y),size(z))  ! tke [J/kg]
  real, intent(inout) :: nuth(size(x),size(y),size(z))  ! ʿǴ [m^2/s]
  real, intent(inout) :: nutv(size(x),size(y),size(z))  ! ľǴ [m^2/s]
  real, intent(inout) :: nuhh(size(x),size(y),size(z))  ! ʿȻ [m^2/s]
  real, intent(inout) :: nuhv(size(x),size(y),size(z))  ! ľȻ [m^2/s]
  real :: ptb(size(z)), BV(size(z))
  real, dimension(size(x),size(y),size(z)) :: lv, ls
  real :: lh, dsh, dsv
  real, parameter :: alpha=1.0e-6
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx  ! x γʻҴֳ [m]
  real :: dy  ! y γʻҴֳ [m]
  real :: dz  ! z γʻҴֳ [m]
  intrinsic :: min, max

  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)
  nx=size(x)
  ny=size(y)
  nz=size(z)

  dsh=sqrt(dx*dy)
  dsv=dz
  lh=dsh

! ̤οʿʿ
  do i=1,nz
     call Mean_2d( pt(:,:,i), ptb(i) )
  end do

! ľ ptb Υ֥ȥХ鿶ư׻.
  call Brunt_Freq( x(1:1), y(1:1), z, ptb(:), BV(:) )

! 絤ΰ٤Ǿʬ
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(BV(k)>0.0)then
              ls(i,j,k)=0.76*sqrt(tke(i,j,k)/BV(k))
              lv(i,j,k)=min(dsv,ls(i,j,k))
           else
              lv(i,j,k)=dsv
           end if
           nuth(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lh,alpha*(dsh**2))
           nutv(i,j,k)=max(0.1*sqrt(tke(i,j,k))*lv(i,j,k),alpha*(dsv**2))
           nuhh(i,j,k)=3.0*nuth(i,j,k)
           nuhv(i,j,k)=nutv(i,j,k)*(1.0+2.0*(lv(i,j,k)/dsv))
        end do
     end do
  end do

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Brunt_Freq( x, y, z, pt, BV, undeff )
! ֥ȥХ鿶ư 2 ׻.
  use analy
  use Phys_Const
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: pt(size(x),size(y),size(z))  !  [K]
  real, intent(inout) :: BV(size(x),size(y),size(z))  ! ֥ȥХ鿶ư [1/s]
  real, intent(in), optional :: undeff
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: dx  ! x γʻҴֳ [m]
  real :: dy  ! y γʻҴֳ [m]
  real :: dz  ! z γʻҴֳ [m]

  nx=size(x)
  ny=size(y)
  nz=size(z)
  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), BV(i,j,:), undeff )
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, pt(i,j,:), BV(i,j,:) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(present(undeff))then
              if(BV(i,j,k)==undeff)then
                 BV(i,j,k)=undeff
              else
                 BV(i,j,k)=(g/pt(i,j,k))*BV(i,j,k)
              end if
           else
              BV(i,j,k)=(g/pt(i,j,k))*BV(i,j,k)
           end if
        end do
     end do
  end do

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

subroutine Ertel_PV( x, y, z, u, v, w, rho, pt, cor, pv, undeff, hx, hy, hz )
! ƥΥݥƥ󥷥뱲٤׻
  use Thermo_Function
  use Thermo_Routine
  use analy 
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ®پ x ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! ®پ y ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! ®پ z ʬ [m/s]
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ̩پ [kg/m^3]
  real, intent(in) :: pt(size(x),size(y),size(z))  ! ̾ [K]
  real, intent(in) :: cor(size(x),size(y))  ! ꥪѥ᡼ [/s]
  real, intent(inout) :: pv(size(x),size(y),size(z))  ! PV [Km^2/kgs]
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! 󥰥ե
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! 󥰥ե
  real :: tmp1(size(x),size(y),size(z))
  real :: tmp2(size(x),size(y),size(z))
  real :: tmp3(size(x),size(y),size(z))
  real :: tmp4(size(x),size(y),size(z))
  real :: tmp5(size(x),size(y),size(z))
  real :: tmp6(size(x),size(y),size(z))
  real :: tmp7(size(x),size(y),size(z))
  integer :: i, j, k
  integer :: nx  !  1 ǿ
  integer :: ny  !  2 ǿ
  integer :: nz  !  3 ǿ
  real :: scalex(size(x),size(y),size(z))
  real :: scaley(size(x),size(y),size(z))
  real :: scalez(size(x),size(y),size(z))

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then
!  ̤ζָۤ׻.
     call grad_vec_3d( x, y, z, pt, tmp1, tmp2, tmp3, undeff,  &
  &                    scalex, scaley, scalez )
!  3  rotation ׻.
     call rotate( x, y, z, u, v, w, tmp4, tmp5, tmp6, undeff,  & 
  &               scalex, scaley, scalez )
!  omega  grad pt Ѥ׻
     call dot_prod( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7, undeff )
  else
!  ̤ζָۤ׻.
     call grad_vec_3d( x, y, z, pt, tmp1, tmp2, tmp3,  &
  &                    hx=scalex, hy=scaley, hz=scalez )
!  3  rotation ׻.
     call rotate( x, y, z, u, v, w, tmp4, tmp5, tmp6,  & 
  &               hx=scalex, hy=scaley, hz=scalez )
!  omega  grad pt Ѥ׻
     call dot_prod( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7 )
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp7(i,j,k)==undeff.or.rho(i,j,k)==undeff)then
                 pv(i,j,k)=undeff
              else
                 pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
                 ! ׻Τб٤ʤΤ, ꥪ­碌.
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              pv(i,j,k)=(tmp7(i,j,k)+cor(i,j)*tmp3(i,j,k))/rho(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine

!--------------------------------------------------------
!--------------------------------------------------------

!--------------------------------------------------------
!--------------------------------------------------------



end module
