module typhoon_analy  ! ټ¸ѥڥϥ⥸塼

contains

subroutine tangent_mean_scal( x, y, xc, yc, u, r, theta, v )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u(size(x),size(y))  ! ǥȺɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  integer :: i, j, k, nx, ny, nr, nt
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nt))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nt))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nt))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nt))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
     end do
  end do

!-- (4) ---
  do i=2,nr
     call Mean_1d( nt, work(i,:), v(i) )
  end do
  v(1)=work(1,1)

end subroutine tangent_mean_scal

subroutine tangent_mean_vec( charc, x, y, xc, yc, u1, u2, r, theta, v )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  integer :: i, j, k, nx, ny, nr, nt
  real :: work1(size(r),size(theta)), work2(size(r),size(theta)), work3(size(r),size(theta))
  real :: posx(size(r),size(theta)), posy(size(r),size(theta)), posz(size(r),size(theta))
  real :: vecx(size(r),size(theta)), vecy(size(r),size(theta)), vecz(size(r),size(theta))
  real :: abpos(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nt))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nt))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nt))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nt))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do


!-- (3) ---
!-- 1. ٥ȥ 2 ʬˤĤޤͤ˳Ǽ ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j) )
        tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j) )
     end do
  end do

!-- 2. ޤȤä, Ǥ x,y ɸ(ֹ, ix,iy ˳Ǽ)
!--    ΰ֥٥ȥȤγѤ׻
  do j=1,nt
     do i=1,nr
        work3(i,j)=0.0
        posx(i,j)=point(i,j,1)-xc
        posy(i,j)=point(i,j,2)-yc
        posz(i,j)=0.0
     end do
  end do

  select case (charc)
  case ('vector')
     call vec_prod( nr, nt, 1, posx, posy, posz, work1, work2, work3, vecx, vecy, vecz )
  case ('scalar')
     call dot_prod( nr, nt, 1, posx, posy, posz, work1, work2, work3, vecz )
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

!-- 3. ٥ȥγʬΤ, z ʬˤĤ (2 ʿ̥٥ȥƱΤγ)
!--    ֥٥ȥͤǳ. -> ®ʬޤͤ.
  call abst( nr, nt, 1, posx, posy, posz, abpos )

  do j=1,nt
     do i=2,nr   
        vecz(i,j)=vecz(i,j)/abpos(i,j)
     end do
  end do


!-- (4) ---
  do i=2,nr
     call Mean_1d( nt, vecz(i,:), v(i) )
  end do
  v(1)=0.0

end subroutine tangent_mean_vec


end module
