module Thermo_Advanced_Function
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Const
use Thermo_Routine
use Math_Const
use Phys_Const

contains

real function Rich( za, pta, ptg, va, qva, qvs )
! Х륯㡼ɥ׻ؿ
  use Phys_Const
  use Thermo_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in) :: pta  ! za Ǥβ [K]
  real, intent(in) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real :: ptvg, ptva, dpt

  ptvg=ptg*((1.0+eps_rdrv*qvs)/(1.0+qvs))
  ptva=pta*((1.0+eps_rdrv*qva)/(1.0+qva))
  dpt=ptva-ptvg
  Rich=(g*za*dpt)/(ptva*(va**2))

  return
end function

!--------------------------------------------------------

real function Louis( z, z0m, richard )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in) :: richard  ! Х륯㡼ɥ
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio

  cm_tmp=(kalm/(log(z)-log(z0m)))**2
  zratio=z/z0m

  if(richard<0.0)then
     Louis=1.0-((2.0*b*richard)/(1.0+3.0*b*c*cm_tmp*sqrt(-richard*zratio)))
  else
     Louis=1.0/(1.0+2.0*b*richard*sqrt(1.0+c*richard))
  end if

  return
end function

!--------------------------------------------------------

real function cm( z, z0m, richard )
! ư̤˴ؤХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ

  if(present(richard))then
     cm=(kalm/(log(z)-log(z0m)))**2
     cm=cm*Louis( z, z0m, richard )
  else
     cm=(kalm/(log(z)-log(z0m)))**2
  end if

  return
end function

!--------------------------------------------------------

real function ust( cm, va )
! ໤® u_* ׻ؿ
  implicit none
  real, intent(in) :: cm  !  za ǤΥХ륯
  real, intent(in) :: va  !  za Ǥοʿ [m/s]

  ust=va*sqrt(cm)

end function




end module
