module Trajectory
!  ȥ饸ȥϤԤ롼
  use Statistics

  public :: Forward_Traject_2d
  public :: Forward_Traject_3d
  public :: Stream_Line_2d
  public :: Stream_Line_3d

  private :: undef_interpo_1d
  private :: undef_interpo_2d
  private :: undef_interpo_3d

contains


subroutine Forward_Traject_2d( dt, stime, step, ini_x, ini_y, t, x, y, u, v, trajx, trajy, opt, undef )
! ե饤Ǥήϥ롼.
! Stream_Line_2d 襹ƥå׸ƤӽФ, κݤή®,
! ȤͿ®ޤΤ u,v .
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  real, intent(in) :: stime  ! ֤Ǥλ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x(:)  !  x [m] ʣ
  real, intent(in) :: ini_y(size(ini_x))  !  y [m] ʣ
  real, intent(in) :: t(:)  ! ®پǡΤ [s]
  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  real, intent(in) :: u(size(x),size(y),size(t))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(t))  ! y ®ʬ [m/s]
  real, intent(inout) :: trajx(step,size(ini_x))  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step,size(ini_x))  ! ȥ饸ȥΰֺɸ y [m]
  character(*), intent(in), optional :: opt  ! ʬ
  real, intent(in), optional :: undef  ! ̤
  character(3) :: option
  integer :: nx, ny, nt, nc, i, j, k, i_trajt
  real :: inter_u(size(x),size(y)), inter_v(size(x),size(y))
  real :: trajt(step)

  nx=size(x)
  ny=size(y)
  nt=size(t)
  nc=size(ini_x)

  trajt=(/((stime+dt*(i-1)),i=1,step)/)

  do i=1,nc
     trajx(1,i)=ini_x(i)
     trajy(1,i)=ini_y(i)
  end do

!-- ®پǡ stime ˤʤ, ޤǤʤΤ, 顼
  if(trajt(1)<t(1))then
     write(*,*) "#### ERROR ####"
     write(*,*) "stime must be more than t(1)."
  end if

  if(trajt(step)>t(nt))then
     write(*,*) "#### ERROR ####"
     write(*,*) "trajt(step) must be less than t(nt)."
  end if

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  do i=1,step-1

!-- ®پ
     if(t(1)==trajt(i).or.t(nt)==trajt(i))then
        do k=1,ny
           do j=1,nx
              inter_u(j,k)=u(j,k,i)
              inter_v(j,k)=v(j,k,i)
           end do
        end do
     else
        call interpo_search_1d( t, trajt(i), i_trajt )

!$omp parallel default(shared)
!$omp do private(j,k)
        do k=1,ny
           do j=1,nx
              call interpolation_1d( (/t(i_trajt), t(i_trajt+1)/),  &
     &                               (/u(j,k,i_trajt), u(j,k,i_trajt+1)/),  &
     &                               trajt(i), inter_u(j,k) )
              call interpolation_1d( (/t(i_trajt), t(i_trajt+1)/),  &
     &                               (/v(j,k,i_trajt), v(j,k,i_trajt+1)/),  &
     &                               trajt(i), inter_v(j,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

     if(present(undef))then

!$omp parallel default(shared)
!$omp do private(k)
        do k=1,nc
           call Stream_Line_2d( dt, 2, trajx(i,k), trajy(i,k), x, y, inter_u,  &
  &             inter_v, trajx(i:i+1,k), trajy(i:i+1,k), opt=option, undef=undef )
        end do
!$omp end do
!$omp end parallel

     else

!$omp parallel default(shared)
!$omp do private(k)
        do k=1,nc
           call Stream_Line_2d( dt, 2, trajx(i,k), trajy(i,k), x, y, inter_u,  &
  &             inter_v, trajx(i:i+1,k), trajy(i:i+1,k), opt=option )
        end do
!$omp end do
!$omp end parallel

     end if

  end do

end subroutine Forward_Traject_2d

!-----------------------------------
!-----------------------------------

subroutine Forward_Traject_3d( dt, stime, step, ini_x, ini_y, ini_z, t, x, y, z, u, v, w, trajx, trajy, trajz, opt, undef )
! ե饤Ǥήϥ롼.
! Stream_Line_2d 襹ƥå׸ƤӽФ, κݤή®,
! ȤͿ®ޤΤ u,v .
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  real, intent(in) :: stime  ! ֤Ǥλ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x(:)  !  x [m]  ʣ
  real, intent(in) :: ini_y(size(ini_x))  !  y [m] ʣ
  real, intent(in) :: ini_z(size(ini_x))  !  z [m] ʣ
  real, intent(in) :: t(:)  ! ®پǡΤ [s]
  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  real, intent(in) :: z(:)  ! z κɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z),size(t))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z),size(t))  ! y ®ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z),size(t))  ! z ®ʬ [m/s]
  real, intent(inout) :: trajx(step,(size(ini_x)))  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step,(size(ini_x)))  ! ȥ饸ȥΰֺɸ y [m]
  real, intent(inout) :: trajz(step,(size(ini_x)))  ! ȥ饸ȥΰֺɸ z [m]
  character(*), intent(in), optional :: opt  ! ʬ
  real, intent(in), optional :: undef  ! ̤
  character(3) :: option
  integer :: nx, ny, nz, nt, nc, i, j, k, l, i_trajt
  real :: inter_u(size(x),size(y),size(z))
  real :: inter_v(size(x),size(y),size(z))
  real :: inter_w(size(x),size(y),size(z))
  real :: trajt(step)

  nx=size(x)
  ny=size(y)
  nz=size(z)
  nt=size(t)
  nc=size(ini_x)

  trajt=(/((stime+dt*(i-1)),i=1,step)/)

  do i=1,nc
     trajx(1,i)=ini_x(i)
     trajy(1,i)=ini_y(i)
     trajz(1,i)=ini_z(i)
  end do

!-- ®پǡ stime ˤʤ, ޤǤʤΤ, 顼
  if(trajt(1)<t(1))then
     write(*,*) "#### ERROR ####"
     write(*,*) "stime must be more than t(1)."
  end if

  if(trajt(step)>t(nt))then
     write(*,*) "#### ERROR ####"
     write(*,*) "trajt(step) must be less than t(nt)."
  end if

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  do i=1,step-1

!-- ®پ
     if(t(1)==trajt(i))then

        do l=1,nz
           do k=1,ny
              do j=1,nx
              inter_u(j,k,l)=u(j,k,l,i)
              inter_v(j,k,l)=v(j,k,l,i)
              inter_w(j,k,l)=v(j,k,l,i)
              end do
           end do
        end do

     else

        call interpo_search_1d( t, trajt(i), i_trajt )

!$omp parallel default(shared)
!$omp do private(j,k,l)
        do l=1,nz
           do k=1,ny
              do j=1,nx
                 call interpolation_1d( (/t(i_trajt), t(i_trajt+1)/),  &
  &                   (/u(j,k,l,i_trajt), u(j,k,l,i_trajt+1)/),  &
  &                   trajt(i), inter_u(j,k,l) )
                 call interpolation_1d( (/t(i_trajt), t(i_trajt+1)/),  &
  &                   (/v(j,k,l,i_trajt), v(j,k,l,i_trajt+1)/),  &
  &                   trajt(i), inter_v(j,k,l) )
                 call interpolation_1d( (/t(i_trajt), t(i_trajt+1)/),  &
  &                   (/w(j,k,l,i_trajt), w(j,k,l,i_trajt+1)/),  &
  &                   trajt(i), inter_w(j,k,l) )
              end do
           end do
        end do
!$omp end do
!$omp end parallel

     end if

     if(present(undef))then

!$omp parallel default(shared)
!$omp do private(k)
        do k=1,nc
           call Stream_Line_3d( dt, 2, trajx(i,k), trajy(i,k), trajz(i,k),  &
  &             x, y, z, inter_u, inter_v, inter_w,  &
  &             trajx(i:i+1,k), trajy(i:i+1,k), trajz(i:i+1,k),  &
  &             opt=option, undef=undef )
        end do
!$omp end do
!$omp end parallel

     else

!$omp parallel default(shared)
!$omp do private(k)
        do k=1,nc
           call Stream_Line_3d( dt, 2, trajx(i,k), trajy(i,k), trajz(i,k),  &
  &             x, y, z, inter_u, inter_v, inter_w,  &
  &             trajx(i:i+1,k), trajy(i:i+1,k), trajz(i:i+1,k), opt=option )
        end do
!$omp end do
!$omp end parallel

     end if

  end do

end subroutine Forward_Traject_3d

!-----------------------------------
!-----------------------------------

subroutine Stream_Line_2d( dt, step, ini_x, ini_y, x, y, u, v, trajx, trajy, opt, undef )
! ή׻롼
! ʬˤĤƤ, ǥեȤǤϥ顼ˡǷ׻.
! 'HO1'= 顼ˡʥۥ󥹥
! 'ME1'= ɥ顼ˡ
! 'RK3'= 3 󥲥å
! 'RK4'= 4 󥲥å
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x  !  x [m]
  real, intent(in) :: ini_y  !  y [m]
  real, intent(in) :: x(:)  ! x κɸ
  real, intent(in) :: y(:)  ! y κɸ
  real, intent(in) :: u(size(x),size(y))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y))  ! x ®ʬ [m/s]
  real, intent(inout) :: trajx(step)  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step)  ! ȥ饸ȥΰֺɸ y [m]
  character(3), intent(in), optional :: opt  ! ʬ
  real, intent(in), optional :: undef  ! ̤
  character(3) :: option
  real :: defun
!-- ʲ, 
  integer :: i, j, k, l, m, n, id
  integer :: nx, ny
  real :: k1, k2, k3, k4, l1, l2, l3, l4
  real :: u1, v1, x1, y1
  real :: inter_p(2)  ! Ǥΰֺɸ󹹿
  real :: inter_v(2)  ! Ǥ®٤͡1=u, 2=v

!-- 뤿, x, y ɤΤ褦ϰϤȤäƤ׻ǽʻͤˤ
!-- Τ, x, y ϰϤǤꤹ
!  call (1)
!  call (nx)
!  call (1)
!  call (ny)

  nx=size(x)
  ny=size(y)

  trajx(1)=ini_x
  trajy(1)=ini_y

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

  select case (option)
  case ('EU1')
     do i=1,step-1
!-- ֤ˤ®
!-- ֤
        inter_p=(/trajx(i), trajy(i)/)
!-- ֤ζ˵ 4 ׻.
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

!-- u ʬˤĤƤν
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
!-- v ʬˤĤƤν
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        x1=trajx(i)+dt*inter_v(1)
        y1=trajy(i)+dt*inter_v(2)
!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do

  case ('HO1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+k1
        y1=trajy(i)+l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+0.5*(k1+k2)
        y1=trajy(i)+0.5*(l1+l2)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do


  case ('ME1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+k2
        y1=trajy(i)+l2

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do



  case ('RK3')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)-k1+2.0*k2
        y1=trajy(i)-l1+2.0*l2

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        x1=trajx(i)+(1.0/6.0)*(k1+4.0*k2+k3)
        y1=trajy(i)+(1.0/6.0)*(l1+4.0*l2+l3)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do


  case ('RK4')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+0.5*k2
        y1=trajy(i)+0.5*l2

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)

        x1=trajx(i)+k3
        y1=trajy(i)+l3

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m,n)==undef.or.u(m,n+1)==undef.or.  &
  &           u(m+1,n)==undef.or.u(m+1,n+1)==undef.or.  &
  &           v(m,n)==undef.or.v(m,n+1)==undef.or.  &
  &           v(m+1,n)==undef.or.v(m+1,n+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              exit
           end if
        end if

        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k4=dt*inter_v(1)
        l4=dt*inter_v(2)
        x1=trajx(i)+(1.0/6.0)*(k1+2.0*k2+2.0*k3+k4)
        y1=trajy(i)+(1.0/6.0)*(l1+2.0*l2+2.0*l3+l4)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do



  end select

end subroutine Stream_Line_2d


subroutine Stream_Line_3d( dt, step, ini_x, ini_y, ini_z, x, y, z, u, v, w, trajx, trajy, trajz, opt, undef )
! ή׻롼
! ʬˤĤƤ, ǥեȤǤϥ顼ˡǷ׻.
! 'HO1'= 顼ˡʥۥ󥹥
! 'ME1'= ɥ顼ˡ
! 'RK3'= 3 󥲥å
! 'RK4'= 4 󥲥å
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x  !  x [m]
  real, intent(in) :: ini_y  !  y [m]
  real, intent(in) :: ini_z  !  z [m]
  real, intent(in) :: x(:)  ! x κɸ
  real, intent(in) :: y(:)  ! y κɸ
  real, intent(in) :: z(:)  ! y κɸ
  real, intent(in) :: u(size(x),size(y),size(z))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! x ®ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! z ®ʬ [m/s]
  real, intent(inout) :: trajx(step)  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step)  ! ȥ饸ȥΰֺɸ y [m]
  real, intent(inout) :: trajz(step)  ! ȥ饸ȥΰֺɸ z [m]
  character(*), intent(in), optional :: opt  ! ʬ
  real, intent(in), optional :: undef  ! ̤
  character(3) :: option
  real :: defun
!-- ʲ, 
  integer :: i, j, k, l, m, n, nx, ny, nz, id
  real :: k1, k2, k3, k4, l1, l2, l3, l4
  real :: u1, v1, w1, x1, y1, z1, n1, n2, n3, n4
  real :: inter_p(3)  ! Ǥΰֺɸ󹹿
  real :: inter_v(3)  ! Ǥ®٤͡1=u, 2=v

!-- 뤿, x, y ɤΤ褦ϰϤȤäƤ׻ǽʻͤˤ
!-- Τ, x, y ϰϤǤꤹ
!  call (1)
!  call (nx)
!  call (1)
!  call (ny)

  nx=size(x)
  ny=size(y)
  nz=size(z)

  trajx(1)=ini_x
  trajy(1)=ini_y
  trajz(1)=ini_z

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  select case (option)
  case ('EU1')
     do i=1,step-1
!-- ֤ˤ®
!-- ֤
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
!-- ֤ζ˵ 4 ׻.
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

!-- u ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
!-- v ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
!-- w ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        x1=trajx(i)+dt*inter_v(1)
        y1=trajy(i)+dt*inter_v(2)
        z1=trajz(i)+dt*inter_v(3)
!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           call undef_interpo_1d( step-i+1, trajz(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do

  case ('HO1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+k1
        y1=trajy(i)+l1
        z1=trajz(i)+n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+0.5*(k1+k2)
        y1=trajy(i)+0.5*(l1+l2)
        z1=trajz(i)+0.5*(n1+n2)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           call undef_interpo_1d( step-i+1, trajz(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do


  case ('ME1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+k2
        y1=trajy(i)+l2
        z1=trajz(i)+n2

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           call undef_interpo_1d( step-i+1, trajz(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do



  case ('RK3')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)-k1+2.0*k2
        y1=trajy(i)-l1+2.0*l2
        z1=trajz(i)-n1+2.0*n2

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        n3=dt*inter_v(3)
        x1=trajx(i)+(1.0/6.0)*(k1+4.0*k2+k3)
        y1=trajy(i)+(1.0/6.0)*(l1+4.0*l2+l3)
        z1=trajz(i)+(1.0/6.0)*(n1+4.0*n2+n3)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           call undef_interpo_1d( step-i+1, trajz(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do


  case ('RK4')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+0.5*k2
        y1=trajy(i)+0.5*l2
        z1=trajz(i)+0.5*n2

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        n3=dt*inter_v(3)
        x1=trajx(i)+k3
        y1=trajy(i)+l3
        z1=trajz(i)+n3

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  

!-- ®پ줬 undef Ǥ, λǤʹߤΥǡˤ undef 
!-- , undef ƶϰ̲ᤷݤ.
        if(present(undef))then
           if(u(m+1,n+1,l+1)==undef.or.u(m,n,l)==undef.or.  &
  &           u(m,n+1,l)==undef.or.u(m,n,l+1)==undef.or.  &
  &           u(m+1,n,l)==undef.or.u(m+1,n,l+1)==undef.or.  &
  &           u(m+1,n+1,l)==undef.or.u(m,n+1,l+1)==undef.or.  &
  &           v(m+1,n+1,l+1)==undef.or.v(m,n,l)==undef.or.  &
  &           v(m,n+1,l)==undef.or.v(m,n,l+1)==undef.or.  &
  &           v(m+1,n,l)==undef.or.v(m+1,n,l+1)==undef.or.  &
  &           v(m+1,n+1,l)==undef.or.v(m,n+1,l+1)==undef.or.  &
  &           w(m+1,n+1,l+1)==undef.or.w(m,n,l)==undef.or.  &
  &           w(m,n+1,l)==undef.or.w(m,n,l+1)==undef.or.  &
  &           w(m+1,n,l)==undef.or.w(m+1,n,l+1)==undef.or.  &
  &           w(m+1,n+1,l)==undef.or.w(m,n+1,l+1)==undef)then
              write(*,*) "*********** WARNING ********"
              write(*,*) "parcel passed the undef point."
              write(*,*) "Exit!!"

              call undef_interpo_1d( step-i+1, trajx(i:step), defun )
              call undef_interpo_1d( step-i+1, trajy(i:step), defun )
              call undef_interpo_1d( step-i+1, trajz(i:step), defun )
              exit
           end if
        end if

        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k4=dt*inter_v(1)
        l4=dt*inter_v(2)
        n4=dt*inter_v(3)
        x1=trajx(i)+(1.0/6.0)*(k1+2.0*k2+2.0*k3+k4)
        y1=trajy(i)+(1.0/6.0)*(l1+2.0*l2+2.0*l3+l4)
        z1=trajz(i)+(1.0/6.0)*(n1+2.0*n2+2.0*n3+n4)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
!-- ׻ΰ賰˽Ф, ʹߤΥƥåפˤ٤ defun 
           call undef_interpo_1d( step-i+1, trajx(i:step), defun )
           call undef_interpo_1d( step-i+1, trajy(i:step), defun )
           call undef_interpo_1d( step-i+1, trajz(i:step), defun )
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do



  end select

end subroutine Stream_Line_3d


!------------------------------
! ʲ, private °³    |
!------------------------------

subroutine undef_interpo_1d( nx, val, undef )
! val  undef .
  implicit none
  integer, intent(in) :: nx  ! ǿ
  real, intent(inout) :: val(nx)  ! 
  real, intent(in) :: undef
  integer :: i

  do i=1,nx
     val(i)=undef
  end do

end subroutine undef_interpo_1d

!------------------------------

subroutine undef_interpo_2d( nx, ny, val, undef )
! val  undef .
  implicit none
  integer, intent(in) :: nx  ! ǿ
  integer, intent(in) :: ny  ! ǿ
  real, intent(inout) :: val(nx,ny)  ! 
  real, intent(in) :: undef
  integer :: i, j

  do j=1,ny
     do i=1,nx
        val(i,j)=undef
     end do
  end do

end subroutine undef_interpo_2d

!------------------------------

subroutine undef_interpo_3d( nx, ny, nz, val, undef )
! val  undef .
  implicit none
  integer, intent(in) :: nx  ! ǿ
  integer, intent(in) :: ny  ! ǿ
  integer, intent(in) :: nz  ! ǿ
  real, intent(inout) :: val(nx,ny,nz)  ! 
  real, intent(in) :: undef
  integer :: i, j, k

  do k=1,nz
     do j=1,ny
        do i=1,nx
           val(i,j,k)=undef
        end do
     end do
  end do

end subroutine undef_interpo_3d

end module Trajectory
