program sound_1d
! 饸ιصݴ¬ǡ, 1 Υץեǡ
! , ٤ˤѡˤ CAPE Υѥ᡼׻.
! ǥǡΥեޥåȤϥƥȷΤߥݡ

  use Thermo_Const
  use Thermo_Function
  use Thermo_Advanced_Function
  use file_operate
  use Statistics
  use Basis
  use dcl
  use Dcl_Thermo_Graph

  implicit none

  real, allocatable, dimension(:) :: temp    ! 
  real, allocatable, dimension(:) :: height  ! 
  real, allocatable, dimension(:) :: pres    ! 
  real, allocatable, dimension(:) :: rh      ! м
  real, allocatable, dimension(:) :: qv      ! 
  real, allocatable, dimension(:) :: pt      ! 
  real, allocatable, dimension(:) :: ept     ! 
  real, allocatable, dimension(:) :: sept    ! ˰
  real, allocatable, dimension(:) :: ew      ! 
  real, allocatable, dimension(:) :: ww      ! 
  real, allocatable, dimension(:) :: tmp     ! ƥݥ
  real :: height_lcl, pres_lcl  ! LCL 
  real :: height_lfc, pres_lfc  ! LFC 
  real :: height_lnb, pres_lnb  ! LNB 
  real :: cape_c  ! CAPE
  real :: cin_c  ! CIN
  real :: precip  ! Ĺ߿
  real :: z_ref  ! CAPE η׻κ, .
  real :: p_ref  ! CAPE η׻κ, ൤.

  integer :: i, j, k, l, m, n, iz
  integer :: nz  ! 
  integer :: nnz  ! ǡޤȤ˻Ȥΰˤ
  integer :: nx  ! ǡο

  character(80), allocatable, dimension(:) :: fname  ! ǡե̾
  character(80) :: list_name  ! ǡꥹȥե̾
  character(20), allocatable, dimension(:,:) :: cval  ! ǡɤ߹
  character(4) :: draw_flag  ! ޤ˴ؤե饰

  logical :: dmp_flag

  real, parameter :: undef=-999.0

!-- namelist file ɤ߹

  namelist /input /z_ref, p_ref, list_name, dmp_flag, draw_flag
  read(5,nml=input)

!-- ɤ߹ǡեο
  nnz=line_number_counter( trim(list_name) )

  allocate(fname(nnz))

  call read_file_text( trim(list_name), 1, nnz, fname )
  
  if(dmp_flag.eqv..true.)then  ! ήѥ᡼ƥȥǡȤ¸.
     open(unit=10,file='convec_parm'//trim(list_name),status='unknown')
     write(10,'(a1000)') "'data-name'", "'reference-height'", "'CAPE'",  &
  &                      "'CIN'", "'precipitable-water'",  &
  &                      "'LCL-height'", "'LFC-height'", "'LNB-height'"
  &                      "'LCL-pressure'", "'LFC-pressure'", "'LNB-pressure'"
     write(10,'(a1000)') "'character'", "'m'", "'J/kg'",  &
  &                      "'J/kg'", "'mm'", "'m'", "'m'", "'m'",  &
  &                      "'Pa'", "'Pa'", "'Pa'" 
  end if

  do i=1,nnz

!-- ƥȥեɤ߹

     nz=line_number_counter( trim(fname(i)) )-2  ! ƥȥñ̤ʬð

!-- 

     allocate(cval(6,nz))
     allocate(height(nz))
     allocate(temp(nz))
     allocate(pres(nz))
     allocate(qv(nz))
     allocate(ew(nz))
     allocate(ww(nz))
     allocate(tmp(nz))

!-- ե뤫ǡɤ߹
     call read_file_text( trim(fname(i)), 6, nz, cval )

!-- character -> real
     do j=1,nz
        height(j)=c2r_convert( cval(1,j) )
        pres(j)=c2r_convert( cval(2,j) )
        temp(j)=c2r_convert( cval(3,j) )
        qv(j)=c2r_convert( cval(4,j) )
        ew(j)=c2r_convert( cval(5,j) )
        ww(j)=c2r_convert( cval(6,j) )
     end do

!-- p_ref  z_ref ֤
     if(p_ref<0.0)then
        ! interpo 뤿󲽽
        do j=1,nz
           tmp(j)=pres(nz-j+1)
        end do
        call interpo_search_1d( tmp, p_ref, iz )
        call interpo_search_1d( tmp(iz:iz+1), height(nz-iz+1:nz-iz),  &
  &                             p_ref, z_ref )
     end if

!-- z_ref  p_ref ֤
     if(z_ref==-999.0)then
        ! interpo 뤿󲽽
        call interpo_search_1d( height, z_ref, iz )
        call interpo_search_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                             z_ref, p_ref )
     end if

!-- ή԰ѥ᡼׻
!-- 1. CAPE ׻
     cape_c=CAPE( pres, height, qv, temp, z_ref, undef )

!-- 2. CIN ׻
     cin_c=CIN( pres, height, qv, temp, z_ref, undef )

!-- 3. Ĺ߿̷׻
     precip=precip_water( pres, qv, undef )

!-- 4. LCL ٷ׻
     height_lcl=z_LCL( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lcl, iz )
     call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                         height_lcl, pres_lcl )

!-- 5. LFC ٷ׻
     height_lfc=z_LFC( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lfc, iz )
     call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                         height_lfc, pres_lfc )

!-- 6. LNB ٷ׻
     height_lnb=z_LNB( z_ref, height, temp, pres, qv )
     call interpo_search_1d( height, height_lnb, iz )
     call interpolation_1d( height(iz:iz+1), pres(iz:iz+1),  &
  &                         height_lnb, pres_lnb )

!-- 7. ⤷, ʬ¾Υѥ᡼׻ǽ.

!-- 10. Ƽѥ᡼Υƥȥǡ¸

     if(dmp_flag.eqv..true.)then
        write(10,'(a100,1000f)') trim(fname), z_ref, p_ref, cape_c, cin_c,  &
  &                              precip, height_lcl, height_lfc, height_lnb,  &
  &                              pres_lcl, pres_lfc, pres_lnb
     end if

!-- ʬۺʬ
     if(draw_flag(1:1)/='x')then
        do j=1,nz
           pt(j)=theta_dry( temp(j), pres(j) )
           ept(j)=thetae_Bolton( temp(j), qv(j), pres(j) )
           sept(j)=thetaes_Bolton( temp(j), pres(j) )
        end do
     end if

!-- skew-T ץåȺʬ
!     call SkewT_vec( trim(fname(i)), 20.0, (/250.0, 300.0/),  )






  end do

  if(dmp_flag.eqv..true.)then
     close(unit=10,status='keep')
  end if

end program
