!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Assimilation
! ǡƱɬפȤʤ롼

contains

subroutine successive_modif_1d( x, fg, obs_posi, obs, method, inter_val,  &
  &                             rad, hx, hobs, lambda )!, undef )
! 1 ǡˤĤ, ༡ˡˤޤԤ.
! , ͤ¬ؤޤޤԤΤȤ.
! ͤ򥼥Ȥ, ༡ޤԤ.
! Ĥޤ, ¬ͤΤߤꤷޤԤ.
  use statistics
  use max_min
  implicit none
  real, intent(in) :: x(:)  ! Ǥκɸ[ľɸ]
  real, intent(in) :: fg(size(x))  ! Ǥ
  real, intent(in) :: obs_posi(:)  ! ¬κɸ[x ϤǤ]
  real, intent(in) :: obs(size(obs_posi))  ! ¬Ǥδ¬
  character(1), intent(in) :: method  ! ƶη
                              ! 'B' : Barnes (1964) ˤ륬
                              ! 'C' : Cressman (1959) ˤͭµ
  real, intent(inout) :: inter_val(size(x))  ! ޤ줿
  real, intent(in), optional :: rad  ! ƶȾ[x ϤǤ]
                                     ! ǥեȤϳƳʻκǶδ¬
                                     ! ׻, κǱΥ.
  real, intent(in), optional :: hx(size(x))  ! x Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: hobs(size(obs_posi))  ! ¬줿 x Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: lambda  ! ¬ɸк / طʸɸк
                                       ! ǥեȤǤϥ.
!  real, intent(in), optional :: undef  ! ¬η»[ͤˤϷ»ʤ]
  integer :: nx, i, j, k, nob, obs_i
  real :: lam
  real :: wei(size(x),size(obs_posi)), interp(size(obs_posi))
  real :: radius(size(x),size(obs_posi)), geo_fg(size(x)), fg2obs(size(x))
  real :: geo_obs(size(obs_posi))
  real :: sphe_rad

!-- undef бΤ, undef äƤ¬
  nx=size(x)
  nob=size(obs_posi)

  if(present(lambda))then
     lam=lambda
  else
     lam=0.0
  end if

!-- ҤϤƤ, ŪľɸϤȤ.
  if(present(hx).and.present(hobs))then
     do i=1,nx
        geo_fg(i)=hx(i)*x(i)
     end do
     do k=1,nob
        geo_obs(i)=hobs(i)*obs_posi(i)
     end do
  else
     if(present(hx).or.present(hobs))then  ! ɤ餫ʤ, 顼Ȥʤ.
        write(*,*) "#### ERROR ####"
        write(*,*) "hx 'and' hobs must be set. STOP"
        stop
     else
        do i=1,nx
           geo_fg(i)=x(i)
        end do
        do k=1,nob
           geo_obs(i)=obs_posi(i)
        end do
     end if
  end if

!-- rad ꤵƤʤ, Ⱦ¤η׻
!-- ƳʻǤκǶܴ¬ޤǤεΥ, ǱȤʤ.
  if(present(rad))then
     sphe_rad=rad
  else
     do i=1,nx
        call nearest_search_1d( geo_obs, geo_fg(i), obs_i )
        fg2obs(i)=abs(geo_obs(obs_i)-geo_fg(i))
     end do
     call max_val_1d( fg2obs, obs_i, sphe_rad)
  end if

!-- ͤѤ, ¬٤ƤͤޤԤ.
  do k=1,nob
     call interpo_search_1d( x, obs_posi(k), fg_interp )
     call interpolation_1d( x(fg_interp:fg_interp+1), fg(fg_interp:fg_interp+1),  &
  &                         obs_posi(k), interp(k) )
  end do

!-- ͳʻ, ¬ޤǤľΥ׻.
  do k=1,nob
     do i=1,nx
        radius(i,k)=sqrt((geo_fg(i)-geo_obs(k))*(geo_fg(i)-geo_obs(k)))
     end do
  end do

!-- Ťߴؿη׻
  select case(method)
  case('B')  ! Barnes ˡ
     do k=1,nob
        do i=1,nx
           wei(i,k)=exp(-(radius(i,k))/(sphe_rad))
        end do
     end do
  case('C')  ! Cressman ˡ
     do k=1,nob
        do i=1,nx
           if(radius(i,j)<rad)then
              wei(i,k)=(sphe_rad**2-radius(i,k)**2)/(sphe_rad**2+radius(i,k)**2)
           else
              wei(i,k)=0.0
           end if
        end do
     end do
  case default
     write(*,*) "#### ERROR ####"
     write(*,*) "method is not specified or, wrong. STOP"
     stop
  end select

!-- η׻
  do i=1,nx
     summ(i)=0.0
     summ_wei(i)=0.0
     do k=1,nob
        if(wei(i,j)/=0.0)then
           summ(i)=summ(i)+wei(i,k)*(obs(k)-intep(k))
           summ_wei(i)=summ_wei(i)+wei(i,k)
        end do
     end do
  end do

  do i=1,nx
     inter_val(i)=fg(i)+(summ(i))/(summ_wei(i)+lam**2)
  end do

end subroutine successive_modif_1d

!------------------------------------
!------------------------------------

subroutine successive_modif_2d( x, y, fg, obs_posix, obs_posiy, obs,  &
  &                             method, inter_val,  &
  &                             rad, hx, hy, hobsx, hobsy, lambda )!, undef )
! 2 ǡˤĤ, ༡ˡˤޤԤ.
! , ͤ¬ؤޤޤԤΤȤ.
! ͤ򥼥Ȥ, ༡ޤԤ.
! Ĥޤ, ¬ͤΤߤꤷޤԤ.
  use statistics
  use max_min
!
  implicit none
  real, intent(in) :: x(:)  ! Ǥ 1 ɸ[ľɸ]
  real, intent(in) :: y(:)  ! Ǥ 2 ɸ[ľɸ]
  real, intent(in) :: fg(size(x),size(y))  ! Ǥ
  real, intent(in) :: obs_posix(:)  ! ¬κɸ[x ϤǤ]
  real, intent(in) :: obs_posiy(:)  ! ¬κɸ[y ϤǤ]
  real, intent(in) :: obs(size(obs_posix),size(obs_posiy))  ! ¬Ǥδ¬
  character(1), intent(in) :: method  ! ƶη
                              ! 'B' : Barnes (1964) ˤ륬
                              ! 'C' : Cressman (1959) ˤͭµ
  real, intent(inout) :: inter_val(size(x),size(y))  ! ޤ줿
  real, intent(in), optional :: rad  ! ƶȾ[x ϤǤ]
                                     ! ǥեȤϳƳʻκǶδ¬
                                     ! ׻, κǱΥ.
  real, intent(in), optional :: hx(size(x))  ! x Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: hy(size(y))  ! y Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: hobsx(size(obs_posix))  ! ¬줿 x Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: hobsy(size(obs_posiy))  ! ¬줿 y Ϥˤ륹.
                                ! ǥեȤϥǥȺɸϤȤƷ׻.
  real, intent(in), optional :: lambda  ! ¬ɸк / طʸɸк
                                       ! ǥեȤǤϥ.
!  real, intent(in), optional :: undef  ! ¬η»[ͤˤϷ»ʤ]
  integer :: nx, i, j, k, nob
  real :: lam
  real :: wei(size(x),size(obs_posi)), interp(size(obs_posi))
  real :: radius(size(x),size(obs_posi)), geo_fg(size(x))
  real :: geo_obs(size(obs_posi))
  real :: sphe_rad

!-- undef бΤ, undef äƤ¬
  nx=size(x)
  nob=size(obs_posi)

  if(present(lambda))then
     lam=lambda
  else
     lam=0.0
  end if

!-- ҤϤƤ, ŪľɸϤȤ.
  if(present(hx).and.present(hobs))then
     do i=1,nx
        geo_fg(i)=hx(i)*x(i)
     end do
     do k=1,nob
        geo_obs(i)=hobs(i)*obs_posi(i)
     end do
  else
     if(present(hx).or.present(hobs))then  ! ɤ餫ʤ, 顼Ȥʤ.
        write(*,*) "#### ERROR ####"
        write(*,*) "hx 'and' hobs must be set. STOP"
        stop
     else
        do i=1,nx
           geo_fg(i)=x(i)
        end do
        do k=1,nob
           geo_obs(i)=obs_posi(i)
        end do
     end if
  end if

!-- rad ꤵƤʤ, Ⱦ¤η׻
!-- ƳʻǤκǶܴ¬ޤǤεΥ, ǱȤʤ.
  if(present(rad))then
     sphe_rad=rad
  else
     do i=1,nx
        call nearest_search_1d( geo_obs, geo_fg(i), obs_i )
        fg2obs(i)=abs(geo_obs(obs_i)-geo_fg(i))
     end do
     call max_val_1d( fg2obs, obs_i, sphe_rad)
  end if

!-- ͤѤ, ¬٤ƤͤޤԤ.
  do k=1,nob
     call interpo_search_1d( x, obs_posi(k), fg_interp )
     call interpolation_1d( x(fg_interp:fg_interp+1), fg(fg_interp:fg_interp+1),  &
  &                         obs_posi(k), interp(k) )
  end do

!-- ͳʻ, ¬ޤǤľΥ׻.
  do k=1,nob
     do i=1,nx
        radius(i,k)=sqrt((geo_fg(i)-geo_obs(k))*(geo_fg(i)-geo_obs(k)))
     end do
  end do

!-- Ťߴؿη׻
  select case(method)
  case('B')  ! Barnes ˡ
     do k=1,nob
        do i=1,nx
           wei(i,k)=exp(-(radius(i,k))/(sphe_rad))
        end do
     end do
  case('C')  ! Cressman ˡ
     do k=1,nob
        do i=1,nx
           if(radius(i,j)<rad)then
              wei(i,k)=(sphe_rad**2-radius(i,k)**2)/(sphe_rad**2+radius(i,k)**2)
           else
              wei(i,k)=0.0
           end if
        end do
     end do
  case default
     write(*,*) "#### ERROR ####"
     write(*,*) "method is not specified or, wrong. STOP"
     stop
  end select

!-- η׻
  do i=1,nx
     summ(i)=0.0
     summ_wei(i)=0.0
     do k=1,nob
        if(wei(i,j)/=0.0)then
           summ(i)=summ(i)+wei(i,k)*(obs(k)-intep(k))
           summ_wei(i)=summ_wei(i)+wei(i,k)
        end do
     end do
  end do

  do i=1,nx
     inter_val(i)=fg(i)+(summ(i))/(summ_wei(i)+lam**2)
  end do

end subroutine successive_modif_1d

!------------------------------------
!------------------------------------
!------------------------------------
!------------------------------------



end module
