!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Derivation  ! ʬ黻׻⥸塼

contains

subroutine div( x, y, u, v, val, undeff, hx, hy )
! 2ȯ׻롼
! 
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{u_{i+1,j}-u_{i-1,j}}{2dx} + \frac{v_{i,j+1}-v_{i,j-1}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ, grad_1d 롼Ȥ߹碌뤳ȤǷ׻Ԥ.
! du/dx = grad_1d( x, u, dudx ), dv/dy = grad_1d( y, v, dvdy ) ȤǷ׻Ԥ,
! ⼫ưŪ˷׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))
  real :: dudx(size(x),size(y)), dvdy(size(x),size(y))
  real :: tmpu(size(x),size(y)), tmpv(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- ѿ.

  if(present(hx).and.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.and.v(i,j)/=undeff)then
              tmpu(i,j)=scaley(i,j)*u(i,j)
              tmpv(i,j)=scalex(i,j)*v(i,j)
           else
              tmpu(i,j)=undeff
              tmpv(i,j)=undeff
           end if
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpv(i,:), dvdy(i,:), undeff )
     end do
     do j=1,ny
        call grad_1d( x, tmpu(:,j), dudx(:,j), undeff )
     end do

     do j=1,ny
        do i=1,nx
           if(dudx(i,j)/=undeff.and.dvdy(i,j)/=undeff)then
              if(scalex(i,j)/=0.0.and.scaley(i,j)/=0.0)then
                 val(i,j)=(dudx(i,j)+dvdy(i,j))/(scalex(i,j)*scaley(i,j))
              else
                 val(i,j)=0.0
              end if
           else
              val(i,j)=undeff
           end if
        end do
     end do

  else

     do j=1,ny
        do i=1,nx
           tmpu(i,j)=scaley(i,j)*u(i,j)
           tmpv(i,j)=scalex(i,j)*v(i,j)
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpv(i,:), dvdy(i,:) )
     end do
     do j=1,ny
        call grad_1d( x, tmpu(:,j), dudx(:,j) )
     end do

     do j=1,ny
        do i=1,nx
           if(scalex(i,j)/=0.0.and.scaley(i,j)/=0.0)then
              val(i,j)=(dudx(i,j)+dvdy(i,j))/(scalex(i,j)*scaley(i,j))
           else
              val(i,j)=0.0
           end if
        end do
     end do
  end if

end subroutine div

!-----------------------------------------
!-----------------------------------------

subroutine curl( x, y, u, v, val, undeff, hx, hy, ord )
! 2 ٷ׻롼
!
! x, y μμ㤤ɬ¤٤뤳.
!
! u, v ϶ִθ֤, Ǥդ2٤׻ǽ
! , du/dz-dw/dx ׻ȤΤ, (x,z,u,w) ν֤, ord ץ false.
!
! $\frac{\partial v}{\partial x} -\frac{\partial u}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{v_{i,j+1}-v_{i,j-1}}{2dx} -\frac{u_{i+1,j}-u_{i-1,j}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ grad_1d ʬ׻ôΤ, η׻⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  logical, intent(in),  optional :: ord  ! ʬν֤ؤ륪ץ.
                 ! true ʤ, ؤʤ, false ʤ, ؤ.
                 ! ǥեȤ true, du/dz-dw/dx ׻ȤΤѤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  logical :: order
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))
  real :: dvdx(size(x),size(y)), dudy(size(x),size(y))
  real :: tmpu(size(x),size(y)), tmpv(size(x),size(y))

  nx=size(x)
  ny=size(y)

!-- ѿ.

  if(present(hx).and.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff.and.v(i,j)/=undeff)then
              tmpu(i,j)=scalex(i,j)*u(i,j)
              tmpv(i,j)=scaley(i,j)*v(i,j)
           else
              tmpu(i,j)=undeff
              tmpv(i,j)=undeff
           end if
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpu(i,:), dudy(i,:), undeff )
     end do
     do j=1,ny
        call grad_1d( x, tmpv(:,j), dvdx(:,j), undeff )
     end do

     do j=1,ny
        do i=1,nx
           if(dudy(i,j)/=undeff.and.dvdx(i,j)/=undeff)then
              if(scalex(i,j)/=0.0.and.scaley(i,j)/=0.0)then
                 val(i,j)=(dvdx(i,j)-dudy(i,j))/(scalex(i,j)*scaley(i,j))
              else
                 val(i,j)=0.0
              end if
           else
              val(i,j)=undeff
           end if
        end do
     end do

  else

     do j=1,ny
        do i=1,nx
           tmpu(i,j)=scalex(i,j)*u(i,j)
           tmpv(i,j)=scaley(i,j)*v(i,j)
        end do
     end do

     do i=1,nx
        call grad_1d( y, tmpu(i,:), dudy(i,:) )
     end do
     do j=1,ny
        call grad_1d( x, tmpv(:,j), dvdx(:,j) )
     end do

     do j=1,ny
        do i=1,nx
           if(scalex(i,j)/=0.0.and.scaley(i,j)/=0.0)then
              val(i,j)=(dvdx(i,j)-dudy(i,j))/(scalex(i,j)*scaley(i,j))
           else
              val(i,j)=0.0
           end if
        end do
     end do
  end if

!-- žν֤դˤ륪ץ
!-- false ʤ, ֤ؤƽϤ.

  if(present(ord))then
     order=ord
  else
     order=.true.
  end if

  if(order.eqv..false.)then
     do j=1,ny
        do i=1,nx
           val(i,j)=-val(i,j)
        end do
     end do
  end if

end subroutine curl

!-----------------------------------------
!-----------------------------------------

subroutine div_3d( x, y, z, u, v, w, val, undeff, hx, hy, hz )
! 3ȯ׻롼
!
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} +\frac{\partial w}{\partial z} $ 
! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥȯ
! $\frac{u_{i+1,j,k}-u_{i-1,j,k}}{2dx} + \frac{v_{i,j+1,k}-v_{i,j-1,k}}{2dy} + \frac{w_{i,j,k+1}-w_{i,j,k-1}}{2dz} $
! ȤǤ. Ѥ 3 ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ¼Ūˤ, grad_1d 롼󤬷׻ԤΤ, ν⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 3 ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  real, dimension(size(x),size(y),size(z)) :: dudx, dvdy, dwdz
  real, dimension(size(x),size(y),size(z)) :: tmpu, tmpv, tmpw

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ѿ.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

!-- ˤ, x  dvdy ׻, y  dudx ׻.

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)/=undeff.and.v(i,j,k)/=undeff.and.w(i,j,k)/=undeff)then
                 tmpu(i,j,k)=scaley(i,j,k)*scalez(i,j,k)*u(i,j,k)
                 tmpv(i,j,k)=scalez(i,j,k)*scalex(i,j,k)*v(i,j,k)
                 tmpw(i,j,k)=scalex(i,j,k)*scaley(i,j,k)*w(i,j,k)
              else
                 tmpu(i,j,k)=undeff
                 tmpv(i,j,k)=undeff
                 tmpw(i,j,k)=undeff
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
     do k=1,nz
        do i=1,nx
           call grad_1d( y, tmpv(i,:,k), dvdy(i,:,k), undeff )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
     do k=1,nz
        do j=1,ny
           call grad_1d( x, tmpu(:,j,k), dudx(:,j,k), undeff )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, tmpw(i,j,:), dwdz(i,j,:), undeff )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(dudx(i,j,k)/=undeff.and.dvdy(i,j,k)/=undeff.and.  &
  &              dwdz(i,j,k)/=undeff)then
                 if(scalex(i,j,k)/=0.0.and.scaley(i,j,k)/=0.0.and.  &
  &                 scalez(i,j,k)/=0.0)then
                    val(i,j,k)=(dudx(i,j,k)+dvdy(i,j,k)+dwdz(i,j,k))/  &
  &                            (scalex(i,j,k)*scaley(i,j,k)*scalez(i,j,k))
                 else
                    val(i,j,k)=0.0
                 end if
              else
                 val(i,j,k)=undeff
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              tmpu(i,j,k)=scaley(i,j,k)*scalez(i,j,k)*u(i,j,k)
              tmpv(i,j,k)=scalez(i,j,k)*scalex(i,j,k)*v(i,j,k)
              tmpw(i,j,k)=scalex(i,j,k)*scaley(i,j,k)*w(i,j,k)
           end do
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
     do k=1,nz
        do i=1,nx
           call grad_1d( y, tmpv(i,:,k), dvdy(i,:,k) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
     do k=1,nz
        do j=1,ny
           call grad_1d( x, tmpu(:,j,k), dudx(:,j,k) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, tmpw(i,j,:), dwdz(i,j,:) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(scalex(i,j,k)/=0.0.and.scaley(i,j,k)/=0.0.and.scalez(i,j,k)/=0.0)then
                 val(i,j,k)=(dudx(i,j,k)+dvdy(i,j,k)+dwdz(i,j,k))/  &
  &                         (scalex(i,j,k)*scaley(i,j,k)*scalez(i,j,k))
              else
                 val(i,j,k)=0.0
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine div_3d

!-----------------------------------------
!-----------------------------------------

subroutine curl_3d( x, y, z, u, v, w, zeta, eta, xi, undeff, hx, hy, hz )
! 3 ٤׻.
! ν֤ϱϤ x, y, z ΥǥȺɸ,
! б٥ȥʬ u, v, w ,
! б٥٥ȥʬ zeta, eta, xi ׻.
! ¼ grad_1d ׻ôΤ, ν⼫ưǹԤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: zeta(size(x),size(y),size(z))  ! ٥٥ȥ x ʬ
  real, intent(inout) :: eta(size(x),size(y),size(z))  ! ٥٥ȥ y ʬ
  real, intent(inout) :: xi(size(x),size(y),size(z))  ! ٥٥ȥ z ʬ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ѿ.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:), undeff,  &
  &                hx=scaley(i,:,:), hy=scalez(i,:,:) )
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:),  &
  &                hx=scaley(i,:,:), hy=scalez(i,:,:) )
     end do
!$omp end do
!$omp end parallel

  end if

! y ˿ľ̾Ǥ y α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), undeff, ord=.false., &
  &                hx=scalex(:,j,:), hy=scalez(:,j,:) )
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), ord=.false.,  &
  &                hx=scalex(:,j,:), hy=scalez(:,j,:) )
     end do
!$omp end do
!$omp end parallel

  end if

! z ˿ľ̾Ǥ z α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k), undeff,  &
  &                hx=scalex(:,:,k), hy=scaley(:,:,k) )
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k),  &
  &                hx=scalex(:,:,k), hy=scaley(:,:,k) )
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine grad_1d( x, u, val, undef, hx )
! 1 Υ顼ѿθۤ׻
! $\frac{\partial p}{\partial x} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}-p_{i-1}}{2dx} $
! ȤǤ. Ѥ 1 ۤ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
  implicit none
  real, intent(in) :: x(:)  ! ֺɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x))  ! x Υ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x))

  nx=size(x)

  if(present(hx))then
     do i=1,nx
        scalex(i)=hx(i)
     end do
  else
     do i=1,nx
        scalex(i)=1.0
     end do
  end if

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef)then
           val(i)=undef
        else
           if(scalex(i)/=0.0)then
              val(i)=(u(i+1)-u(i-1))/(scalex(i)*(x(i+1)-x(i-1)))
           else
              val(i)=0.0
           end if
        end if
     end do
!-- ǡΤʤξüν ---
     if(u(1)==undef.or.u(2)==undef)then
        val(1)=undef
     else
        if(scalex(1)/=0.0)then
           val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
        else
           val(1)=0.0
        end if
     end if
     if(u(nx)==undef.or.u(nx-1)==undef)then
        val(nx)=undef
     else
        if(scalex(nx)/=0.0)then
           val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
        else
           val(nx)=0.0
        end if
     end if
  else
     do i=2,nx-1
        if(scalex(i)/=0.0)then
           val(i)=(u(i+1)-u(i-1))/(scalex(i)*(x(i+1)-x(i-1)))
        else
           val(i)=0.0
        end if
     end do
!-- ǡΤʤξüν ---
     if(scalex(1)/=0.0)then
        val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
     else
        val(1)=0.0
     end if
     if(scalex(nx)/=0.0)then
        val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
     else
        val(nx)=0.0
     end if
  end if

end subroutine grad_1d



subroutine grad_2d( x, y, u, valx, valy, undeff, hx, hy )
  ! 1 顼ۤΥ롼Ѥ 2 ۤΥ٥ȥ׻
  ! $\nabla _hp =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j}-p_{i-1,j}}{2dx} ,\; \frac{p_{i,j+1}-p_{i,j-1}}{2dy} \right) $
  ! ȤǤ. Ѥ2ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! Ѥ 1 ۷׻롼 2 ƤӽФȤˤƤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: u(size(x),size(y))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))

  nx=size(x)
  ny=size(y)

  if(present(hx).or.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

  if(present(undeff))then
     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i), undeff)
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:), undeff)
     end do

     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff)then
              if(scalex(i,j)/=0.0)then
                 valx(i,j)=valx(i,j)/scalex(i,j)
              else
                 valx(i,j)=0.0
              end if
              if(scaley(i,j)/=0.0)then
                 valy(i,j)=valy(i,j)/scaley(i,j)
              else
                 valy(i,j)=0.0
              end if
!-- , else ʤΤ, grad_1d 롼ǤǤ undeff äƤ뤫ƱȤ
!-- ʤΤ, 䰦.
           end if
        end do
     end do

  else

     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i) )
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:) )
     end do

     do j=1,ny
        do i=1,nx
           if(scalex(i,j)/=0.0)then
              valx(i,j)=valx(i,j)/scalex(i,j)
           else
              valx(i,j)=0.0
           end if
           if(scaley(i,j)/=0.0)then
              valy(i,j)=valy(i,j)/scaley(i,j)
           else
              valy(i,j)=0.0
           end if
        end do
     end do

  end if

end subroutine grad_2d



subroutine grad_3d( x, y, z, u, valx, valy, valz, undeff, hx, hy, hz )
  ! 1 顼ۤΥ롼Ѥ 3 ۤΥ٥ȥ׻.
  ! $\nabla p =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} ,\; \frac{\partial p}{\partial z} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j,k}-p_{i-1,j,k}}{2dx} ,\; \frac{p_{i,j+1,k}-p_{i,j-1,k}}{2dy} ,\; \frac{p_{i,j,k+1}-p_{i,j,k-1}}{2dz} \right) $
  ! ȤǤ. Ѥ 3 ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! Ѥ 1 ۷׻롼 3 ƤӽФȤˤƤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valz(size(x),size(y),size(z))  ! ׻줿 z  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i),undeff)
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i),undeff)
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:),undeff)
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)/=undeff)then
                 if(scalex(i,j,k)/=0.0)then
                    valx(i,j,k)=valx(i,j,k)/scalex(i,j,k)
                 else
                    valx(i,j,k)=0.0
                 end if
                 if(scaley(i,j,k)/=0.0)then
                    valy(i,j,k)=valy(i,j,k)/scaley(i,j,k)
                 else
                    valy(i,j,k)=0.0
                 end if
                 if(scalez(i,j,k)/=0.0)then
                    valz(i,j,k)=valz(i,j,k)/scalez(i,j,k)
                 else
                    valz(i,j,k)=0.0
                 end if
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i))
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i))
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:))
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(scalex(i,j,k)/=0.0)then
                 valx(i,j,k)=valx(i,j,k)/scalex(i,j,k)
              else
                 valx(i,j,k)=0.0
              end if
              if(scaley(i,j,k)/=0.0)then
                 valy(i,j,k)=valy(i,j,k)/scaley(i,j,k)
              else
                 valy(i,j,k)=0.0
              end if
              if(scalez(i,j,k)/=0.0)then
                 valz(i,j,k)=valz(i,j,k)/scalez(i,j,k)
              else
                 valz(i,j,k)=0.0
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine grad_3d

!-----------------------------------------
!-----------------------------------------

subroutine grad4_1d( x, u, val, undef, hx )
! 1 Υ顼ѿθۤ׻
! $\frac{\partial p}{\partial x} $ 
! 4 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $(2/3)*\frac{p_{i+1}-p_{i-1}}{dx} -(p_{i+2}-p_{i-2})/(12dx)$
! ȤǤ. Ѥ 1 ۤ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
  implicit none
  real, intent(in) :: x(:)  ! ֺɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x))  ! x Υ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x)), dx(size(x)), coe23, coe112

  nx=size(x)
  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do
  dx(1)=x(2)-x(1)
  dx(nx)=x(nx)-x(nx-1)
  coe23=2.0/3.0
  coe112=1.0/12.0

  if(present(hx))then
     do i=1,nx
        scalex(i)=hx(i)
     end do
  else
     do i=1,nx
        scalex(i)=1.0
     end do
  end if

  if(present(undef))then
     do i=3,nx-2
        if(u(i+1)==undef.or.u(i-1)==undef.or.  &
  &        u(i+2)==undef.or.u(i-2)==undef)then
           val(i)=undef
        else
           if(scalex(i)/=0.0)then
              val(i)=(coe23*(u(i+1)-u(i-1))-coe112*(u(i+2)-u(i-2)))  &
  &                  /(scalex(i)*dx(i))
           else
              val(i)=0.0
           end if
        end if
     end do

!-- ǡΤʤξüν (ξü 1 ¦) ---
     if(u(1)==undef.or.u(3)==undef)then
        val(2)=undef
     else
        if(scalex(2)/=0.0)then
           val(2)=0.5*(u(3)-u(1))/(scalex(2)*dx(2))
        else
           val(2)=0.0
        end if
     end if

     if(u(nx)==undef.or.u(nx-2)==undef)then
        val(nx-1)=undef
     else
        if(scalex(nx-1)/=0.0)then
           val(nx-1)=0.5*(u(nx)-u(nx-2))/(scalex(nx-1)*dx(nx-1))
        else
           val(nx-1)=0.0
        end if
     end if

!-- ǡΤʤξüν ---
     if(u(1)==undef.or.u(2)==undef)then
        val(1)=undef
     else
        if(scalex(1)/=0.0)then
           val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
        else
           val(1)=0.0
        end if
     end if
     if(u(nx)==undef.or.u(nx-1)==undef)then
        val(nx)=undef
     else
        if(scalex(nx)/=0.0)then
           val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
        else
           val(nx)=0.0
        end if
     end if
  else
     do i=3,nx-2
        if(scalex(i)/=0.0)then
           val(i)=(coe23*(u(i+1)-u(i-1))-coe112*(u(i+2)-u(i-2)))  &
  &                  /(scalex(i)*dx(i))
        else
           val(i)=0.0
        end if
     end do

!-- ǡΤʤξüν (ξü 1 ¦) ---
     if(scalex(2)/=0.0)then
        val(2)=0.5*(u(3)-u(1))/(scalex(2)*dx(2))
     else
        val(2)=0.0
     end if

     if(scalex(nx-1)/=0.0)then
        val(nx-1)=0.5*(u(nx)-u(nx-2))/(scalex(nx-1)*dx(nx-1))
     else
        val(nx-1)=0.0
     end if

!-- ǡΤʤξüν ---
     if(scalex(1)/=0.0)then
        val(1)=(u(2)-u(1))/(scalex(1)*(x(2)-x(1)))
     else
        val(1)=0.0
     end if
     if(scalex(nx)/=0.0)then
        val(nx)=(u(nx)-u(nx-1))/(scalex(nx)*(x(nx)-x(nx-1)))
     else
        val(nx)=0.0
     end if
  end if

end subroutine grad4_1d

!-----------------------------------------

subroutine grad4_2d( x, y, u, valx, valy, undeff, hx, hy )
  ! 1 顼ۤΥ롼Ѥ 2 ۤΥ٥ȥ׻
  ! $\nabla _hp =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} \right) $ 
  ! 4 ʬǽ񤭴,  $(i,j)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j}-p_{i-1,j}}{2dx} ,\; \frac{p_{i,j+1}-p_{i,j-1}}{2dy} \right) $
  ! $(2/3)*\frac{p_{i+1,j}-p_{i-1,j}}{dx} -(p_{i+2,j}-p_{i-2,j})/(12dx),\; 
  ! (2/3)*\frac{p_{i,j+1}-p_{i,j-1}}{dy} -(p_{i,j+2}-p_{i,j-2})/(12dy)$
  ! ȤǤ. Ѥ2ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! Ѥ 1 ۷׻롼 2 ƤӽФȤˤƤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: u(size(x),size(y))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  real :: scalex(size(x),size(y)), scaley(size(x),size(y))

  nx=size(x)
  ny=size(y)

  if(present(hx).or.present(hy))then
     do j=1,ny
        do i=1,nx
           scalex(i,j)=hx(i,j)
           scaley(i,j)=hy(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           scalex(i,j)=1.0
           scaley(i,j)=1.0
        end do
     end do
  end if

  if(present(undeff))then
     do i=1,ny
        call grad4_1d(x, u(:,i), valx(:,i), undeff)
     end do

     do i=1,nx
        call grad4_1d(y, u(i,:), valy(i,:), undeff)
     end do

     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undeff)then
              if(scalex(i,j)/=0.0)then
                 valx(i,j)=valx(i,j)/scalex(i,j)
              else
                 valx(i,j)=0.0
              end if
              if(scaley(i,j)/=0.0)then
                 valy(i,j)=valy(i,j)/scaley(i,j)
              else
                 valy(i,j)=0.0
              end if
!-- , else ʤΤ, grad_1d 롼ǤǤ undeff äƤ뤫ƱȤ
!-- ʤΤ, 䰦.
           end if
        end do
     end do

  else

     do i=1,ny
        call grad4_1d(x, u(:,i), valx(:,i) )
     end do

     do i=1,nx
        call grad4_1d(y, u(i,:), valy(i,:) )
     end do

     do j=1,ny
        do i=1,nx
           if(scalex(i,j)/=0.0)then
              valx(i,j)=valx(i,j)/scalex(i,j)
           else
              valx(i,j)=0.0
           end if
           if(scaley(i,j)/=0.0)then
              valy(i,j)=valy(i,j)/scaley(i,j)
           else
              valy(i,j)=0.0
           end if
        end do
     end do

  end if

end subroutine grad4_2d

!-----------------------------------------
!-----------------------------------------

subroutine zast_2_w_2d( x, y, zeta, zf, zt, u, v, w, wh, undef )
! terrain following ɸϤɾƤ®ʬǥȺɸϤǤ
! ®ʬѴ.
! , terrain following Ϥοʿ®ϥǥȺɸϤǤ
! 礭Ѳʤ, Υ롼Ǥϱľ®ΤѴԤ.
! ޤ, 3 ǥȷϤγʻѴΤǤϤʤ, terrain following Ϥ
! ®ʬǥȷѴ.
! , ʿˤϥǥȷϤˤΤбƤ.
! ⤷, ɸѴ, vert_coord_conv ⥸塼ѤΤ.
  implicit none
  real, dimension(:), intent(in) :: x  ! κɸ [m]
  real, dimension(:), intent(in) :: y  ! κɸ [m]
  real, dimension(size(x),size(y)), intent(in) :: zeta  ! terrain ϱľɸ [m]
  real, dimension(size(x),size(y)), intent(in) :: zf  ! ɽ̹ٺɸ [m]
  real, dimension(size(x),size(y)), intent(in) :: zt  ! ɸǾü [m]
  real, dimension(size(x),size(y)), intent(in) :: u  ! zeta ˤ [m/s]
  real, dimension(size(x),size(y)), intent(in) :: v  ! zeta ˤ [m/s]
  real, dimension(size(x),size(y)), intent(in) :: w  ! zeta ˤľ [m/s]
  real, dimension(size(x),size(y)), intent(inout) :: wh  ! ǥȷϤˤľ [m/s]
  real, intent(in), optional :: undef  ! »
  integer :: i, j, nx, ny
  real, dimension(size(x),size(y)) :: dx, dy
  real :: j31, j32, jd, coe

  nx=size(x)
  ny=size(y)

  call grad_2d( x, y, zf, dx, dy )

  if(present(undef))then
     do j=1,ny
        do i=1,nx
           if(u(i,j)/=undef.and.v(i,j)/=undef.and.w(i,j)/=undef)then
              jd=1.0-zf(i,j)/zt(i,j)
              coe=zeta(i,j)/zt(i,j)-1.0
              j31=coe*dx(i,j)
              j32=coe*dy(i,j)
              wh(i,j)=(u(i,j)*j31+v(i,j)*j32+w(i,j))/jd
           else
              wh(i,j)=undef
           end if
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           jd=1.0-zf(i,j)/zt(i,j)
           coe=zeta(i,j)/zt(i,j)-1.0
           j31=coe*dx(i,j)
           j32=coe*dy(i,j)
           wh(i,j)=(u(i,j)*j31+v(i,j)*j32+w(i,j))/jd
        end do
     end do
  end if

end subroutine zast_2_w_2d

!-----------------------------------------
!-----------------------------------------

subroutine zast_2_w_3d( x, y, zeta, zf, zt, u, v, w, wh, undef )
! terrain following ɸϤɾƤ®ʬǥȺɸϤǤ
! ®ʬѴ.
! , terrain following Ϥοʿ®ϥǥȺɸϤǤ
! 礭Ѳʤ, Υ롼Ǥϱľ®ΤѴԤ.
! ޤ, 3 ǥȷϤγʻѴΤǤϤʤ, terrain following Ϥ
! ®ʬǥȷѴ.
! , ʿˤϥǥȷϤˤΤбƤ.
! ⤷, ɸѴ, vert_coord_conv ⥸塼ѤΤ.
  implicit none
  real, dimension(:,:,:), intent(in) :: zeta  ! terrain Ϥαľɸ [m]
  real, dimension(size(zeta,1)), intent(in) :: x  ! κɸ [m]
  real, dimension(size(zeta,2)), intent(in) :: y  ! κɸ [m]
  real, dimension(size(zeta,1),size(zeta,2)), intent(in) :: zf  ! ɽ̹ٺɸ [m]
  real, dimension(size(zeta,1),size(zeta,2)), intent(in) :: zt  ! ɸǾü [m]
  real, dimension(size(zeta,1),size(zeta,2),size(zeta,3)), intent(in) :: u  ! zeta ˤ [m/s]
  real, dimension(size(zeta,1),size(zeta,2),size(zeta,3)), intent(in) :: v  ! zeta ˤ [m/s]
  real, dimension(size(zeta,1),size(zeta,2),size(zeta,3)), intent(in) :: w  ! zeta ˤľ [m/s]
  real, dimension(size(zeta,1),size(zeta,2),size(zeta,3)), intent(inout) :: wh  ! ǥȷϤˤľ [m/s]
  real, intent(in), optional :: undef  ! »
  integer :: k, nx, ny, nz

  nx=size(zeta,1)
  ny=size(zeta,2)
  nz=size(zeta,3)

  if(present(undef))then

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call zast_2_w_2d( x, y, zeta(:,:,k), zf, zt,  &
  &                       u(:,:,k), v(:,:,k), w(:,:,k),  &
  &                       wh(:,:,k), undef )
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(k)
     do k=1,nz
        call zast_2_w_2d( x, y, zeta(:,:,k), zf, zt,  &
  &                       u(:,:,k), v(:,:,k), w(:,:,k),  &
  &                       wh(:,:,k) )
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine zast_2_w_3d

!-----------------------------------------
!-----------------------------------------

subroutine laplacian_1d( x, u, val, undef )
! 1 Υ顼ѿΥץ饷׻
! $\frac{\partial ^2p}{\partial x^2} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}+p_{i-1}-2p_i}{dx^2} $
! ȤǤ. Ѥ 1 ץ饷׻.
! ǡ­ʤΰǤ, undef .
! option  undef Ƥʤ, 0.0 .
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ

  nx=size(x)

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef.or.u(i)==undef)then
           val(i)=undef
        else
           val(i)=4.0*(u(i+1)+u(i-1)-2.0*u(i))/((x(i+1)-x(i-1))**2)
        end if
     end do
!-- ǡΤʤξüν ---
!     if(u(1)==undef.or.u(2)==undef)then
!        val(1)=undef
!     else
!        val(1)=(u(2)-u(1))/dx
!     end if
!     if(u(nx)==undef.or.u(nx-1)==undef)then
!        val(nx)=undef
!     else
!        val(nx)=(u(nx)-u(nx-1))/dx
!     end if
     val(1)=undef
     val(nx)=undef
  else
     do i=2,nx-1
        val(i)=4.0*(u(i+1)+u(i-1)-2.0*u(i))/((x(i+1)-x(i-1))**2)
     end do
!-- ǡΤʤξüν ---
!     val(1)=(u(2)-u(1))/dx
!     val(nx)=(u(nx)-u(nx-1))/dx
     val(1)=0.0
     val(nx)=0.0
  end if

end subroutine laplacian_1d

!-----------------------------------------
!-----------------------------------------

subroutine laplacian_2d( x, y, u, val, undef )
! 2 Υ顼ѿΥץ饷׻
! $\frac{\partial ^2p}{\partial x^2} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}+p_{i-1}-2p_i}{dx^2} $
! ȤǤ. Ѥ 1 ץ饷׻.
! ǡ­ʤΰǤ, undef .
! option  undef Ƥʤ, 0.0 .
! ľɸϤؤбϤޤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: u(size(x),size(y))  ! ζб 2 顼
  real, intent(inout) :: val(size(x),size(y))  ! 顼ͤ 2 Υץ饷
  real, intent(in), optional :: undef
  integer :: i, j  ! 졼ź
  integer :: nx, ny  ! ǿ
!  real :: scalex(size(x),size(y))
  real :: tmpu(size(x),size(y)), tmpv(size(x),size(y))

  nx=size(x)
  ny=size(y)

  if(present(undef))then

     val=undef

     do j=1,ny
        call laplacian_1d( x, u(1:nx,j), tmpu(1:nx,j), undef )
     end do
     do i=1,nx
        call laplacian_1d( y, u(i,1:ny), tmpv(i,1:ny), undef )
     end do

     do j=1,ny
        do i=1,nx
           if(tmpu(i,j)/=undef.and.tmpv(i,j)/=undef)then
              val(i,j)=tmpu(i,j)+tmpv(i,j)
           end if
        end do
     end do

  else

     do j=1,ny
        call laplacian_1d( x, u(1:nx,j), tmpu(1:nx,j) )
     end do
     do i=1,nx
        call laplacian_1d( y, u(i,1:ny), tmpv(i,1:ny) )
     end do

     do j=1,ny
        do i=1,nx
           val(i,j)=tmpu(i,j)+tmpv(i,j)
        end do
     end do

  end if

end subroutine laplacian_2d

!-----------------------------------------
!-----------------------------------------

subroutine laplacian_3d( x, y, z, u, val, undef )
! 3 Υ顼ѿΥץ饷׻
! $\frac{\partial ^2p}{\partial x^2} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}+p_{i-1}-2p_i}{dx^2} $
! ȤǤ. Ѥ 1 ץ饷׻.
! ǡ­ʤΰǤ, undef .
! option  undef Ƥʤ, 0.0 .
! ľɸϤؤбϤޤ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ζб 3 顼
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 顼ͤ 3 Υץ饷
  real, intent(in), optional :: undef
  integer :: i, j, k  ! 졼ź
  integer :: nx, ny, nz  ! ǿ
!  real :: scalex(size(x),size(y))
  real :: tmpu(size(x),size(y),size(z)), tmpv(size(x),size(y),size(z))

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(undef))then

     val=undef

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)

     do k=1,nz
        call laplacian_2d( x, y, u(1:nx,1:ny,k), tmpu(1:nx,1:ny,k), undef )
     end do

!$omp end do
!$omp end parallel

     do j=1,ny
        do i=1,nx
           call laplacian_1d( z, u(i,j,1:nz), tmpv(i,j,1:nz), undef )
        end do
     end do

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmpu(i,j,k)/=undef.and.tmpv(i,j,k)/=undef)then
                 val(i,j,k)=tmpu(i,j,k)+tmpv(i,j,k)
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)

     do k=1,nz
        call laplacian_2d( x, y, u(1:nx,1:ny,k), tmpu(1:nx,1:ny,k) )
     end do

!$omp end do
!$omp end parallel

     do j=1,ny
        do i=1,nx
           call laplacian_1d( z, u(i,j,1:nz), tmpv(i,j,1:nz) )
        end do
     end do

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              val(i,j,k)=tmpu(i,j,k)+tmpv(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine laplacian_3d

!-----------------------------------------
!-----------------------------------------

subroutine z_2_zeta( z, zf, zt, zeta )
! ɸ z  terrain following ɸѴ.
  implicit none
  real, intent(in) :: z(:,:,:)    ! ǥȴɸϱľɸ [m]
  real, intent(in) :: zf(size(z,1),size(z,2))   ! ɽ̹ [m]
  real, intent(in) :: zt(size(z,1),size(z,2))   ! ǹ [m]
  real, intent(inout) :: zeta(size(z,1),size(z,2),size(z,3))  ! terrain following ɸ [m]

  integer :: i, j, k
  integer :: nx, ny, nz

  nx=size(z,1)
  ny=size(z,2)
  nz=size(z,3)

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

  do k=1,nz
     do j=1,ny
        do i=1,nx
           zeta(i,j,k)=zt(i,j)*(z(i,j,k)-zf(i,j))/(zt(i,j)-zf(i,j))
        end do
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine z_2_zeta

!-----------------------------------------
!-----------------------------------------


subroutine turb_visc( signal, x, y, z, u, v, w, rho, nuh, nuv, val, undef, hx, hy, hz, sfctau )
! ǥȺɸϤˤήǴ׻.
  implicit none
  character(1) :: signal  ! ǥȺɸϤβܤήʬȽꤹ.
                  ! [1] = ǥȺɸϤˤ x ɸʬ ( u ʬ)
                  ! [2] = ǥȺɸϤˤ y ɸʬ ( v ʬ)
                  ! [3] = ǥȺɸϤˤ z ɸʬ ( w ʬ)
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfctau(size(x),size(y))  ! ɽ̤Υեå
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  character(1) :: signaltau(3)
  integer :: id
  real, dimension(size(x),size(y)) :: stau
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  signaltau=(/ '1', '2', '3' /)
  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  do id=1,3
     if(present(sfctau))then
        stau(:,:)=sfctau(:,:)
        if(present(undef))then
           call Reynolds_stress( signal//signaltau(id),  &
  &             x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, sfctau=stau, undef=undef )
        else
           call Reynolds_stress( signal//signaltau(id),  &
  &             x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, sfctau=stau )
        end if
     else
        if(present(undef))then
           call Reynolds_stress( signal//signaltau(id),  &
  &             x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, undef=undef )
        else
           call Reynolds_stress( signal//signaltau(id),  &
  &             x, y, z, u, v, w, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez )
        end if
     end if
  end do

!-- ήη׻, 3 ȯԤȤǤ뤿,
!-- ʲǤ, div_3d ѤƷ׻Ԥ.

  if(present(undef))then
     call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &               hx=scalex, hy=scaley, hz=scalez, undeff=undef )
  else
     call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &               hx=scalex, hy=scaley, hz=scalez )
  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine Reynolds_stress( signal, x, y, z, u, v, w, rho, nuh, nuv, val,  &
  &                         undef, hx, hy, hz, sfctau )
! ǥȺɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfctau(size(x),size(y))  ! ǥǲؤǤαϤͿƤ, ͤ.
        ! ͤϲ⤻, ñ val κǲؤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real :: stau(size(x),size(y))
  real :: sxx(size(x),size(y),size(z)), nu(size(x),size(y),size(z))
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  logical, dimension(size(x),size(y),size(z)) :: undeflag

  nx=size(x)
  ny=size(y)
  nz=size(z)
  undeflag=.false.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0
  stau=0.0

!-- ɽ̥եåͤ.

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:,:)=sfctau(:,:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

!-- ϥƥ󥽥η׻
  if(present(undef))then
     call deform_tensor( signal, x, y, z, u, v, w, sxx,  &
  &                      hx=scalex, hy=scaley, hz=scalez, undef=undef )
  else
     call deform_tensor( signal, x, y, z, u, v, w, sxx,  &
  &                      hx=scalex, hy=scaley, hz=scalez )
  end if

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do

  else if(signal(1:2)=='23'.or.signal(1:2)=='32')then

     if(signal(2:2)=='3')then
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuv(i,j,k)
              end do
           end do
        end do
     else
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuh(i,j,k)
              end do
           end do
        end do
     end if

  else if(signal(1:2)=='13'.or.signal(1:2)=='31')then

     if(signal(2:2)=='3')then
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuv(i,j,k)
              end do
           end do
        end do
     else
        do k=1,nz
           do j=1,ny
              do i=1,nx
                 nu(i,j,k)=nuh(i,j,k)
              end do
           end do
        end do
     end if

  else if(signal(1:2)=='11')then

     if(present(undef))then
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez, undeff=undef )
     else
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )
     end if

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do

  else if(signal(1:2)=='22')then

     if(present(undef))then
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez, undeff=undef )
     else
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )
     end if

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuh(i,j,k)
           end do
        end do
     end do

  else if(signal(1:2)=='33')then

     if(present(undef))then
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez, undeff=undef )
     else
        call div_3d( x, y, z, u, v, w, val, hx=scalex, hy=scaley, hz=scalez )
     end if

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nu(i,j,k)=nuv(i,j,k)
           end do
        end do
     end do
  end if

  if(present(undef))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(val(i,j,k)==undef.or.nu(i,j,k)==undef.or.sxx(i,j,k)==undef)then
                 undeflag(i,j,k)=.true.
              end if
           end do
        end do
     end do
  end if

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,1).eqv..false.)then
              val(i,j,1)=stau(i,j)
           else
              val(i,j,1)=undef
           end if
        end do
     end do
  else
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,1).eqv..false.)then
              val(i,j,1)=rho(i,j,1)*nu(i,j,1)*(sxx(i,j,1)-(2.0/3.0)*val(i,j,1))
           else
              val(i,j,1)=undef
           end if
        end do
     end do
!$omp end do
!$omp end parallel
  end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
  do k=2,nz
     do j=1,ny
        do i=1,nx
           if(undeflag(i,j,k).eqv..false.)then
              val(i,j,k)=rho(i,j,k)*nu(i,j,k)*(sxx(i,j,k)-(2.0/3.0)*val(i,j,k))
           else
              val(i,j,k)=undef
           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine deform_tensor( signal, x, y, z, u, v, w, val, undef, hx, hy, hz )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z)) :: tmpu, tmpv, tmpw
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  real, dimension(size(x),size(y),size(z)) :: ddx, ddy, ddz
  logical, dimension(size(x),size(y),size(z)) :: undeflag

  nx=size(x)
  ny=size(y)
  nz=size(z)
  undeflag=.false.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(present(undef))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(u(i,j,k)==undef.or.v(i,j,k)==undef.or.w(i,j,k)==undef)then
                 undeflag(i,j,k)=.true.
              end if
           end do
        end do
     end do
  end if

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 tmpu(i,j,k)=u(i,j,k)/scalex(i,j,k)
                 tmpv(i,j,k)=v(i,j,k)/scaley(i,j,k)
              else
                 tmpu(i,j,k)=undef
                 tmpv(i,j,k)=undef
              end if
           end do
        end do
     end do

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, tmpv(:,j,k), ddx(:,j,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, tmpu(i,:,k), ddy(i,:,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if((ddx(i,j,k)==undef).or.(ddy(i,j,k)==undef))then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, tmpv(:,j,k), ddx(:,j,k) )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, tmpu(i,:,k), ddy(i,:,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=ddx(i,j,k)*scaley(i,j,k)/scalex(i,j,k)+  &
  &                         ddy(i,j,k)*scalex(i,j,k)/scaley(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(signal(1:2)=='23'.or.signal(1:2)=='32')then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 tmpv(i,j,k)=v(i,j,k)/scaley(i,j,k)
                 tmpw(i,j,k)=w(i,j,k)/scalez(i,j,k)
              else
                 tmpv(i,j,k)=undef
                 tmpw(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, tmpw(i,:,k), ddy(i,:,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, tmpv(i,j,:), ddz(i,j,:), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if((ddy(i,j,k)==undef).or.(ddz(i,j,k)==undef))then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, tmpw(i,:,k), ddy(i,:,k) )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, tmpv(i,j,:), ddz(i,j,:) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=ddy(i,j,k)*scalez(i,j,k)/scaley(i,j,k)+  &
  &                         ddz(i,j,k)*scaley(i,j,k)/scalez(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(signal(1:2)=='13'.or.signal(1:2)=='31')then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 tmpu(i,j,k)=u(i,j,k)/scalex(i,j,k)
                 tmpw(i,j,k)=w(i,j,k)/scalez(i,j,k)
              else
                 tmpu(i,j,k)=undef
                 tmpw(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, tmpu(i,j,:), ddz(i,j,:), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, tmpw(:,j,k), ddx(:,j,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if((ddz(i,j,k)==undef).or.(ddx(i,j,k)==undef))then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, tmpu(i,j,:), ddz(i,j,:) )
           end do
        end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, tmpw(:,j,k), ddx(:,j,k) )
           end do
        end do
!$omp end do
!$omp end parallel
     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=ddz(i,j,k)*scalex(i,j,k)/scalez(i,j,k)+  &
  &                         ddx(i,j,k)*scalez(i,j,k)/scalex(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(signal(1:2)=='11')then

     !-- scale  undef ꤷƤʤΤ, undef ׻Ϥʤ.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
     do k=1,nz
        do i=1,nx
           call grad_1d( y, scalex(i,:,k), ddy(i,:,k) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, scalex(i,j,:), ddz(i,j,:) )
        end do
     end do
!$omp end do
!$omp end parallel

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, u(:,j,k), ddx(:,j,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if(ddx(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, u(:,j,k), ddx(:,j,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=2.0*(ddx(i,j,k)+ddy(i,j,k)*v(i,j,k)/scaley(i,j,k)+  &
  &                              ddz(i,j,k)*w(i,j,k)/scalez(i,j,k))/scalex(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(signal(1:2)=='22')then

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, v(i,:,k), ddy(i,:,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if(ddy(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, v(i,:,k), ddy(i,:,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

     !-- scale  undef ꤷƤʤΤ, undef ׻Ϥʤ.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
     do j=1,ny
        do i=1,nx
           call grad_1d( z, scaley(i,j,:), ddz(i,j,:) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
     do k=1,nz
        do j=1,ny
           call grad_1d( x, scaley(:,j,k), ddx(:,j,k) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=2.0*(ddy(i,j,k)+ddz(i,j,k)*w(i,j,k)/scalez(i,j,k)+  &
  &                              ddx(i,j,k)*u(i,j,k)/scalex(i,j,k))/scaley(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else if(signal(1:2)=='33')then

     !-- scale  undef ꤷƤʤΤ, undef ׻Ϥʤ.
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
     do k=1,nz
        do i=1,nx
           call grad_1d( y, scalez(i,:,k), ddy(i,:,k) )
        end do
     end do
!$omp end do
!$omp end parallel

     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, w(i,j,:), ddz(i,j,:), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if(ddz(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, w(i,j,:), ddz(i,j,:) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
     do k=1,nz
        do j=1,ny
           call grad_1d( x, scalez(:,j,k), ddx(:,j,k) )
        end do
     end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=2.0*(ddz(i,j,k)+ddx(i,j,k)*u(i,j,k)/scalex(i,j,k)+  &
  &                              ddy(i,j,k)*v(i,j,k)/scaley(i,j,k))/scalez(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine turb_diff( x, y, z, phi, rho, nuh, nuv, val, undef, hx, hy, hz, sfcphi )
! ήȻ׻.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: phi(size(x),size(y),size(z))  ! ήȻ׻륹顼
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľǴ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 3 ȯ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfcphi(size(x),size(y))      ! ɽ̤Υեå
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  character(1) :: signaltau(3)
  integer :: id
  real, dimension(size(x),size(y)) :: stau
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez

  signaltau=(/ '1', '2', '3' /)

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  do id=1,3
     if(present(sfcphi))then
        stau(:,:)=sfcphi(:,:)
        if(present(undef))then
           call Reynolds_scal( signaltau(id),  &
  &             x, y, z, phi, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, sfcphi=stau, undef=undef )
        else
           call Reynolds_scal( signaltau(id),  &
  &             x, y, z, phi, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, sfcphi=stau )
        end if
     else
        if(present(undef))then
           call Reynolds_scal( signaltau(id),  &
  &             x, y, z, phi, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez, undef=undef )
        else
           call Reynolds_scal( signaltau(id),  &
  &             x, y, z, phi, rho, nuh, nuv, tau(:,:,:,id),  &
  &             hx=scalex, hy=scaley, hz=scalez )
        end if
     end if
  end do

!-- ή 3 ȯƱȤʤΤ, div_3d ǤޤȤ.
  if(present(undef))then
     call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &               hx=scalex, hy=scaley, hz=scalez, undeff=undef )
  else
     call div_3d( x, y, z, tau(:,:,:,1), tau(:,:,:,2), tau(:,:,:,3), val,  &
  &               hx=scalex, hy=scaley, hz=scalez )
  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine Reynolds_scal( signal, x, y, z, phi, rho, nuh, nuv, val, undef, hx, hy, hz, sfcphi )
! 顼̤ήեå׻.
  implicit none
  character(1) :: signal  ! ǥȺɸϤβܤήեåʬȽꤹ.
                          ! [1] = ǥȺɸϤˤ x ɸʬ
                          ! [2] = ǥȺɸϤˤ y ɸʬ
                          ! [3] = ǥȺɸϤˤ z ɸʬ
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: phi(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(x),size(y),size(z))  ! ʿȻ
  real, intent(in) :: nuv(size(x),size(y),size(z))  ! ľȻ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  real, intent(in), optional :: sfcphi(size(x),size(y))  ! ǥǲؤǤΥեåͿƤ, ͤ.
        ! ͤϲ⤻, ñ val κǲؤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real, dimension(size(x),size(y)) :: stau
  real, dimension(size(x),size(y),size(z)) :: scalex, scaley, scalez
  logical, dimension(size(x),size(y),size(z)) :: undeflag

  nx=size(x)
  ny=size(y)
  nz=size(z)
  undeflag=.false.

  if(present(hx).and.present(hy).and.present(hz))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=hx(i,j,k)
              scaley(i,j,k)=hy(i,j,k)
              scalez(i,j,k)=hz(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              scalex(i,j,k)=1.0
              scaley(i,j,k)=1.0
              scalez(i,j,k)=1.0
           end do
        end do
     end do
  end if

  val=0.0

  if(present(sfcphi))then
     if(signal(1:1)=='3')then
        stau(:,:)=sfcphi(:,:)
     end if
  end if

  select case (signal(1:1))
  case ('1')
     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, phi(:,j,k), val(:,j,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if(val(i,j,k)==undef.or.nuh(i,j,k)==undef.or.nuv(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j,k)
        do k=1,nz
           do j=1,ny
              call grad_1d( x, phi(:,j,k), val(:,j,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=rho(i,j,k)*nuh(i,j,k)*val(i,j,k)/scalex(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  case ('2')
     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, phi(i,:,k), val(i,:,k), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do k=1,nz
           do j=1,ny
              do i=1,nx
                 if(val(i,j,k)==undef.or.nuh(i,j,k)==undef.or.nuv(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,k)
        do k=1,nz
           do i=1,nx
              call grad_1d( y, phi(i,:,k), val(i,:,k) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=rho(i,j,k)*nuh(i,j,k)*val(i,j,k)/scaley(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  case ('3')
     if(present(undef))then
!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, phi(i,j,:), val(i,j,:), undef=undef )
           end do
        end do
!$omp end do
!$omp end parallel

        do j=1,ny
           do i=1,nx
              do k=1,nz
                 if(val(i,j,k)==undef.or.nuh(i,j,k)==undef.or.nuv(i,j,k)==undef)then
                    undeflag(i,j,k)=.true.
                 end if
              end do
           end do
        end do

     else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)
        do j=1,ny
           do i=1,nx
              call grad_1d( z, phi(i,j,:), val(i,j,:) )
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(undeflag(i,j,k).eqv..false.)then
                 val(i,j,k)=rho(i,j,k)*nuv(i,j,k)*val(i,j,k)/scalez(i,j,k)
              else
                 val(i,j,k)=undef
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

     do j=1,ny
        do i=1,nx
           if(present(sfcphi))then
              if(undeflag(i,j,1).eqv..false.)then
                 val(i,j,1)=stau(i,j)
              else
                 val(i,j,1)=undef
              end if
           end if
        end do
     end do

  end select

end subroutine

!-----------------------------------------
!-----------------------------------------

! ʲ, ꥸʥ zast_2_vel_?d Ǥ뤬, CReSS ǤϿʿ®˴ؤ
! terrain following ʬѲϤʤΤ, ΤȤʲ롼
! ȤӤʤ.
!subroutine zast_2_vel_2d( x, y, zast, u, v, w, uh, vh, wh, undef )
!! terrain following ɸϤɾƤ®ʿȱľѴ.
!! , 3 ǥȷϤѴΤǤϤʤ, terrain following ɸϤ
!! ®ʬǥȷѴ.
!! , ʿˤϥǥȷϤˤΤбƤ.
!! ⤷, ɸѴ, vert_coord_conv ⥸塼ѤΤ.
!  implicit none
!  real, dimension(:), intent(in) :: x  ! κɸ [m]
!  real, dimension(:), intent(in) :: y  ! κɸ [m]
!  real, dimension(size(x),size(y)), intent(in) :: zast  ! terrain Ϥ,  1  [m]
!  real, dimension(size(x),size(y)), intent(in) :: u  ! zast ˤ [m/s]
!  real, dimension(size(x),size(y)), intent(in) :: v  ! zast ˤ [m/s]
!  real, dimension(size(x),size(y)), intent(in) :: w  ! zast ˤľ [m/s]
!  real, dimension(size(x),size(y)), intent(inout) :: uh  ! ǥȷϤˤ [m/s]
!  real, dimension(size(x),size(y)), intent(inout) :: vh  ! ǥȷϤˤ [m/s]
!  real, dimension(size(x),size(y)), intent(inout) :: wh  ! ǥȷϤˤľ [m/s]
!  real, intent(in), optional :: undef  ! »
!  integer :: i, j, nx, ny
!  real, dimension(size(x),size(y)) :: dx, dy
!  real :: cosx, sinx, cosy, siny
!
!  nx=size(x)
!  ny=size(y)
!
!  call grad_2d( x, y, zast, dx, dy )
!
!  if(present(undef))then
!     do j=1,ny
!        do i=1,nx
!           if(u(i,j)/=undef.and.v(i,j)/=undef.and.w(i,j)/=undef)then
!              cosx=1.0/sqrt(1.0+dx(i,j)*dx(i,j))
!              cosy=1.0/sqrt(1.0+dy(i,j)*dy(i,j))
!              sinx=dx(i,j)*cosx
!              siny=dy(i,j)*cosy
!              uh(i,j)=u(i,j)*cosx
!              vh(i,j)=v(i,j)*cosy
!              wh(i,j)=w(i,j)+u(i,j)*sinx+v(i,j)*siny
!           else
!              uh(i,j)=undef
!              vh(i,j)=undef
!              wh(i,j)=undef
!           end if
!        end do
!     end do
!  else
!     do j=1,ny
!        do i=1,nx
!           cosx=1.0/sqrt(1.0+dx(i,j)*dx(i,j))
!           cosy=1.0/sqrt(1.0+dy(i,j)*dy(i,j))
!           sinx=dx(i,j)*cosx
!           siny=dy(i,j)*cosy
!           uh(i,j)=u(i,j)*cosx
!           vh(i,j)=v(i,j)*cosy
!           wh(i,j)=w(i,j)+u(i,j)*sinx+v(i,j)*siny
!        end do
!     end do
!  end if
!
!end subroutine zast_2_vel_2d
!
!!-----------------------------------------
!!-----------------------------------------
!
!subroutine zast_2_vel_3d( x, y, zast, u, v, w, uh, vh, wh, undef )
!! terrain following ɸϤɾƤ®ʿȱľѴ.
!! , 3 ǥȷϤѴΤǤϤʤ, terrain following ɸϤ
!! ®ʬǥȷѴ.
!! , ʿˤϥǥȷϤˤΤбƤ.
!! ⤷, ɸѴ, vert_coord_conv ⥸塼ѤΤ.
!  implicit none
!  real, dimension(:,:,:), intent(in) :: zast  ! terrain Ϥιٺɸ [m]
!  real, dimension(size(zast,1)), intent(in) :: x  ! κɸ [m]
!  real, dimension(size(zast,2)), intent(in) :: y  ! κɸ [m]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(in) :: u  ! zast ˤ [m/s]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(in) :: v  ! zast ˤ [m/s]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(in) :: w  ! zast ˤľ [m/s]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(inout) :: uh  ! ǥȷϤˤ [m/s]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(inout) :: vh  ! ǥȷϤˤ [m/s]
!  real, dimension(size(zast,1),size(zast,2),size(zast,3)), intent(inout) :: wh  ! ǥȷϤˤľ [m/s]
!  real, intent(in), optional :: undef  ! »
!  integer :: k, nx, ny, nz
!
!  nx=size(zast,1)
!  ny=size(zast,2)
!  nz=size(zast,3)
!
!  if(present(undef))then
!
!!$omp parallel default(shared)
!!$omp do schedule(runtime) private(k)
!     do k=1,nz
!        call zast_2_vel_2d( x, y, zast(:,:,k), u(:,:,k), v(:,:,k), w(:,:,k),  &
!  &                         uh(:,:,k), vh(:,:,k), wh(:,:,k), undef )
!     end do
!!$omp end do
!!$omp end parallel
!
!  else
!
!!$omp parallel default(shared)
!!$omp do schedule(runtime) private(k)
!     do k=1,nz
!        call zast_2_vel_2d( x, y, zast(:,:,k), u(:,:,k), v(:,:,k), w(:,:,k),  &
!  &                         uh(:,:,k), vh(:,:,k), wh(:,:,k) )
!     end do
!!$omp end do
!!$omp end parallel
!
!  end if
!
!end subroutine zast_2_vel_3d


end module Derivation
