program Thorpe
  use gtool_history
  use Ellip_Slv
  use Derivation
  use geometry

use omp_lib
  implicit none
  integer :: i, j, k
  integer :: nx, ny, nz
  integer, parameter :: nl=200  ! سβ
  real :: dx, dy, dz
  real, parameter :: xc=0.5, yc=0.5, zc=0.5  ! 濴
  real, parameter :: sr=0.1  ! Ⱦ
  real, allocatable :: x(:), y(:), z(:)
  real, allocatable :: rho(:,:,:)
  real, allocatable :: psi(:,:,:), pt0(:,:,:), dpsi(:,:,:), ug(:,:,:), vg(:,:,:)
  integer :: method
  character(6) :: tp
  real, parameter :: ptmin=280.0, ptmax=380.0
  real :: xd(nl,1), yd(nl,1), zd(nl,1)
  double precision :: t1, t2

 namelist /input /nx,ny,nz,tp,method
 read(5,input)

  allocate(x(nx))
  allocate(y(ny))
  allocate(z(nz))
  allocate(psi(nx,ny,nz))
  allocate(rho(nx,ny,nz))
  allocate(pt0(nx,ny,nz))
  allocate(dpsi(nx,ny,nz))
  allocate(ug(nx,ny,nz))
  allocate(vg(nx,ny,nz))

!-- ʻֳ֤
  dx=1.0/real(nx-1)
  dy=1.0/real(ny-1)
  dz=1.0/real(nz-1)

!-- ɸѿ

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)
  z=(/(dz*(i-1),i=1,nz)/)

!-- ܾ첹̤

  do k=1,nz
     do j=1,ny
        do i=1,nx
           pt0(i,j,k)=ptmin+(ptmax-ptmin)/(z(nz)-z(1))*z(k)
        end do
     end do
  end do

!-- Υޥ꡼γԤس

  call product_circle( xc, yc, sr, nl, xd(:,1), yd(:,1) )
  call product_circle( yc, zc, sr, nl, yd(:,1), zd(:,1) )

  open(unit=10,file='Thorpe.dat',status='unknown')
     do i=1,nl
        write(10,*) xd(i,1), yd(i,1), zd(i,1)
     end do
  close(unit=10,status='keep')

!-- Υޥ꡼

  rho=0.0

  do k=1,nz
     do j=1,ny
        do i=1,nx
!           rho(i,j,k)=(2.0e4/8.85)  &
!  &                   *exp(-((x(i)-xc)**2+(y(j)-yc)**2+(z(k)-zc)**2)/sr/sr)
           if(((x(i)-xc)**2+(y(j)-yc)**2+(z(k)-zc)**2)<sr*sr)then
              rho(i,j,k)=2.0e4/8.85
           end if
        end do
     end do
  end do
 
!-- ݥ᥽åɤ

t1=omp_get_wtime()
  select case (method)
  case(1)
     call Ellip_GauSei_3d(x,y,z,rho,1.0e-6,tp,psi)
  case(2)
     call Ellip_Jacobi_3d(x,y,z,rho,1.0e-6,tp,psi)
  end select
t2=omp_get_wtime()
write(*,*) "ellapse time is", t2-t1

!-- ݥƥ󥷥륢Υޥ꡼Ϲη׻

  do k=1,nz
     call grad_2d( x, y, psi(:,:,k), vg(:,:,k), ug(:,:,k) )
     do j=1,ny
        call grad_1d( x, psi(:,j,k), vg(:,j,k) )
        do i=1,nx
           vg(i,j,k)=vg(i,j,k)*0.25
           ug(i,j,k)=-ug(i,j,k)*0.25
        end do
     end do
  end do

!-- ݥƥ󥷥륢Υޥ꡼αľۤ򲹰̤δܾ­碌

  do j=1,ny
     do i=1,nx
        call grad_1d( z, psi(i,j,:), dpsi(i,j,:) )
        do k=1,nz
           pt0(i,j,k)=pt0(i,j,k)+0.1*dpsi(i,j,k)
        end do
     end do
  end do

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='Thorpe.nc', title='Thorpe model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y','z'/), dimsizes=(/nx,ny,nz/),               &
    & longnames=(/'X-coordinate','Y-coordinate','Z-coordinate'/),       &
    & units=(/'m','m','m'/),                                 &
    & origin=0.0, interval=0.0 )

  call HistoryPut( 'x', x )                            ! ѿ
  call HistoryPut( 'y', y )                            ! ѿ
  call HistoryPut( 'z', z )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='SF', dims=(/'x','y','z'/), &
    & longname='stream function', units='1', xtype='float')

  call HistoryPut('SF',psi)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='pt', dims=(/'x','y','z'/), &
    & longname='potential temperature', units='K', xtype='float')

  call HistoryPut('pt',pt0)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='Ug', dims=(/'x','y','z'/), &
    & longname='geostrophic U', units='m/s', xtype='float')

  call HistoryPut('Ug',ug)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='Vg', dims=(/'x','y','z'/), &
    & longname='geostrophic V', units='m/s', xtype='float')

  call HistoryPut('Vg',vg)                         ! ѿ

  call HistoryClose

end program
