program draw
  use dcl
  use Dcl_Automatic
  use gtool_history
  use Statistics
  use max_min
  use Thermo_Const
  use file_operate
  use basis

  implicit none

  integer :: i, j, k
  integer :: nx, ny, nl
  integer :: nargv, fig_type
  integer :: xdmin, xdmax, ydmin, ydmax
  integer, dimension(2) :: ind 
  real :: xmin, xmax, ymin, ymax, xscale, yscale
  real, allocatable, dimension(:) :: x, y
  real, allocatable, dimension(:,:) :: val1, val2, val3, val4, xd, yd
  real, allocatable, dimension(:,:) :: dum1, dum2
  real, pointer, dimension(:) :: a1
  character(80) :: argv, forma
  character(80) :: cont_val, shade_val, vx_val, vy_val, fname, txtname
  character(80) :: x_axis, y_axis
  character(80), allocatable, dimension(:,:) :: cval
  character(80) :: draw_title, title
  character(1) :: line_flag
  real :: cmin, cmax, smin, smax, sfact, cfact, vxfact, vyfact

  cont_val=''
  shade_val=''
  vx_val=''
  vy_val=''

  namelist /drawinput /fig_type, xmin, xmax, ymin, ymax, fname,  &
  &                    txtname, cont_val, shade_val, vx_val, vy_val,  &
  &                    cmin, cmax, smin, smax, x_axis, y_axis,  &
  &                    sfact, cfact, vxfact, vyfact, title
  read(5,nml=drawinput)

  nullify(a1)
  call HistoryGetPointer( trim(fname), trim(x_axis), a1 )
  nx=size(a1)
  nullify(a1)
  call HistoryGetPointer( trim(fname), trim(y_axis), a1 )
  ny=size(a1)

  allocate(x(nx))
  allocate(y(ny))
  allocate(val1(nx,ny))
  allocate(val2(nx,ny))
  allocate(val3(nx,ny))
  allocate(val4(nx,ny))

  call SGISET('IFONT',2 )
  call UZFACT( 0.6 )
  call GLLSET('LMISS',.TRUE.)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )

  if(trim(title)=='')then
     draw_title=trim(cont_val)//' and '//trim(shade_val)
  else
     draw_title=trim(title)
  end if

!-- ѿ
  call HistoryGet( trim(fname), trim(x_axis), x(1:nx) )
  call HistoryGet( trim(fname), trim(y_axis), y(1:ny) )

  forma=trim(x_axis)//'=^1:'  &
  &   //trim(adjustl( i2c_convert( nx ) ))//','//trim(y_axis)//'=^1:'  &
  &   //trim(adjustl( i2c_convert( ny ) ))
  

  if(cont_val/='')then
     call HistoryGet( trim(fname), trim(cont_val), val1(1:nx,1:ny),  &
  &                   range=trim(adjustl(forma)) )

     do j=1,ny
        do i=1,nx
           if(val1(i,j)/=999.0)then
              val1(i,j)=val1(i,j)*cfact
           end if
        end do
     end do
  end if
  if(shade_val/='')then
     call HistoryGet( trim(fname), trim(shade_val), val2(1:nx,1:ny),  &
  &                   range=trim(adjustl(forma)) )

     do j=1,ny
        do i=1,nx
           if(val2(i,j)/=999.0)then
              val2(i,j)=val2(i,j)*sfact
           end if
        end do
     end do
  end if
  if(vx_val/='')then
     call HistoryGet( trim(fname), trim(vx_val), val3(1:nx,1:ny),  &
  &                   range=trim(adjustl(forma)) )

     do j=1,ny
        do i=1,nx
           if(val3(i,j)/=999.0)then
              val3(i,j)=val3(i,j)
           end if
        end do
     end do
  end if
  if(vy_val/='')then
     call HistoryGet( trim(fname), trim(vy_val), val4(1:nx,1:ny),  &
  &                   range=trim(adjustl(forma)) )

     do j=1,ny
        do i=1,nx
           if(val4(i,j)/=999.0)then
              val4(i,j)=val4(i,j)
           end if
        end do
     end do
  end if

!-- ƥȥǡ뤫ǧ
  if(txtname/='')then
     nl=line_number_counter( trim(txtname) )
     allocate(xd(nl,1))
     allocate(yd(nl,1))
     allocate(cval(2,nl))

     call read_file_text( trim(txtname), 2, nl, cval )

     do i=1,nl
        xd(i,1)=c2r_convert( cval(1,i) )
        yd(i,1)=c2r_convert( cval(2,i) )
     end do
     ind=(/8,8/)  ! index define
  end if

!-- ΰη
  call nearest_search_1d( x, xmin, xdmin )
  call nearest_search_1d( x, xmax, xdmax )
  call nearest_search_1d( y, ymin, ydmin )
  call nearest_search_1d( y, ymax, ydmax )

  xscale=0.05/vxfact
!  xscale=0.025
  call calc_vscale( (/(xmax-xmin), (ymax-ymin)/), (/0.6, 0.6/), xscale, yscale )
!  yscale=yscale

!  dummy=-10.0
write(*,*) "draw", trim(draw_title)
  call color_setting( 10, (/smin, smax/), min_tab=10999, max_tab=99999 )  

  call DclOpenGraphics(2)

  if(fig_type==1)then
     if(txtname/='')then
     call Dcl_2D_cont_shade( trim(draw_title),  &
  &       x(xdmin:xdmax), y(ydmin:ydmax),  &
  &       val1(xdmin:xdmax,ydmin:ydmax),  &
  &       val2(xdmin:xdmax,ydmin:ydmax),  &
  &       (/cmin, cmax/), (/smin, smax/),  &
  &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &       c_num=(/10, 10/), viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &       xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind )  !,  &
     else
     call Dcl_2D_cont_shade( trim(draw_title),  &
  &       x(xdmin:xdmax), y(ydmin:ydmax),  &
  &       val1(xdmin:xdmax,ydmin:ydmax),  &
  &       val2(xdmin:xdmax,ydmin:ydmax),  &
  &       (/cmin, cmax/), (/smin, smax/),  &
  &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &       c_num=(/10, 10/), viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &       trigleg='a', l_idx=ind )  !,  &
     end if
  end if

  if(fig_type==2)then
     if(txtname/='')then
     call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &       x(xdmin:xdmax), y(ydmin:ydmax),  &
  &       val1(xdmin:xdmax,ydmin:ydmax),  &
  &       val2(xdmin:xdmax,ydmin:ydmax),  &
  &       val3(xdmin:xdmax,ydmin:ydmax),  &
  &       val4(xdmin:xdmax,ydmin:ydmax),  &
  &       (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &       c_num=(/10, 10/), viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &       xg=xd(:,1:1), yg=yd(:,1:1), trigleg='a', l_idx=ind,  &
  &       unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &       unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
     else
     call Dcl_2D_cont_shade_vec( trim(draw_title),  &
  &       x(xdmin:xdmax), y(ydmin:ydmax),  &
  &       val1(xdmin:xdmax,ydmin:ydmax),  &
  &       val2(xdmin:xdmax,ydmin:ydmax),  &
  &       val3(xdmin:xdmax,ydmin:ydmax),  &
  &       val4(xdmin:xdmax,ydmin:ydmax),  &
  &       (/20, 20/), (/cmin, cmax/), (/smin, smax/),  &
  &       (/trim(x_axis), trim(y_axis)/), (/'(f6.1)', 'f(6.1)'/),  &
  &       c_num=(/10, 10/), viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/),  &
  &       trigleg='a', l_idx=ind,  &
  &       unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
  &       unit_fact=(/vxfact, vyfact/), unit_title=(/'U','V'/) )
     end if
  end if

  if(fig_type<0)then
     if(trim(cont_val)/='')then
        if(trim(shade_val)/='')then
           line_flag = 'a'
        else
           line_flag = 'l'
        end if
     else
        if(trim(shade_val)/='')then
           line_flag = 'p'
        else
           write(*,*) "ERROR : shade_val or cont_val must set. STOP"
           stop
        end if
     end if
  end if

  if(fig_type==-1)then  ! x axis line draw
     allocate(xd(nx,ny))
     do i=1,nx
        xd(i,:)=x(i)
     end do

     ! ΰϰΤ, c  s 礭 cmin, cmax ľ
     if(cmin>smin)then
        cmin=smin
     end if
     if(cmax<smax)then
        cmax=smax
     end if

     do i=ydmin,ydmax
        call Dcl_PL( trim(line_flag), trim(draw_title),  &
  &          xd(xdmin:xdmax,i:i),  &
  &          val1(xdmin:xdmax,i:i),  &
  &          xd(xdmin:xdmax,i:i),  &
  &          val2(xdmin:xdmax,i:i),  &
  &          (/trim(x_axis), '               '/),  &
  &          x_int=(/xd(xdmin,1), xd(xdmax,1)/), y_int=(/cmin, cmax/),  &
  &          viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/) )
     end do
  end if

  if(fig_type==-2)then  ! y axis line draw
     allocate(yd(ny,nx))  ! ν֤ 2 ܤοʤΤny, nxؤ.
     allocate(dum1(ny,nx))
     allocate(dum2(ny,nx))
     do i=1,ny
        yd(i,:)=y(i)
     end do

     do j=1,ny
        do i=1,nx
           dum1(j,i)=val1(i,j)
           dum2(j,i)=val2(i,j)
        end do
     end do

     ! ΰϰΤ, c  s 礭 cmin, cmax ľ
     if(cmin>smin)then
        cmin=smin
     end if
     if(cmax<smax)then
        cmax=smax
     end if

     do i=xdmin,xdmax
        call Dcl_PL( trim(line_flag), trim(draw_title),  &
  &          dum1(i:i,ydmin:ydmax),  &
  &          yd(ydmin:ydmax,i:i),  &
  &          dum2(i:i,ydmin:ydmax),  &
  &          yd(ydmin:ydmax,i:i),  &
  &          (/'               ', trim(y_axis)/),  &
  &          x_int=(/yd(ydmin,1), yd(ydmax,1)/), y_int=(/cmin, cmax/),  &
  &          viewx_int=(/0.2, 0.8/), viewy_int=(/0.2, 0.8/) )
     end do
  end if


  call DclCloseGraphics

end program
