!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module radar_analysis  ! 졼ǡϥ⥸塼

  use Matrix_calc

  implicit none

contains

subroutine VVP( r, t, p, x, y, z, vr, u, v, w, undef )
! VVP ˡѤƥɥåץ顼졼ư®٥ǡ®ǡѤ.
! ׻ν֤
! 1. ɸѴԤ.
! 2. ׻õ.
! 3. ɸѿ (G) ׻.
! 4. չ (G-1) ׻.
! 5. ׻Ԥ.
!    ʳǵ᤿ʪ̤ 3 ®پʤΤ,  5  3 ʬ׻Τ߹Ԥ.
  implicit none
  integer, intent(in) :: r(:)  ! ưʻҺɸ [m]
  integer, intent(in) :: t(:)  ! Ʊ̳ʻҺɸ [rad]
  integer, intent(in) :: p(:)  ! ĳʻҺɸ [rad]
  integer, intent(in) :: x(:)  ! ʻҺɸ [m]
  integer, intent(in) :: y(:)  ! ʻҺɸ [m]
  integer, intent(in) :: z(:)  ! ľʻҺɸ [m]
  integer, intent(in) :: vr(size(r),size(t),size(p))  ! ɥåץ顼졼®٥ǡ [m/s]
  integer, intent(inout) :: u(size(x),size(y),size(z))  ! ®پǡ [m/s]
  integer, intent(inout) :: v(size(x),size(y),size(z))  ! ®پǡ [m/s]
  integer, intent(inout) :: w(size(x),size(y),size(z))  ! ®پǡ [m/s]
  real, intent(in), optional :: undef  ! ̤ǡ
  real, allocatable, dimension(:) :: Vo, Vv
  real, allocatable, dimension(:,:) :: a, b, c

  integer, parameter :: nm=11
  integer :: i, j, k, nx, ny, nz, nr, nt, np, nl

  nr=size(r)
  nt=size(t)
  np=size(p)
  nx=size(x)
  ny=size(y)
  nz=size(z)
  allocate(a(nm,nm))
  allocate(c(nm,nm))

!$omp parallel default(shared)
!$omp do private(i,j,k,a,b,c,nl,Vo)

  do k=1,nz
     do j=1,ny
        do i=1,nx
        !-- 1,2. ɸѴȷ׻õ.
           call search_calc_point( r, t, p, x(i), y(j), z(k), ix, iy, iz, nl )
           allocate(b(nm,nl))
        !-- 3. ɸѿη׻
        !-- 4. չη׻
           call invert_mat( c, a )
        !-- 5. ׻
           u(i,j,k)=calc_G( 1, a, b, Vo )
           v(i,j,k)=calc_G( 2, a, b, Vo )
           w(i,j,k)=calc_G( 8, a, b, Vo )
           deallocate(b)
        end do
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine VVP

end module radar_analysis
