module make_init
! ͥǡ.

  use gtool_history
  use Derivation
  use Algebra
  use Ellip_Slv
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_init
  use val_coord
  use Thermo_Const
  use Thermo_Function
  use sub_calc

contains

subroutine make_initialize()

  use Thermo_Const
  use Phys_Const
  implicit none

  integer :: i, j, k
  real, dimension(nr+1,nz+1) :: tmp_pres, tmp_pold
  real, dimension(nri,nzi) :: tmp_pi

!-- ͥǡɤ߹

  call HistoryGet( trim(finame), 'r', r_i )
  call HistoryGet( trim(finame), 'z', z_i )
  call HistoryGet( trim(finame), 'u', u_i )
  call HistoryGet( trim(finame), 'v', v_i )
  call HistoryGet( trim(finame), 'w', w_i )
  call HistoryGet( trim(finame), 'p', p_i )   ! p_i -> Pa
  call HistoryGet( trim(finame), 't', t_i )
  call HistoryGet( trim(finame), 'qv', qv_i )
  call HistoryGet( trim(finame), 'ql', ql_i )

!-- Ϥ򵬳ʲ
  do k=1,nzi
     do j=1,nri
        tmp_pi(j,k)=exner_func_dry( p_i(j,k) )  ! tmp_pi -> 1
        p_i(j,k)=tmp_pi(j,k)                    ! p_i -> 1
     end do
  end do

!-- ǡؤ
  call auto_interpolation_2d( r_i, z_i, r_u, z_s, u_i, u_old,  &
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, v_i, v_old,  &
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_w, w_i, w_old,  &
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, p_i, p_old,  &  ! p_old -> 1
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, t_i, t_old,  &
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, qv_i, qv_old,  &
  &                           undef=undef, undefr=undef )
  call auto_interpolation_2d( r_i, z_i, r_s, z_s, ql_i, ql_old,  &
  &                           undef=undef, undefr=undef )

!-- ΰ賰
  do j=1,nz+1
     do i=1,nr+1
        if(u_old(i,j)==undef)then
           u_old(i,j)=0.0
        end if
        if(v_old(i,j)==undef)then
           v_old(i,j)=0.0
        end if
        if(w_old(i,j)==undef)then
           w_old(i,j)=0.0
        end if
        if(ql_old(i,j)==undef)then
           ql_old(i,j)=0.0
        end if
     end do
  end do

  do i=1,nr+1
     if(r_s(i)>r_i(nri))then
        do j=1,nz+1
           p_old(i,j)=ext_1d(r_s(i-2),r_s(i-1),p_old(i-2,j),p_old(i-1,j),r_s(i))
           t_old(i,j)=ext_1d(r_s(i-2),r_s(i-1),t_old(i-2,j),t_old(i-1,j),r_s(i))
           qv_old(i,j)=ext_1d(r_s(i-2),r_s(i-1),qv_old(i-2,j),qv_old(i-1,j),r_s(i))
        end do
     end if
  end do

  do i=nr+1,1,-1
     if(r_s(i)<r_i(1))then
        do j=1,nz+1
           p_old(i,j)=ext_1d(r_s(i+1),r_s(i+2),p_old(i+1,j),p_old(i+2,j),r_s(i))
           t_old(i,j)=ext_1d(r_s(i+1),r_s(i+2),t_old(i+1,j),t_old(i+2,j),r_s(i))
           qv_old(i,j)=ext_1d(r_s(i+1),r_s(i+2),qv_old(i+1,j),qv_old(i+2,j),r_s(i))
        end do
     end if
  end do

  do j=1,nz+1
     if(z_s(j)>z_i(nzi))then
        do i=1,nr+1
           p_old(i,j)=ext_1d(z_s(j-2),z_s(j-1),p_old(i,j-2),p_old(i,j-1),z_s(j))
           t_old(i,j)=ext_1d(z_s(j-2),z_s(j-1),t_old(i,j-2),t_old(i,j-1),z_s(j))
           qv_old(i,j)=ext_1d(z_s(j-2),z_s(j-1),qv_old(i,j-2),qv_old(i,j-1),z_s(j))
        end do
     end if
  end do

  do j=nz+1,1,-1
     if(z_s(j)<z_i(1))then
        do i=1,nr+1
           p_old(i,j)=ext_1d(z_s(j+1),z_s(j+2),p_old(i,j+1),p_old(i,j+2),z_s(j))
           t_old(i,j)=ext_1d(z_s(j+1),z_s(j+2),t_old(i,j+1),t_old(i,j+2),z_s(j))
           qv_old(i,j)=ext_1d(z_s(j+1),z_s(j+2),qv_old(i,j+1),qv_old(i,j+2),z_s(j))
        end do
     end if
  end do

  !-- original data
  do k=1,nz+1
     do j=1,nr+1
        tmp_pold(j,k)=p_old(j,k)   ! tmp_pold -> 1
        tmp_pres(j,k)=p0*(tmp_pold(j,k)**(Cpd/Rd))
     end do
  end do

!-- ǡǡؤ(Don't openMP)
  do k=1,nz+1
     do j=1,nr+1
        ub_u(j,k)=0.0
        vb_s(j,k)=0.0
        wb_w(j,k)=0.0
        pb_s(j,k)=tmp_pold(nr,k)   ! pb_s -> 1
                                ! ¦ΤΰΤߤʿѾȤѤ.
        p_old(j,k)=tmp_pold(j,k)-pb_s(j,k)  ! p_old -> 1 (perturbation)
                                ! ϤΤк׻Ԥ.
        ptb_s(j,k)=t_old(nr,k)
        pti_s(j,k)=t_old(j,k)
        qvb_s(j,k)=qv_old(nr,k)
        qtb_s(j,k)=ql_old(nr,k)
        tempb_s(j,k)=thetaP_2_T( t_old(nr,k), tmp_pres(nr,k) )
        rhob_s(j,k)=TP_2_rho( tempb_s(j,k), tmp_pres(nr,k) )
        ptvb_s(j,k)=TqvP_2_thetav( tempb_s(j,k), qvb_s(j,k), tmp_pres(nr,k) )
        pte_s(j,k)=thetae_Bolton( thetaP_2_T( t_old(j,k), tmp_pres(j,k) ),  &
  &                               qv_old(j,k), tmp_pres(j,k) )
     end do
  end do

!-- new data
  do k=1,nz+1
     do j=1,nr+1
        u_new(j,k)=u_old(j,k)
        v_new(j,k)=v_old(j,k)
        w_new(j,k)=w_old(j,k)
        p_new(j,k)=p_old(j,k)    ! p_new -> 1
        t_new(j,k)=t_old(j,k)
        qv_new(j,k)=qv_old(j,k)
        qc_new(j,k)=qc_old(j,k)
        ql_new(j,k)=ql_old(j,k)
     end do
  end do

!-- Υǡ򸵤, ѿΤ, ƥåˤ.
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz+1
     call auto_interpolation_1d( r_s, r_u, ptb_s(:,k), ptb_u(:,k),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( r_s, r_u, pti_s(:,k), pti_u(:,k),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( r_s, r_u, ptvb_s(:,k), ptvb_u(:,k),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( r_s, r_u, qvb_s(:,k), qvb_u(:,k),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( r_s, r_u, rhob_s(:,k), rhob_u(:,k),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( r_s, r_u, pte_s(:,k), pte_u(:,k),  &
  &                              undef=undef, undefr=undef )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr+1
     call auto_interpolation_1d( z_s, z_w, ptb_s(j,:), ptb_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, pti_s(j,:), pti_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, ptvb_s(j,:), ptvb_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, qvb_s(j,:), qvb_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, rhob_s(j,:), rhob_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, pte_s(j,:), pte_w(j,:),  &
  &                              undef=undef, undefr=undef )
     call auto_interpolation_1d( z_s, z_w, tempb_s(j,:), tempb_w(j,:),  &
  &                              undef=undef, undefr=undef )
  end do
!$omp end do
!$omp end parallel

  do j=1,nr+1
     if(r_u(j)>r_s(nr+1))then
        do k=1,nz+1
           ptb_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), ptb_u(j-2,k), ptb_u(j-1,k), r_u(j))
           pti_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), pti_u(j-2,k), pti_u(j-1,k), r_u(j))
           ptvb_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), ptvb_u(j-2,k), ptvb_u(j-1,k), r_u(j))
           qvb_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), qvb_u(j-2,k), qvb_u(j-1,k), r_u(j))
           rhob_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), rhob_u(j-2,k), rhob_u(j-1,k), r_u(j))
           pte_u(j,k)=ext_1d( r_u(j-2), r_u(j-1), pte_u(j-2,k), pte_u(j-1,k), r_u(j))
        end do
     end if
  end do

  do j=nr+1,1,-1
     if(r_u(j)<r_s(1))then
        do k=1,nz+1
           ptb_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), ptb_u(j+1,k), ptb_u(j+2,k), r_u(j))
           pti_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), pti_u(j+1,k), pti_u(j+2,k), r_u(j))
           ptvb_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), ptvb_u(j+1,k), ptvb_u(j+2,k), r_u(j))
           qvb_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), qvb_u(j+1,k), qvb_u(j+2,k), r_u(j))
           rhob_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), rhob_u(j+1,k), rhob_u(j+2,k), r_u(j))
           pte_u(j,k)=ext_1d( r_u(j+1), r_u(j+2), pte_u(j+1,k), pte_u(j+2,k), r_u(j))
        end do
     end if
  end do

  do k=1,nz+1
     if(z_w(k)>z_s(nz+1))then
        do j=1,nr+1
           ptb_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), ptb_w(j,k-2), ptb_w(j,k-1), z_w(k))
           pti_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), pti_w(j,k-2), pti_w(j,k-1), z_w(k))
           ptvb_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), ptvb_w(j,k-2), ptvb_w(j,k-1), z_w(k))
           qvb_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), qvb_w(j,k-2), qvb_w(j,k-1), z_w(k))
           rhob_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), rhob_w(j,k-2), rhob_w(j,k-1), z_w(k))
           pte_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), pte_w(j,k-2), pte_w(j,k-1), z_w(k))
           tempb_w(j,k)=ext_1d( z_w(k-2), z_w(k-1), tempb_w(j,k-2), tempb_w(j,k-1), z_w(k))
        end do
     end if
  end do

  do k=nz+1,1,-1
     if(z_w(k)<z_s(1))then
        do j=1,nr+1
           ptb_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), ptb_w(j,k+1), ptb_w(j,k+2), z_w(k))
           pti_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), pti_w(j,k+1), pti_w(j,k+2), z_w(k))
           ptvb_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), ptvb_w(j,k+1), ptvb_w(j,k+2), z_w(k))
           qvb_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), qvb_w(j,k+1), qvb_w(j,k+2), z_w(k))
           rhob_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), rhob_w(j,k+1), rhob_w(j,k+2), z_w(k))
           pte_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), pte_w(j,k+1), pte_w(j,k+2), z_w(k))
           tempb_w(j,k)=ext_1d( z_w(k+1), z_w(k+2), tempb_w(j,k+1), tempb_w(j,k+2), z_w(k))
        end do
     end if
  end do

!-- , sst ϰȤƷ׻Ƥ.
  sst_s(1:nr+1)=sst
  sst_u(1:nr+1)=sst 
!  call auto_interpolation_1d( r_i, r_s, sst_i, sst_s )
!  call auto_interpolation_1d( r_i, r_u, sst_i, sst_u )

end subroutine make_initialize

end module
