program thermo2  ! thermo طδؿǧ
  use Thermo_Function
  use Thermo_Advanced_Function
  implicit none
  integer, parameter :: dl=2
  integer, parameter :: n=27
  real :: z_ref
  real, dimension(n) :: z, temp, pres, rh, rho, es, qv, tmpv, pt

  write(*,*) "Input the reference height. [m]"
  read(*,*) z_ref

  z=(/ 0.0, 132.0, 583.0, 1054.0, 1547.0, 2063.0, 2609.0, 3182.0, 3792.0, 4442.0, 5138.0, 5888.0, 6703.0, 7595.0, 8581.0, 9682.0, 10935.0, 12396.0, 13236.0, 14177.0, 15260.0, 16568.0, 17883.0, 19620.0, 20743.0, 22139.0, 23971.0 /)
  pres=(/ 1015.0, 1000.0, 950.0, 900.0, 850.0, 800.0, 750.0, 700.0, 650.0, 600.0, 550.0, 500.0, 450.0, 400.0, 350.0, 300.0, 250.0, 200.0, 175.0, 150.0, 125.0, 100.0, 80.0, 60.0, 50.0, 40.0, 30.0 /)
  temp=(/299.4499817, 299.1499939, 296.1499939, 292.9499817, 290.4499817, 287.7500000, 284.9499817, 281.7500000, 278.2500000, 274.5499878, 270.6499939, 266.2500000, 261.2500000, 255.4499969, 248.3499908, 239.9499969, 229.8499908, 217.9499969, 211.6499939, 205.5499878, 200.9499969, 199.6499939, 203.3499908, 209.2500000, 212.5499878, 215.8499908, 219.1499939 /)
  qv=(/18.2, 17.6, 15.3, 13.0, 11.0, 8.3, 7.0, 5.8, 4.5, 3.5, 3.2, 2.0, 1.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 /)

  qv=1.0e-3*qv
  pres=1.0e2*pres

  tmpv=precip_water(pres,qv,dl=dl)
  tmpv=CAPE(pres,z,qv,temp,z_ref,dl=dl)
  tmpv=CIN(pres,z,qv,temp,z_ref,dl=dl)
  tmpv=z_LCL(z_ref,z,temp,pres,qv,dl=dl)
  tmpv=z_LFC(z_ref,z,temp,pres,qv,dl=dl)
  tmpv=z_LNB(z_ref,z,temp,pres,qv,dl=dl)
  tmpv=T_LFC(z_ref,z,temp,pres,qv,dl=dl)
  tmpv=T_LNB(z_ref,z,temp,pres,qv,dl=dl)

end program
