!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Algebra   ! 黻˹Ԥ⥸塼
! ͭͷ׻, 黻, ٥ȥ黻˹Ԥ.

  use Basis

  public :: rectangle_int

interface rectangle_int

  module procedure rectangle_intf, rectangle_intd

end interface rectangle_int

contains

subroutine rectangle_intf( x, y, bot, top, res, undeff )  ! 1 ʬ
  ! ֳ֤Ǥ׻ǽǤ뤬, ٤ݾڤʤ.
  implicit none
  real, intent(in) :: bot  ! ʬֺü
  real, intent(in) :: top  ! ʬֱü
  real, intent(in) :: x(:)  ! ʬѿ
  real, intent(in) :: y(size(x))  ! ʬؿ
  real, intent(inout) :: res  ! ʬʬ
  real, intent(in), optional :: undeff
  integer :: i, nx, i_bot, i_top
  real :: y_bot, y_top

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "rectangle_int" )
  end if

  res=0.0

!-- bot < top ǤʤХ顼
  if(bot>top)then
     write(*,*) "#### ERROR (algebra:rectangle_int) ####"
     write(*,*) "integrated interval must be bot < top. STOP"
     stop
  end if

!-- ʲʬ
!-- ºݤˤ, ʬ˺Ƕ᤹

  if(present(undeff))then
     do i=1,nx
        if(x(i)/=undeff)then
           if(x(i)>bot)then
              write(*,*) "#### WARNING (algebra:rectangle_int) ####"
              write(*,*) "there is NOT the bot in the x(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
           end if
           exit
        end if
     end do

     do i=nx,1,-1
        if(x(i)/=undeff)then
           if(x(i)<top)then
              write(*,*) "#### WARNING (algebra:rectangle_int) ####"
              write(*,*) "there is NOT the top in the x(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
           end if
           exit
        end if
     end do

     do i=1,nx
        if(x(i)/=undeff)then
           if(x(i)>=bot)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
              i_bot=i
              exit
           end if
        end if
     end do

     do i=nx,1,-1
        if(x(i)/=undeff)then
           if(x(i)<=top)then  ! i_top  bot - top κǤ top ˶Ťʻ
              i_top=i
              exit
           end if
        end if
     end do

  else

     if(x(1)>bot)then
        write(*,*) "#### WARNING (algebra:rectangle_int) ####"
        write(*,*) "there is NOT the bot in the x(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
     end if
     if(x(nx)<top)then
        write(*,*) "#### WARNING (algebra:rectangle_int) ####"
        write(*,*) "there is NOT the top in the x(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
     end if

     do i=1,nx
        if(x(i)>=bot)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
           i_bot=i
           exit
        end if
     end do

     do i=nx,1,-1
        if(x(i)<=top)then  ! i_top  bot - top κǤ top ˶Ťʻ
           i_top=i
           exit
        end if
     end do

  end if

!-- ʲǳʻҤƤϤޤʤʬޤ䴰
  if(present(undeff))then
     if(i_bot/=1)then
        if(y(i_bot)/=undeff.and.y(i_bot-1)/=undeff.and.x(i_bot)/=x(i_bot-1))then
           y_bot=y(i_bot-1)  &
     &           +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
        else
           y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
        end if
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        if(y(i_top)/=undeff.and.y(i_top+1)/=undeff.and.x(i_top+1)/=x(i_top))then
           y_top=y(i_top)  &
     &           +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
        else
           y_top=-y(i_top)
        end if
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  else
     if(i_bot/=1)then
        y_bot=y(i_bot-1)  &
     &        +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        y_top=y(i_top)  &
     &        +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  end if

  if(i_bot<i_top)then  ! ʬ˳ʻҤ 2 İʾ夢Ȥ

     if(present(undeff))then
        do i=i_bot,i_top-1
           if(y(i+1)/=undeff.and.y(i)/=undeff)then
              if(i==i_bot)then
                 res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &                  +0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
                     ! ü;̾ûʬ
              else
                 res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
              end if
           end if
        end do
        res=res+0.5*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     else
        do i=i_bot,i_top-1
           if(i==i_bot)then
              res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &               +0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
                  ! ü;̾ûʬ
           else
              res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
           end if
        end do
        res=res+0.5*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     end if
  else
     if(present(undeff))then
        if(y(i_bot)/=undeff)then
           res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &            +0.5*(top-x(i))*(y_top+y(i))
        else
           res=0.5*(top-bot)*(y_top+y_bot)
        end if
     else
        res=res+0.5*(x(i_bot)-bot)*(y(i_bot)+y_bot)  &
  &         +0.5*(top-x(i_bot))*(y_top+y(i_bot))
     end if
  end if

end subroutine rectangle_intf

!------------------------------------------
!------------------------------------------

subroutine rectangle_intd( x, y, bot, top, res, undeff )  ! 1 ʬ
  ! ֳ֤Ǥ׻ǽǤ뤬, ٤ݾڤʤ.
  implicit none
  double precision, intent(in) :: bot  ! ʬֺü
  double precision, intent(in) :: top  ! ʬֱü
  double precision, intent(in) :: x(:)  ! ʬѿ
  double precision, intent(in) :: y(size(x))  ! ʬؿ
  double precision, intent(inout) :: res  ! ʬʬ
  double precision, intent(in), optional :: undeff
  integer :: i, nx, i_bot, i_top
  double precision :: y_bot, y_top

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "rectangle_int" )
  end if

  res=0.0d0

!-- bot < top ǤʤХ顼
  if(bot>top)then
     write(*,*) "#### ERROR (algebra:rectangle_int) ####"
     write(*,*) "integrated interval must be bot < top. STOP"
     stop
  end if

!-- ʲʬ
!-- ºݤˤ, ʬ˺Ƕ᤹

  if(present(undeff))then
     do i=1,nx
        if(x(i)/=undeff)then
           if(x(i)>bot)then
              write(*,*) "#### WARNING (algebra:rectangle_int) ####"
              write(*,*) "there is NOT the bot in the x(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
           end if
           exit
        end if
     end do

     do i=nx,1,-1
        if(x(i)/=undeff)then
           if(x(i)<top)then
              write(*,*) "#### WARNING (algebra:rectangle_int) ####"
              write(*,*) "there is NOT the top in the x(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
           end if
           exit
        end if
     end do

     do i=1,nx
        if(x(i)/=undeff)then
           if(x(i)>=bot)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
              i_bot=i
              exit
           end if
        end if
     end do

     do i=nx,1,-1
        if(x(i)/=undeff)then
           if(x(i)<=top)then  ! i_top  bot - top κǤ top ˶Ťʻ
              i_top=i
              exit
           end if
        end if
     end do

  else

     if(x(1)>bot)then
        write(*,*) "#### WARNING (algebra:rectangle_int) ####"
        write(*,*) "there is NOT the bot in the x(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
     end if
     if(x(nx)<top)then
        write(*,*) "#### WARNING (algebra:rectangle_int) ####"
        write(*,*) "there is NOT the top in the x(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
     end if

     do i=1,nx
        if(x(i)>=bot)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
           i_bot=i
           exit
        end if
     end do

     do i=nx,1,-1
        if(x(i)<=top)then  ! i_top  bot - top κǤ top ˶Ťʻ
           i_top=i
           exit
        end if
     end do

  end if

!-- ʲǳʻҤƤϤޤʤʬޤ䴰
  if(present(undeff))then
     if(i_bot/=1)then
        if(y(i_bot)/=undeff.and.y(i_bot-1)/=undeff.and.x(i_bot)/=x(i_bot-1))then
           y_bot=y(i_bot-1)  &
     &           +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
        else
           y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
        end if
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        if(y(i_top)/=undeff.and.y(i_top+1)/=undeff.and.x(i_top+1)/=x(i_top))then
           y_top=y(i_top)  &
     &           +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
        else
           y_top=-y(i_top)
        end if
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  else
     if(i_bot/=1)then
        y_bot=y(i_bot-1)  &
     &        +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        y_top=y(i_top)  &
     &        +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  end if

  if(i_bot<i_top)then  ! ʬ˳ʻҤ 2 İʾ夢Ȥ

     if(present(undeff))then
        do i=i_bot,i_top-1
           if(y(i+1)/=undeff.and.y(i)/=undeff)then
              if(i==i_bot)then
                 res=res+0.5d0*(x(i)-bot)*(y(i)+y_bot)  &
  &                  +0.5d0*(x(i+1)-x(i))*(y(i+1)+y(i))
                     ! ü;̾ûʬ
              else
                 res=res+0.5d0*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
              end if
           end if
        end do
        res=res+0.5d0*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     else
        do i=i_bot,i_top-1
           if(i==i_bot)then
              res=res+0.5d0*(x(i)-bot)*(y(i)+y_bot)  &
  &               +0.5d0*(x(i+1)-x(i))*(y(i+1)+y(i))
                  ! ü;̾ûʬ
           else
              res=res+0.5d0*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
           end if
        end do
        res=res+0.5d0*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     end if
  else
     if(present(undeff))then
        if(y(i_bot)/=undeff)then
           res=res+0.5d0*(x(i)-bot)*(y(i)+y_bot)  &
  &            +0.5d0*(top-x(i))*(y_top+y(i))
        else
           res=0.5d0*(top-bot)*(y_top+y_bot)
        end if
     else
        res=res+0.5d0*(x(i_bot)-bot)*(y(i_bot)+y_bot)  &
  &         +0.5d0*(top-x(i_bot))*(y_top+y(i_bot))
     end if
  end if

end subroutine rectangle_intd

!------------------------------------------
!------------------------------------------

subroutine rectangle_int_2d( x, y, z, botx, topx, boty, topy, res, undeff )
  ! 2 ʬ
  ! ֳ֤Ǥ׻ǽǤ뤬, ٤ݾڤʤ.
  ! ʤ, ʬ롼ʬ֤֤˰¸ʤʬˤΤбƤ.
  ! Ĥޤ, \int^{y_2}_{y_1}{\int^{x_2}_{x_1}{f(x,y)dxdy}}
  ! ׻Ȥ, y_1, y_2, x_1, x_2 줾 x, y ˰¸ʤȤǤ.

  implicit none
  real, intent(in) :: x(:)  ! ʬѿ 1
  real, intent(in) :: y(:)  ! ʬѿ 2
  real, intent(in) :: botx  ! ʬ 1 ü
  real, intent(in) :: topx  ! ʬ 1 ü
  real, intent(in) :: boty  ! ʬ 2 ü
  real, intent(in) :: topy  ! ʬ 2 ü
  real, intent(in) :: z(size(x),size(y))  ! ʬؿ
  real, intent(inout) :: res  ! ʬʬ
  real, intent(in), optional :: undeff
  integer :: i, j, nx, ny, i_bot, i_top
  real :: resy(size(y))

  nx=size(x)
  ny=size(y)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, z ),  &
  &                                     "rectangle_int_2d" )
  end if

  resy=0.0
  res=0.0

!-- ʲʬ
!-- ºݤˤ, ʬ˺Ƕ᤹

  if(y(1)>boty)then
     write(*,*) "#### WARNING ####"
     write(*,*) "there is NOT the bot in the y(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
  end if
  if(y(ny)<topy)then
     write(*,*) "#### WARNING ####"
     write(*,*) "there is NOT the top in the y(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
  end if

  do i=1,ny
     if(y(i)>=boty)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
        i_bot=i
        exit
     end if
  end do

  if(i_bot>1)then  ! ΰ 1 ʻҳ¦ꤷƤ.
     i_bot=i_bot-1
  end if

  do i=ny,1,-1
     if(y(i)<=topy)then  ! i_top  bot - top κǤ top ˶Ťʻ
        i_top=i
        exit
     end if
  end do

  if(i_top<ny)then  ! ΰ 1 ʻҳ¦ꤷƤ.
     i_top=i_top+1
  end if

  if(present(undeff))then
     do j=i_bot,i_top
        call rectangle_int( x, z(:,j), botx, topx, resy(j), undeff=undeff )
     end do

     call rectangle_int( y, resy, boty, topy, res, undeff=undeff )

  else
     do j=i_bot,i_top
        call rectangle_int( x, z(:,j), botx, topx, resy(j) )
     end do

     call rectangle_int( y, resy, boty, topy, res )

  end if

end subroutine rectangle_int_2d

!------------------------------------------
!------------------------------------------

subroutine abst_2d(x,y,dis)
  ! 2 ٥ȥͤ׻롼
  implicit none
  real, intent(in) :: x(:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2))  ! y Υ٥ȥʬ
  real, intent(inout) :: dis(size(x,1),size(x,2))  ! Ǥͥ٥ȥ
  integer :: i, j, nx, ny

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "abst_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, dis ),  &
  &                                     "abst_2d" )
  end if

  do j=1,ny
     do i=1,nx
        dis(i,j)=sqrt(x(i,j)**2+y(i,j)**2)
     end do
  end do

end subroutine abst_2d

!------------------------------------------
!------------------------------------------

subroutine abst_3d(x,y,z,dis)  ! 3 ٥ȥͤ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dis(size(x,1),size(x,2),size(x,3))  ! Ǥͥ٥ȥ
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "abst_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, z ),  &
  &                                     "abst_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, dis ),  &
  &                                     "abst_3d" )
  end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dis(i,j,k)=sqrt(x(i,j,k)**2+y(i,j,k)**2+z(i,j,k)**2)
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine abst_3d

!------------------------------------------
!------------------------------------------

subroutine calc_radius(xp,yp,zp,x,y,z,rad)
  ! ֤εΥ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: xp  ! 濴ֺɸ x ʬ
  real, intent(in) :: yp  ! 濴ֺɸ y ʬ
  real, intent(in) :: zp  ! 濴ֺɸ z ʬ
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: z(:)  ! z ΰֺɸ
  real, intent(inout) :: rad(size(x),size(y),size(z))  ! Υ
  integer :: i, j, k, nx, ny, nz

  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, rad ),  &
  &                                     "calc_radius" )
  end if

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           rad(i,j,k)=sqrt((x(i)-xp)**2+(y(j)-yp)**2+(z(k)-zp)**2)
        end do
     end do
  end do
!$omp end do
!$omp end parallel


end subroutine calc_radius

!------------------------------------------
!------------------------------------------

subroutine dot_prod_2d(x,y,u,v,dot,undeff)
  ! 2٥ȥѷ׻롼
  ! dot_prod  2 
  implicit none
  real, intent(in) :: x(:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2))  ! y Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2))  ! y Υ٥ȥʬ
  real, intent(inout) :: dot(size(x,1),size(x,2))  ! 
  real, intent(in), optional :: undeff        ! ̤
  integer :: i, j, nx, ny

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "dot_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "dot_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, v ),  &
  &                                     "dot_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, dot ),  &
  &                                     "dot_prod_2d" )
  end if

  if(present(undeff))then

     do j=1,ny
        do i=1,nx
           if(x(i,j)==undeff.or.u(i,j)==undeff.or.  &
  &           y(i,j)==undeff.or.v(i,j)==undeff)then
              dot(i,j)=undeff
           else
              dot(i,j)=x(i,j)*u(i,j)+y(i,j)*v(i,j)
           end if
        end do
     end do

  else

     do j=1,ny
        do i=1,nx
           dot(i,j)=x(i,j)*u(i,j)+y(i,j)*v(i,j)
        end do
     end do

  end if

end subroutine dot_prod_2d

!------------------------------------------
!------------------------------------------

subroutine dot_prod_3d(x,y,z,u,v,w,dot,undeff)
  ! 2٥ȥѷ׻롼
  ! פ, 2 ǤѤ׻뤳Ȥǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dot(size(x,1),size(x,2),size(x,3))  ! 
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "dot_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, z ),  &
  &                                     "dot_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, u ),  &
  &                                     "dot_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, v ),  &
  &                                     "dot_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, w ),  &
  &                                     "dot_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, dot ),  &
  &                                     "dot_prod_3d" )
  end if

  if(present(undeff))then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 dot(i,j,k)=undeff
              else
                 dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
           end do
        end do
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine dot_prod_3d

!------------------------------------------
!------------------------------------------

subroutine vec_prod_2d(x,y,u,v,vecz,undeff)
  ! 2٥ȥγѷ׻롼
  ! vec_prod  2 
  ! ѤʤΤ, 2 Ƿ׻, Ѥ 1 ʬʤΤ,
  ! intent(inout) ΰ 1 ĤʤȤ.
  implicit none
  real, intent(in) :: x(:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2))  ! y Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2))  ! y Υ٥ȥʬ
  real, intent(inout) :: vecz(size(x,1),size(x,2))  ! Ѥľʬ
  real, intent(in), optional :: undeff
  integer :: i, j, nx, ny

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "vec_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "vec_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, v ),  &
  &                                     "vec_prod_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, vecz ),  &
  &                                     "vec_prod_2d" )
  end if

  if(present(undeff))then

        do j=1,ny
           do i=1,nx
              if(x(i,j)==undeff.or.u(i,j)==undeff.or.  &
  &              y(i,j)==undeff.or.v(i,j)==undeff)then
                 vecz(i,j)=undeff
              else
                 vecz(i,j)=x(i,j)*v(i,j)-y(i,j)*u(i,j)
              end if
           end do
        end do

  else

        do j=1,ny
           do i=1,nx
              vecz(i,j)=x(i,j)*v(i,j)-y(i,j)*u(i,j)
           end do
        end do

  end if

end subroutine vec_prod_2d

!-----------------------------------------
!-----------------------------------------

subroutine vec_prod_3d(x,y,z,u,v,w,vecx,vecy,vecz,undeff)
  ! 2٥ȥγѷ׻롼
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: vecx(size(x,1),size(x,2),size(x,3))  ! Ѥ x ʬ
  real, intent(inout) :: vecy(size(x,1),size(x,2),size(x,3))  ! Ѥ y ʬ
  real, intent(inout) :: vecz(size(x,1),size(x,2),size(x,3))  ! Ѥ z ʬ
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, z ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, u ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, v ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, w ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, vecx ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, vecy ),  &
  &                                     "vec_prod_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, vecz ),  &
  &                                     "vec_prod_3d" )
  end if

  if(present(undeff))then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 vecx(i,j,k)=undeff
                 vecy(i,j,k)=undeff
                 vecz(i,j,k)=undeff
              else
                 vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
                 vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
                 vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
              vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
              vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
           end do
        end do
     end do
!$omp end do
!$omp end parallel

  end if

end subroutine vec_prod_3d

!-----------------------------------------
!-----------------------------------------

!-----------------------------------------
!-----------------------------------------

end module Algebra
