!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module max_min  ! ׻⥸塼 1

interface max_val_1d

  module procedure max_val_1di, max_val_1df, max_val_1dd

end interface max_val_1d

interface max_val_2d

  module procedure max_val_2di, max_val_2df, max_val_2dd

end interface max_val_2d

interface max_val_3d

  module procedure max_val_3di, max_val_3df, max_val_3dd

end interface max_val_3d

interface min_val_1d

  module procedure min_val_1di, min_val_1df, min_val_1dd

end interface min_val_1d

interface min_val_2d

  module procedure min_val_2di, min_val_2df, min_val_2dd

end interface min_val_2d

interface min_val_3d

  module procedure min_val_3di, min_val_3df, min_val_3dd

end interface min_val_3d

contains


subroutine max_val_1di(var, mamn, mamv, undef)
  ! 1 Ѻ, ֹ롼
  implicit none
  integer, intent(in) :: var(:)  ! õ
  integer, intent(inout) :: mamn  ! κͤ˳ֹ
  integer, intent(inout) :: mamv  ! κ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mamv=var(i)
              mamn=i
           else
              if(var(i)>mamv)then
                 mamv=var(i)
                 mamn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mamn=nx+1
        mamv=undef
     end if

  else

     mamv=var(1)
     mamn=1

     do i=2,nx
        if(var(i)>mamv)then
           mamv=var(i)
           mamn=i
        end if
     end do
  end if

end subroutine max_val_1di

!-----------------------------
!-----------------------------

subroutine max_val_1df(var, mamn, mamv, undef)
  ! 1 Ѻ, ֹ롼
  implicit none
  real, intent(in) :: var(:)  ! õ
  integer, intent(inout) :: mamn  ! κͤ˳ֹ
  real, intent(inout) :: mamv  ! κ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mamv=var(i)
              mamn=i
           else
              if(var(i)>mamv)then
                 mamv=var(i)
                 mamn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mamn=nx+1
        mamv=undef
     end if

  else

     mamv=var(1)
     mamn=1

     do i=2,nx
        if(var(i)>mamv)then
           mamv=var(i)
           mamn=i
        end if
     end do
  end if

end subroutine max_val_1df

!-----------------------------
!-----------------------------

subroutine max_val_1dd(var, mamn, mamv, undef)
  ! 1 Ѻ, ֹ롼
  implicit none
  double precision, intent(in) :: var(:)  ! õ
  integer, intent(inout) :: mamn  ! κͤ˳ֹ
  double precision, intent(inout) :: mamv  ! κ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mamv=var(i)
              mamn=i
           else
              if(var(i)>mamv)then
                 mamv=var(i)
                 mamn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mamn=nx+1
        mamv=undef
     end if

  else

     mamv=var(1)
     mamn=1

     do i=2,nx
        if(var(i)>mamv)then
           mamv=var(i)
           mamn=i
        end if
     end do
  end if

end subroutine max_val_1dd

!-----------------------------
!-----------------------------

subroutine max_val_2di(var, mamnx, mamny, mamv, undef)
! 2 Ѻ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  integer, intent(in) :: var(:,:)  ! 2 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  integer, intent(inout) :: mamv  ! κ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  integer :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call max_val_1di(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call max_val_1di(tmp,mamny,mamv,undef)

     if(mamny==ny+1)then
        mamnx=nx+1
     else
        mamnx=tmp_num(mamny)
     end if

  else

     do j=1,ny
        call max_val_1di(var(:,j),tmp_num(j),tmp(j))
     end do
     call max_val_1di(tmp,mamny,mamv)

     mamnx=tmp_num(mamny)

  end if

end subroutine max_val_2di

!-----------------------------
!-----------------------------

subroutine max_val_2df(var, mamnx, mamny, mamv, undef)
! 2 Ѻ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  real, intent(in) :: var(:,:)  ! 2 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  real, intent(inout) :: mamv  ! κ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  real :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call max_val_1df(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call max_val_1df(tmp,mamny,mamv,undef)

     if(mamny==ny+1)then
        mamnx=nx+1
     else
        mamnx=tmp_num(mamny)
     end if

  else

     do j=1,ny
        call max_val_1df(var(:,j),tmp_num(j),tmp(j))
     end do
     call max_val_1df(tmp,mamny,mamv)

     mamnx=tmp_num(mamny)

  end if

end subroutine max_val_2df

!-----------------------------
!-----------------------------

subroutine max_val_2dd(var, mamnx, mamny, mamv, undef)
! 2 Ѻ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  double precision, intent(in) :: var(:,:)  ! 2 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  double precision, intent(inout) :: mamv  ! κ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  double precision :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call max_val_1dd(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call max_val_1dd(tmp,mamny,mamv,undef)

     if(mamny==ny+1)then
        mamnx=nx+1
     else
        mamnx=tmp_num(mamny)
     end if

  else

     do j=1,ny
        call max_val_1dd(var(:,j),tmp_num(j),tmp(j))
     end do
     call max_val_1dd(tmp,mamny,mamv)

     mamnx=tmp_num(mamny)

  end if

end subroutine max_val_2dd

!-----------------------------
!-----------------------------

subroutine max_val_3di(var, mamnx, mamny, mamnz, mamv, undef)
  ! 3 Ѻ, ֹ롼
  implicit none
  integer, intent(in) :: var(:,:,:)  ! 3 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  integer, intent(inout) :: mamnz  ! κͤ˳ 3 ֹ
  integer, intent(inout) :: mamv  ! κ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  integer :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call max_val_2di(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call max_val_1di(tmp,mamnz,mamv,undef)

     if(mamnz==nz+1)then
        mamnx=nx+1
        mamny=ny+1
     else
        mamnx=tmp_num1(mamnz)
        mamny=tmp_num2(mamnz)
     end if

  else

     do j=1,nz
        call max_val_2di(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call max_val_1di(tmp,mamnz,mamv)

     mamnx=tmp_num1(mamnz)
     mamny=tmp_num2(mamnz)

  end if

end subroutine max_val_3di

!-----------------------------
!-----------------------------

subroutine max_val_3df(var, mamnx, mamny, mamnz, mamv, undef)
  ! 3 Ѻ, ֹ롼
  implicit none
  real, intent(in) :: var(:,:,:)  ! 3 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  integer, intent(inout) :: mamnz  ! κͤ˳ 3 ֹ
  real, intent(inout) :: mamv  ! κ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  real :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call max_val_2df(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call max_val_1df(tmp,mamnz,mamv,undef)

     if(mamnz==nz+1)then
        mamnx=nx+1
        mamny=ny+1
     else
        mamnx=tmp_num1(mamnz)
        mamny=tmp_num2(mamnz)
     end if

  else

     do j=1,nz
        call max_val_2df(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call max_val_1df(tmp,mamnz,mamv)

     mamnx=tmp_num1(mamnz)
     mamny=tmp_num2(mamnz)

  end if

end subroutine max_val_3df

!-----------------------------
!-----------------------------

subroutine max_val_3dd(var, mamnx, mamny, mamnz, mamv, undef)
  ! 3 Ѻ, ֹ롼
  implicit none
  double precision, intent(in) :: var(:,:,:)  ! 3 õ
  integer, intent(inout) :: mamnx  ! κͤ˳ 1 ֹ
  integer, intent(inout) :: mamny  ! κͤ˳ 2 ֹ
  integer, intent(inout) :: mamnz  ! κͤ˳ 3 ֹ
  double precision, intent(inout) :: mamv  ! κ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  double precision :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call max_val_2dd(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call max_val_1dd(tmp,mamnz,mamv,undef)

     if(mamnz==nz+1)then
        mamnx=nx+1
        mamny=ny+1
     else
        mamnx=tmp_num1(mamnz)
        mamny=tmp_num2(mamnz)
     end if

  else

     do j=1,nz
        call max_val_2dd(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call max_val_1dd(tmp,mamnz,mamv)

     mamnx=tmp_num1(mamnz)
     mamny=tmp_num2(mamnz)

  end if

end subroutine max_val_3dd

!-----------------------------
!-----------------------------

subroutine min_val_1di(var, mimn, mimv, undef)
!-- 1 ѺǾ, ֹ롼
  implicit none
  integer, intent(in) :: var(:)  ! Ǿõ
  integer, intent(inout) :: mimn  ! κǾͤ˳ֹ
  integer, intent(inout) :: mimv  ! κǾ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mimv=var(i)
              mimn=i
           else
              if(var(i)<mimv)then
                 mimv=var(i)
                 mimn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mimn=nx+1
        mimv=undef
     end if

  else

     mimv=var(1)
     mimn=1

     do i=2,nx
        if(var(i)<mimv)then
           mimv=var(i)
           mimn=i
        end if
     end do

  end if

end subroutine min_val_1di

!-----------------------------
!-----------------------------

subroutine min_val_1df(var, mimn, mimv, undef)
!-- 1 ѺǾ, ֹ롼
  implicit none
  real, intent(in) :: var(:)  ! Ǿõ
  integer, intent(inout) :: mimn  ! κǾͤ˳ֹ
  real, intent(inout) :: mimv  ! κǾ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mimv=var(i)
              mimn=i
           else
              if(var(i)<mimv)then
                 mimv=var(i)
                 mimn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mimn=nx+1
        mimv=undef
     end if

  else

     mimv=var(1)
     mimn=1

     do i=2,nx
        if(var(i)<mimv)then
           mimv=var(i)
           mimn=i
        end if
     end do

  end if

end subroutine min_val_1df

!-----------------------------
!-----------------------------

subroutine min_val_1dd(var, mimn, mimv, undef)
!-- 1 ѺǾ, ֹ롼
  implicit none
  double precision, intent(in) :: var(:)  ! Ǿõ
  integer, intent(inout) :: mimn  ! κǾͤ˳ֹ
  double precision, intent(inout) :: mimv  ! κǾ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  ! Ŀ(size ؿǼư׻)
  integer :: i  ! 졼ź
  logical :: undeflag

  nx=size(var)
  undeflag=.true.

  if(present(undef))then

     do i=1,nx
        if(var(i)/=undef)then
           if(undeflag.eqv..true.)then
              undeflag=.false.
              mimv=var(i)
              mimn=i
           else
              if(var(i)<mimv)then
                 mimv=var(i)
                 mimn=i
              end if
           end if
        end if
     end do

     if(undeflag.eqv..true.)then
        mimn=nx+1
        mimv=undef
     end if

  else

     mimv=var(1)
     mimn=1

     do i=2,nx
        if(var(i)<mimv)then
           mimv=var(i)
           mimn=i
        end if
     end do

  end if

end subroutine min_val_1dd

!-----------------------------
!-----------------------------

subroutine min_val_2di(var, mimnx, mimny, mimv, undef)
! 2 ѺǾ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  integer, intent(in) :: var(:,:)  ! 2 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  integer, intent(inout) :: mimv  ! κǾ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  integer :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call min_val_1di(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call min_val_1di(tmp,mimny,mimv,undef)

     if(mimny==ny+1)then
        mimnx=nx+1
     else
        mimnx=tmp_num(mimny)
     end if

  else

     do j=1,ny
        call min_val_1di(var(:,j),tmp_num(j),tmp(j))
     end do
     call min_val_1di(tmp,mimny,mimv)

     mimnx=tmp_num(mimny)
  end if

end subroutine min_val_2di

!-----------------------------
!-----------------------------

subroutine min_val_2df(var, mimnx, mimny, mimv, undef)
! 2 ѺǾ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  real, intent(in) :: var(:,:)  ! 2 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  real, intent(inout) :: mimv  ! κǾ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  real :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call min_val_1df(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call min_val_1df(tmp,mimny,mimv,undef)

     if(mimny==ny+1)then
        mimnx=nx+1
     else
        mimnx=tmp_num(mimny)
     end if

  else

     do j=1,ny
        call min_val_1df(var(:,j),tmp_num(j),tmp(j))
     end do
     call min_val_1df(tmp,mimny,mimv)

     mimnx=tmp_num(mimny)
  end if

end subroutine min_val_2df

!-----------------------------
!-----------------------------

subroutine min_val_2dd(var, mimnx, mimny, mimv, undef)
! 2 ѺǾ, ֹ롼
!-- 2 Ǥ, x  y  1 롼Ƥ, Ǥκͤ1
!-- Ǽ, Ф1롼Ѥ뤳Ȥ, ΤκͤФ
  implicit none
  double precision, intent(in) :: var(:,:)  ! 2 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  double precision, intent(inout) :: mimv  ! κǾ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  double precision :: tmp(size(var,2))  ! 
  integer :: tmp_num(size(var,2))  ! 

  nx=size(var,1)
  ny=size(var,2)

  if(present(undef))then
     do j=1,ny
        call min_val_1dd(var(:,j),tmp_num(j),tmp(j),undef)
     end do
     call min_val_1dd(tmp,mimny,mimv,undef)

     if(mimny==ny+1)then
        mimnx=nx+1
     else
        mimnx=tmp_num(mimny)
     end if

  else

     do j=1,ny
        call min_val_1dd(var(:,j),tmp_num(j),tmp(j))
     end do
     call min_val_1dd(tmp,mimny,mimv)

     mimnx=tmp_num(mimny)
  end if

end subroutine min_val_2dd

!-----------------------------
!-----------------------------

subroutine min_val_3di(var, mimnx, mimny, mimnz, mimv, undef)
  ! 3 ѺǾ, ֹ롼
  implicit none
  integer, intent(in) :: var(:,:,:)  ! 3 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  integer, intent(inout) :: mimnz  ! κǾͤ˳ 3 ֹ
  integer, intent(inout) :: mimv  ! κǾ
  integer, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  integer :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call min_val_2di(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call min_val_1di(tmp,mimnz,mimv,undef)

     if(mimnz==nz+1)then
        mimnx=nx+1
        mimny=ny+1
     else
        mimnx=tmp_num1(mimnz)
        mimny=tmp_num2(mimnz)
     end if

  else

     do j=1,nz
        call min_val_2di(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call min_val_1di(tmp,mimnz,mimv)

     mimnx=tmp_num1(mimnz)
     mimny=tmp_num2(mimnz)
  end if

end subroutine min_val_3di

!-----------------------------
!-----------------------------

subroutine min_val_3df(var, mimnx, mimny, mimnz, mimv, undef)
  ! 3 ѺǾ, ֹ롼
  implicit none
  real, intent(in) :: var(:,:,:)  ! 3 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  integer, intent(inout) :: mimnz  ! κǾͤ˳ 3 ֹ
  real, intent(inout) :: mimv  ! κǾ
  real, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  real :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call min_val_2df(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call min_val_1df(tmp,mimnz,mimv,undef)

     if(mimnz==nz+1)then
        mimnx=nx+1
        mimny=ny+1
     else
        mimnx=tmp_num1(mimnz)
        mimny=tmp_num2(mimnz)
     end if

  else

     do j=1,nz
        call min_val_2df(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call min_val_1df(tmp,mimnz,mimv)

     mimnx=tmp_num1(mimnz)
     mimny=tmp_num2(mimnz)
  end if

end subroutine min_val_3df

!-----------------------------
!-----------------------------

subroutine min_val_3dd(var, mimnx, mimny, mimnz, mimv, undef)
  ! 3 ѺǾ, ֹ롼
  implicit none
  double precision, intent(in) :: var(:,:,:)  ! 3 Ǿõ
  integer, intent(inout) :: mimnx  ! κǾͤ˳ 1 ֹ
  integer, intent(inout) :: mimny  ! κǾͤ˳ 2 ֹ
  integer, intent(inout) :: mimnz  ! κǾͤ˳ 3 ֹ
  double precision, intent(inout) :: mimv  ! κǾ
  double precision, intent(in), optional :: undef  ! ̤
  integer :: nx  !  1 ǤĿ(size ؿǼư׻)
  integer :: ny  !  2 ǤĿ(size ؿǼư׻)
  integer :: nz  !  3 ǤĿ(size ؿǼư׻)
  integer :: j  ! 졼ź
  double precision :: tmp(size(var,3))  ! 
  integer :: tmp_num1(size(var,3))  ! 
  integer :: tmp_num2(size(var,3))  ! 

  nx=size(var,1)
  ny=size(var,2)
  nz=size(var,3)

  if(present(undef))then
     do j=1,nz
        call min_val_2dd(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j),undef)
     end do
     call min_val_1dd(tmp,mimnz,mimv,undef)

     if(mimnz==nz+1)then
        mimnx=nx+1
        mimny=ny+1
     else
        mimnx=tmp_num1(mimnz)
        mimny=tmp_num2(mimnz)
     end if

  else

     do j=1,nz
        call min_val_2dd(var(:,:,j),tmp_num1(j),tmp_num2(j),tmp(j))
     end do
     call min_val_1dd(tmp,mimnz,mimv)

     mimnx=tmp_num1(mimnz)
     mimny=tmp_num2(mimnz)
  end if

end subroutine min_val_3dd



end module max_min
