program make_init
!-- producing initial data of zeta
!-- Version Montgomery and Kallenbach (1997).

  use gtool_history

  implicit none

  double precision, parameter :: rmax=20.0d0
  double precision, parameter :: vmax=50.0d0

!-- namelist variables

  integer :: nx, ny
  integer :: mnum
  real, allocatable, dimension(:) :: xr, yr
  double precision :: xmin, ymin, dx, dy
  double precision :: zetamax, zetap
  character(1000) :: fname

  integer :: i, j, k
  double precision :: r, theta, coe, coe1, alpha
  double precision :: tcx, tcy
  double precision, allocatable, dimension(:) :: x, y
  double precision, allocatable, dimension(:,:) :: zeta
  double precision :: makez

  namelist /initial /nx, ny, xmin, ymin, dx, dy, fname,  &
  &                  tcx, tcy
  namelist /vprof /zetamax, zetap, mnum, alpha
  read(5,nml=initial)
  read(5,nml=vprof)

  allocate(x(nx))
  allocate(y(ny))
  allocate(xr(nx))
  allocate(yr(ny))
  allocate(zeta(nx,ny))

  x=(/((xmin+dx*dble(i-1)),i=1,nx)/)
  y=(/((ymin+dy*dble(j-1)),j=1,ny)/)

  xr=(/((xmin+dx*real(i-1)),i=1,nx)/)
  yr=(/((ymin+dy*real(j-1)),j=1,ny)/)

  zeta=0.0d0
  coe1=1.0d0/6.0d0
  coe=(6.0d0*alpha)**coe1

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,r,theta)

  do j=1,ny
     do i=1,nx
        r=rmax*(dsqrt((x(i)-tcx)**2+(y(j)-tcy)**2))/(0.5d0*(x(nx)-x(1)))

        if(x(i)-tcx>0.0d0.and.y(j)-tcy>0.0d0)then
           theta=datan((y(j)-tcy)/(x(i)-tcx))
        else if(x(i)-tcx<0.0d0.and.y(j)-tcy>0.0d0)then
           theta=dabs(dacos(-1.0d0))-datan((y(j)-tcy)/dabs(x(i)-tcx))
        else if(x(i)-tcx<0.0d0.and.y(j)-tcy<0.0d0)then
           theta=dabs(dacos(-1.0d0))+datan(dabs(y(j)-tcy)/dabs(x(i)-tcx))
        else if(x(i)-tcx>0.0d0.and.y(j)-tcy<0.0d0)then
           theta=2.0d0*dabs(dacos(-1.0d0))-datan(dabs(y(j)-tcy)/(x(i)-tcx))
        else if(x(i)-tcx==0.0d0.and.y(j)-tcy<0.0d0)then
           theta=1.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx==0.0d0.and.y(j)-tcy>0.0d0)then
           theta=0.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx>0.0d0.and.y(j)-tcy==0.0d0)then
           theta=0.0d0
        else if(x(i)-tcx<0.0d0.and.y(j)-tcy==0.0d0)then
           theta=dabs(dacos(-1.0d0))
        end if

        zeta(i,j)=(rmax*vmax/(x(nx)-x(1)))*zetamax*coe*r*  &
  &               dexp(coe1-alpha*(r**6))*(1.0d0+dcos(dble(mnum)*theta))
     end do
  end do

!$omp end do
!$omp end parallel

  call HistoryCreate( file=trim(adjustl(fname)), title='BAROTRO initial data', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ nx, ny /),  &
  & longnames=(/'X-coordinate','Y-coordinate'/),  &
  & units=(/'m', 'm'/) )

  call HistoryPut( 'x', xr )
  call HistoryPut( 'y', yr )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y'/), &
  &    longname='vorticity', units='s-1', xtype='double' )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &    longname='X-coord double', units='m', xtype='double' )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &    longname='Y-coord double', units='m', xtype='double' )

  call HistoryPut( 'zeta', zeta )
  call HistoryPut( 'xd', x )
  call HistoryPut( 'yd', y )

  call HistoryClose()

end program
