module sub_mod

  use derivation

contains

subroutine psi2uv( psi, u, v )
!-- converting psi to u and v
  use saveval_define
  implicit none
  double precision, dimension(size(x),size(y)), intent(in) :: psi   ! stream function
  double precision, dimension(size(x),size(y)), intent(inout) :: u
                            ! advecting speed of x direction
  double precision, dimension(size(x),size(y)), intent(inout) :: v
                                            ! advecting speed of y direction

  integer :: i, j

  call grad_2d( x, y, psi, v, u )

  u=-u

end subroutine psi2uv


subroutine set_bound( val )
!-- setting boundary condition
  use saveval_define
  implicit none
  double precision, dimension(nx,ny), intent(inout) :: val

  integer :: i, j

  select case (boundary(1:1))
  case ('1')
     do i=1,nx
        val(i,1)=bnd(i,1)
     end do
  case ('2')
     do i=1,nx
        val(i,1)=val(i,2)-(y(2)-y(1))*bnd(i,1)
     end do
  case ('3')
     do i=1,nx
        val(i,1)=val(i,ny-1)
     end do
  end select

  select case (boundary(2:2))
  case ('1')
     do j=1,ny
        val(1,j)=bnd(1,j)
     end do
  case ('2')
     do j=1,ny
        val(1,j)=val(2,j)-(x(2)-x(1))*bnd(1,j)
     end do
  case ('3')
     do j=1,ny
        val(1,j)=val(nx-1,j)
     end do
  end select

  select case (boundary(3:3))
  case ('1')
     do i=1,nx
        val(i,ny)=bnd(i,ny)
     end do
  case ('2')
     do i=1,nx
        val(i,ny)=val(i,ny-1)+(y(ny)-y(ny-1))*bnd(i,ny)
     end do
  case ('3')
     do i=1,nx
        val(i,ny)=val(i,2)
     end do
  end select

  select case (boundary(2:2))
  case ('1')
     do j=1,ny
        val(nx,j)=bnd(nx,j)
     end do
  case ('2')
     do j=1,ny
        val(nx,j)=val(nx-1,j)+(x(nx)-x(nx-1))*bnd(1,j)
     end do
  case ('3')
     do j=1,ny
        val(nx,j)=val(2,j)
     end do
  end select

end subroutine set_bound

end module sub_mod
