module m_phase1

  implicit none

contains

  subroutine phase4( nx, ny, ival1, oval1, fval1, wnx, wny, spgix, spgiy )

  implicit none

  integer, intent(in) :: nx, ny
  double precision, dimension(nx,ny), intent(in) :: ival1
  double precision, dimension(nx,ny), intent(out) :: oval1
  double precision, dimension(nx,ny), intent(out) :: fval1
  integer, intent(in) :: wnx, wny
  integer, intent(in) :: spgix, spgiy

  integer :: i, j, nnx, nny
  real :: t1, t2, t3
  integer :: SITJ(5), SITI(5)
  integer :: LITJ(5), LITI(5)
  double precision :: STJ((ny/spgiy)*2), STI((nx/spgix)*2)
  double precision :: LTJ(ny*2), LTI(nx*2)
  double precision :: WG(ny/spgiy,nx/spgix)
  double precision :: WGL(ny,nx)
  double precision, dimension(-(nx/2-1):nx/2-1,-(ny/2-1):ny/2-1) :: sp, spi
  double precision, dimension(ny,nx) :: fpval3, cpval3
  double precision, dimension(ny/spgiy,nx/spgix) :: cpval1, fpval1
  double precision, dimension(-(ny/spgiy/2-1):(ny/spgiy/2-1),-(nx/spgix/2-1):(nx/spgix/2-1)) :: cpval2, fpval2

  nnx=nx/spgix
  nny=ny/spgiy

  call P2INIT( nny, nnx, SITJ, STJ, SITI, STI )
  call P2INIT( ny, nx, LITJ, LTJ, LITI, LTI )

  do j=1,nny
     do i=1,nnx
        cpval1(j,i)=dble(ival1((i-1)*spgix+1,(j-1)*spgiy+1))
        fpval1(j,i)=cpval1(j,i)
     end do
  end do

  call cpu_time(t1)

  cpval2=0.0d0
  call P2G2SA( nny/2-1, nnx/2-1, nny, nnx, cpval1, cpval2, WG,  &
  &            SITJ, STJ, SITI, STI )

  fpval2=0.0d0
  call P2G2SA( nny/2-1, nnx/2-1, nny, nnx, fpval1, fpval2, WG,  &
  &            SITJ, STJ, SITI, STI )

  call cpu_time(t2)

  write(*,*) "cpu_time is ", t2-t1, "[sec]."

  sp=0.0d0
  spi=0.0d0

  sp(0,0)=cpval2(0,0)

  if(wny>0)then
     do j=1,wny
        sp(j,0)=cpval2(j,0)
        sp(-j,0)=cpval2(-j,0)
     end do
  end if

  if(wnx>0)then
     do i=1,wnx
        sp(0,i)=cpval2(0,i)
        sp(0,-i)=cpval2(0,-i)
     end do
  end if

  if(wnx>0.and.wny>0)then
     do i=1,wnx
        do j=1,wny
           sp(j,i)=cpval2(j,i)
           sp(j,-i)=cpval2(j,-i)
           sp(-j,i)=cpval2(-j,i)
           sp(-j,-i)=cpval2(-j,-i)
        end do
     end do
  end if

  spi(-(nny/2-1):nny/2-1,-(nnx/2-1):nnx/2-1)=fpval2(-(nny/2-1):nny/2-1,-(nnx/2-1):nnx/2-1)

  cpval3=0.0d0
  call P2S2GA( ny/2-1, nx/2-1, ny, nx, sp, cpval3, WGL,  &
  &            LITJ, LTJ, LITI, LTI )

  fpval3=0.0d0
  call P2S2GA( ny/2-1, nx/2-1, ny, nx, spi, fpval3, WGL,  &
  &            LITJ, LTJ, LITI, LTI )

  do j=1,ny
     do i=1,nx
        oval1(i,j)=cpval3(j,i)
        fval1(i,j)=fpval3(j,i)
     end do
  end do

  end subroutine phase4

end module m_phase1

program fft_check4

!-- FFT ѴΥǡǤտǴְ.
!-- 󥰥ץǤΤư.
!-- FFT 롼ΥåΤ˹ԤΤ,
!-- ׻̤ϥڥȥ֤ξ򤽤Τޤ޿Ūɽ.

  use m_phase1
  use math_const
  use Statistics
  use max_min

  implicit none

  integer, parameter :: nx=500, ny=500
  integer, parameter :: spgix=1, spgiy=1
  integer, parameter :: wnx=10, wny=5

  integer :: i, j, k, l, icounter, ip, jp
  integer :: ixmax, iymax
  double precision :: emax, mmax
  double precision :: x(nx), y(ny)
  double precision, allocatable, dimension(:,:) :: valp1
  double precision, allocatable, dimension(:) :: totsp1, totsp2
  double precision, dimension(nx,ny) :: ival1, oval0, oval1, oval2, fval1, error

     x=(/((dble(i)/dble(nx)),i=1,nx)/)
     y=(/((dble(j)/dble(ny)),j=1,ny)/)

!     ival1=2.0d0
     ival1=0.0d0

     do j=1,ny
        do i=1,nx
           do l=0,wny
              do k=0,wnx
                 ival1(i,j)=ival1(i,j)  &
  &                         +dsin(2.0d0*pi_dp*(dble(k)*dble(i-1)/dble(nx)  &
  &                                     +dble(l)*dble(j-1)/dble(ny)))
!                 ival1(i,j)=dexp(-64.0d0*dlog(2.0d0)  &
!  &                              *((dble(i)/dble(nx)-0.5d0)**2  &
!  &                               +(dble(j)/dble(ny)-0.5d0)**2))
              end do
           end do
        end do
     end do

!-- Normalize ival1

     call max_val_2d( ival1, ixmax, iymax, mmax )
     do j=1,ny
        do i=1,nx
           ival1(i,j)=ival1(i,j)/mmax
        end do
     end do

!     call phase1( nx, ny, ival1, oval1, fval1, 0, 0, spgix, spgiy )
     call phase4( nx, ny, ival1, oval1, fval1, wnx, wny, spgix, spgiy )

     do j=1,ny
        do i=1,nx
           error(i,j)=dabs(oval1(i,j)-ival1(i,j))
        end do
     end do

     call max_val_2d( error, ixmax, iymax, emax )

     write(*,'(a28)') "*********** Result **********"
     write(*,'(a12,1PE16.8)') "ERROR max : ", emax
     write(*,'(a12,1PE16.8)') "Input val : ", ival1(ixmax,iymax)
     write(*,'(a12,1PE16.8)') "Output val: ", oval1(ixmax,iymax)
     write(*,'(a12,i4,a2,i4)') "emax i, j : ", ixmax, ', ', iymax

     do j=1,ny
        do i=1,nx
           error(i,j)=dabs(fval1(i,j)-ival1(i,j))
        end do
     end do

     call max_val_2d( error, ixmax, iymax, emax )

     write(*,'(a28)') "******* Result (full) ******"
     write(*,'(a12,1PE16.8)') "ERROR max : ", emax
     write(*,'(a12,1PE16.8)') "Input val : ", ival1(ixmax,iymax)
     write(*,'(a12,1PE16.8)') "Output val: ", fval1(ixmax,iymax)

!     do j=1,ny
!        do i=1,nx
!           write(*,*) "v check", ival1(i,j), fval1(i,j), oval1(i,j)
!        end do
!     end do

end program fft_check4
