program read_coards
! coards  NETCDF եɤ߹롼˻ΩƤե
  use netcdf
  use derivation
  use file_operate
  use phys_const
  use math_const
  use gmt
  implicit none
  integer :: nx, ny, nz, nt, slice
  real, allocatable, dimension(:,:,:) :: u, v, w, diverg
  real, allocatable, dimension(:,:) :: hx, hy
  real, allocatable, dimension(:) :: lon, lat, lev
  real, allocatable, dimension(:) :: lond, latd
  integer :: i, j, k, l, counter
  real :: lonmin, latmin, dlon, dlat
  integer :: stat, ncid, xtype
  integer, allocatable, dimension(:) :: dimlen, dimids
  character(80) :: fname
  character(10), allocatable, dimension(:) :: cval
  real, allocatable, dimension(:,:,:,:,:) :: val
  integer :: natt, nvar, ndim, unlimdimId, ndims

  write(*,*) "pi=", pi
  write(*,*) "input the fname"
  read(*,*) fname

  write(*,*) "input the slice number"
  read(*,*) slice

  stat=nf90_open( trim(fname), NF90_NOWRITE, ncid )

  if(stat/=NF90_NOERR)then
     write(*,*) trim(nf90_strerror(stat))
  end if

  stat=nf90_inquire( ncid, ndim, nvar, natt, unlimdimId )

  if(stat/=NF90_NOERR)then
     write(*,*) trim(nf90_strerror(stat))
  end if

  allocate(cval(ndim))
  allocate(dimlen(ndim))

  do i=1,ndim
     stat=nf90_inquire_dimension( ncid, i, name=cval(i), len=dimlen(i) )

     if(stat/=NF90_NOERR)then
        write(*,*) trim(nf90_strerror(stat))
     end if

     write(*,*) "#", i, dimlen(i), trim(cval(i))
  end do

  allocate(lev(dimlen(2)))
  allocate(lon(dimlen(3)))
  allocate(lat(dimlen(4)))
  allocate(lond(dimlen(3)))
  allocate(latd(dimlen(4)))

  nx=dimlen(4)
  ny=dimlen(3)
  nz=dimlen(2)
  nt=dimlen(1)
write(*,*) "nt", nt

  deallocate(cval)

  allocate(cval(nvar))

  counter=0

  do i=1,nvar
     stat=nf90_inquire_variable( ncid, i, name=cval(i), xtype=xtype,  &
  &       ndims=ndims )

     if(stat/=NF90_NOERR)then
        write(*,*) trim(nf90_strerror(stat))
     end if

     allocate(dimids(ndims))

     stat=nf90_inquire_variable( ncid, i, name=cval(i), xtype=xtype,  &
  &       dimids=dimids )

     write(*,*) "dimids=", dimids, ndims

     if(ndims==4)then
        counter=counter+1
     end if

     deallocate(dimids)

     if(stat/=NF90_NOERR)then
        write(*,*) trim(nf90_strerror(stat))
     end if

  end do

  allocate(val(nx, ny, nz, nt, counter))

  counter=0

  do i=1,nvar

     stat=nf90_inquire_variable( ncid, i, name=cval(i), xtype=xtype,  &
  &       ndims=ndims )

     if(stat/=NF90_NOERR)then
        write(*,*) trim(nf90_strerror(stat))
     end if

     allocate(dimids(ndims))

     stat=nf90_inquire_variable( ncid, i, dimids=dimids )

     if(size(dimids)==4)then
     counter=counter+1
     stat=nf90_get_var( ncid, i, val(:,:,:,:,counter), start=(/1,1,1,1/), count=(/nx, ny, nz,1/) )
     end if

     deallocate(dimids)

  end do

     allocate(u(nx,ny,nz))
     allocate(v(nx,ny,nz))
     allocate(w(nx,ny,nz))
     allocate(diverg(nx,ny,nz))

     counter=0
  do i=1,nvar
     stat=nf90_inquire_variable( ncid, i, name=cval(i), xtype=xtype,  &
  &       ndims=ndims )

     if(stat/=NF90_NOERR)then
        write(*,*) trim(nf90_strerror(stat))
     end if

     allocate(dimids(ndims))

     stat=nf90_inquire_variable( ncid, i, dimids=dimids )

!     if(size(dimids)==4)then
!     counter=counter+1
!     stat=nf90_get_var( ncid, i, val(:,:,:,:,counter), start=(/1,1,1,1/), count=(/nx, ny, nz,1/) )
!     end if

     write(*,*) "val name", trim(cval(i))
     if(trim(cval(i))=='LON')then
        stat=nf90_get_var( ncid, i, lon(:), start=(/1/), count=(/nx/) )
        do j=1,nx
           lond(j)=lon(j)*pi/180.0
        end do
     end if
     if(trim(cval(i))=='LAT')then
        stat=nf90_get_var( ncid, i, lat(:), start=(/1/), count=(/ny/) )
        do j=1,ny
           latd(j)=lat(j)*pi/180.0
        end do
     end if

     if(size(dimids)==4)then
     write(*,*) "val name dim4", trim(cval(i))
     counter=counter+1
!     if(trim(cval(i))=='lon')then
!        do j=1,dimids(1)
!           lon(j)=val(j,i)
!        end do
!     end if
!     if(trim(cval(i))=='u')then
!        do l=1,dimids(3)
!           do k=1,dimids(2)
!              do j=1,dimids(1)
!                 u(j,k,l)=val(j,k,l,i)
!              end do
!           end do
!        end do
!     end if
     if(trim(cval(i))=='U')then
  write(*,*) "val name LON", trim(cval(i))
        do l=1,nz
           do k=1,ny
              do j=1,nx
                 u(j,k,l)=val(j,k,l,nt,counter)
              end do
           end do
        end do
     end if
     if(trim(cval(i))=='V')then
        do l=1,nz
           do k=1,ny
              do j=1,nx
                 v(j,k,l)=val(j,k,l,nt,counter)
              end do
           end do
        end do
     end if
!-- 書き換え OK 'W'
     if(trim(cval(i))=='W')then
        do l=1,nz
           do k=1,ny
              do j=1,nx
                 w(j,k,l)=val(j,k,l,nt,counter)
              end do
           end do
        end do
     end if
  end if
     deallocate(dimids)
  end do

  allocate(hx(nx,ny))
  allocate(hy(nx,ny))

  do j=1,ny
     do i=1,nx
        hx(i,j)=radius*cos(latd(j))
        hy(i,j)=radius
     end do
  end do

do i=1,nx
   write(*,*) "radius", lon(i), lat(i), radius
   write(*,*) "radius", lond(i), latd(i), radius
end do

  call div( lond, latd, u(:,:,slice), v(:,:,slice), diverg(:,:,slice), hx=hx, hy=hy, undeff=-999.9)
!  call curl( lond, latd, u(:,:,slice), v(:,:,slice), diverg(:,:,slice), hx=hx, hy=hy, undeff=-999.9)

!  stat=nf90_create( 'output.nc', NF90_CLOBBER, ncid )

!  if(stat/=NF90_NOERR)then
!     write(*,*) trim(nf90_strerror(stat))
!  end if

!  stat=nf90_def_dim( ncid, 'div', 2, dimid )

!  if(stat/=NF90_NOERR)then
!     write(*,*) trim(nf90_strerror(stat))
!  end if

!  stat=nf90_def_var( ncid, name='div', NF90_FLOAT, )
write(*,*) &
  &                (/dble(lon(1)),dble(lon(nx))/),  &
  &                (/dble(lat(1)),dble(lat(ny))/),  &
  &                (/dble((lon(2)-lon(1))),dble((lat(2)-lat(1)))/)

!-- diverg -> w に変えれば OK
!  stat=grd_create( 'output.grd', diverg(:,:,slice),  &
  stat=grd_create( 'output.grd', diverg(:,:,slice),  &
  &                (/dble(lon(1)),dble(lon(nx))/),  &
  &                (/dble(lat(1)),dble(lat(ny))/),  &
  &                (/dble((lon(2)-lon(1))),dble((lat(2)-lat(1)))/),  &
  &                jscan=1, overwrite=.true. )

!  call write_file( 'output.bin', nx, ny, 1, diverg(:,:,2), mode='unknown')

end program
