module Algebra   ! 黻˹Ԥ⥸塼
! ͭͷ׻, 黻, ٥ȥ黻˹Ԥ.

  public :: rectangle_int

contains

subroutine rectangle_int( x, y, bot, top, res, undeff )  ! 1 ʬ
  ! ֳ֤Ǥ׻ǽǤ뤬, ٤ݾڤʤ.
  implicit none
  real, intent(in) :: bot  ! ʬֺü
  real, intent(in) :: top  ! ʬֱü
  real, intent(in) :: x(:)  ! ʬѿ
  real, intent(in) :: y(size(x))  ! ʬؿ
  real, intent(inout) :: res  ! ʬʬ
  real, intent(in), optional :: undeff
  integer :: i, nx, i_bot, i_top
  real :: y_bot, y_top

  nx=size(x)

  res=0.0

!-- bot < top ǤʤХ顼
  if(bot>top)then
     write(*,*) "#### ERROR ####"
     write(*,*) "integrated interval must be bot < top. STOP"
     stop
  end if

!-- ʲʬ
!-- ºݤˤ, ʬ˺Ƕ᤹

  if(x(1)>bot)then
     write(*,*) "#### WARNING ####"
     write(*,*) "there is NOT the bot in the x(i)."  ! ΤȤ, i_bot=1ȤƤƤ, x(1)=bot ʤΤ, ;ʬ׻ϥȤʤƶϤʤ.
     i_bot=1
  end if
  if(x(nx)<top)then
     write(*,*) "#### WARNING ####"
     write(*,*) "there is NOT the top in the x(i)."  ! ΤȤ, i_top=nx ȤƤ, x(nx)=top ʤΤ, ;ʬ׻ϥȤʤ.
     i_top=nx
  end if

  do i=2,nx-1
     if(x(i)>=bot)then  ! i_bot  bot - top κǤ bot ˶Ťʻ
        i_bot=i
        exit
     end if
  end do

  do i=nx-1,2,-1
     if(x(i)<=top)then  ! i_top  bot - top κǤ top ˶Ťʻ
        i_top=i
        exit
     end if
  end do

!-- ʲǳʻҤƤϤޤʤʬޤ䴰
  if(present(undeff))then
     if(i_bot/=1)then
        if(y(i_bot)/=undeff.and.y(i_bot-1)/=undeff.and.x(i_bot)/=x(i_bot-1))then
           y_bot=y(i_bot-1)  &
     &           +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
        else
           y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
        end if
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        if(y(i_top)/=undeff.and.y(i_top+1)/=undeff.and.x(i_top+1)/=x(i_top))then
           y_top=y(i_top)  &
     &           +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
        else
           y_top=-y(i_top)
        end if
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  else
     if(i_bot/=1)then
        y_bot=y(i_bot-1)  &
     &        +((y(i_bot)-y(i_bot-1))/(x(i_bot)-x(i_bot-1)))*(bot-x(i_bot-1))
     else
        y_bot=-y(i_bot)  ! Ǹʬǥˤ뤿
     end if
     if(i_top/=nx)then
        y_top=y(i_top)  &
     &        +((y(i_top+1)-y(i_top))/(x(i_top+1)-x(i_top)))*(x(i_top+1)-top)
     else
        y_top=-y(i_top)  ! Ǹʬǥˤ뤿
     end if
  end if

  if(i_bot<i_top)then  ! ʬ˳ʻҤ 2 İʾ夢Ȥ

     if(present(undeff))then
        do i=i_bot,i_top-1
           if(y(i+1)/=undeff.and.y(i)/=undeff)then
              if(i==i_bot)then
                 res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &                  +0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
                     ! ü;̾ûʬ
              else
                 res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
              end if
           end if
        end do
        res=res+0.5*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     else
        do i=i_bot,i_top-1
           if(i==i_bot)then
              res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &               +0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
                  ! ü;̾ûʬ
           else
              res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))  ! ̾û
           end if
        end do
        res=res+0.5*(top-x(i_top))*(y_top+y(i_top))  ! ü;Τ
     end if
  else
     if(present(undeff))then
        if(y(i_bot)/=undeff)then
           res=res+0.5*(x(i)-bot)*(y(i)+y_bot)  &
  &            +0.5*(top-x(i))*(y_top+y(i))
        else
           res=0.5*(top-bot)*(y_top+y_bot)
        end if
     else
        res=res+0.5*(x(i_bot)-bot)*(y(i_bot)+y_bot)  &
  &         +0.5*(top-x(i_bot))*(y_top+y(i_bot))
     end if
  end if

end subroutine rectangle_int

!------------------------------------------

subroutine abst(x,y,z,dis)  ! 3 ٥ȥͤ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dis(size(x,1),size(x,2),size(x,3))  ! Ǥͥ٥ȥ
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

!$omp parallel do shared(dis,x,y,z) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dis(i,j,k)=sqrt(x(i,j,k)**2+y(i,j,k)**2+z(i,j,k)**2)
        end do
     end do
  end do
!$omp end parallel do

end subroutine abst

!------------------------------------------

subroutine radius(xp,yp,zp,x,y,z,rad)
  ! ֤εΥ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: xp  ! 濴ֺɸ x ʬ
  real, intent(in) :: yp  ! 濴ֺɸ y ʬ
  real, intent(in) :: zp  ! 濴ֺɸ z ʬ
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: z(:)  ! z ΰֺɸ
  real, intent(inout) :: rad(size(x),size(y),size(z))  ! Υ
  integer :: i, j, k, nx, ny, nz

  nx=size(x)
  ny=size(y)
  nz=size(z)

!$omp parallel do shared(rad,x,y,z,xp,yp,zp) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           rad(i,j,k)=sqrt((x(i)-xp)**2+(y(j)-yp)**2+(z(k)-zp)**2)
        end do
     end do
  end do
!$omp end parallel do


end subroutine radius

!------------------------------------------
!------------------------------------------

subroutine dot_prod(x,y,z,u,v,w,dot,undeff)
  ! 2٥ȥѷ׻롼
  ! פ, 2 ǤѤ׻뤳Ȥǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dot(size(x,1),size(x,2),size(x,3))  ! 
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 dot(i,j,k)=undeff
              else
                 dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do
  else
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine dot_prod


subroutine vec_prod(x,y,z,u,v,w,vecx,vecy,vecz,undeff)
  ! 2٥ȥγѷ׻롼
  ! ǿפ뤳Ȥ 2 Ѥ׻ǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: vecx(size(x,1),size(x,2),size(x,3))  ! Ѥ x ʬ
  real, intent(inout) :: vecy(size(x,1),size(x,2),size(x,3))  ! Ѥ y ʬ
  real, intent(inout) :: vecz(size(x,1),size(x,2),size(x,3))  ! Ѥ z ʬ
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 vecx(i,j,k)=undeff
                 vecy(i,j,k)=undeff
                 vecz(i,j,k)=undeff
              else
                 vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
                 vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
                 vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do

  else

!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
              vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
              vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine vec_prod

!-----------------------------------------
!-----------------------------------------

!-----------------------------------------
!-----------------------------------------

end module Algebra
