program sound_2d
! ʣΥǥǡޤץ
! ꥹȺκݤ 00Z ǻϤޤ, 00Z ǽ褦˺뤳.
! ­ʤʬ unknown 䤦.

  use file_operate
  use basis
  use Statistics
  use Thermo_Function
  use Max_Min
  use dcl
  use Dcl_Automatic

  implicit none

!-- integer
  integer :: nt       ! γʻҿ
  integer :: nz       ! z γʻҿ
  integer :: nf       ! conv_dat ѥǡ
  integer :: ntnum, nznum  ! number of vector for nt and nz
  integer :: iz_ref   ! dz = 0 ΤȤ, flist  iz_ref ܤι٥ǡ.
  integer :: IWS      ! ǥХ
  integer :: days     ! 
  integer :: i_counter    ! 󥿡
  integer :: i_counter_c  ! 󥿡
  integer :: snum, cnum  ! 顼ο
  integer :: cont_flag, shade_flag  ! 顼, ѥե饰ѿ
  integer :: cmap  ! 顼ޥå
  integer :: izmin, izmax
  integer, allocatable, dimension(:) :: year_v    ! ǯ
  integer, allocatable, dimension(:) :: month_v   ! 
  integer, allocatable, dimension(:) :: day_v     ! 
  integer, allocatable, dimension(:) :: hour_v    ! 
  integer, allocatable, dimension(:) :: inter_z ! ѹ
  integer, allocatable, dimension(:) :: i_flag  ! 
  integer, allocatable, dimension(:) :: o_flag  ! 
  integer, allocatable, dimension(:) :: c_flag  ! 
  integer :: fixsn(100)  ! 顼ʪ̤б륫顼ޥå

!-- tmp
  integer :: nttmp, i, j, k, i_undef, i_tmp
!-- parameter
  integer, parameter :: col_num=6
  integer, parameter :: skip_num=2
  real, parameter :: vxint(2)=(/0.1,0.9/)
  real, parameter :: vyint(2)=(/0.15,0.9/)
  real, parameter :: unitfact(2)=(/0.05, 0.05/)  ! unit vector for V coord.

!-- real
  real :: z_bot       ! βü
  real :: z_top       ! ξü
  real :: dz          ! ľֳ [m]
  real :: dvy         ! vy δֳ
  real :: smax, smin, cmax, cmin  ! 顼, ξ
  real, allocatable, dimension(:) :: time  ! 
  real, allocatable, dimension(:) :: z     ! ٺɸ
  real, allocatable, dimension(:) :: vx     ! viewport 
  real, allocatable, dimension(:,:) :: vy     ! viewport 
  real, allocatable, dimension(:,:) :: val_f        ! ׻
  real, allocatable, dimension(:,:) :: val_inter    ! ׻ѿ
  real, allocatable, dimension(:,:) :: tline        ! ׻ѿ
  real, allocatable, dimension(:,:) :: yline        ! ׻ѿ
  real, allocatable, dimension(:,:,:) :: val_draw   ! ѿ
  real :: undef
  real :: conv_undef
  real :: ymin, ymax, vx_new(2), vy_new(2)
  real :: unitfactv(2)
  real :: fixs(100)  ! 顼ʪ
  !  fixs(snum+1), fixsn(snum+2)  fixsn(1), fixsn(snum+2) ǾΥ顼

!-- tmp
  real, dimension(2) :: pt_tmp, ept_tmp, sept_tmp, rh_tmp, s_int, c_int

!-- character
  character(1000) :: flist         ! եꥹ̾
  character(1000) :: conv_dat      ! sound_1d ǽϤήѥ᡼ǡ
  character(1000) :: title_txt     ! ȥ̾
  character(10) :: cont_val      ! ѿ̾
  character(10) :: shade_val     ! 顼ѿ̾
  character(10) :: conv_list     ! ǡե饰
  character(1000), allocatable, dimension(:,:) :: fname  ! ե̾
  character(1000), allocatable, dimension(:,:) :: val_w  ! ƥȥǡ
  character(70) :: sysfont
  character(10) :: unitval     ! value of unit vector [m/s]
  character(20) :: unititle   ! unit vector title
!-- tmp
  character(1000) :: tmp_c

!-- logical
  logical :: vec_val       ! ѿ̾
  logical :: fflag, fixs_flag

!-- type
  type(dtime) :: start_day, end_day
  type(dcl_date) :: stime

!-- namelist reading
  namelist /input /flist, conv_dat, conv_list, conv_undef, dz, z_bot,  &
  &                z_top, iz_ref, IWS, title_txt, cmap,  &
  &                cmin, cmax, smin, smax, cont_val, shade_val,  &
  &                vec_val, cnum, snum, undef, sysfont, ntnum, nznum,  &
  &                unitval, fixs_flag, fixs, fixsn
  read(5,nml=input)

  fflag=.false.

  nt=line_number_counter( trim(flist) )
  s_int=(/smin, smax/)
  c_int=(/cmin, cmax/)
  unitfactv=(/0.05/c2r_convert(unitval), 0.05/c2r_convert(unitval)/)
  unititle='U = '//trim(adjustl(unitval))//'m/s'

  allocate(fname(2,nt))
  call read_file_text( trim(flist), 2, nt, fname )

  if(dz==0.0)then
     write(*,*) "*** MESSAGE (main) *** : z is specified by "  &
  &           //trim(adjustl(fname(1,iz_ref)))
     nz=line_number_counter( trim(fname(1,iz_ref)) ) -skip_num
  else
     nz=int((z_top-z_bot)/dz)+1
  end if

  allocate(time(nt))
  allocate(z(nz))
  allocate(inter_z(nz))
  allocate(val_inter(col_num+4,nz))
  allocate(val_draw(col_num+4,nt,nz))
  allocate(year_v(nt))
  allocate(month_v(nt))
  allocate(day_v(nt))
  allocate(hour_v(nt))

!-- DCL set
  if(len_trim(adjustl(sysfont))/=0)then
     call SGISET( 'IFONT', 1 )
     call SWLSET( 'LSYSFNT', .true. )
     write(*,*) "This drawing mode is sysfont."
  else
     call SGISET( 'IFONT', 2 )
     write(*,*) "This drawing mode is dclfont."
  end if

  call UZFACT(0.8)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )
  CALL GLRSET( 'RMISS', undef )
  CALL GLLSET( 'LMISS', .TRUE. )

  do i=1,nt
     tmp_c=trim(fname(2,i))
     year_v(i)=c2i_convert( trim(tmp_c(1:4)) )
     month_v(i)=c2i_convert( trim(tmp_c(5:6)) )
     day_v(i)=c2i_convert( trim(tmp_c(7:8)) )
     hour_v(i)=c2i_convert( trim(tmp_c(9:10)) )
  end do

  start_day%year_d=year_v(1)
  start_day%month_d=month_v(1)
  start_day%day_d=day_v(1)
  start_day%hour_d=hour_v(1)
  start_day%min_d=0
  start_day%sec_d=0
  end_day%year_d=year_v(nt)
  end_day%month_d=month_v(nt)
  end_day%day_d=day_v(nt)
  end_day%hour_d=hour_v(nt)
  end_day%min_d=0
  end_day%sec_d=0
  days=counter_day( start_day, end_day )-1
  stime%year=year_v(1)
  stime%month=month_v(1)
  stime%day=day_v(1)

  if(dz==0.0)then
     write(*,*) "*** MESSAGE (main) *** : z is specified by "  &
  &           //trim(adjustl(fname(1,iz_ref)))
     nz=line_number_counter( trim(fname(1,iz_ref)) ) -skip_num
     allocate(val_w(1,nz))
     call read_file_text( trim(fname(1,iz_ref)), 1, nz, val_w,  &
  &                       skip=skip_num )
     do k=1,nz
        z(k)=c2r_convert( val_w(1,k) )
     end do
     call interpo_search_1d( z, z_bot, izmin )
     call interpo_search_1d( z, z_top, izmax )
     if(izmin==0)then
        izmin=1
     end if
     deallocate(val_w)
  else
     do i=1,nz
        z(i)=z_bot+dz*real(i-1)
     end do
     izmin=1
     izmax=nz
  end if

  if(izmax-izmin+1<nznum)then
     nznum=izmax-izmin+1
  end if
  if(nt<ntnum)then
     ntnum=nt
  end if

  do i=1,nt
     end_day%year_d=year_v(i)
     end_day%month_d=month_v(i)
     end_day%day_d=day_v(i)
     time(i)=real(counter_day( start_day, end_day ))  &
  &         +real(hour_v(i)-hour_v(1))/24.0-1.0
  end do

!-- time loop
!-- 1. reading values from text file
!-- 2. interpolating to grid point
!-- 3. calculating each value

  do i=1,nt
     if(trim(fname(1,i))/='unknown')then
        nttmp=line_number_counter( trim(fname(1,i)) ) -skip_num
        allocate(val_w(col_num,nttmp))
        allocate(val_f(col_num,nttmp))
        call read_file_text( trim(fname(1,i)), col_num, nttmp, val_w,  &
  &                          skip=skip_num )

     !-- convert type from character to float
        do k=1,nttmp
           do j=1,col_num
              val_f(j,k)=c2r_convert( val_w(j,k) )
           end do
        end do

     !-- calculating the interpolating points
        do k=1,nz
           call interpo_search_1d( val_f(1,:), z(k), inter_z(k), undeff=int(undef) )
        end do

     !-- calculating each value (temp, u, v, rh)
        do k=1,nz
           do j=2,col_num
              if(inter_z(k)/=int(undef).and.inter_z(k)/=nttmp)then
                 if(val_f(j,inter_z(k))==undef.or.  &
  &                 val_f(j,inter_z(k)+1)==undef)then
                    val_inter(:,k)=undef
                    exit
                 end if

                 call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                     val_f(j,inter_z(k):inter_z(k)+1),  &
  &                                     z(k), val_inter(j,k) )
              else
                 val_inter(j,k)=undef
              end if
           end do
        end do

     !-- calculating each value (pt, ept, sept)
        do k=1,nz
           if(val_inter(2,k)==undef)then
              val_inter(col_num+1,k)=undef
              val_inter(col_num+2,k)=undef
              val_inter(col_num+3,k)=undef
              val_inter(col_num+4,k)=undef
           else
              pt_tmp(1)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
              ept_tmp(1)=thetae_Bolton( val_f(3,inter_z(k)),  &
  &                                     val_f(4,inter_z(k)),  &
  &                                     val_f(2,inter_z(k)) )
              sept_tmp(1)=thetaes_Bolton( val_f(3,inter_z(k)),  &
  &                                       val_f(2,inter_z(k)) )
              rh_tmp(1)=qvTP_2_RH( val_f(4,inter_z(k)),  &
  &                                val_f(3,inter_z(k)),  &
  &                                val_f(2,inter_z(k)) )
              pt_tmp(2)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
              ept_tmp(2)=thetae_Bolton( val_f(3,inter_z(k)+1),  &
  &                                     val_f(4,inter_z(k)+1),  &
  &                                     val_f(2,inter_z(k)+1) )
              sept_tmp(2)=thetaes_Bolton( val_f(3,inter_z(k)+1),  &
  &                                       val_f(2,inter_z(k)+1) )
              rh_tmp(2)=qvTP_2_RH( val_f(4,inter_z(k)+1),  &
  &                                val_f(3,inter_z(k)+1),  &
  &                                val_f(2,inter_z(k)+1) )

              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  pt_tmp, z(k), val_inter(col_num+1,k) )
              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  ept_tmp, z(k), val_inter(col_num+2,k) )
              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  sept_tmp, z(k), val_inter(col_num+3,k) )
              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  rh_tmp, z(k), val_inter(col_num+4,k) )

           end if
        end do

        deallocate(val_w)
        deallocate(val_f)

     else
        val_inter=undef
     end if

     do j=1,col_num+4
        do k=1,nz
           if(j==4)then  ! ˤĤƤν.
              if(val_inter(j,k)/=undef)then
                 val_draw(j,i,k)=val_inter(j,k)*1.0e3
              else
                 val_draw(j,i,k)=undef
              end if
           else
              val_draw(j,i,k)=val_inter(j,k)
           end if
        end do
     end do

  end do

!-- draw value separate
!--  val_inter ȤƤ.(ޤ̤)

  select case (cont_val)
  case ('temp')
     cont_flag=3
  case ('qv')
     cont_flag=4
  case ('pt')
     cont_flag=col_num+1
  case ('ept')
     cont_flag=col_num+2
  case ('sept')
     cont_flag=col_num+3
  case ('rh')
     cont_flag=col_num+4
  case ('east')
     cont_flag=5
  case ('north')
     cont_flag=6
  end select

  select case (shade_val)
  case ('temp')
     shade_flag=3
  case ('qv')
     shade_flag=4
  case ('pt')
     shade_flag=col_num+1
  case ('ept')
     shade_flag=col_num+2
  case ('sept')
     shade_flag=col_num+3
  case ('rh')
     shade_flag=col_num+4
  case ('east')
     shade_flag=5
  case ('north')
     shade_flag=6
  end select

!-- DCL part
!-- ޤ, -
  if(fixs_flag.eqv..true.)then
call sgscmn( cmap )
     call color_setting( snum, s_int,  &
  &                      min_tab=fixsn(1), max_tab=fixsn(snum+2),  &
  &                      col_min=fixsn(1), col_max=fixsn(snum+2),  &
  &                      col_tab=cmap,  &
  &                      val_spec=fixs(1:snum+1),  &
  &                      col_spec=fixsn(2:snum+1) )
  else
     call color_setting( snum, s_int, col_min=15, col_max=85,  &
  &                      col_tab=cmap, min_tab=10999, max_tab=99999 )
  end if

  call DclOpenGraphics(IWS)

  if(len_trim(adjustl(sysfont))/=0)then
!     CALL SWSLFT(sysfont)
     CALL SWCSET('FONTNAME', sysfont)
  end if

  if(vec_val.eqv..false.)then
     call Dcl_2D_Cont_Shade_Calendar( trim(title_txt),  &
  &       time, z(izmin:izmax),  &
  &       val_draw(cont_flag,:,izmin:izmax),  &
  &       val_draw(shade_flag,:,izmin:izmax),  &
  &       c_int, s_int,  &
  &       (/'            ', 'altitude (m)'/), stime, days, (/'(f6.1)', '(f6.1)'/),  &
  &       viewx_int=vxint, viewy_int=vyint,  &
  &       c_num=(/cnum, snum/), no_tone=.true. )
  else
     call Dcl_2D_Cont_Shade_vec_Calendar( trim(title_txt),  &
  &       time, z(izmin:izmax),  &
  &       val_draw(cont_flag,:,izmin:izmax),  &
  &       val_draw(shade_flag,:,izmin:izmax),  &
  &       val_draw(5,:,izmin:izmax), val_draw(6,:,izmin:izmax),  &
  &       (/ntnum,nznum/), c_int, s_int,  &
  &       (/'            ', 'altitude (m)'/), stime, days,  &
  &       (/'(f6.1)', '(f6.1)'/),  &
  &       viewx_int=vxint, viewy_int=vyint,  &
  &       c_num=(/cnum, snum/), no_tone=.true.,  &
  &       unitv=.true., vfact=unitfactv, unit_fact=unitfact,  &
  &       unit_fact_sign=.false.,  &
  &       unit_title=(/trim(adjustl(unititle)), '                    '/) )
  end if

  call DclSetParm( "GRAPH:LCLIP", .true. )
  call DclDrawMarker( (/0.0/), (/0.0/) )
  CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )
  call DclSetParm( "GRAPH:LCLIP", .false. )
  if(fixs_flag.eqv..true.)then
     call tone_bar( snum, s_int,  &
  &                 (/vx_new(2)+0.025, vx_new(2)+0.05/),  &
  &                 (/vy_new(1)+0.05, vy_new(2)/),  &
  &                 '(f6.1)', col_mem_num=10,  &
  &                 trigle='a', col_spec=fixs(1:snum+1),  &
  &                 val_spec=fixsn(2:snum+1) )
  else
     call tone_bar( snum, s_int,  &
  &                 (/vx_new(2)+0.025, vx_new(2)+0.05/),  &
  &                 (/vy_new(1)+0.05, vy_new(2)/),  &
  &                 '(f6.1)', col_mem_num=10,  &
  &                 trigle='a' )
  end if
  call DclSetParm( "GRAPH:LCLIP", .true. )

!-- ʹ, ήѥ᡼ѿλǡ񤭽Ф

  deallocate(fname)
  deallocate(year_v)
  deallocate(month_v)
  deallocate(day_v)
  deallocate(hour_v)
  deallocate(time)

  if(trim(conv_dat(1:1))/='')then
     nf=len_trim(conv_list)
     nt=line_number_counter( trim(conv_dat) )

     allocate(fname(nf,nt))
     allocate(year_v(nt-2))
     allocate(month_v(nt-2))
     allocate(day_v(nt-2))
     allocate(hour_v(nt-2))
     allocate(i_flag(3))
     allocate(o_flag(nf))
     allocate(c_flag(nf))
     allocate(time(nt-2))
     allocate(tline(nt,nf))
     allocate(yline(nt,nf))

     call read_file_text( trim(conv_dat), nf, nt, fname )
     i_counter=0
     i_counter_c=0

     do i=1,nf
        select case(conv_list(i:i))
        case('t')
           i_flag(1)=i
        case('z')
           i_flag(2)=i
        case('p')
           i_flag(3)=i
        case('o')
           i_counter=i_counter+1
           o_flag(i_counter)=i
        case('c')
           i_counter_c=i_counter_c+1
           c_flag(i_counter_c)=i
        end select
     end do

     do i=1,nt-2
        tmp_c=trim( adjustl( fname(i_flag(1),i+2) ) )
        year_v(i)=c2i_convert( trim(tmp_c(1:4)) )
        month_v(i)=c2i_convert( trim(tmp_c(5:6)) )
        day_v(i)=c2i_convert( trim(tmp_c(7:8)) )
        hour_v(i)=c2i_convert( trim(tmp_c(9:10)) )
     end do

     start_day%year_d=year_v(1)
     start_day%month_d=month_v(1)
     start_day%day_d=day_v(1)
     end_day%year_d=year_v(nt-2)
     end_day%month_d=month_v(nt-2)
     end_day%day_d=day_v(nt-2)
     days=counter_day( start_day, end_day )-1
     stime%year=year_v(1)
     stime%month=month_v(1)
     stime%day=day_v(1)

     do i=1,nt-2
        end_day%year_d=year_v(i)
        end_day%month_d=month_v(i)
        end_day%day_d=day_v(i)
        time(i)=real(counter_day( start_day, end_day ))+real(hour_v(i))/24.0-1.0
     end do

     if(i_counter>0)then

     !-- vx  i_counter ʬ.
        allocate(vx(2))
        allocate(vy(i_counter,2))
        vx=(/0.2, 0.95/)
        dvy=(0.8-0.1*real(i_counter-1))/real(i_counter)
        vy(1,1)=0.1
        vy(1,2)=vy(1,1)+dvy
        if(i_counter>1)then
           do i=2,i_counter
              vy(i,1)=vy(i-1,2)+0.1
              vy(i,2)=vy(i,1)+dvy
           end do
        end if

        do i=1,nt-2
           do j=1,i_counter
              tmp_c=trim( adjustl( fname(o_flag(j),i+2) ) )
              tline(i,j)=time(i)
              yline(i,j)=c2r_convert( trim(tmp_c))
           end do
        end do
      
        do j=1,i_counter
           i_undef=1
           do i=1,nt-2
              if(yline(i,j)/=undef)then
                 exit
              else
                 i_undef=i_undef+1
              end if
           end do

           if(j>1)then
              fflag=.true.
           end if
           tmp_c=trim(fname(o_flag(j),1))//  &
  &             '('//trim(fname(o_flag(j),2))//')'

           call min_val_1d( yline(i_undef:nt-2,j), i_tmp, ymin, undef )
           call max_val_1d( yline(i_undef:nt-2,j), i_tmp, ymax, undef )

           call Dcl_PL_Calendar( 'l', '',   &
  &             tline(i_undef:nt-2,j:j), yline(i_undef:nt-2,j:j),  &
  &             tline(i_undef:nt-2,j:j), yline(i_undef:nt-2,j:j),  &
  &             (/trim(tmp_c), trim(tmp_c)/),  &
  &             stime, days, viewx_int=vx, viewy_int=vy(j,:),  &
  &             x_int=(/tline(1,1),tline(nt-2,1)/), y_int=(/ymin,ymax/),  &
  &             no_frame=fflag )
        end do

     end if

     if(i_counter_c>0)then

        do i=1,nt-2
           do j=1,i_counter_c
              tmp_c=trim(fname(o_flag(j),i+2))
              tline(i,j)=time(i)
              yline(i,j)=c2r_convert( trim(tmp_c))
           end do
        end do
      
        tmp_c=''
        do j=1,i_counter_c
           tmp_c=trim(tmp_c)//', '//trim(fname(c_flag(j),1))
        end do
      
        i_undef=1
        do i=1,nt-2
           if(yline(i,j)/=undef)then
              exit
           else
              i_undef=i_undef+1
           end if
        end do

        call min_val_2d( yline(i_undef:nt-2,1:c_flag(j)),  &
  &                      i_tmp, i_tmp, ymin, undef )
        call max_val_2d( yline(i_undef:nt-2,1:c_flag(j)),  &
  &                      i_tmp, i_tmp, ymax, undef )

        call Dcl_PL_Calendar( 'l', '',  &
  &          tline(i_undef:nt-2,1:c_flag(j)), yline(i_undef:nt-2,1:c_flag(j)),  &
  &          tline(i_undef:nt-2,1:c_flag(j)), yline(i_undef:nt-2,1:c_flag(j)),  &
  &          (/'', trim(tmp_c)/), stime, days,  &
  &          x_int=(/tline(1,1),tline(nt-2,1)/), y_int=(/ymin,ymax/) )

     end if

  end if

  call DclCloseGraphics

end program
