program fft_test
! fft 롼μ¹®٤׻롼
! ¿ǡ򥹥ڥȥѴ, ˵ѴƸ᤹Ȥ
! ѴΥǡȤθκ֤ͤ.

  use ffts
  use max_min

  implicit none

  integer :: n
  real, allocatable :: re(:)
  complex, allocatable :: co(:)
  real, allocatable :: err(:)
  real, allocatable :: ren(:)
  real :: tf1, tf2, to1, to2, err_max
  integer :: i, emax
  character(1) :: flag
  integer, dimension(5) :: prim

  write(*,*) "Input the data number (odd number)."
  read(*,*) n

!  write(*,*) "Do calculate the prime factors? [y/n]"
!  read(*,*) flag

!  if(flag=='n')then
!     write(*,*) "Input each prime factor (2,3,5,7,other)."
!     read(*,*) prim(1), prim(2), prim(3), prim(4), prim(5)
!  end if

  flag=""

  allocate(re(n))
  allocate(co(n/2))
  allocate(ren(n))
  allocate(err(n))

  do i=1,n
     re(i)=exp(-4.0*(i-n/2)**2)
  end do

  call cpu_time( tf1 )

  if(flag=='y')then
     call r2c_ffttp_1d( n, re, co, prim='o' )
     call c2r_ffttp_1d( n, co, ren, prim='o' )
  else
     call r2c_ffttp_1d( n, re, co, prim='o', prim_fact=prim )
     call c2r_ffttp_1d( n, co, ren, prim='o', prim_fact=prim )
  end if

  call cpu_time( tf2 )

  do i=1,n
     err(i)=abs(re(i)-ren(i))
  end do

  call max_val_1d( err, emax, err_max )

  write(*,*) "fft error is ", err_max

  call cpu_time( to1 )

  if(flag=='y')then
     call r2c_ffttp_1d( n, re, co, prim='x' )
     call c2r_ffttp_1d( n, co, ren, prim='x' )
  else
     call r2c_ffttp_1d( n, re, co, prim='x', prim_fact=prim )
     call c2r_ffttp_1d( n, co, ren, prim='x', prim_fact=prim )
  end if

  call cpu_time( to2 )

  do i=1,n
     err(i)=abs(re(i)-ren(i))
  end do

  call max_val_1d( err, emax, err_max )

  write(*,*) "fft error is ", err_max

  write(*,*) "-------------------------------"
  write(*,*) "cpu time (fft) is ", tf2-tf1, "[s]."
  write(*,*) "cpu time (dft) is ", to2-to1, "[s]."
  write(*,*) "-------------------------------"

end program
