module Statistics  ! ײϴطΥ롼

  private :: summ

interface Bubble_Sort
! Bubble_Sort

  module procedure Bubble_Sort_i, Bubble_Sort_f

end interface Bubble_Sort

contains

subroutine Mean_1d( x, ave, error )  ! 1 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, nt
  integer :: nx  ! ǡǿ
  real :: summ

  summ=0.0
  nt=0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           summ=summ+x(i)
           nt=1+nt
        end if
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do i=1,nx
        summ=summ+x(i)
     end do

     ave=summ/nx

  end if

end subroutine Mean_1d


subroutine Mean_2d( x, ave, error )  ! 2 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  real :: summ

  summ=0.0
  nt=0
  nx=size(x,1)
  ny=size(x,2)

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              summ=summ+x(i,j)
              nt=1+nt
           end if
        end do
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do j=1,ny
        do i=1,nx
           summ=summ+x(i,j)
        end do
     end do

     ave=summ/(nx*ny)

  end if

end subroutine Mean_2d


subroutine Mean_3d( x, ave, error )  ! 3 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 2
  real :: summ

  summ=0.0
  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 summ=summ+x(i,j,k)
                 nt=1+nt
              end if
           end do
        end do
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              summ=summ+x(i,j,k)
           end do
        end do
     end do

     ave=summ/(nx*ny*nz)

  end if

end subroutine Mean_3d


subroutine Anomaly_1d( x, anor, error )  ! 1 ǡк֤
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: anor(size(x))  !  x(i) бк anor(i)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i
  integer :: nx  ! ǡǿ
  real :: ave

  nx=size(x)

  if(present(error))then
     call Mean_1d( x, ave, error )
     do i=1,nx
        if(x(i)==error)then
           anor(i)=error
        else
           anor(i)=x(i)-ave
        end if
     end do
  else
     call Mean_1d( x, ave )
     do i=1,nx
        anor(i)=x(i)-ave
     end do
  end if

end subroutine Anomaly_1d


subroutine Anomaly_2d( x, anor, error )  ! 2 ǡк֤
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: anor(size(x,1),size(x,2))  !  x(i,j) бк anor(i,j)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  real :: ave

  nx=size(x,1)
  ny=size(x,2)

  if(present(error))then
     call Mean_2d( x, ave, error )
     do j=1,ny
        do i=1,nx
           if(x(i,j)==error)then
              anor(i,j)=error
           else
              anor(i,j)=x(i,j)-ave
           end if
        end do
     end do
  else
     call Mean_2d( x, ave, error )
     do j=1,ny
        do i=1,nx
           anor(i,j)=x(i,j)-ave
        end do
     end do
  end if

end subroutine Anomaly_2d


subroutine Anomaly_3d( x, anor, error )  ! 3 ǡк֤
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: anor(size(x,1),size(x,2),size(x,3))  !  x(i,j,k) бк anor(i,j,k)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, k
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  real :: ave

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(error))then
     call Mean_3d( x, ave, error )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==error)then
                 anor(i,j,k)=error
              else
                 anor(i,j,k)=x(i,j,k)-ave
              end if
           end do
        end do
     end do
  else
     call Mean_3d( x, ave, error )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              anor(i,j,k)=x(i,j,k)-ave
           end do
        end do
     end do
  end if

end subroutine Anomaly_3d


subroutine stand_vari( x, anor, error )  ! 1 ǡɸк׻
  ! ɸк$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{epsilon ^2} $$
  ! , $\epsilon $ʿͤΤ$x-\bar{x}$Ǥ.
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: anor  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i
  integer :: nx  ! ǡ
  real :: an(size(x))

  nx=size(x)
  anor=0.0

  if(present(error))then
     call Anomaly_1d( x, an, error )
     do i=1,nx
        if(x(i)/=error)then
           anor=anor+an(i)**2
        end if
     end do
  else
     call Anomaly_1d( x, an )
     do i=1,nx
        anor=anor+an(i)**2
     end do
  end if

end subroutine stand_vari

subroutine covariance( x, y, cov, error )  ! 2 Ĥ 1 ǡζʬ׻
  ! ʬ$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{(x-\bar{x})(y-\bar{y})} $$
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: cov  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i
  integer :: nx  ! ǡ
  real :: an1(size(x)), an2(size(x))

  nx=size(x)
  cov=0.0

  if(present(error))then
     call Anomaly_1d( x, an1, error )
     call Anomaly_1d( y, an2, error )
     do i=1,nx
        if(x(i)/=error)then
           cov=cov+an1(i)*an2(i)
        end if
     end do
  else
     call Anomaly_1d( x, an1 )
     call Anomaly_1d( y, an2 )
     do i=1,nx
        cov=cov+an1(i)*an2(i)
     end do
  end if

end subroutine covariance


subroutine nearest_search_1d( x, point, i )
  ! 1 Ƕ˵õ롼
  ! interpo_search_1d ͤ, ͤ +1 ͤεΥӤ
  ! Υû򤹤.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  real :: tmp1, tmp2
  integer :: j, nx

  nx=size(x)

  call interpo_search_1d( x, point, j )

  if(j==0)then  ! i=1 ˤΤ, tmp1 x(1), tmp2  x(2) ,  if ʸ
           ! Ǥޤ.
     tmp1=x(j+1)
     tmp2=x(j+2)
  else
     if(j==nx)then  ! i=nx ˤΤ, tmp2  x(nx), tmp1  x(nx-1) ,
            !  if ʸǤޤ.
        tmp1=x(j)
        tmp2=x(j-1)
     else
        tmp1=x(j)
        tmp2=x(j+1)
     end if
  end if

  if(abs(point-tmp1)>abs(tmp2-point))then
     i=j+1
  else
     i=j
  end if

end subroutine nearest_search_1d


subroutine nearest_search_2d( x, y, pointx, pointy, i, j )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ

  call nearest_search_1d( x, pointx, i )
  call nearest_search_1d( y, pointy, j )

end subroutine nearest_search_2d


subroutine nearest_search_3d( x, y, z, pointx, pointy, pointz, i, j, k )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ

  call nearest_search_1d( x, pointx, i )
  call nearest_search_1d( y, pointy, j )
  call nearest_search_1d( z, pointz, k )

end subroutine nearest_search_3d


subroutine interpo_search_1d( x, point, i, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: nx, j
  integer :: just

  nx=size(x)
  if(present(undeff))then
     just=int(undeff)
  else
     just=0
  end if

  do j=1,nx
     if(x(1)>point)then
        write(*,*) "****** WARNING ******"
        write(*,*) "searching point was not found."
        write(*,*) "Abort. Exit.!!!"
        i=just
        exit
     end if

     if(present(undeff))then
        if(x(j)/=undeff)then
           if(x(j)<=point)then
              i=j
           else
              exit
           end if
        end if
     else
        if(x(j)<=point)then
           i=j
        else
           exit
        end if
     end if
  end do

end subroutine interpo_search_1d


subroutine interpo_search_2d( x, y, pointx, pointy, i, j, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: just

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1d( x, pointx, i, just )
     call interpo_search_1d( y, pointy, j, just )
  else
     call interpo_search_1d( x, pointx, i )
     call interpo_search_1d( y, pointy, j )
  end if

end subroutine interpo_search_2d


subroutine interpo_search_3d( x, y, z, pointx, pointy, pointz, i, j, k, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k  ! pointz ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: just

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1d( x, pointx, i, just )
     call interpo_search_1d( y, pointy, j, just )
     call interpo_search_1d( z, pointz, k, just )
  else
     call interpo_search_1d( x, pointx, i )
     call interpo_search_1d( y, pointy, j )
     call interpo_search_1d( z, pointz, k )
  end if

end subroutine interpo_search_3d


subroutine interpolation_1d( x, y, point, val )
  ! 1 ޥ롼
  implicit none
  real, intent(in) :: x(2)  ! κü
  real, intent(in) :: y(2)  ! x Ƥ
  real, intent(in) :: point  ! 
  real, intent(inout) :: val  ! Ǥ
  real :: fd, dt
  real :: tmin
  real :: tmax
  real :: xmin
  real :: xmax

  tmin=x(1)
  tmax=x(2)
  xmin=y(1)
  xmax=y(2)

  dt=point-tmin

  fd=(xmax-xmin)/(tmax-tmin)

  val=xmin+dt*fd
end subroutine interpolation_1d


subroutine interpolation_2d( x, y, z, point, val )
  ! 2 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2,2)  ! x, y ǤγǤ, (i,j) ˤĤ, i<=x, j<=y
  real, intent(in) :: point(2)  !  point(1)<=x ɸ, point(2)<=y ɸ
  real, intent(inout) :: val  ! Ǥ
  real :: valx(2)

  ! y(1) Ǥ x Ǥ
  call interpolation_1d( (/x(1), x(2)/), (/z(1,1), z(2,1)/), point(1), valx(1) )

  ! y(2) Ǥ x Ǥ
  call interpolation_1d( (/x(1), x(2)/), (/z(1,2), z(2,2)/), point(1), valx(2) )

  ! x  y Ǥ(줬)
  call interpolation_1d( (/y(1), y(2)/), (/valx(1), valx(2)/), point(2), val )

end subroutine interpolation_2d


subroutine interpolation_3d( x, y, z, u, point, val )
  ! 3 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2)  ! ޤζ z κü
  real, intent(in) :: u(2,2,2)  ! x, y, z ǤγǤ, (i,j,k) ˤĤ, i<=x, j<=y, k<=z
  real, intent(in) :: point(3)  !  point(1)<=x ɸ, point(2)<=y ɸ, point(3)<=z ɸ
  real, intent(inout) :: val  ! Ǥ
  real :: valx(2)

  ! z(1) Ǥ x-y ʿ̤Ǥνޤ
  call interpolation_2d( x, y, u(:,:,1), point(1:2), valx(1) )

  ! z(2) Ǥ x Ǥ
  call interpolation_2d( x, y, u(:,:,2), point(1:2), valx(2) )

  ! z(1)  z Ǥ(줬)
  call interpolation_1d( (/z(1), z(2)/), (/valx(1), valx(2)/), point(3), val )

end subroutine interpolation_3d

!------------------------------------
!------------------------------------

subroutine auto_interpolation_1d( x, r, u, v, undef )
  ! ɸ x Ƥǡ u 
  ! ɸ r ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ
  real, intent(in) :: r(:)  ! ޺ɸ
  real, intent(in) :: u(size(x))  ! ǡ
  real, intent(inout) :: v(size(r))  ! ޤǡ
  integer, intent(in), optional :: undef  ! ̤
  integer :: i, nx, nr, ix, ir
  integer :: defun

  if(present(undef))then
     defun=undef
  else
     defun=0
  end if

  nx=size(x)
  nr=size(r)

  do i=1, nr
     call interpo_search_1d( x, r(i), ir, defun )

     if(ir/=defun.and.ir<nx)then
        call interpolation_1d( x(ir:ir+1), u(ir:ir+1), r(i), v(i) )
     else
        v(i)=real(defun)
     end if
  end do

end subroutine auto_interpolation_1d

!------------------------------------
!------------------------------------

subroutine auto_interpolation_2d( x, y, r, q, u, v, undef )
  ! ɸ x, y Ƥǡ u 
  ! ɸ r, q ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ 1
  real, intent(in) :: y(:)  ! ɸ 2
  real, intent(in) :: r(:)  ! ޺ɸ 1
  real, intent(in) :: q(:)  ! ޺ɸ 2
  real, intent(in) :: u(size(x),size(y))  ! ǡ
  real, intent(inout) :: v(size(r),size(q))  ! ޤǡ
  integer, intent(in), optional :: undef  ! ̤
  integer :: i, j, nx, ny, nr, nq, ix, iy, ir, iq
  integer :: defun

  if(present(undef))then
     defun=undef
  else
     defun=0
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nq=size(q)

  do j=1, nq
     do i=1, nr
        call interpo_search_2d( x, y, r(i), q(j), ir, iq, defun )

        if(ir/=defun.and.iq/=defun.and.ir<nx.and.iq<ny)then
           call interpolation_2d( x(ir:ir+1), y(iq:iq+1),  &
  &                               u(ir:ir+1,iq:iq+1), (/r(i), q(j)/), v(i,j) )
        else
           v(i,j)=real(defun)
        end if
     end do
  end do

end subroutine auto_interpolation_2d

!------------------------------------
!------------------------------------

subroutine auto_interpolation_3d( x, y, z, r, q, p, u, v, undef )
  ! ɸ x, y, z Ƥǡ u 
  ! ɸ r, q, p ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ 1
  real, intent(in) :: y(:)  ! ɸ 2
  real, intent(in) :: z(:)  ! ɸ 3
  real, intent(in) :: r(:)  ! ޺ɸ 1
  real, intent(in) :: q(:)  ! ޺ɸ 2
  real, intent(in) :: p(:)  ! ޺ɸ 3
  real, intent(in) :: u(size(x),size(y),size(z))  ! ǡ
  real, intent(inout) :: v(size(r),size(q),size(p))  ! ޤǡ
  integer, intent(in), optional :: undef  ! ̤
  integer :: i, j, k, nx, ny, nz, nr, nq, np, ix, iy, iz, ir, iq, ip
  integer :: defun

  if(present(undef))then
     defun=undef
  else
     defun=0
  end if

  nx=size(x)
  ny=size(y)
  nz=size(z)
  nr=size(r)
  nq=size(q)
  np=size(p)

  do k=1, np
     do j=1, nq
        do i=1, nr
           call interpo_search_3d( x, y, z, r(i), q(j), p(k),  &
  &                                ir, iq, ip, defun )

           if(ir/=defun.and.iq/=defun.and.ip/=defun.and.  &
  &           ir<nx.and.iq<ny.and.ip<nz)then
              call interpolation_3d( x(ir:ir+1), y(iq:iq+1), z(ip:ip+1),  &
  &                               u(ir:ir+1,iq:iq+1,ip:ip+1),  &
  &                               (/r(i), q(j), p(k)/), v(i,j,k) )
           else
              v(i,j,k)=real(defun)
           end if
        end do
     end do
  end do

end subroutine auto_interpolation_3d

!------------------------------------
!------------------------------------

subroutine LSM( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef ! undef 
  real :: u(size(x)), v(size(x))
  integer :: i
  integer :: nx  ! ǡ
  real :: a, b, c, d

  nx=size(x)
  a=0.0
  b=0.0
  c=0.0
  d=0.0

!$omp parallel do shared(u, v, x, y) private(i)
  do i=1,nx
     u(i)=x(i)*x(i)
     v(i)=x(i)*y(i)
  end do
!$omp end parallel do

  call summ(v,a,undef)
  call summ(x,b,undef)
  call summ(y,c,undef)
  call summ(u,d,undef)

  slope=(nx*a-b*c)/(nx*d-b**2)
  intercept=(c*d-a*b)/(nx*d-b**2)

end subroutine LSM

!------------------------------------
!------------------------------------

subroutine LSM_poly( x, y, a, intercept, undef )
! LSM ¿༰С.
! LSM Ǥ, F(x)=a_0+a_1x ľԤäƤ,
! LSM_poly Ǥ, F(x)=\sum^{N}_{n=0}{a_nx^n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  use Matrix_Calc
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: a(:)  ! ¿༰η
  real, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k
  integer :: nx  ! ǡθĿ
  integer :: poly_n  ! κǹ⼡. 1 ʤ, LSM Ʊ.
  real :: coe(0:size(a)), tmpa_coe(0:size(a),0:size(a)), tmpb_coe(0:size(a))
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  real :: tmp(size(x))  ! ٤׻ΰ

  nx=size(x)
  poly_n=size(a)

!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i)/=undef)then
                    tmp(i)=x(i)**(j+k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summ( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           if(x(i)/=undef)then
              tmp(i)=y(i)*(x(i)**j)
           else
              tmp(i)=undef
           end if
        end do
        call summ( tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i)**(j+k)
              end do
              call summ( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           tmp(i)=y(i)*(x(i)**j)
        end do
        call summ( tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausss( tmpa_coe(0:poly_n,0:poly_n), tmpb_coe(0:poly_n),  &
  &            coe(0:poly_n) )

  do i=1,poly_n
     a(i)=coe(i)
  end do
  intercept=coe(0)

end subroutine

!------------------------------------

subroutine Reg_Line( x, y, slope, intercept )
  ! LSM ѤƲľη slope  intercept ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real :: u(size(x)), v(size(x))
  integer :: nx  ! ǡ

  nx=size(x)

  call Anomaly_1d( x, u )
  call Anomaly_1d( y, v )
  call LSM( u, v, slope, intercept )

end subroutine

subroutine Cor_Coe( x, y ,cc, error )  ! 2 ǡط׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: cc  ! ط
  real, intent(in), optional :: error  ! »
  integer :: nx  ! ǡĿ
  real :: cov, anor1, anor2

  nx=size(x)

  if(present(error))then
     call covariance( x, y, cov, error )
     call stand_vari( x, anor1, error )
     call stand_vari( y, anor2, error )
  else
     call covariance( x, y, cov )
     call stand_vari( x, anor1 )
     call stand_vari( y, anor2 )
  end if

  cc=cov/(sqrt(anor1)*sqrt(anor2))

end subroutine Cor_Coe

!---------------------------------
!---------------------------------

subroutine Move_ave( x, n, y, error )
! ưʿѤ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  integer, intent(in) :: n  ! ʿѤȤ
  real, intent(inout) :: y(size(x))  ! ʿѲΥǡ.
                      ! ºݤ, y(1:n-1) ޤǤˤϥ.
  real, intent(in), optional :: error  ! »
  integer :: nx, i
  real :: tmp

  nx=size(x)

  if(nx<n.or.n<2)then
     write(*,*) "### ERROR ### (Move_ave)"
     write(*,*) "x(nx) : nx must be more than n or n must be more than 2."
     write(*,*) "STOP"
     stop
  end if

  if(present(error))then
     call Mean_1d( x(1:n), tmp, error )
     y(1:n-1)=0.0
     y(n)=tmp

     do i=n+1,nx
        y(i)=y(i-1)+(x(i)-x(i-n))/real(n)
     end do
  else
     call Mean_1d( x(1:n), tmp )
     y(1:n-1)=0.0
     y(n)=tmp

     do i=n+1,nx
        y(i)=y(i-1)+(x(i)-x(i-n))/real(n)
     end do
  end if

end subroutine Move_ave

!---------------------------------
!---------------------------------

subroutine Bubble_Sort_i( a, b, sig )
! Х֥륽ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  integer, intent(in) :: a(:)  ! Ȥ
  integer, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, n
  integer :: tmp

  n=size(a)

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  do i=1,n
     b(i)=a(i)
  end do

  if(sig=='i')then  ! ٤
     do i=1,n
        do j=1,n-1
           if(b(j)>b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  else
     do i=1,n
        do j=1,n-1
           if(b(j)<b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  end if

end subroutine Bubble_Sort_i

!---------------------------------
!---------------------------------

subroutine Bubble_Sort_f( a, b, sig )
! Х֥륽ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  real, intent(in) :: a(:)  ! Ȥ
  real, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, n
  real :: tmp

  n=size(a)

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  do i=1,n
     b(i)=a(i)
  end do

  if(sig=='i')then  ! ٤
     do i=1,n
        do j=1,n-1
           if(b(j)>b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  else
     do i=1,n
        do j=1,n-1
           if(b(j)<b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  end if

end subroutine Bubble_Sort_f

!---------------------------------
!---------------------------------
!---- ʲ, private 롼----
!---------------------------------
!---------------------------------

subroutine summ( z, add, undeff )
! undef ±黻Ԥ private 롼. ȤԲ.
  implicit none
  real, intent(in) :: z(:)
  real, intent(inout) :: add
  real, intent(in), optional :: undeff
  integer :: i
  integer :: nx

  nx=size(z)

  add=0.0
  if(present(undeff))then
     do i=1,nx
        if(undeff/=z(i))then
           add=add+z(i)
        end if
     end do
  else
     do i=1,nx
        add=add+z(i)
     end do
  end if

end subroutine summ


end module
