module fft_force_solv

  use fftsub_mod
  use ffts

contains

subroutine fft_ADV_term( psik, ADV )
!-- calculating advection terms
  use Math_Const
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(nx,ny), intent(in) :: psik     ! psik
  complex(kind(0d0)), dimension(nx,ny), intent(inout) :: ADV   ! advection term

  integer :: i, j
  double precision :: lxi, lyi
  complex(kind(0d0)), dimension(jxnt,jynt) :: psi3k, uk, vk, u, v, anm, akl, bnm, bkl, tma

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly

  psi3k=0.0d0
  uk=0.0d0
  vk=0.0d0
  u=0.0d0
  v=0.0d0
  anm=0.0d0
  akl=0.0d0
  bnm=0.0d0
  bkl=0.0d0
  ADV=0.0d0

  call rearrange_2to3( psik, psi3k )

  call psik2ukvk( psi3k, uk, vk )

  call ffttp_2d( jxnt, jynt, uk, u, 'i', 'o', prim_factx=pxfact,  &
  &              prim_facty=pyfact, omegax_fix=omegaxjbi,  &
  &              omegaxn_fix=omegaxjni, omegay_fix=omegayjbi,  &
  &              omegayn_fix=omegayjni )
  call ffttp_2d( jxnt, jynt, vk, v, 'i', 'o', prim_factx=pxfact,  &
  &              prim_facty=pyfact, omegax_fix=omegaxjbi,  &
  &              omegaxn_fix=omegaxjni, omegay_fix=omegayjbi,  &
  &              omegayn_fix=omegayjni )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do j=1,jynt
     do i=1,jxnt
        anm(i,j)=u(i,j)*v(i,j)
        bnm(i,j)=v(i,j)*v(i,j)-u(i,j)*u(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

  call ffttp_2d( jxnt, jynt, anm, akl, 'r', 'o', prim_factx=pxfact,  &
  &              prim_facty=pyfact, omegax_fix=omegaxjbr, omegaxn_fix=omegaxjnr,  &
  &              omegay_fix=omegayjbr, omegayn_fix=omegayjnr )
  call ffttp_2d( jxnt, jynt, bnm, bkl, 'r', 'o', prim_factx=pxfact,  &
  &              prim_facty=pyfact, omegax_fix=omegaxjbr, omegaxn_fix=omegaxjnr,  &
  &              omegay_fix=omegayjbr, omegayn_fix=omegayjnr )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     tma(i,1)=-akl(i,1)
     tma(jxnt-i+2,1)=dconjg(tma(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     tma(1,j)=akl(1,j)
     tma(1,jynt-j+2)=akl(1,jynt-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        tma(i,j)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,j)  &
  &              -dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,j)
        tma(i,j)=tma(i,j)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
        tma(jxnt-i+2,jynt-j+2)=dconjg(tma(i,j))
        tma(i,jynt-j+2)=-((dble(i-1)*lxi)**2-(dble(j-1)*lyi)**2)*akl(i,jynt-j+2)  &
  &                     +dble(i-1)*dble(j-1)*lxi*lyi*bkl(i,jynt-j+2)
        tma(i,jynt-j+2)=tma(i,jynt-j+2)/((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)
        tma(jxnt-i+2,j)=dconjg(tma(i,jynt-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

  call rearrange_3to2( tma, ADV )

end subroutine fft_ADV_term


subroutine fft_DIFF_term( psik, DIFF )
!-- calculating diffusion term
! nu*lap(zeta)
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(nx,ny), intent(in) :: psik      ! psik
  complex(kind(0d0)), dimension(nx,ny), intent(inout) :: DIFF   ! diffusion term

  integer :: i, j
  double precision :: lxi, lyi, pi4

  DIFF=0.0d0

  lxi=1.0d0/Lx
  lyi=1.0d0/Ly
  pi4=4.0d0*pi_dp*pi_dp

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)

  do i=2,hxnt+1
     DIFF(i,1)=-nu*pi4*((dble(i-1)*lxi)**2)*psik(i,1)
     DIFF(nx-i+2,1)=dconjg(DIFF(i,1))
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(j)

  do j=2,hynt+1
     DIFF(1,j)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,j)
     DIFF(1,ny-j+2)=-nu*pi4*((dble(j-1)*lyi)**2)*psik(1,ny-j+2)
  end do

!$omp end do
!$omp barrier
!$omp do schedule(runtime) private(i,j)

  do j=2,hynt+1
     do i=2,hxnt+1
        DIFF(i,j)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)*psik(i,j)
        DIFF(nx-i+2,ny-j+2)=dconjg(DIFF(i,j))
        DIFF(i,ny-j+2)=-nu*pi4*((dble(i-1)*lxi)**2+(dble(j-1)*lyi)**2)  &
  &                    *psik(i,ny-j+2)
        DIFF(nx-i+2,j)=dconjg(DIFF(i,ny-j+2))
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine fft_DIFF_term


subroutine fft_calc_FORCE( psik, force )
!-- calculating total forcing terms
  use fft_saveval_define
  implicit none
  complex(kind(0d0)), dimension(nx,ny), intent(in) :: psik       ! psi
  complex(kind(0d0)), dimension(nx,ny), intent(inout) :: force   ! total force

  integer :: i, j
  complex(kind(0d0)), dimension(nx,ny) :: ADV, DIFF

  force=0.0d0

!-- calculating advecting term 

  call fft_ADV_term( psik, ADV )

!-- calculating beta effect

!  call BETA_term( v, BETA )

!-- calculating diffusion term

  call fft_DIFF_term( psik, DIFF )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j)

  do j=1,2*hynt+1
     do i=1,hxnt+1
!        force(i,j)=-ADV(i,j)+BETA(i,j)+DIFF(i,j)
!        force(i,j)=DIFF(i,j)
        force(i,j)=ADV(i,j)+DIFF(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine fft_calc_FORCE


end module fft_force_solv
