module fft_val_alloc_isp
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  implicit none

contains

subroutine fft_val_allocate()

  use fft_saveval_define
  use fft_val_define_isp

  implicit none

  integer :: err

  err=0
  allocate(zi(nxi,nyi),stat=err)
  allocate(psid(nx,ny),stat=err)
  allocate(ud(nx,ny),stat=err)
  allocate(vd(nx,ny),stat=err)
  allocate(zd(nx,ny),stat=err)
  allocate(zor(nx,ny),stat=err)
  allocate(ur(nx,ny),stat=err)
  allocate(vr(nx,ny),stat=err)
  allocate(psior(nx,ny),stat=err)
  allocate(psiko(kxnt,kynt),stat=err)
  allocate(zko(kxnt,kynt),stat=err)
  allocate(psikn(kxnt,kynt),stat=err)
  allocate(zopt1(kxnt,kynt),stat=err)
  allocate(uk(kxnt,kynt),stat=err)
  allocate(vk(kxnt,kynt),stat=err)
  allocate(tmpr(nx,ny),stat=err)
  allocate(tmpi(nx,ny),stat=err)

  allocate(zor_isp(ny,nx),stat=err)
  allocate(psior_isp(ny,nx),stat=err)
  allocate(ur_isp(ny,nx),stat=err)
  allocate(vr_isp(ny,nx),stat=err)
  allocate(zko_isp(-hynt:hynt,-hxnt:hxnt),stat=err)
  allocate(psiko_isp(-hynt:hynt,-hxnt:hxnt),stat=err)
  allocate(uk_isp(-hynt:hynt,-hxnt:hxnt),stat=err)
  allocate(vk_isp(-hynt:hynt,-hxnt:hxnt),stat=err)
  allocate(tmp_work(ny,nx),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (fft_val_allocate) *** : cannot allocate."
     stop
  end if

end subroutine fft_val_allocate


subroutine fft_val_coordinate()

  use fft_saveval_define

  implicit none

  integer :: i
  double precision :: dxtmp, dytmp

!-- 各座標径の設定

  x=(/((xmin+(dble(i-1))*dx),i=1,nx)/)
  y=(/((ymin+(dble(i-1))*dy),i=1,ny)/)
  xd=(/((real(xmin)+(real(i-1))*real(dx)),i=1,nx)/)
  yd=(/((real(ymin)+(real(i-1))*real(dy)),i=1,ny)/)

  dxtmp=dx*dble(nx-1)/dble(jxnt-1)
  dytmp=dy*dble(ny-1)/dble(jynt-1)
  xj=(/(xmin+dble(i-1)*dxtmp,i=1,jxnt)/)
  yj=(/(ymin+dble(i-1)*dytmp,i=1,jynt)/)

end subroutine

end module fft_val_alloc_isp
