program solver
! Holton (2004) non-divergent barotropic vortex model
  use gtool_history
  use Derivation
  use Statistics
  use Math_Const
  use Phys_Const
  use Basis
  use saveval_define
  use val_define
  use read_namelist
  use saveval_alloc
  use val_alloc
  use val_coord
  use time_scheme
  use sub_mod
  use force_solv
  use Ellip_Slv

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it

!-- namelist の読み込み

  call read_name()

!-- allocating array

  call saveval_allocate()
  call val_allocate()

!-- 格子点の再定義

  call val_coordinate()

!-- 初期値化 (計算領域の設定や境界条件の設定, 特にポアソン計算について)

write(*,*) "starting initialization."

!-- psi, omega に対して, 各境界条件フラグを設定.

  bnd=0.0d0

!-- reading initial data

  call HistoryGet( trim(ininame), trim(adjustl(inix)), xi )
  call HistoryGet( trim(ininame), trim(adjustl(iniy)), yi )
!  call HistoryGet( trim(ininame), trim(adjustl(inif)), fi )
  call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )

  do i=1,nx
     xd(i)=real(x(i))
  end do
  do j=1,ny
     yd(j)=real(y(j))
  end do

write(*,*) "starting interpolation of initial data."
!  call auto_interpolation_1d( yi, y, fi, coril )
  call auto_interpolation_2d( xi, yi, xd, yd, zi, zd )

!  call grad_1d( y, coril, betaf )

  do j=1,ny
     do i=1,nx
        zo(i,j)=dble(zd(i,j))
     end do
  end do

!-- setting psi

write(*,*) "setting initial data of psi."
  call Ellip_Jacobi_2d( x, y, zo, eps, boundary, psio,  &
  &                     init_flag=.false. )

!-- 境界強制値の設定.

  write(*,*) "normally pass the initialization."

!-- 出力ファイルの初期化
  call HistoryCreate( file=trim(foname), title='BAROTRO result data', &
  & source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  & dimsizes=(/ nx, ny, 0 /),  & 
  & longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*real(dt) )
  
  call HistoryPut( 'x', xd )
  call HistoryPut( 'y', yd )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
    & longname='stream line function', units='m2 s-1', xtype='float')

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
    & longname='vorticity', units='s-1', xtype='float')

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
    & longname='X wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
    & longname='Y wind', units='m s-1', xtype='float')

  write(*,*) "time integration start."

  !-- 出力等の処理 (初期値の出力)

  call psi2uv( psio, u, v )

  do j=1,ny
     do i=1,nx
        psid(i,j)=real(psio(i,j))
        zd(i,j)=real(zo(i,j))
        ud(i,j)=real(u(i,j))
        vd(i,j)=real(v(i,j))
        psin(i,j)=psio(i,j)
        zn(i,j)=zo(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call HistoryPut( 'psi', psid )
  call HistoryPut( 'zeta', zd )
  call HistoryPut( 'u', ud )
  call HistoryPut( 'v', vd )

!-- solver スタート

  do it=1,nt

     select case (time_flag(1:3))
     case ('L-F')
        call time_schematic( it, zo, psio, zn, psin, zopt1 )
     case ('AB2')
        call time_schematic( it, zo, psio, zn, psin, zopt1 )
     case default
        call time_schematic( it, zo, psio, zn, psin )
     end select

     zo=zn
     psio=psin

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", dble(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        call psi2uv( psin, u, v )

        do j=1,ny
           do i=1,nx
              psid(i,j)=real(psin(i,j))
              zd(i,j)=real(zn(i,j))
              ud(i,j)=real(u(i,j))
              vd(i,j)=real(v(i,j))
           end do
        end do

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", dble(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'psi', psid )
        call HistoryPut( 'zeta', zd )
        call HistoryPut( 'u', ud )
        call HistoryPut( 'v', vd )

     end if

  end do

!-- solver ストップ

  write(*,*) "solver is normally."

end program
