module file_output
!-- module to control file input and output.
  use sub_mod
  use fftsub_mod
  use mpi_mod
  use basis

contains

subroutine dmp_file( psik, uk_mbl, vk_mbl, pk, itime, history )
!-- control file output
  use gtool_history
  use savegloval_define
  implicit none
  complex(kind(0d0)), intent(in) :: psik(1:kxnt,1:kynt)
  complex(kind(0d0)), intent(in) :: uk_mbl(1:kxnt,1:kynt,0:nzp+1)
  complex(kind(0d0)), intent(in) :: vk_mbl(1:kxnt,1:kynt,0:nzp+1)
  complex(kind(0d0)), intent(in) :: pk(1:kxnt,1:kynt)
  integer, intent(in) :: itime
  type(GT_HISTORY), intent(inout) :: history
  integer :: k
  complex(kind(0d0)), dimension(1:kxnt,1:kynt) :: uk_nbm, vk_nbm, zk_nbm
  complex(kind(0d0)), dimension(1:kxnt,1:kynt,0:nzp+1) :: wk_mbl
  double precision, dimension(nx,ny) :: tmpd
  real, dimension(nx,ny) :: psi_nbm, u_nbm, v_nbm, z_nbm, p
  real, dimension(nx,ny,0:nzp+1) :: u_mbl, v_mbl, w_mbl
!-- For debug
  real, dimension(nx,ny,0:nzp+1) :: HADVu_dmp, HADVv_dmp, VADVu_dmp, VADVv_dmp, HDIFFu_dmp, HDIFFv_dmp, VDIFFu_dmp, VDIFFv_dmp, CORILu_dmp, CORILv_dmp, PGRADu_dmp, PGRADv_dmp

  call psik2ukvk( psik(1:kxnt,1:kynt), uk_nbm(1:kxnt,1:kynt), vk_nbm(1:kxnt,1:kynt) )
  call psik2zetak( psik(1:kxnt,1:kynt), zk_nbm(1:kxnt,1:kynt), zkopt=basezeta )
  call W_divergence2( uk_mbl(1:kxnt,1:kynt,0:nzp+1), vk_mbl(1:kxnt,1:kynt,0:nzp+1),  &
  &                   wk_mbl(1:kxnt,1:kynt,0:nzp+1) )

  call spec2phys( psik, tmpd )
  call type_convert_d2r( tmpd, psi_nbm )
  call spec2phys( uk_nbm, tmpd )
  call type_convert_d2r( tmpd, u_nbm )
  call spec2phys( vk_nbm, tmpd )
  call type_convert_d2r( tmpd, v_nbm )
  call spec2phys( zk_nbm, tmpd )
  call type_convert_d2r( tmpd, z_nbm )
  call spec2phys( pk, tmpd )
  call type_convert_d2r( tmpd, p )

  do k=1,nzp
     call spec2phys( uk_mbl(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, u_mbl(1:nx,1:ny,k) )
     call spec2phys( vk_mbl(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, v_mbl(1:nx,1:ny,k) )
     call spec2phys( wk_mbl(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, w_mbl(1:nx,1:ny,k) )
  end do

!-- For debug
  do k=1,nzp
     call spec2phys( HADVud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, HADVu_dmp(1:nx,1:ny,k) )
     call spec2phys( HADVvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, HADVv_dmp(1:nx,1:ny,k) )
     call spec2phys( VADVud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, VADVu_dmp(1:nx,1:ny,k) )
     call spec2phys( VADVvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, VADVv_dmp(1:nx,1:ny,k) )
     call spec2phys( HDIFFud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, HDIFFu_dmp(1:nx,1:ny,k) )
     call spec2phys( HDIFFvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, HDIFFv_dmp(1:nx,1:ny,k) )
     call spec2phys( VDIFFud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, VDIFFu_dmp(1:nx,1:ny,k) )
     call spec2phys( VDIFFvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, VDIFFv_dmp(1:nx,1:ny,k) )
     call spec2phys( CORILud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, CORILu_dmp(1:nx,1:ny,k) )
     call spec2phys( CORILvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, CORILv_dmp(1:nx,1:ny,k) )
     call spec2phys( PGRADud(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, PGRADu_dmp(1:nx,1:ny,k) )
     call spec2phys( PGRADvd(1:kxnt,1:kynt,k), tmpd )
     call type_convert_d2r( tmpd, PGRADv_dmp(1:nx,1:ny,k) )
  end do

  call output_2d( psi_nbm, u_nbm, v_nbm, z_nbm, p,  &
  &               u_mbl, v_mbl, w_mbl, history,  &
  &               HADVu_dmp, HADVv_dmp, VADVu_dmp, VADVv_dmp,  &
  &               HDIFFu_dmp, HDIFFv_dmp, VDIFFu_dmp, VDIFFv_dmp,  &
  &               CORILu_dmp, CORILv_dmp, PGRADu_dmp, PGRADv_dmp )

  if(MY_RANK==0)then
     write(*,*) "*******************************************"
     write(*,*) "File damp (time =", dble(itime)*dt, "[s])."
     write(*,*) "*******************************************"
  end if

end subroutine dmp_file


subroutine output_2d( psi, u_nbm, v_nbm, z_nbm, p,  &
  &                   u_mbl, v_mbl, w_mbl, history,  &
  &                   HADVu_dmp, HADVv_dmp, VADVu_dmp, VADVv_dmp,  &
  &                   HDIFFu_dmp, HDIFFv_dmp, VDIFFu_dmp, VDIFFv_dmp,  &
  &                   CORILu_dmp, CORILv_dmp, PGRADu_dmp, PGRADv_dmp )
!-- output 2d variables in NetCDF file
  use gtool_history
  use savegloval_define
  implicit none
  real, intent(in) :: psi(nx,ny)
  real, intent(in) :: u_nbm(nx,ny)
  real, intent(in) :: v_nbm(nx,ny)
  real, intent(in) :: z_nbm(nx,ny)
  real, intent(in) :: p(nx,ny)
  real, intent(in) :: u_mbl(nx,ny,0:nzp+1)
  real, intent(in) :: v_mbl(nx,ny,0:nzp+1)
  real, intent(in) :: w_mbl(nx,ny,0:nzp+1)
  type(GT_HISTORY), intent(inout) :: history
!-- For debug
  real, dimension(nx,ny,0:nzp+1), intent(in) :: HADVu_dmp, HADVv_dmp, VADVu_dmp, VADVv_dmp, HDIFFu_dmp, HDIFFv_dmp, VDIFFu_dmp, VDIFFv_dmp, CORILu_dmp, CORILv_dmp, PGRADu_dmp, PGRADv_dmp
  real, dimension(nx,ny,nz) :: dmp_u_mbl, dmp_v_mbl, dmp_w_mbl
  integer :: IERROR

  call mpi_gather_dmpuvw( IERROR, u_mbl, v_mbl, w_mbl,  &
  &                       dmp_u_mbl, dmp_v_mbl, dmp_w_mbl )

  if(MY_RANK==0)then
     call HistoryPut( 'psi', psi, history=history )
     call HistoryPut( 'unbm', u_nbm, history=history )
     call HistoryPut( 'vnbm', v_nbm, history=history )
     call HistoryPut( 'zeta', z_nbm, history=history )
     call HistoryPut( 'p', p, history=history )
     call HistoryPut( 'umbl', dmp_u_mbl, history=history )
     call HistoryPut( 'vmbl', dmp_v_mbl, history=history )
     call HistoryPut( 'wmbl', dmp_w_mbl, history=history )
  end if

!-- For debug
  call mpi_gather_dmpuvw( IERROR, HADVu_dmp, HADVv_dmp, VADVu_dmp,  &
  &                       dmp_u_mbl, dmp_v_mbl, dmp_w_mbl )

  if(MY_RANK==0)then
     call HistoryPut( 'HADVu', dmp_u_mbl, history=history )
     call HistoryPut( 'HADVv', dmp_v_mbl, history=history )
     call HistoryPut( 'VADVu', dmp_w_mbl, history=history )
  end if

  call mpi_gather_dmpuvw( IERROR, HDIFFu_dmp, HDIFFv_dmp, VADVv_dmp,  &
  &                       dmp_u_mbl, dmp_v_mbl, dmp_w_mbl )

  if(MY_RANK==0)then
     call HistoryPut( 'HDIFFu', dmp_u_mbl, history=history )
     call HistoryPut( 'HDIFFv', dmp_v_mbl, history=history )
     call HistoryPut( 'VADVv', dmp_w_mbl, history=history )
  end if

  call mpi_gather_dmpuvw( IERROR, VDIFFu_dmp, VDIFFv_dmp, CORILu_dmp,  &
  &                       dmp_u_mbl, dmp_v_mbl, dmp_w_mbl )

  if(MY_RANK==0)then
     call HistoryPut( 'VDIFFu', dmp_u_mbl, history=history )
     call HistoryPut( 'VDIFFv', dmp_v_mbl, history=history )
     call HistoryPut( 'CORILu', dmp_w_mbl, history=history )
  end if

  call mpi_gather_dmpuvw( IERROR, PGRADu_dmp, PGRADv_dmp, CORILv_dmp,  &
  &                       dmp_u_mbl, dmp_v_mbl, dmp_w_mbl )

  if(MY_RANK==0)then
     call HistoryPut( 'PGRADu', dmp_u_mbl, history=history )
     call HistoryPut( 'PGRADv', dmp_v_mbl, history=history )
     call HistoryPut( 'CORILv', dmp_w_mbl, history=history )
  end if

end subroutine output_2d


subroutine make_restart( itn, rtn, psik, uk_mbl, vk_mbl,  &
  &                      zk_nbm, nbm_opt, mbl_optu, mbl_optv )
!-- output restart file
  use savegloval_define

  use dc_string, only: toChar
  use dc_types, only: STRING, DP, TOKEN
  use dc_trace, only: SetDebug
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: DCDiffTimeCreate, operator(+), operator(*), mod, &
    & DCDiffTimePutLine, EvalNonDim, EvalSec
  use gtool_history, only: GT_HISTORY, HistoryCreate, HistoryAddVariable, &
    &                    HistoryClose, HistoryCopy, HistoryPut, &
    &                    HistorySetTime, HistoryAddAttr, HistoryPutLine, &
    &                    HistoryPutAxisMPI
  use dc_string, only: StoA, CPrintf
  use dc_message, only: MessageNotify
  use mpi
  implicit none
  integer, intent(in) :: itn
  real, intent(in) :: rtn
  complex(kind(0d0)), dimension(:,:,:), intent(in) :: uk_mbl
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), intent(in) :: psik
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), intent(in) :: vk_mbl
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), intent(in) :: zk_nbm
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), optional, intent(in) :: nbm_opt
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), optional, intent(in) :: mbl_optu
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), optional, intent(in) :: mbl_optv
  double precision, dimension(size(uk_mbl,1),size(uk_mbl,2)) :: tmpd
  double precision, dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)) :: tmp3d
  type(GT_HISTORY) :: res_hst
  integer :: ix, jy, kz, ii, jj, kk

  ix=size(uk_mbl,1)
  jy=size(uk_mbl,2)
  kz=size(uk_mbl,3)

  call HistoryCreate( file=trim(adjustl(resfname)),  &
  &    title='MBL_NBM result data', &
  &    source='Satoki Tsujino', institution='Hokudai', dims=(/'x', 'y', 'z'/),  &
  &    dimsizes=(/ ix, jy, kz /),  & 
  &    longnames=(/'X-coordinate','Y-coordinate','Z-coordinate'/),  &
  &    units=(/'m', 'm', 'm'/), flag_mpi_split=.true., history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(respsir)), dims=(/'x','y'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(respsii)), dims=(/'x','y'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(reszetar)), dims=(/'x','y'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(reszetai)), dims=(/'x','y'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resumblr)), dims=(/'x','y','z'/), &
  &                        longname='X-velocity in MBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resumbli)), dims=(/'x','y','z'/), &
  &                        longname='X-velocity in MBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resvmblr)), dims=(/'x','y','z'/), &
  &                        longname='Y-velocity in MBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resvmbli)), dims=(/'x','y','z'/), &
  &                        longname='Y-velocity in MBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &                        longname='X-coord double',  &
  &                        units='m', xtype='double', history=res_hst )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &                        longname='Y-coord double',  &
  &                        units='m', xtype='double', history=res_hst )

  if(present(nbm_opt))then
     call HistoryAddVariable( varname=trim(adjustl(res_nbm_optr)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_nbm_opti)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  if(present(mbl_optu))then
     call HistoryAddVariable( varname=trim(adjustl(res_mbl_optur)),  &
  &                           dims=(/'x','y','z'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_mbl_optui)),  &
  &                           dims=(/'x','y','z'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  if(present(mbl_optv))then
     call HistoryAddVariable( varname=trim(adjustl(res_mbl_optvr)),  &
  &                           dims=(/'x','y','z'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_mbl_optvi)),  &
  &                           dims=(/'x','y','z'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  !-- Trivial (not reuse)
  call HistoryPut( 'x', xd(1:ix), history=res_hst )
  call HistoryPut( 'y', yd(1:jy), history=res_hst )
  call HistoryPut( 'z', z_pe(0:nzp+1), history=res_hst )

  call HistoryAddAttr( trim(adjustl(respsir)), trim(adjustl(rest)),  &
  &                    rtn, history=res_hst )
  call HistoryAddAttr( trim(adjustl(respsir)), trim(adjustl(restn)),  &
  &                    real(itn), history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(psik(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(respsir)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(psik(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(respsii)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(zk_nbm(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(reszetar)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(zk_nbm(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(reszetai)), tmpd, history=res_hst )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           tmp3d(ii,jj,kk)=dble(uk_mbl(ii,jj,kk))
        end do
     end do
  end do

  call HistoryPut( trim(adjustl(resumblr)), tmp3d, history=res_hst )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           tmp3d(ii,jj,kk)=dimag(uk_mbl(ii,jj,kk))
        end do
     end do
  end do

  call HistoryPut( trim(adjustl(resumbli)), tmp3d, history=res_hst )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           tmp3d(ii,jj,kk)=dble(vk_mbl(ii,jj,kk))
        end do
     end do
  end do

  call HistoryPut( trim(adjustl(resvmblr)), tmp3d, history=res_hst )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           tmp3d(ii,jj,kk)=dimag(vk_mbl(ii,jj,kk))
        end do
     end do
  end do

  call HistoryPut( trim(adjustl(resvmbli)), tmp3d, history=res_hst )

  !-- Trivial (not reuse)
  call HistoryPut( 'xd', x(1:ix), history=res_hst )
  call HistoryPut( 'yd', y(1:jy), history=res_hst )

  if(present(nbm_opt))then

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dble(nbm_opt(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_nbm_optr)), tmpd, history=res_hst )

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dimag(nbm_opt(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_nbm_opti)), tmpd, history=res_hst )

  end if

  if(present(mbl_optu))then

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              tmp3d(ii,jj,kk)=dble(mbl_optu(ii,jj,kk))
           end do
        end do
     end do

     call HistoryPut( trim(adjustl(res_mbl_optur)), tmp3d, history=res_hst )

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              tmp3d(ii,jj,kk)=dimag(mbl_optu(ii,jj,kk))
           end do
        end do
     end do

     call HistoryPut( trim(adjustl(res_mbl_optui)), tmp3d, history=res_hst )

  end if

  if(present(mbl_optv))then

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              tmp3d(ii,jj,kk)=dble(mbl_optv(ii,jj,kk))
           end do
        end do
     end do

     call HistoryPut( trim(adjustl(res_mbl_optvr)), tmp3d, history=res_hst )

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              tmp3d(ii,jj,kk)=dimag(mbl_optv(ii,jj,kk))
           end do
        end do
     end do

     call HistoryPut( trim(adjustl(res_mbl_optvi)), tmp3d, history=res_hst )

  end if

  call HistoryClose( history=res_hst )

end subroutine make_restart


subroutine read_restart( filename, psik, zk_nbm, uk_mbl, vk_mbl,  &
  &                      nbm_opt, mbl_optu, mbl_optv )
!-- output restart file
  use savegloval_define

  use gtool_history
  use mpi
  implicit none
  character(*), intent(in) :: filename
  complex(kind(0d0)), dimension(:,:,:), intent(out) :: uk_mbl
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), intent(out) :: psik
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), intent(out) :: vk_mbl
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), intent(out) :: zk_nbm
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2)), optional, intent(out) :: nbm_opt
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), optional, intent(out) :: mbl_optu
  complex(kind(0d0)), dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)), optional, intent(out) :: mbl_optv
  double precision, dimension(size(uk_mbl,1),size(uk_mbl,2)) :: tmpr, tmpi
  double precision, dimension(size(uk_mbl,1),size(uk_mbl,2),size(uk_mbl,3)) :: tmp3r, tmp3i
  integer :: ix, jy, kz, ii, jj, kk
  complex(kind(0d0)) :: img_unit

  ix=size(uk_mbl,1)
  jy=size(uk_mbl,2)
  kz=size(uk_mbl,3)
  img_unit=(0.0d0,1.0d0)

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(respsir)), tmpr,  &
  &                flag_mpi_split=.true. )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(respsii)), tmpi,  &
  &                flag_mpi_split=.true. )

  do jj=1,jy
     do ii=1,ix
        psik(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(reszetar)), tmpr,  &
  &                flag_mpi_split=.true. )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(reszetai)), tmpi,  &
  &                flag_mpi_split=.true. )

  do jj=1,jy
     do ii=1,ix
        zk_nbm(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resumblr)), tmp3r,  &
  &                flag_mpi_split=.true. )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resumbli)), tmp3i,  &
  &                flag_mpi_split=.true. )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           uk_mbl(ii,jj,kk)=dble(tmp3r(ii,jj,kk))+img_unit*tmp3i(ii,jj,kk)
        end do
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resvmblr)), tmp3r,  &
  &                flag_mpi_split=.true. )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resvmbli)), tmp3i,  &
  &                flag_mpi_split=.true. )

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           vk_mbl(ii,jj,kk)=dble(tmp3r(ii,jj,kk))+img_unit*tmp3i(ii,jj,kk)
        end do
     end do
  end do

  if(present(nbm_opt))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_nbm_optr)), tmpr,  &
  &                flag_mpi_split=.true. )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_nbm_opti)), tmpi,  &
  &                flag_mpi_split=.true. )

     do jj=1,jy
        do ii=1,ix
           nbm_opt(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
        end do
     end do

  end if

  if(present(mbl_optu))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_mbl_optur)), tmp3r,  &
  &                flag_mpi_split=.true. )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_mbl_optui)), tmp3i,  &
  &                flag_mpi_split=.true. )

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              mbl_optu(ii,jj,kk)=dble(tmp3r(ii,jj,kk))+img_unit*tmp3i(ii,jj,kk)
           end do
        end do
     end do

  end if

  if(present(mbl_optv))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_mbl_optvr)), tmp3r,  &
  &                flag_mpi_split=.true. )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_mbl_optvi)), tmp3i,  &
  &                flag_mpi_split=.true. )

     do kk=1,kz
        do jj=1,jy
           do ii=1,ix
              mbl_optv(ii,jj,kk)=dble(tmp3r(ii,jj,kk))+img_unit*tmp3i(ii,jj,kk)
           end do
        end do
     end do

  end if

end subroutine read_restart

subroutine output_initialization( history )
!-- initialize the output file
  use savegloval_define
  use gtool_history
  implicit none
  integer :: i, subm
  integer :: access, status
  type(GT_HISTORY), intent(inout) :: history

  if(MY_RANK==0)then
  if(resopt==0)then
     call HistoryCreate( file=trim(adjustl(foname)),  &
  &       title='MBL-NBM result data', source='test',  &
  &       institution='test', dims=(/'x', 'y', 'z', 't'/),  &
  &       dimsizes=(/ nx, ny, nz, 0 /),  & 
  &       longnames=(/'X-coordinate', 'Y-coordinate',  &
  &                   'Z-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 'm', 's'/), origin=0.0,  &
  &       interval=real(dmpstp)*real(dt), history=history )

  else if(resopt==1)then

     do i=1,subn
        status=access( 'swap'//trim(adjustl(subhead(i)))//'.'//  &
  &                    trim(adjustl(foname)), ' ' )
        if(status/=0)then
           subm=i
           exit
        end if
     end do

     call HistoryCreate( file='swap'//trim(adjustl(subhead(subm)))//'.'//  &
  &                           trim(adjustl(foname)),  &
  &       title='MBL-NBM result data', &
  &       source='test', institution='test', dims=(/'x', 'y', 'z', 't'/),  &
  &       dimsizes=(/ nx, ny, nz, 0 /),  & 
  &       longnames=(/'X-coordinate', 'Y-coordinate',  &
  &                   'Z-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 'm', 's'/), origin=restime,  &
  &       interval=real(dmpstp)*real(dt), history=history )
  
  end if

  call HistoryPut( 'x', xd, history=history )
  call HistoryPut( 'y', yd, history=history )
  call HistoryPut( 'z', zd, history=history )

  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='unbm', dims=(/'x','y','t'/), &
  &                        longname='X wind in NBM', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='vnbm', dims=(/'x','y','t'/), &
  &                        longname='Y wind in NBM', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='p', dims=(/'x','y','t'/), &
  &                        longname='pressure in NBM', units='Pa',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='umbl', dims=(/'x','y','z','t'/), &
  &                        longname='X wind in MBL', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='vmbl', dims=(/'x','y','z','t'/), &
  &                        longname='Y wind in MBL', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='wmbl', dims=(/'x','y','z','t'/), &
  &                        longname='Vertical velocity at the top of MBL', units='m s-1',  &
  &                        xtype='float', history=history )

!-- For debug
  call HistoryAddVariable( varname='HADVu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of horizontal advection',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='HADVv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of horizontal advection',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='VADVu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of vertical advection',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='VADVv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of vertical advection',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='HDIFFu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of horizontal diffusion',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='HDIFFv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of horizontal diffusion',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='VDIFFu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of vertical diffusion',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='VDIFFv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of vertical diffusion',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='CORILu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of Coriolis force',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='CORILv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of Coriolis force',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='PGRADu', dims=(/'x','y','z','t'/), &
  &                        longname='u component of pressure gradient',  &
  &                        units='s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='PGRADv', dims=(/'x','y','z','t'/), &
  &                        longname='v component of pressure gradient',  &
  &                        units='s-1', xtype='float', history=history )

  end if

end subroutine output_initialization


end module file_output
