program solver
! Nolan and Montgomery 2001 の浅水モデル
  use gtool_history
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use time_scheme

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, ct

!-- namelist の読み込み

  call read_name()

!-- allocating array

  call val_allocate()

!-- 初期値化 (2d データから 3 次元データへの拡張)

  do i=1,nr
     ub(i)=0.0
  end do
write(*,*) "starting initialization."
  call HistoryGet( trim(finame), 'vbar', vib )
  call HistoryGet( trim(finame), 'hbar', hib )
  call HistoryGet( trim(finame), 'r', ri )

!-- 格子点の再定義
  call val_coordinate()

!-- bar の半格子点への内挿
  call cont_interpolation( ri, rv, vib, vb )
  call cont_interpolation( ri, rs, hib, hb )

!-- レイリーダンピング設定
  epsu=0.0
  epsv=0.0
  epsh=0.0

  do i=1,nr
     if(rv(i)>=r_dmp)then
        epsu(i)=1.0
        epsv(i)=1.0
        epsh(i)=1.0
     end if
  end do

!-- 初期値作成

  do j=1,ntheta
     do i=1,nr
!        urp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        vrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        hrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
        urp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
        vrp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
        hrp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
     end do
  end do

  write(*,*) "normally pass the initialization."

!-- 出力ファイルの初期化
  call HistoryCreate( file=trim(foname), title='shallow result data', &
  & source='test', institution='test', dims=(/'r    ','theta', 't    '/),  &
  & dimsizes=(/nr,ntheta, 0/),  & 
  & longnames=(/'r-coordinate    ','theta-coordinate', 'time            '/),  &
  & units=(/'m  ', 'rad', 's  '/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'r', rs )
  call HistoryPut( 'theta', theta )
  
  call HistoryAddVariable( varname='up', dims=(/'r    ','theta','t    '/), &
    & longname='radial wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='vp', dims=(/'r    ','theta','t    '/), &
    & longname='tangential wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='hp', dims=(/'r    ','theta','t    '/), &
    & longname='geopotential height', units='m', xtype='float')

  write(*,*) "time integration start."

  !-- 出力等の処理 (初期値の出力)
  do j=1,ntheta
     do i=1,nr
        ucp_old(i,j)=urp_dmp(i,j)
        vcp_old(i,j)=vrp_dmp(i,j)
        hcp_old(i,j)=hrp_dmp(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call HistoryPut( 'up', urp_dmp )
  call HistoryPut( 'vp', vrp_dmp )
  call HistoryPut( 'hp', hrp_dmp )

!$omp parallel default(shared)
!$omp do private(i)
  do i=1,nr
     call ffttp_1d( ntheta, ucp_old(i,:), ucp_new(i,:), 'r', prim='o' )
     call ffttp_1d( ntheta, vcp_old(i,:), vcp_new(i,:), 'r', prim='o' )
     call ffttp_1d( ntheta, hcp_old(i,:), hcp_new(i,:), 'r', prim='o' )
  end do
!$omp end do
!$omp end parallel

!-- solver スタート

  do it=1,nt

     call time_schematic( it )

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

!$omp parallel default(shared)
!$omp do private(i)
        do i=1,nr
           call ffttp_1d( ntheta, ucp_new(i,:), ucp_dmp(i,:), 'i', prim='o' )
           call ffttp_1d( ntheta, vcp_new(i,:), vcp_dmp(i,:), 'i', prim='o' )
           call ffttp_1d( ntheta, hcp_new(i,:), hcp_dmp(i,:), 'i', prim='o' )
           do j=1,ntheta
              urp_new(i,j)=real(ucp_dmp(i,j))
              vrp_new(i,j)=real(vcp_dmp(i,j))
              hrp_new(i,j)=real(hcp_dmp(i,j))
           end do
        end do
!$omp end do
!$omp end parallel

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'up', urp_new )
        call HistoryPut( 'vp', vrp_new )
        call HistoryPut( 'hp', hrp_new )

     end if

  end do

!-- solver ストップ

  write(*,*) "solver is normally."

contains

subroutine cont_interpolation( icor, ocor, ival, oval )
!-- 半格子点ずれた点への線形内挿を行う.
  use Statistics

  implicit none

  real, intent(in) :: icor(:)  ! 内挿前の座標
  real, intent(in) :: ocor(:)  ! 内挿後の座標
  real, intent(in) :: ival(size(icor))  ! icor で定義される変数
  real, intent(inout) :: oval(size(ocor))  ! ocor で定義される変数
  integer :: i, ni, no, tmpi

  ni=size(icor)
  no=size(ocor)

  do i=1,no
     call interpo_search_1d( icor, ocor(i), tmpi )
     call interpolation_1d( (/icor(tmpi), icor(tmpi+1)/),  &
  &                         (/ival(tmpi), ival(tmpi+1)/),  &
  &                         ocor(i), oval(i) )
  end do

end subroutine

end program
