module val_define
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new
!-- 配列および一貫変数は save 属性をつけて module を読み込んだときに値が
!  保存される仕様にする.

  implicit none

!-- parameter variables
  real, parameter :: rho0=1.225

!-- value definition
!-- integer, save part
  integer, save :: nri ! r 方向の配列個数初期データ
  integer, save :: nzi ! z 方向の配列個数初期データ
  integer, save :: nr  ! r 方向の配列個数
  integer, save :: nz  ! z 方向の配列個数
  integer, save :: nt  ! 時間ステップ
  integer, save :: dmpstp  ! ダンプ間隔

!-- real, save part
  real, save :: rmin            ! r 方向原点
  real, save :: zmin            ! z 方向原点
  real, save :: dr              ! r 方向格子間隔
  real, save :: dz              ! z 方向格子間隔
  real, save :: dtb             ! 時間間隔 (large)
  real, save :: dts             ! 時間間隔 (small)
  real, save :: coril           ! コリオリパラメータ
  real, save :: zsp             ! スポンジ層高度
  real, save :: SPG_coe         ! スポンジ層の最大時定数 [1/s]
  real, save :: tau_R           ! レイリー放射冷却緩和時間 [s]
  real, save :: lo              ! スマゴリンスキー平均長さ [m]
  real, save :: fallv           ! 水物質の落下速度 [m/s]
  real, save :: qt_thres        ! 落下速度の有無の閾値 [kg/kg]
  real, save :: cg              ! open boundary の重力波速度 [m/s]
  real, save :: CD0             ! 運動量交換係数の切片
  real, save :: rimin           ! r 方向原点初期値
  real, save :: zimin           ! z 方向原点初期値
  real, save :: dri             ! r 方向格子間隔初期値
  real, save :: dzi             ! z 方向格子間隔初期値
  real, save :: sst             ! SST 初期値データ
  real, save :: undef           ! サウンディングデータの未定義値.
  real, save :: zlim            ! 接線風速の到達高度 [m].
  real, save :: vvmax           ! 接線風速の最大値 [m/s].
  real, save :: rvmax           ! RMW [m].
  real, save :: Ts              ! surface temperature [K].
  real, save :: alpha           ! Coefficient for damping acoustic mode.
  real, save :: beta            ! Coefficient for CN-scheme. (0.0<beta<=1.0)
  real, save :: nunh            ! artifitial diffusion coefficient for horizon
  real, save :: nunv            ! artifitial diffusion coefficient for altitude

!-- 1d val
  real, save, dimension(4) :: sfact  ! サウンディングデータの各ファクター
                                     ! 1, 2, 3, 4 = z, p, t, q
  real, save, allocatable, dimension(:) :: r_i    ! 動径座標初期データ
  real, save, allocatable, dimension(:) :: z_i    ! 鉛直座標初期データ
  real, save, allocatable, dimension(:) :: sst_i  ! sst 初期データ
  real, save, allocatable, dimension(:) :: r_u    ! 動径座標 u 点
  real, save, allocatable, dimension(:) :: r_s    ! 動径座標 s 点
  real, save, allocatable, dimension(:) :: z_w    ! 鉛直座標 w 点
  real, save, allocatable, dimension(:) :: z_s    ! 鉛直座標 s 点
  real, save, allocatable, dimension(:) :: sst_u  ! sst u
  real, save, allocatable, dimension(:) :: sst_s  ! sst s
  real, save, allocatable, dimension(:) :: pts    ! 海面温位
  real, save, allocatable, dimension(:) :: qvs    ! 海面飽和水蒸気混合比
  real, save, allocatable, dimension(:) :: ps    ! 海面気圧
  real, save, allocatable, dimension(:) :: us_dmp   ! surface 動径風速 dmp
  real, save, allocatable, dimension(:) :: vs_dmp   ! surface 接線風速 dmp
  real, save, allocatable, dimension(:) :: ws_dmp   ! surface 鉛直風速 dmp
  real, save, allocatable, dimension(:) :: ps_dmp   ! surface 圧力 dmp
  real, save, allocatable, dimension(:) :: ts_dmp   ! surface 温位 dmp
  real, save, allocatable, dimension(:) :: qvs_dmp  ! surface 水蒸気 dmp
  real, save, allocatable, dimension(:) :: qcs_dmp  ! surface 凝結水 dmp
  real, save, allocatable, dimension(:) :: qls_dmp  ! surface 凝結水 dmp
  real, save, allocatable, dimension(:) :: qts_dmp  ! surface 凝結水 dmp
  real, save, allocatable, dimension(:) :: Tsurf    ! surface temp.

!-- 2d val (prognostic value)
  real, save, allocatable, dimension(:,:) :: u_dmp   ! 動径風速 dmp
  real, save, allocatable, dimension(:,:) :: v_dmp   ! 接線風速 dmp
  real, save, allocatable, dimension(:,:) :: w_dmp   ! 鉛直風速 dmp
  real, save, allocatable, dimension(:,:) :: p_dmp   ! 圧力 dmp
  real, save, allocatable, dimension(:,:) :: t_dmp   ! 温位 dmp
  real, save, allocatable, dimension(:,:) :: qv_dmp  ! 水蒸気 dmp
  real, save, allocatable, dimension(:,:) :: qc_dmp  ! 凝結水 dmp
  real, save, allocatable, dimension(:,:) :: ql_dmp  ! 凝結水 dmp
  real, save, allocatable, dimension(:,:) :: u_old   ! 動径風速 old
  real, save, allocatable, dimension(:,:) :: v_old   ! 接線風速 old
  real, save, allocatable, dimension(:,:) :: w_old   ! 鉛直風速 old
  real, save, allocatable, dimension(:,:) :: p_old   ! 規格化圧力 old
  real, save, allocatable, dimension(:,:) :: t_old   ! 温位 old
  real, save, allocatable, dimension(:,:) :: qv_old  ! 水蒸気 old
  real, save, allocatable, dimension(:,:) :: qc_old  ! 凝結水 old
  real, save, allocatable, dimension(:,:) :: ql_old  ! 凝結水 old
  real, save, allocatable, dimension(:,:) :: u_new   ! 動径風速 new
  real, save, allocatable, dimension(:,:) :: v_new   ! 接線風速 new
  real, save, allocatable, dimension(:,:) :: w_new   ! 鉛直風速 new
  real, save, allocatable, dimension(:,:) :: p_new   ! 規格化圧力 new
  real, save, allocatable, dimension(:,:) :: t_new   ! 温位 new
  real, save, allocatable, dimension(:,:) :: qv_new  ! 水蒸気 new
  real, save, allocatable, dimension(:,:) :: qc_new  ! 凝結水 new
  real, save, allocatable, dimension(:,:) :: ql_new  ! 凝結水 new
  real, save, allocatable, dimension(:,:) :: u_tmp   ! 動径風速 tmp
  real, save, allocatable, dimension(:,:) :: v_tmp   ! 接線風速 tmp
  real, save, allocatable, dimension(:,:) :: w_tmp   ! 鉛直風速 tmp
  real, save, allocatable, dimension(:,:) :: p_tmp   ! 規格化圧力 tmp
  real, save, allocatable, dimension(:,:) :: t_tmp   ! 温位 tmp
  real, save, allocatable, dimension(:,:) :: qv_tmp  ! 水蒸気 tmp
  real, save, allocatable, dimension(:,:) :: qc_tmp  ! 凝結水 tmp
  real, save, allocatable, dimension(:,:) :: ql_tmp  ! 凝結水 tmp

!-- 2d val (working value)
  real, save, allocatable, dimension(:,:) :: u_u   ! 動径風速 u
  real, save, allocatable, dimension(:,:) :: v_u   ! 接線風速 u
  real, save, allocatable, dimension(:,:) :: w_u   ! 鉛直風速 u
  real, save, allocatable, dimension(:,:) :: p_u   ! 規格化圧力 u
  real, save, allocatable, dimension(:,:) :: t_u   ! 温位 u
  real, save, allocatable, dimension(:,:) :: qv_u  ! 水蒸気 u
  real, save, allocatable, dimension(:,:) :: qc_u  ! 凝結水 u
  real, save, allocatable, dimension(:,:) :: ql_u  ! 凝結水 u
  real, save, allocatable, dimension(:,:) :: u_s   ! 動径風速 s
  real, save, allocatable, dimension(:,:) :: v_s   ! 接線風速 s
  real, save, allocatable, dimension(:,:) :: w_s   ! 鉛直風速 s
  real, save, allocatable, dimension(:,:) :: p_s   ! 規格化圧力 s
  real, save, allocatable, dimension(:,:) :: t_s   ! 温位 s
  real, save, allocatable, dimension(:,:) :: qv_s  ! 水蒸気 s
  real, save, allocatable, dimension(:,:) :: qc_s  ! 凝結水 s
  real, save, allocatable, dimension(:,:) :: ql_s  ! 凝結水 s
  real, save, allocatable, dimension(:,:) :: u_w   ! 動径風速 w
  real, save, allocatable, dimension(:,:) :: v_w   ! 接線風速 w
  real, save, allocatable, dimension(:,:) :: w_w   ! 鉛直風速 w
  real, save, allocatable, dimension(:,:) :: p_w   ! 規格化圧力 w
  real, save, allocatable, dimension(:,:) :: t_w   ! 温位 w
  real, save, allocatable, dimension(:,:) :: qv_w  ! 水蒸気 w
  real, save, allocatable, dimension(:,:) :: qc_w  ! 凝結水 w
  real, save, allocatable, dimension(:,:) :: ql_w  ! 凝結水 w
  real, save, allocatable, dimension(:,:) :: u_c   ! 動径風速 c
  real, save, allocatable, dimension(:,:) :: v_c   ! 接線風速 c
  real, save, allocatable, dimension(:,:) :: w_c   ! 鉛直風速 c
  real, save, allocatable, dimension(:,:) :: p_c   ! 規格化圧力 c
  real, save, allocatable, dimension(:,:) :: t_c   ! 温位 c
  real, save, allocatable, dimension(:,:) :: qv_c  ! 水蒸気 c
  real, save, allocatable, dimension(:,:) :: qc_c  ! 凝結水 c
  real, save, allocatable, dimension(:,:) :: ql_c  ! 凝結水 c

!-- 2d val (diagnostic value)
  real, save, allocatable, dimension(:,:) :: ub_u     ! 動径初期風速 u
  real, save, allocatable, dimension(:,:) :: vb_s     ! 接線初期風速 s
  real, save, allocatable, dimension(:,:) :: wb_w     ! 鉛直初期風速 w
  real, save, allocatable, dimension(:,:) :: pb_s     ! 圧力初期 s
  real, save, allocatable, dimension(:,:) :: ptb_u    ! 温位初期 u
  real, save, allocatable, dimension(:,:) :: ptb_s    ! 温位初期 s
  real, save, allocatable, dimension(:,:) :: ptb_w    ! 温位初期 w
  real, save, allocatable, dimension(:,:) :: pti_u    ! 温位初期 u for BUOY
  real, save, allocatable, dimension(:,:) :: pti_s    ! 温位初期 s for BUOY
  real, save, allocatable, dimension(:,:) :: pti_w    ! 温位初期 w for BUOY
  real, save, allocatable, dimension(:,:) :: qvb_u    ! 水蒸気混合比初期 u
  real, save, allocatable, dimension(:,:) :: qvb_s    ! 水蒸気混合比初期 s
  real, save, allocatable, dimension(:,:) :: qvb_w    ! 水蒸気混合比初期 w
  real, save, allocatable, dimension(:,:) :: qtb_s    ! 凝結水混合比初期 s
  real, save, allocatable, dimension(:,:) :: ptv_u    ! 仮温位 u
  real, save, allocatable, dimension(:,:) :: ptv_s    ! 仮温位 s
  real, save, allocatable, dimension(:,:) :: ptv_w    ! 仮温位 w
  real, save, allocatable, dimension(:,:) :: ptv_c    ! 仮温位 c
  real, save, allocatable, dimension(:,:) :: ptvb_s   ! 仮温位 s
  real, save, allocatable, dimension(:,:) :: ptvb_u   ! 仮温位 u
  real, save, allocatable, dimension(:,:) :: ptvb_w   ! 仮温位 w
  real, save, allocatable, dimension(:,:) :: pte_u    ! 相当温位 u
  real, save, allocatable, dimension(:,:) :: pte_s    ! 相当温位 s
  real, save, allocatable, dimension(:,:) :: pte_w    ! 相当温位 w
  real, save, allocatable, dimension(:,:) :: pte_c    ! 相当温位 c
  real, save, allocatable, dimension(:,:) :: rhob_u   ! 密度 u
  real, save, allocatable, dimension(:,:) :: rhob_s   ! 密度 s
  real, save, allocatable, dimension(:,:) :: rhob_w   ! 密度 w
  real, save, allocatable, dimension(:,:) :: temp_u   ! 温度 u
  real, save, allocatable, dimension(:,:) :: temp_s   ! 温度 s
  real, save, allocatable, dimension(:,:) :: temp_w   ! 温度 w
  real, save, allocatable, dimension(:,:) :: temp_c   ! 温度 c
  real, save, allocatable, dimension(:,:) :: tempb_s  ! 温度
  real, save, allocatable, dimension(:,:) :: tempb_w  ! 温度
  real, save, allocatable, dimension(:,:) :: u_i      ! 動径初期速度初期データ
  real, save, allocatable, dimension(:,:) :: v_i      ! 接線初期速度初期データ
  real, save, allocatable, dimension(:,:) :: w_i      ! 鉛直初期速度初期データ
  real, save, allocatable, dimension(:,:) :: p_i      ! 圧力初期データ
  real, save, allocatable, dimension(:,:) :: t_i      ! 温位初期データ
  real, save, allocatable, dimension(:,:) :: qv_i     ! 水蒸気初期データ
  real, save, allocatable, dimension(:,:) :: qc_i     ! 凝結物初期データ
  real, save, allocatable, dimension(:,:) :: ql_i     ! 凝結物初期データ

!-- 2d val (force term)
  real, save, allocatable, dimension(:,:) :: force_u   ! u forcing term
  real, save, allocatable, dimension(:,:) :: force_v   ! v forcing term
  real, save, allocatable, dimension(:,:) :: force_w   ! w forcing term
  real, save, allocatable, dimension(:,:) :: force_p   ! p forcing term
  real, save, allocatable, dimension(:,:) :: force_t   ! t forcing term
  real, save, allocatable, dimension(:,:) :: force_qv  ! qv forcing term
  real, save, allocatable, dimension(:,:) :: force_qc  ! qt forcing term
  real, save, allocatable, dimension(:,:) :: force_ql  ! qt forcing term
  real, save, allocatable, dimension(:,:) :: forcea_u  ! u forcing term
  real, save, allocatable, dimension(:,:) :: forcea_v  ! v forcing term
  real, save, allocatable, dimension(:,:) :: forcea_w  ! w forcing term
  real, save, allocatable, dimension(:,:) :: forcea_p  ! p forcing term
  real, save, allocatable, dimension(:,:) :: forcea_t  ! t forcing term
  real, save, allocatable, dimension(:,:) :: forcea_qv ! qv forcing term
  real, save, allocatable, dimension(:,:) :: forcea_qc ! qt forcing term
  real, save, allocatable, dimension(:,:) :: forcea_ql ! qt forcing term
  real, save, allocatable, dimension(:,:) :: ADV_u     ! ADV u
  real, save, allocatable, dimension(:,:) :: ADV_v     ! ADV v
  real, save, allocatable, dimension(:,:) :: ADV_w     ! ADV w
  real, save, allocatable, dimension(:,:) :: ADV_t     ! ADV t
  real, save, allocatable, dimension(:,:) :: ADV_qv    ! ADV qv
  real, save, allocatable, dimension(:,:) :: ADV_qc    ! ADV qt
  real, save, allocatable, dimension(:,:) :: ADV_ql    ! ADV qt
  real, save, allocatable, dimension(:,:) :: DIFF_u    ! DIFF u
  real, save, allocatable, dimension(:,:) :: DIFF_v    ! DIFF v
  real, save, allocatable, dimension(:,:) :: DIFF_w    ! DIFF w
  real, save, allocatable, dimension(:,:) :: DIFF_t    ! DIFF t
  real, save, allocatable, dimension(:,:) :: DIFF_qv   ! DIFF qv
  real, save, allocatable, dimension(:,:) :: DIFF_qc   ! DIFF qt
  real, save, allocatable, dimension(:,:) :: DIFF_ql   ! DIFF qt
  real, save, allocatable, dimension(:,:) :: NUMD_u    ! NUMDIFF u
  real, save, allocatable, dimension(:,:) :: NUMD_v    ! NUMDIFF v
  real, save, allocatable, dimension(:,:) :: NUMD_w    ! NUMDIFF w
  real, save, allocatable, dimension(:,:) :: NUMD_t    ! NUMDIFF t
  real, save, allocatable, dimension(:,:) :: NUMD_qv   ! NUMDIFF qv
  real, save, allocatable, dimension(:,:) :: NUMD_qc   ! NUMDIFF qc
  real, save, allocatable, dimension(:,:) :: NUMD_ql   ! NUMDIFF ql
  real, save, allocatable, dimension(:,:) :: GRADP_u   ! GRADP u
  real, save, allocatable, dimension(:,:) :: GRADP_w   ! GRADP w
  real, save, allocatable, dimension(:,:) :: FLUX_s    ! FLUX s
  real, save, allocatable, dimension(:,:) :: SPG_u     ! sponge u
  real, save, allocatable, dimension(:,:) :: SPG_v     ! sponge v
  real, save, allocatable, dimension(:,:) :: SPG_w     ! sponge w
  real, save, allocatable, dimension(:,:) :: SPG_t     ! sponge t
  real, save, allocatable, dimension(:,:) :: SPG_qv    ! sponge qv
  real, save, allocatable, dimension(:,:) :: SPG_qc    ! sponge qt
  real, save, allocatable, dimension(:,:) :: SPG_ql    ! sponge qt
  real, save, allocatable, dimension(:,:) :: RAD_t     ! radiation t
  real, save, allocatable, dimension(:,:) :: BUOY_w    ! Buoyancy w
  real, save, allocatable, dimension(:,:) :: CLOUD_pt  ! Cloud physics pt
  real, save, allocatable, dimension(:,:) :: CLOUD_qv  ! Cloud physics qv
  real, save, allocatable, dimension(:,:) :: CLOUD_qc  ! Cloud physics qc
  real, save, allocatable, dimension(:,:) :: CLOUD_ql  ! Cloud physics ql
  real, save, allocatable, dimension(:,:) :: CC_u      ! Cori + Centri u
  real, save, allocatable, dimension(:,:) :: CC_v      ! Cori + Centri v

!-- character part
  character(80), save :: finame  ! 初期値ファイル名
  character(80), save :: sname   ! 初期値参照用サウンディングファイル名
  character(80), save :: foname  ! 結果値ファイル名
  character(1), save :: time_flag  ! 時間スキームに関するフラグ
  character(4), save :: rord     ! サウンディングファイルの格納順序

end module
