module mpi_mod

  use mpi

contains

subroutine mpi_initial( IERROR )
! MPI プロセスの初期化
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR

!-- Initializing MPI

  call MPI_INIT( IERROR )

!-- Getting total process number and oneself process ID.

  call MPI_COMM_RANK( MPI_COMM_WORLD, MY_RANK, IERROR )
  call MPI_COMM_SIZE( MPI_COMM_WORLD, PETOT, IERROR )

end subroutine mpi_initial


subroutine mpi_shared( IERROR )
! namelist ファイルで読み込んだ変数を Broadcasting
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

  !-- &basic
  call MPI_BCAST( npe, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( nx, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( ny, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( nz, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( jxnt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( jynt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( hxnt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( hynt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( nt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( Lx, 1, MPI_DOUBLE_PRECISION,  0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( Ly, 1, MPI_DOUBLE_PRECISION,  0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( dt, 1, MPI_DOUBLE_PRECISION,  0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( dmpstp, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( time_flag(1:3), 3, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( foname(1:1000), 1000, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )

  !-- &param_nbm
  call MPI_BCAST( calc_nbm_flag, 1, MPI_LOGICAL, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( nu, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( flag_fric, 1, MPI_LOGICAL, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( mu, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( flag_stretch, 1, MPI_LOGICAL, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( force_type, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( sth_fname(1:1000), 1000, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( zetam, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( flag_sthmod, 1, MPI_LOGICAL, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( sth_thres_zeta, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( cent_lat, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( rho0, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )

  !-- &param_mbl
  call MPI_BCAST( calc_mbl_flag,   1, MPI_LOGICAL, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( z_mbl, nzlim, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( KH_mbl, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( K_mbl, 1, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( ndiff_mbl, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( smt_mbl_opt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )

  !-- &input
  call MPI_BCAST( nxi, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( nyi, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( ininame(1:1000), 1000, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( inix(1:100), 100, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( iniy(1:100), 100, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( iniz(1:100), 100, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( inixd(1:100), 100, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( iniyd(1:100), 100, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( i_adj, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )

  !-- &restart
  call MPI_BCAST( resopt, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( resfname(1:1000), 1000, MPI_CHARACTER, 0, MPI_COMM_WORLD, IERROR )
  call MPI_BCAST( restp, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, IERROR )

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

end subroutine mpi_shared


subroutine mpi_gather_w( IERROR, wk_mbl, wk_mbl_tot )
! uk, vk を gather.
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  complex(kind(0d0)), dimension(kxnt,kynt,0:nzp+1), intent(in) :: wk_mbl    ! wk for MBL
  complex(kind(0d0)), dimension(kxnt,kynt,nz), intent(inout) :: wk_mbl_tot
!ORG  complex(kind(0d0)), dimension(kxnt*kynt*nzp) :: tmp_wk
!ORG  complex(kind(0d0)), dimension(kxnt*kynt*nz) :: tmp_wk_tot
  integer :: n_mpi_tot, icounter, ii, jj, kk

  n_mpi_tot=kxnt*kynt*nzp
  icounter=1

!ORG  do kk=1,nzp
!ORG  do jj=1,kynt
!ORG  do ii=1,kxnt
!ORG     tmp_wk(icounter)=wk_mbl(ii,jj,kk)
!ORG     icounter=icounter+1
!ORG  end do
!ORG  end do
!ORG  end do

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

!ORG  call MPI_GATHER( tmp_wk(1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
!ORG  &                tmp_wk_tot(1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  call MPI_GATHER( wk_mbl(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                wk_mbl_tot(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                0, MPI_COMM_WORLD, IERROR )

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

!ORG  if(MY_RANK==0)then
!ORG
!ORG     icounter=1
!ORG
!ORG     do kk=1,nz
!ORG     do jj=1,kynt
!ORG     do ii=1,kxnt
!ORG        wk_mbl_tot(ii,jj,kk)=tmp_wk_tot(icounter)
!ORG        icounter=icounter+1
!ORG     end do
!ORG     end do
!ORG     end do
!ORG
!ORG  end if

end subroutine mpi_gather_w


subroutine mpi_scatter_w( IERROR, wk_mbl_tot, wk_mbl )
! uk, vk を scatter.
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  complex(kind(0d0)), dimension(kxnt,kynt,nz), intent(in) :: wk_mbl_tot
  complex(kind(0d0)), dimension(kxnt,kynt,0:nzp+1), intent(inout) :: wk_mbl
!ORG  complex(kind(0d0)), dimension(kxnt*kynt*nzp) :: tmp_wk
!ORG  complex(kind(0d0)), dimension(kxnt*kynt*nz) :: tmp_wk_tot
  integer :: n_mpi_tot, icounter, ii, jj, kk

  n_mpi_tot=kxnt*kynt*nzp

!ORG  if(MY_RANK==0)then
!ORG
!ORG     icounter=1
!ORG
!ORG     do kk=1,nz
!ORG     do jj=1,kynt
!ORG     do ii=1,kxnt
!ORG        tmp_wk_tot(icounter)=wk_mbl_tot(ii,jj,kk)
!ORG        icounter=icounter+1
!ORG     end do
!ORG     end do
!ORG     end do
!ORG
!ORG  end if

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )
!  call MPI_SCATTER( wk_mbl_tot(1,1,nzp*MY_RANK+1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  call MPI_SCATTER( wk_mbl_tot(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                 wk_mbl(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
!ORG  call MPI_SCATTER( tmp_wk_tot(1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
!ORG  &                 tmp_wk(1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                 0, MPI_COMM_WORLD, IERROR )
  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

  icounter=1

!ORG  do kk=1,nzp
!ORG  do jj=1,kynt
!ORG  do ii=1,kxnt
!ORG     wk_mbl(ii,jj,kk)=tmp_wk(icounter)
!ORG     icounter=icounter+1
!ORG  end do
!ORG  end do
!ORG  end do

end subroutine mpi_scatter_w


subroutine mpi_sendrecv_vald( IERROR, ioval1, ioval2 )
! ioval の上下端を 1 層上下の ioval へ転送
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  double precision, dimension(:,:,:), intent(inout) :: ioval1
  double precision, dimension(size(ioval1,1),size(ioval1,2),size(ioval1,3)), intent(inout) :: ioval2
  integer :: n_mpi_tot, ix, jy, kz
  integer :: ireqsl(2), ireqsu(2), ireqrl(2), ireqru(2)
  integer, dimension(MPI_STATUS_SIZE) :: mpi_stat
!-- ** ioval の 3 次元目は kz = nzp+2 であることに注意. **
!-- 渡す前の引数の 3 次元目は k==1 が ioval(:,:,2), 
!-- k==nzp が ioval(:,:,kz-1) に対応する. 

  ix=size(ioval1,1)
  jy=size(ioval1,2)
  kz=size(ioval1,3)
  n_mpi_tot=ix*jy

  !-- 層 L の下端 (k==1) を層 L-1 の上端 (k==nzp+1) へ送信
  if(MY_RANK/=0)then  ! MY_RANK==0 はモデル下端
     call MPI_ISEND( ioval1(1,1,2), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK-1, MY_RANK, MPI_COMM_WORLD, ireqsl(1), IERROR )
     call MPI_ISEND( ioval2(1,1,2), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK-1, MY_RANK, MPI_COMM_WORLD, ireqsl(2), IERROR )
  end if
  !-- 層 L の上端 (k==nzp) を層 L+1 の下端 (k==1) へ送信
  if(MY_RANK/=PETOT-1)then  ! MY_RANK==PETOT-1 はモデル上端
     call MPI_ISEND( ioval1(1,1,kz-1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK+1, MY_RANK, MPI_COMM_WORLD, ireqsu(1), IERROR )
     call MPI_ISEND( ioval2(1,1,kz-1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK+1, MY_RANK, MPI_COMM_WORLD, ireqsu(2), IERROR )
  end if
  if(MY_RANK/=PETOT-1)then  ! MY_RANK==PETOT-1 はモデル上端
     call MPI_IRECV( ioval1(1,1,kz), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK+1, MY_RANK+1, MPI_COMM_WORLD, ireqrl(1), IERROR )
     call MPI_IRECV( ioval2(1,1,kz), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK+1, MY_RANK+1, MPI_COMM_WORLD, ireqrl(2), IERROR )
  end if
  if(MY_RANK/=0)then  ! MY_RANK==0 はモデル下端
     call MPI_IRECV( ioval1(1,1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK-1, MY_RANK-1, MPI_COMM_WORLD, ireqru(1), IERROR )
     call MPI_IRECV( ioval2(1,1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  MY_RANK-1, MY_RANK-1, MPI_COMM_WORLD, ireqru(2), IERROR )
  end if

  if(MY_RANK/=0)then
     call MPI_WAIT( ireqsl(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqsl(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=PETOT-1)then
     call MPI_WAIT( ireqsu(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqsu(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=PETOT-1)then
     call MPI_WAIT( ireqrl(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqrl(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=0)then
     call MPI_WAIT( ireqru(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqru(2), mpi_stat, IERROR )
  end if

end subroutine mpi_sendrecv_vald


subroutine mpi_sendrecv_valcpd( IERROR, ioval1, ioval2 )
! ioval の上下端を 1 層上下の ioval へ転送
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  complex(kind(0d0)), dimension(:,:,:), intent(inout) :: ioval1
  complex(kind(0d0)), dimension(size(ioval1,1),size(ioval1,2),size(ioval1,3)), intent(inout) :: ioval2
  integer :: n_mpi_tot, ix, jy, kz
  integer :: ireqsl(2), ireqsu(2), ireqrl(2), ireqru(2)
  integer, dimension(MPI_STATUS_SIZE) :: mpi_stat
!-- ** ioval の 3 次元目は kz = nzp+2 であることに注意. **
!-- 渡す前の引数の 3 次元目は k==1 が ioval(:,:,2), 
!-- k==nzp が ioval(:,:,kz-1) に対応する. 

  ix=size(ioval1,1)
  jy=size(ioval1,2)
  kz=size(ioval1,3)
  n_mpi_tot=ix*jy

  !-- 層 L の下端 (k==1) を層 L-1 の上端 (k==nzp+1) へ送信
  if(MY_RANK/=0)then  ! MY_RANK==0 はモデル下端
     call MPI_ISEND( ioval1(1,1,2), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK-1, MY_RANK, MPI_COMM_WORLD, ireqsl(1), IERROR )
     call MPI_ISEND( ioval2(1,1,2), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK-1, MY_RANK, MPI_COMM_WORLD, ireqsl(2), IERROR )
  end if
  !-- 層 L の上端 (k==nzp) を層 L+1 の下端 (k==1) へ送信
  if(MY_RANK/=PETOT-1)then  ! MY_RANK==PETOT-1 はモデル上端
     call MPI_ISEND( ioval1(1,1,kz-1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK+1, MY_RANK, MPI_COMM_WORLD, ireqsu(1), IERROR )
     call MPI_ISEND( ioval2(1,1,kz-1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK+1, MY_RANK, MPI_COMM_WORLD, ireqsu(2), IERROR )
  end if
  if(MY_RANK/=PETOT-1)then  ! MY_RANK==PETOT-1 はモデル上端
     call MPI_IRECV( ioval1(1,1,kz), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK+1, MY_RANK+1, MPI_COMM_WORLD, ireqrl(1), IERROR )
     call MPI_IRECV( ioval2(1,1,kz), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK+1, MY_RANK+1, MPI_COMM_WORLD, ireqrl(2), IERROR )
  end if
  if(MY_RANK/=0)then  ! MY_RANK==0 はモデル下端
     call MPI_IRECV( ioval1(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK-1, MY_RANK-1, MPI_COMM_WORLD, ireqru(1), IERROR )
     call MPI_IRECV( ioval2(1,1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  MY_RANK-1, MY_RANK-1, MPI_COMM_WORLD, ireqru(2), IERROR )
  end if

  if(MY_RANK/=0)then
     call MPI_WAIT( ireqsl(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqsl(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=PETOT-1)then
     call MPI_WAIT( ireqsu(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqsu(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=PETOT-1)then
     call MPI_WAIT( ireqrl(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqrl(2), mpi_stat, IERROR )
  end if
  if(MY_RANK/=0)then
     call MPI_WAIT( ireqru(1), mpi_stat, IERROR )
     call MPI_WAIT( ireqru(2), mpi_stat, IERROR )
  end if

end subroutine mpi_sendrecv_valcpd


subroutine mpi_sendrecvp2p_vald( IERROR, sendid, recvid, senval1, senval2,  &
  &                              recval1, recval2 )
! ioval の上下端を 1 層上下の ioval へ転送
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  integer, intent(in) :: sendid  ! 送信元の MY_RANK
  integer, intent(in) :: recvid  ! 受信側の MY_RANK
  double precision, dimension(:,:), intent(in) :: senval1
  double precision, dimension(size(senval1,1),size(senval1,2)), intent(in) :: senval2
  double precision, dimension(size(senval1,1),size(senval1,2)), intent(inout) :: recval1
  double precision, dimension(size(senval1,1),size(senval1,2)), intent(inout) :: recval2
  integer :: n_mpi_tot, ix, jy, ireqs1, ireqs2, ireqr1, ireqr2
  integer, dimension(MPI_STATUS_SIZE) :: mpi_stat
!-- ** ioval の 3 次元目は kz = nzp+2 であることに注意. **
!-- 渡す前の引数の 3 次元目は k==1 が ioval(:,:,2), 
!-- k==nzp が ioval(:,:,kz-1) に対応する. 

  ix=size(senval1,1)
  jy=size(senval1,2)
  n_mpi_tot=ix*jy

  if(MY_RANK==sendid)then  ! 送信側 (dest には送信先=受信側のランクが必要)
     call MPI_ISEND( senval1(1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  recvid, sendid, MPI_COMM_WORLD, ireqs1, IERROR )
     call MPI_ISEND( senval2(1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  recvid, sendid, MPI_COMM_WORLD, ireqs2, IERROR )
  end if
  if(MY_RANK==recvid)then  ! 受信側 (source には送信元のランクが必要)
     call MPI_IRECV( recval1(1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  sendid, sendid, MPI_COMM_WORLD, ireqr1, IERROR )
     call MPI_IRECV( recval2(1,1), n_mpi_tot, MPI_DOUBLE_PRECISION,  &
  &                  sendid, sendid, MPI_COMM_WORLD, ireqr2, IERROR )
  end if

  if(MY_RANK==sendid)then  ! 送信側
     call MPI_WAIT( ireqs1, mpi_stat, IERROR )
     call MPI_WAIT( ireqs2, mpi_stat, IERROR )
  end if
  if(MY_RANK==recvid)then  ! 受信側
     call MPI_WAIT( ireqr1, mpi_stat, IERROR )
     call MPI_WAIT( ireqr2, mpi_stat, IERROR )
  end if

end subroutine mpi_sendrecvp2p_vald


subroutine mpi_sendrecvp2p_valcpd( IERROR, sendid, recvid, senval1, senval2,  &
  &                                recval1, recval2 )
! ioval の上下端を 1 層上下の ioval へ転送
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  integer, intent(in) :: sendid  ! 送信元の MY_RANK
  integer, intent(in) :: recvid  ! 受信側の MY_RANK
  complex(kind(0d0)), dimension(:,:), intent(in) :: senval1
  complex(kind(0d0)), dimension(size(senval1,1),size(senval1,2)), intent(in) :: senval2
  complex(kind(0d0)), dimension(size(senval1,1),size(senval1,2)), intent(inout) :: recval1
  complex(kind(0d0)), dimension(size(senval1,1),size(senval1,2)), intent(inout) :: recval2
  integer :: n_mpi_tot, ix, jy, ireqs1, ireqs2, ireqr1, ireqr2
  integer, dimension(MPI_STATUS_SIZE) :: mpi_stat
!-- ** ioval の 3 次元目は kz = nzp+2 であることに注意. **
!-- 渡す前の引数の 3 次元目は k==1 が ioval(:,:,2), 
!-- k==nzp が ioval(:,:,kz-1) に対応する. 

  ix=size(senval1,1)
  jy=size(senval1,2)
  n_mpi_tot=ix*jy

  if(MY_RANK==sendid)then  ! 送信側 (dest には送信先=受信側のランクが必要)
     call MPI_ISEND( senval1(1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  recvid, sendid, MPI_COMM_WORLD, ireqs1, IERROR )
     call MPI_ISEND( senval2(1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  recvid, sendid, MPI_COMM_WORLD, ireqs2, IERROR )
  end if
  if(MY_RANK==recvid)then  ! 受信側 (source には送信元のランクが必要)
     call MPI_IRECV( recval1(1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  sendid, sendid, MPI_COMM_WORLD, ireqr1, IERROR )
     call MPI_IRECV( recval2(1,1), n_mpi_tot, MPI_DOUBLE_COMPLEX,  &
  &                  sendid, sendid, MPI_COMM_WORLD, ireqr2, IERROR )
  end if

  if(MY_RANK==sendid)then  ! 送信側
     call MPI_WAIT( ireqs1, mpi_stat, IERROR )
     call MPI_WAIT( ireqs2, mpi_stat, IERROR )
  end if
  if(MY_RANK==recvid)then  ! 受信側
     call MPI_WAIT( ireqr1, mpi_stat, IERROR )
     call MPI_WAIT( ireqr2, mpi_stat, IERROR )
  end if

end subroutine mpi_sendrecvp2p_valcpd


subroutine mpi_gather_dmpuvw( IERROR, u_mbl, v_mbl, w_mbl,  &
  &                           u_mbl_tot, v_mbl_tot, w_mbl_tot )
! uk, vk を gather.
  use mpi
  use savegloval_define
  implicit none
  integer, intent(inout) :: IERROR
  real, dimension(nx,ny,0:nzp+1), intent(in) :: u_mbl
  real, dimension(nx,ny,0:nzp+1), intent(in) :: v_mbl
  real, dimension(nx,ny,0:nzp+1), intent(in) :: w_mbl
  real, dimension(nx,ny,nz), intent(inout) :: u_mbl_tot
  real, dimension(nx,ny,nz), intent(inout) :: v_mbl_tot
  real, dimension(nx,ny,nz), intent(inout) :: w_mbl_tot
  integer :: n_mpi_tot

  n_mpi_tot=nx*ny*nzp

  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )
  call MPI_GATHER( u_mbl(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                u_mbl_tot(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                0, MPI_COMM_WORLD, IERROR )
  call MPI_GATHER( v_mbl(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                v_mbl_tot(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                0, MPI_COMM_WORLD, IERROR )
  call MPI_GATHER( w_mbl(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                w_mbl_tot(1,1,1), n_mpi_tot, MPI_REAL,  &
  &                0, MPI_COMM_WORLD, IERROR )
  call MPI_BARRIER( MPI_COMM_WORLD, IERROR )

end subroutine mpi_gather_dmpuvw


subroutine mpi_outstd( cha )
  use mpi
  use savegloval_define
  use basis
  implicit none
  character(*), intent(in) :: cha
  character(10) :: forma

  forma='(a'//trim(adjustl(i2c_convert(len_trim(cha))))//')'

  if(MY_RANK==0)then
     write(*,trim(adjustl(forma))) trim(adjustl(cha))
  end if

end subroutine mpi_outstd

end module mpi_mod
