module read_namelist

  use savegloval_define

  implicit none

  namelist /basic /npe, nx, ny, nz, jxnt, jynt, hxnt, hynt,  &
  &                nt, Lx, Ly, dt, dmpstp, time_flag, foname
  namelist /param_nbm /calc_nbm_flag, nu, flag_fric, mu,  &
  &                    flag_stretch, force_type, sth_fname, sth_vname, zetam,  &
  &                    flag_sthmod, sth_thres_zeta, cent_lat, rho0
  namelist /param_mbl /calc_mbl_flag, z_mbl, KH_mbl, K_mbl, ndiff_mbl, smt_mbl_opt
  namelist /input /nxi, nyi, ininame, inix, iniy, iniz, inixd, iniyd, i_adj
  namelist /restart /resopt, resfname, restp

contains


subroutine read_name_post()

  use savegloval_define

  read(5,nml=basic)
  read(5,nml=param_nbm)
  read(5,nml=param_mbl)
  read(5,nml=input)
  read(5,nml=restart)

end subroutine read_name_post


subroutine read_name_shared_post()

  use savegloval_define

  kxnt=2*hxnt+1
  kynt=2*hynt+1
  dx=Lx/dble(nx-1)
  dy=Ly/dble(ny-1)
  xmin=0.0d0
  ymin=0.0d0

  if(mod(nz,npe)/=0)then
     write(*,*) "*** ERROR (read_name) ***: mod(nz,npe) is not zero. stop"
     stop
  end if

  if(npe/=PETOT)then
     write(*,*) "*** ERROR (read_name) ***: npe is not identical to PETOT. stop"
     stop
  end if
  nzp=nz/npe

end subroutine read_name_shared_post

end module read_namelist
