module val_define_baro
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new
!-- 配列および一貫変数は save 属性をつけて module を読み込んだときに値が
!  保存される仕様にする.

  implicit none

!-- value definition
!-- integer, save part
  integer, save :: nx  ! x 方向の配列個数
  integer, save :: ny  ! y 方向の配列個数
  integer, save :: nt  ! 時間ステップ
  integer, save :: dmpstp  ! ダンプ間隔
  integer, save :: init_n  ! 初期の波数

!-- 2d integer
  integer, save, allocatable, dimension(:,:) :: ibp  ! 境界計算方式指定 (psi)
  integer, save, allocatable, dimension(:,:) :: ibo  ! 境界計算方式指定 (omg)

!-- 2d logical
  logical, save, allocatable, dimension(:,:) :: calc_flag  ! ポアソン計算するか

!-- real, save part
  real, save :: xmin  ! x 方向原点
  real, save :: ymin  ! y 方向原点
  real, save :: dx  ! x 方向格子間隔
  real, save :: dy  ! y 方向格子間隔
  real, save :: dt  ! 時間間隔
  real, save :: diff_r  ! 動径方向の拡散係数
  real, save :: diff_t  ! 接線方向の拡散係数
  real, save :: undef  ! 未計算領域の格子点に格納される値.
  real, save :: vbar  ! 平均流の値.
  real, save :: eps  ! ポアソン収束条件
  real, save :: nu  ! 粘性係数
  real, save :: d2r  ! degree to radian
  real, save :: r2d  ! radian to degree

!-- 1d val
  real, save, allocatable, dimension(:) :: x      ! ベクトル動径座標
  real, save, allocatable, dimension(:) :: y      ! 接線座標
  real, save, allocatable, dimension(:) :: x_inv  ! 1/x
  real, save, allocatable, dimension(:) :: x2_inv ! 1/x**2

!-- 2d val (prognostic value)
  real, save, allocatable, dimension(:,:) :: omega_dmp  ! 渦度 dmp
  real, save, allocatable, dimension(:,:) :: omega_old  ! 渦度 old
  real, save, allocatable, dimension(:,:) :: omega_new  ! 渦度 new
  real, save, allocatable, dimension(:,:) :: omega_tmp  ! 渦度 tmp

!-- 2d val (diagnostic value)
  real, save, allocatable, dimension(:,:) :: psi_dmp  ! 流線関数 dmp
  real, save, allocatable, dimension(:,:) :: psi_old  ! 流線関数 old
  real, save, allocatable, dimension(:,:) :: psi_new  ! 流線関数 new
  real, save, allocatable, dimension(:,:) :: psi_tmp  ! 流線関数 tmp
  real, save, allocatable, dimension(:,:) :: u_dmp  ! x 方向速度 dmp
  real, save, allocatable, dimension(:,:) :: v_dmp  ! y 方向速度 dmp

!-- 2d val (force term)
  real, save, allocatable, dimension(:,:) :: force_omega  ! omega forcing term
  real, save, allocatable, dimension(:,:) :: forcea_omega  ! omega forcing term
  real, save, allocatable, dimension(:,:) :: ADV
  real, save, allocatable, dimension(:,:) :: BETA
  real, save, allocatable, dimension(:,:) :: DIFF
  real, save, allocatable, dimension(:,:) :: dpdx
  real, save, allocatable, dimension(:,:) :: dpdy
  real, save, allocatable, dimension(:,:) :: dodx
  real, save, allocatable, dimension(:,:) :: dody
  real, save, allocatable, dimension(:,:) :: do2dx2
  real, save, allocatable, dimension(:,:) :: do2dy2
  real, save, allocatable, dimension(:,:) :: dp2dx2
  real, save, allocatable, dimension(:,:) :: dp2dy2
  real, save, allocatable, dimension(:,:) :: dpdoydx
  real, save, allocatable, dimension(:,:) :: dpdoxdy
  real, save, allocatable, dimension(:,:) :: dodpxdy
  real, save, allocatable, dimension(:,:) :: dodpydx
  real, save, allocatable, dimension(:,:) :: pdoy
  real, save, allocatable, dimension(:,:) :: pdox
  real, save, allocatable, dimension(:,:) :: odpx
  real, save, allocatable, dimension(:,:) :: odpy
  real, save, allocatable, dimension(:,:) :: pois_force
  real, save, allocatable, dimension(:,:) :: bndp  ! boundary condition value for psi
  real, save, allocatable, dimension(:,:) :: bndo  ! boundary condition value for omg
  real, save, allocatable, dimension(:,:) :: x_inv_2d  ! For 2d in x_inv
  real, save, allocatable, dimension(:,:) :: x2_inv_2d ! For 2d in x2_inv

!-- 3d val (force term)
  real, save, allocatable, dimension(:,:,:) :: AJ  ! Arakawa Jacobian

!-- character part
  character(80), save :: finame  ! 初期値ファイル名
  character(80), save :: foname  ! 結果値ファイル名
  character(80), save :: inner_file  ! 境界形状ファイル名
  character(1), save :: time_flag  ! 時間スキームに関するフラグ
  character(10), save :: force_flag  ! 強制項の各効果を入れるためのフラグ
  character(3), save :: init_type  ! 初期値データに入っている変数の種類
  character(4), save :: boundary  ! ポアソン用の 4 軸境界条件
  character(1), save, allocatable, dimension(:,:) :: cval  ! inner_bound ファイル読み込み用

end module val_define_baro
