program solver
! Weisman and Klemp 2004 の非圧縮重力流モデル
  use gtool_history
  use Derivation
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use time_scheme
  use make_init
  use sub_calc
  use force_solv

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, counter_psi

!-- テンポラリ実変数
  real :: mean_psi, chan_leng

!-- namelist の読み込み

  call read_name()

!-- allocating array

  call val_allocate()

!-- 格子点の再定義

  call val_coordinate()

!-- 初期値化 (計算領域の設定や境界条件の設定, 特にポアソン計算について)

write(*,*) "starting initialization."

!-- 初期条件データから読み込み

  call read_file_text( trim(inner_file), nx, ny, cval, skip=1,  &
  &                    forma='('//trim(adjustl(i2c_convert(nx)))//'a1)' )

!-- psi, omega に対して, 各境界条件フラグを設定.

  do j=1,ny
     do i=1,nx
        if(trim(adjustl(cval(i,j)))=='-')then
           ibo(i,j)=10
           ibp(i,j)=10
           calc_flag(i,j)=.false.
        else
           ibp(i,j)=c2i_convert( trim(adjustl(cval(i,j))) )
           ibo(i,j)=c2i_convert( trim(adjustl(cval(i,j))) )
           if(ibp(i,j)==0)then
              calc_flag(i,j)=.true.
           else
              calc_flag(i,j)=.false.
           end if
        end if
     end do
  end do

  boundary='1112'  ! psi はポアソンソルバに渡す分だけ作成.

  do j=1,ny
     ibo(1,j)=2
     ibo(nx,j)=-2
     ibb(1,j)=2
     ibb(nx,j)=-2
  end do

  do i=1,nx
     ibo(i,1)=4
     ibo(i,ny)=-4
     ibb(i,1)=4
     ibb(i,ny)=-4
  end do

!-- 初期値作成

  if(len_trim(finame)==0)then
     omega_old=0.0
     psi_old=0.0
     buoy_old=0.0
     chan_leng=y(ny)-y(1)

     do j=1,ny
        do i=1,nx
if(j<=ny/2)then
           psi_old(i,j)=ubar*(y(j)-0.5*chan_leng)
else
           psi_old(i,j)=(2.0*ubar/chan_leng)*(chan_leng*y(j)-0.5*y(j)**2)  &
  &                     -0.75*ubar*chan_leng
end if
if(y(j)<y(ny/2).and.abs(x(i))<1.0)then
           buoy_old(i,j)=-1.0
end if
!           omega_old(i,j)=exp(-((x(i)-0.5*(x(nx)-x(1)))**2+(y(j)-0.5*(y(ny)-y(1)))**2))
        end do
     end do

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              psi_old(i,j)=undef
              omega_old(i,j)=undef
              buoy_old(i,j)=undef
           end if
        end do
     end do
  else
     call make_initialize()
  end if

!-- 境界強制値の設定.

  bndp=0.0
  bndo=0.0
  bndb=0.0

  !-- 以下で境界値を設定しているが, フラックス量や固定強制量がゼロの場合は
  !   上で既に設定(初期化)しているので行わない.
  do j=1,ny
     bndp(1,j)=psi_old(1,j)
  end do

  do i=1,nx
     bndp(i,1)=bndp(1,1)
     bndp(i,ny)=bndp(1,ny)
  end do

!-- 内部境界での psi の値は境界廻りの psi の平均値を用いることにする.

  mean_psi=0.0
  counter_psi=0

  do j=2,ny-1
     do i=2,nx-1
        if(ibp(i,j)==1)then
           mean_psi=mean_psi+ubar*(y(j)-0.5*(y(ny)-y(1)))
           counter_psi=counter_psi+1
        end if
     end do
  end do

  if(counter_psi>0)then
     mean_psi=mean_psi/real(counter_psi)
  end if

  do j=2,ny-1
     do i=2,nx-1
        if(ibp(i,j)==1)then
           bndp(i,j)=mean_psi
           psi_old(i,j)=mean_psi
        end if
     end do
  end do

  call set_omega_inner( x, y, psi_old, ibo, bndo )
  call bound_set( x, y, omega_old, ibo, bndo, undef )
  call bound_set( x, y, buoy_old, ibb, bndb, undef )

  write(*,*) "normally pass the initialization."

!-- 出力ファイルの初期化
  call HistoryCreate( file=trim(foname), title='Grav. Curr. result data', &
  & source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  & dimsizes=(/nx,ny, 0/),  & 
  & longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'x', x )
  call HistoryPut( 'y', y )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
    & longname='stream line function', units='m2 s-1', xtype='float')

  call HistoryAddVariable( varname='omega', dims=(/'x','y','t'/), &
    & longname='vorticity', units='s-1', xtype='float')

  call HistoryAddVariable( varname='buoy', dims=(/'x','y','t'/), &
    & longname='buoyancy', units='m s-2', xtype='float')

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
    & longname='X wind', units='m s-1', xtype='float')

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
    & longname='Y wind', units='m s-1', xtype='float')

  write(*,*) "time integration start."

  !-- 出力等の処理 (初期値の出力)

  call calc_wind( x, y, psi_old, u_dmp, v_dmp, undef=undef )

  do j=1,ny
     do i=1,nx
        psi_dmp(i,j)=psi_old(i,j)
        omega_dmp(i,j)=omega_old(i,j)
        buoy_dmp(i,j)=buoy_old(i,j)
        psi_new(i,j)=psi_old(i,j)
        omega_new(i,j)=omega_old(i,j)
        buoy_new(i,j)=buoy_old(i,j)
     end do
  end do

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call HistoryPut( 'psi', psi_dmp )
  call HistoryPut( 'omega', omega_dmp )
  call HistoryPut( 'buoy', buoy_dmp )
  call HistoryPut( 'u', u_dmp )
  call HistoryPut( 'v', v_dmp )

!-- solver スタート

  do it=1,nt

     call time_schematic( it )

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        do j=1,ny
           do i=1,nx
              psi_dmp(i,j)=psi_new(i,j)
              omega_dmp(i,j)=omega_new(i,j)
              buoy_dmp(i,j)=buoy_new(i,j)
           end do
        end do

        call calc_wind( x, y, psi_dmp, u_dmp, v_dmp, undef=undef )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dt, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'psi', psi_dmp )
        call HistoryPut( 'omega', omega_dmp )
        call HistoryPut( 'buoy', buoy_dmp )
        call HistoryPut( 'u', u_dmp )
        call HistoryPut( 'v', v_dmp )

     end if

  end do

!-- solver ストップ

  write(*,*) "solver is normally."

end program
