module val_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist

  implicit none

contains

subroutine val_allocate()

  implicit none

  allocate(r_i(nri))     ! 動径座標
  allocate(z_i(nzi))     ! 鉛直座標
  allocate(sst_i(nri))   ! sst 初期データ
  allocate(r_u(nr+1))    ! 動径座標
  allocate(r_s(nr+1))    ! 動径座標
  allocate(z_w(nz+1))    ! 鉛直座標
  allocate(z_s(nz+1))    ! 鉛直座標
  allocate(sst_u(nr+1))  ! sst u
  allocate(sst_s(nr+1))  ! sst s
  allocate(pts(nr+1))    ! 海面温位
  allocate(qvs(nr+1))    ! 海面水蒸気混合比
  allocate(ps(nr+1))     ! 海面気圧
  allocate(us_dmp(nr+1))   ! surface 動径風速 dmp
  allocate(vs_dmp(nr+1))   ! surface 接線風速 dmp
  allocate(ws_dmp(nr+1))   ! surface 鉛直風速 dmp
  allocate(ps_dmp(nr+1))   ! surface 圧力 dmp
  allocate(ts_dmp(nr+1))   ! surface 温位 dmp
  allocate(qvs_dmp(nr+1))  ! surface 水蒸気 dmp
  allocate(qts_dmp(nr+1))  ! surface 凝結水 dmp
  allocate(Tsurf(nr+1))    ! surface temp.

!-- 2d val (prognostic value)
  allocate(u_dmp(nr+1,nz+1))   ! 動径風速 dmp
  allocate(v_dmp(nr+1,nz+1))   ! 接線風速 dmp
  allocate(w_dmp(nr+1,nz+1))   ! 鉛直風速 dmp
  allocate(p_dmp(nr+1,nz+1))   ! 圧力 dmp
  allocate(t_dmp(nr+1,nz+1))   ! 温位 dmp
  allocate(qv_dmp(nr+1,nz+1))  ! 水蒸気 dmp
  allocate(qc_dmp(nr+1,nz+1))  ! 凝結水 dmp
  allocate(ql_dmp(nr+1,nz+1))  ! 凝結水 dmp
  allocate(u_old(nr+1,nz+1))   ! 動径風速 old
  allocate(v_old(nr+1,nz+1))   ! 接線風速 old
  allocate(w_old(nr+1,nz+1))   ! 鉛直風速 old
  allocate(p_old(nr+1,nz+1))   ! 規格化圧力 old
  allocate(t_old(nr+1,nz+1))   ! 温位 old
  allocate(qv_old(nr+1,nz+1))  ! 水蒸気 old
  allocate(qc_old(nr+1,nz+1))  ! 凝結水 old
  allocate(ql_old(nr+1,nz+1))  ! 凝結水 old
  allocate(u_new(nr+1,nz+1))   ! 動径風速 new
  allocate(v_new(nr+1,nz+1))   ! 接線風速 new
  allocate(w_new(nr+1,nz+1))   ! 鉛直風速 new
  allocate(p_new(nr+1,nz+1))   ! 規格化圧力 new
  allocate(t_new(nr+1,nz+1))   ! 温位 new
  allocate(qv_new(nr+1,nz+1))  ! 水蒸気 new
  allocate(qc_new(nr+1,nz+1))  ! 凝結水 new
  allocate(ql_new(nr+1,nz+1))  ! 凝結水 new
  allocate(u_tmp(nr+1,nz+1))   ! 動径風速 tmp
  allocate(v_tmp(nr+1,nz+1))   ! 接線風速 tmp
  allocate(w_tmp(nr+1,nz+1))   ! 鉛直風速 tmp
  allocate(p_tmp(nr+1,nz+1))   ! 規格化圧力 tmp
  allocate(t_tmp(nr+1,nz+1))   ! 温位 tmp
  allocate(qv_tmp(nr+1,nz+1))  ! 水蒸気 tmp
  allocate(qc_tmp(nr+1,nz+1))  ! 凝結水 tmp
  allocate(ql_tmp(nr+1,nz+1))  ! 凝結水 tmp

!-- 2d val (working value)
  allocate(u_u(nr+1,nz+1))   ! 動径風速 u
  allocate(v_u(nr+1,nz+1))   ! 接線風速 u
  allocate(w_u(nr+1,nz+1))   ! 鉛直風速 u
  allocate(p_u(nr+1,nz+1))   ! 規格化圧力 u
  allocate(t_u(nr+1,nz+1))   ! 温位 u
  allocate(qv_u(nr+1,nz+1))  ! 水蒸気 u
  allocate(qc_u(nr+1,nz+1))  ! 凝結水 u
  allocate(ql_u(nr+1,nz+1))  ! 凝結水 u
  allocate(u_s(nr+1,nz+1))   ! 動径風速 s
  allocate(v_s(nr+1,nz+1))   ! 接線風速 s
  allocate(w_s(nr+1,nz+1))   ! 鉛直風速 s
  allocate(p_s(nr+1,nz+1))   ! 規格化圧力 s
  allocate(t_s(nr+1,nz+1))   ! 温位 s
  allocate(qv_s(nr+1,nz+1))  ! 水蒸気 s
  allocate(qc_s(nr+1,nz+1))  ! 凝結水 s
  allocate(ql_s(nr+1,nz+1))  ! 凝結水 s
  allocate(u_w(nr+1,nz+1))   ! 動径風速 w
  allocate(v_w(nr+1,nz+1))   ! 接線風速 w
  allocate(w_w(nr+1,nz+1))   ! 鉛直風速 w
  allocate(p_w(nr+1,nz+1))   ! 規格化圧力 w
  allocate(t_w(nr+1,nz+1))   ! 温位 w
  allocate(qv_w(nr+1,nz+1))  ! 水蒸気 w
  allocate(qc_w(nr+1,nz+1))  ! 凝結水 w
  allocate(ql_w(nr+1,nz+1))  ! 凝結水 w
  allocate(u_c(nr+1,nz+1))   ! 動径風速 c
  allocate(v_c(nr+1,nz+1))   ! 接線風速 c
  allocate(w_c(nr+1,nz+1))   ! 鉛直風速 c
  allocate(p_c(nr+1,nz+1))   ! 規格化圧力 c
  allocate(t_c(nr+1,nz+1))   ! 温位 c
  allocate(qv_c(nr+1,nz+1))  ! 水蒸気 c
  allocate(qc_c(nr+1,nz+1))  ! 凝結水 c
  allocate(ql_c(nr+1,nz+1))  ! 凝結水 c

!-- 2d val (diagnostic value)
  allocate(ub_u(nr+1,nz+1))     ! 動径初期風速 u
  allocate(vb_s(nr+1,nz+1))     ! 接線初期風速 s
  allocate(wb_w(nr+1,nz+1))     ! 鉛直初期風速 w
  allocate(pb_s(nr+1,nz+1))     ! 圧力初期 s
  allocate(ptb_u(nr+1,nz+1))    ! 温位初期 u
  allocate(ptb_s(nr+1,nz+1))    ! 温位初期 s
  allocate(ptb_w(nr+1,nz+1))    ! 温位初期 w
  allocate(pti_u(nr+1,nz+1))    ! 温位初期 u for BUOY
  allocate(pti_s(nr+1,nz+1))    ! 温位初期 s for BUOY
  allocate(pti_w(nr+1,nz+1))    ! 温位初期 w for BUOY
  allocate(qvb_u(nr+1,nz+1))    ! 水蒸気混合比初期 u
  allocate(qvb_s(nr+1,nz+1))    ! 水蒸気混合比初期 s
  allocate(qvb_w(nr+1,nz+1))    ! 水蒸気混合比初期 w
  allocate(qtb_s(nr+1,nz+1))    ! 凝結水混合比初期 s
  allocate(ptv_u(nr+1,nz+1))    ! 仮温位 u
  allocate(ptv_s(nr+1,nz+1))    ! 仮温位 s
  allocate(ptv_w(nr+1,nz+1))    ! 仮温位 w
  allocate(ptv_c(nr+1,nz+1))    ! 仮温位 c
  allocate(ptvb_s(nr+1,nz+1))   ! 仮温位 s
  allocate(ptvb_u(nr+1,nz+1))   ! 仮温位 u
  allocate(ptvb_w(nr+1,nz+1))   ! 仮温位 w
  allocate(pte_u(nr+1,nz+1))    ! 相当温位 u
  allocate(pte_s(nr+1,nz+1))    ! 相当温位 s
  allocate(pte_w(nr+1,nz+1))    ! 相当温位 w
  allocate(pte_c(nr+1,nz+1))    ! 相当温位 c
  allocate(rhob_u(nr+1,nz+1))   ! 密度 u
  allocate(rhob_s(nr+1,nz+1))   ! 密度 s
  allocate(rhob_w(nr+1,nz+1))   ! 密度 w
  allocate(temp_u(nr+1,nz+1))   ! 温度 u
  allocate(temp_s(nr+1,nz+1))   ! 温度 s
  allocate(temp_w(nr+1,nz+1))   ! 温度 w
  allocate(temp_c(nr+1,nz+1))   ! 温度 c
  allocate(tempb_s(nr+1,nz+1))  ! 温度
  allocate(tempb_w(nr+1,nz+1))  ! 温度
  allocate(u_i(nri,nzi))        ! 動径初期速度初期データ
  allocate(v_i(nri,nzi))        ! 接線初期速度初期データ
  allocate(w_i(nri,nzi))        ! 鉛直初期速度初期データ
  allocate(p_i(nri,nzi))        ! 圧力初期データ
  allocate(t_i(nri,nzi))        ! 温位初期データ
  allocate(qv_i(nri,nzi))       ! 水蒸気初期データ
  allocate(qc_i(nri,nzi))       ! 凝結物初期データ
  allocate(ql_i(nri,nzi))       ! 凝結物初期データ

!-- 2d val (force term)
  allocate(force_u(nr+1,nz+1))   ! u forcing term
  allocate(force_v(nr+1,nz+1))   ! v forcing term
  allocate(force_w(nr+1,nz+1))   ! w forcing term
  allocate(force_p(nr+1,nz+1))   ! p forcing term
  allocate(force_t(nr+1,nz+1))   ! t forcing term
  allocate(force_qv(nr+1,nz+1))  ! qv forcing term
  allocate(force_qc(nr+1,nz+1))  ! qt forcing term
  allocate(force_ql(nr+1,nz+1))  ! qt forcing term
  allocate(forcea_u(nr+1,nz+1))  ! u forcing term
  allocate(forcea_v(nr+1,nz+1))  ! v forcing term
  allocate(forcea_w(nr+1,nz+1))  ! w forcing term
  allocate(forcea_p(nr+1,nz+1))  ! p forcing term
  allocate(forcea_t(nr+1,nz+1))  ! t forcing term
  allocate(forcea_qv(nr+1,nz+1)) ! qv forcing term
  allocate(forcea_qc(nr+1,nz+1)) ! qt forcing term
  allocate(forcea_ql(nr+1,nz+1)) ! qt forcing term
  allocate(ADV_u(nr+1,nz+1))     ! ADV u
  allocate(ADV_v(nr+1,nz+1))     ! ADV v
  allocate(ADV_w(nr+1,nz+1))     ! ADV w
  allocate(ADV_t(nr+1,nz+1))     ! ADV t
  allocate(ADV_qv(nr+1,nz+1))    ! ADV qv
  allocate(ADV_qc(nr+1,nz+1))    ! ADV qt
  allocate(ADV_ql(nr+1,nz+1))    ! ADV qt
  allocate(DIFF_u(nr+1,nz+1))    ! DIFF u
  allocate(DIFF_v(nr+1,nz+1))    ! DIFF v
  allocate(DIFF_w(nr+1,nz+1))    ! DIFF w
  allocate(DIFF_t(nr+1,nz+1))    ! DIFF t
  allocate(DIFF_qv(nr+1,nz+1))   ! DIFF qv
  allocate(DIFF_qc(nr+1,nz+1))   ! DIFF qt
  allocate(DIFF_ql(nr+1,nz+1))   ! DIFF qt
  allocate(NUMD_u(nr+1,nz+1))    ! NUMDIFF u
  allocate(NUMD_v(nr+1,nz+1))    ! NUMDIFF v
  allocate(NUMD_w(nr+1,nz+1))    ! NUMDIFF w
  allocate(NUMD_t(nr+1,nz+1))    ! NUMDIFF t
  allocate(NUMD_qv(nr+1,nz+1))   ! NUMDIFF qv
  allocate(NUMD_qc(nr+1,nz+1))   ! NUMDIFF qc
  allocate(NUMD_ql(nr+1,nz+1))   ! NUMDIFF ql
  allocate(GRADP_u(nr+1,nz+1))   ! GRADP u
  allocate(GRADP_w(nr+1,nz+1))   ! GRADP w
  allocate(FLUX_s(nr+1,nz+1))    ! FLUX s
  allocate(SPG_u(nr+1,nz+1))     ! sponge u
  allocate(SPG_v(nr+1,nz+1))     ! sponge v
  allocate(SPG_w(nr+1,nz+1))     ! sponge w
  allocate(SPG_t(nr+1,nz+1))     ! sponge t
  allocate(SPG_qv(nr+1,nz+1))    ! sponge qv
  allocate(SPG_qc(nr+1,nz+1))    ! sponge qt
  allocate(SPG_ql(nr+1,nz+1))    ! sponge qt
  allocate(RAD_t(nr+1,nz+1))     ! radiation t
  allocate(BUOY_w(nr+1,nz+1))    ! Buoyancy w
  allocate(CLOUD_pt(nr+1,nz+1))  ! Cloud physics pt
  allocate(CLOUD_qv(nr+1,nz+1))  ! Cloud physics qv
  allocate(CLOUD_qc(nr+1,nz+1))  ! Cloud physics qc
  allocate(CLOUD_ql(nr+1,nz+1))  ! Cloud physics ql
  allocate(CC_u(nr+1,nz+1))      ! Cori + Centri u
  allocate(CC_v(nr+1,nz+1))      ! Cori + Centri v

end subroutine

end module
