program poison3
! 多重格子法による解析サンプル
  use gtool_history
  use Ellip_Slv
!$  use omp_lib

  implicit none

  integer, parameter :: levelmax=100
  integer :: nx, ny, nz
  integer :: i, j, k, l
  real, allocatable, dimension(:,:,:) :: dmpv
  double precision :: dx, dy, dz
  double precision :: t1, t2, t3, t4, t5
  double precision :: accel, hel_fact
  double precision, allocatable, dimension(:) :: x, y, z
  double precision, allocatable, dimension(:,:,:) :: rho, psi, psit, psia, dpsi, rhom, psim, rhog, psig, psinew, psite, psie, dpsit
  double precision, allocatable, dimension(:,:,:) :: at, bt, ct
  double precision, parameter :: undef=999.0
  integer :: method
  integer :: level, conv_num, add_itr, skipnum, skipnug
  integer :: levelz(levelmax)
  character(6) :: tp
  logical :: ter_flag

  namelist /input /nx,ny,nz,tp,method,ter_flag
  namelist /multi_grid /level, levelz, conv_num, add_itr, accel, hel_fact
  read(5,input)
  read(5,multi_grid)

  allocate(x(nx))
  allocate(y(ny))
  allocate(z(nz))
  allocate(psi(nx,ny,nz))
  allocate(psit(nx,ny,nz))
  allocate(psia(nx,ny,nz))
  allocate(dpsi(nx,ny,nz))
  allocate(dpsit(nx,ny,nz))
  allocate(rho(nx,ny,nz))
  allocate(psie(nx,ny,nz))
  allocate(psite(nx,ny,nz))
  allocate(at(nx,ny,nz))
  allocate(bt(nx,ny,nz))
  allocate(ct(nx,ny,nz))
  allocate(dmpv(nx,ny,nz))

  t1=0.0d0
  t2=0.0d0
  t3=0.0d0
  t4=0.0d0
  t5=0.0d0

  dx=1.0/dble(nx-1)
  dy=1.0/dble(ny-1)
  dz=1.0/dble(nz-1)

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)
  z=(/(dz*(i-1),i=1,nz)/)

  rho=0.0d0
  psia=0.0d0
  at=1.0d0
  bt=1.0d0
  ct=1.0d0
! do i=1,nx
! do j=1,ny
! rho(i,j)=exp(-10.0*((x(i)-0.5)**2+(y(j)-0.5)**2))
! end do
! end do
  do k=1,nz
     do j=1,ny
        do i=1,nx
! org
           if(((((i-(nx-1)/2)**2+(j-(ny-1)/2)**2)*dx*dy)<0.05d0*0.05d0).and.(((k-(nz-1)/2)**2)*dz*dz)<0.05d0*0.05d0)then
              rho(i,j,k)=-1.0d4/8.85d0
           end if

! analysis
!        rho(i,j)=-2.0*((1.0-6.0*x(i)**2)*(y(j)**2)*(1.0-y(j)**2)+(1.0-6.0*y(j)**2)*(x(i)**2)*(1.0-x(i)**2))
!        psia(i,j)=(x(i)**2-x(i)**4)*(y(j)**4-y(j)**2)

        end do
     end do
  end do

!  call cpu_time( t1 )
!$ t1=omp_get_wtime()

  select case (method)
  case(1)
!$ t3=omp_get_wtime()
     !-- Full level solver
!     call Ellip_GauSei_3d(x,y,z,rho,1.0d-8,tp,psit,xa=at,ya=bt,za=ct,ln=1000000)
!     call calc_error_3d(x,y,z,psit,rho,psite,xa=at,ya=bt,za=ct)
!$ t4=omp_get_wtime()

     call Full_Multi_Grid_3d( level, levelz(1:level), x, y, z, rho, 1.0d-8, tp, psi,  &
  &                           xa=at, ya=bt, za=ct, a=ct, b=ct, c=ct, d=ct, e=ct, f=ct, g=hel_fact*ct,  &
!ORG  &                           xa=at, ya=bt, za=ct,  &
  &                           conv_num=conv_num, add_itr=add_itr, accel=accel )
     call calc_error_3d(x,y,z,psi,rho,psie,xa=at,ya=bt,za=ct,  &
  &                     a=ct,b=ct,c=ct,d=ct,e=ct,f=ct,g=hel_fact*ct)
!ORG     call calc_error_3d(x,y,z,psi,rho,psie,xa=at,ya=bt,za=ct)

     dpsi(1:nx,1:ny,1:nz)=psi(1:nx,1:ny,1:nz)-psia(1:nx,1:ny,1:nz)
     dpsit(1:nx,1:ny,1:nz)=psit(1:nx,1:ny,1:nz)-psia(1:nx,1:ny,1:nz)
!$ t5=omp_get_wtime()

  case(2)
     call Ellip_GauSei_3d(x,y,z,rho,1.0d-8,tp,psit,xa=at,ya=bt,za=ct,ln=1000000)
  end select

!  call cpu_time( t2 )
!$ t2=omp_get_wtime()

!$ write(*,*) "Main solver elapse time is ", t2-t1, "[s]."

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ヒストリー作成
    & file='poison.nc', title='poison model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y','z'/), dimsizes=(/nx,ny,nz/),       &
    & longnames=(/'X-coordinate','Y-coordinate','Z-coordinate'/),       &
    & units=(/'m','m','m'/),                             &
    & origin=0.0, interval=0.0 )
 
  call conv_d2f_1d( x, dmpv(1:nx,1,1) ) 
  call HistoryPut( 'x', dmpv(1:nx,1,1) )
  call conv_d2f_1d( y, dmpv(1,1:ny,1) ) 
  call HistoryPut( 'y', dmpv(1,1:ny,1) )
  call conv_d2f_1d( z, dmpv(1,1,1:nz) ) 
  call HistoryPut( 'z', dmpv(1,1,1:nz) )

  call HistoryAddVariable( &                           ! 変数定義
    & varname='psi', dims=(/'x','y','z'/), &
    & longname='psi', units='1', xtype='float')

  call conv_d2f( psi, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('psi',dmpv)                         ! 変数出力
!  call HistoryPut('psi',psi)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='psit', dims=(/'x','y','z'/), &
    & longname='true of psi', units='1', xtype='float')

  call conv_d2f( psit, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('psit',dmpv)                         ! 変数出力
!  call HistoryPut('psit',psit)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='epsit', dims=(/'x','y','z'/), &
    & longname='error of true psi for rho', units='1', xtype='float')

  call conv_d2f( psite, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('epsit',dmpv)                         ! 変数出力
!  call HistoryPut('epsit',psite)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='epsi', dims=(/'x','y','z'/), &
    & longname='error of psi for rho', units='1', xtype='float')

  call conv_d2f( psie, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('epsi',dmpv)                         ! 変数出力
!  call HistoryPut('epsi',psie)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='dpsi', dims=(/'x','y','z'/), &
    & longname='difference between psi and psia', units='1', xtype='float')

  call conv_d2f( dpsi, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('dpsi',dmpv)                         ! 変数出力
!  call HistoryPut('dpsi',dpsi)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='dpsit', dims=(/'x','y','z'/), &
    & longname='difference between psit and psia', units='1', xtype='float')

  call conv_d2f( dpsit, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('dpsit',dmpv)                         ! 変数出力
!  call HistoryPut('dpsit',dpsit)                         ! 変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='rho', dims=(/'x','y','z'/), &
    & longname='forcing', units='1', xtype='float')

  call conv_d2f( rho, dmpv(1:nx,1:ny,1:nz) )
  call HistoryPut('rho',dmpv)                         ! 変数出力
!  call HistoryPut('rho',rho)                         ! 変数出力
  call HistoryClose

  write(*,*) "--------------------------------------------"
  write(*,'(a28,1p,E14.5,a5)') "Main solver running time = ",  &
  &                            (t2-t1), " [s]."
  if(method==1)then
     write(*,*) "This Method is Seidel Method."
     write(*,'(a22,1p,E14.5,a5)') "Seidel running time = ",  &
  &                               (t4-t3), " [s]."
     write(*,'(a19,1p,E14.5,a5)') "FMG running time = ",  &
  &                               (t5-t4), " [s]."
  else
     write(*,*) "This Method is Jacobi Method."
  end if
  write(*,*) "--------------------------------------------"

contains

subroutine conv_d2f_1d( dval, fval )
  implicit none
  double precision, intent(in) :: dval(:)
  real, intent(out) :: fval(size(dval))
  integer :: ii, ix

  ix=size(dval)

  do ii=1,ix
     fval(ii)=real(dval(ii))
  end do

end subroutine conv_d2f_1d

subroutine conv_d2f( dval, fval )
  implicit none
  double precision, intent(in) :: dval(:,:,:)
  real, intent(out) :: fval(size(dval,1),size(dval,2),size(dval,3))
  integer :: ii, jj, kk, ix, jy, kz

  ix=size(dval,1)
  jy=size(dval,2)
  kz=size(dval,3)

  do kk=1,kz
     do jj=1,jy
        do ii=1,ix
           fval(ii,jj,kk)=real(dval(ii,jj,kk))
        end do
     end do
  end do

end subroutine conv_d2f


subroutine calc_error_3d( xl, yl, zl, ul, fl, error, xa, ya, za,  &
  &                       a, b, c, d, e, f, g )
!-- Calculation error for f^l - L^lu^l
  implicit none
  double precision, intent(in) :: xl(:)                  ! X grid on the level grid
  double precision, intent(in) :: yl(:)                  ! Y grid on the level grid
  double precision, intent(in) :: zl(:)                  ! Z grid on the level grid
  double precision, intent(in) :: ul(size(xl),size(yl),size(zl))  ! The initial guess for u on the level grid
  double precision, intent(in) :: fl(size(xl),size(yl),size(zl))  ! The forcing on the level grid
  double precision, intent(out) :: error(size(xl),size(yl),size(zl)) ! The error for fl - Ll(ul)
  double precision, intent(in), optional :: xa(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: ya(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: za(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: a(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: b(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: c(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: d(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: e(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: f(size(xl),size(yl),size(zl))  ! coefficient in PDE
  double precision, intent(in), optional :: g(size(xl),size(yl),size(zl))  ! coefficient in PDE
  integer :: ii, jj, kk, nxl, nyl, nzl
  double precision :: dxi, dyi, dzi
  double precision, dimension(size(xl),size(yl),size(zl)) :: xat, yat, zat, at, bt, ct, dt, et, ft, gt

  !-- Set and Allocate variables
  nxl=size(xl)
  nyl=size(yl)
  nzl=size(zl)
  dxi=1.0d0/(xl(2)-xl(1))
  dyi=1.0d0/(yl(2)-yl(1))
  dzi=1.0d0/(zl(2)-zl(1))

  xat=1.0d0
  yat=1.0d0
  zat=1.0d0
  at=0.0d0
  bt=0.0d0
  ct=0.0d0
  dt=0.0d0
  et=0.0d0
  ft=0.0d0
  gt=0.0d0

  if(present(xa))then
     xat(1:nxl,1:nyl,1:nzl)=xa(1:nxl,1:nyl,1:nzl)
  end if
  if(present(ya))then
     yat(1:nxl,1:nyl,1:nzl)=ya(1:nxl,1:nyl,1:nzl)
  end if
  if(present(za))then
     zat(1:nxl,1:nyl,1:nzl)=za(1:nxl,1:nyl,1:nzl)
  end if
  if(present(a))then
     at(1:nxl,1:nyl,1:nzl)=a(1:nxl,1:nyl,1:nzl)
  end if
  if(present(b))then
     bt(1:nxl,1:nyl,1:nzl)=b(1:nxl,1:nyl,1:nzl)
  end if
  if(present(c))then
     ct(1:nxl,1:nyl,1:nzl)=c(1:nxl,1:nyl,1:nzl)
  end if
  if(present(d))then
     dt(1:nxl,1:nyl,1:nzl)=d(1:nxl,1:nyl,1:nzl)
  end if
  if(present(e))then
     et(1:nxl,1:nyl,1:nzl)=e(1:nxl,1:nyl,1:nzl)
  end if
  if(present(f))then
     ft(1:nxl,1:nyl,1:nzl)=f(1:nxl,1:nyl,1:nzl)
  end if
  if(present(g))then
     gt(1:nxl,1:nyl,1:nzl)=g(1:nxl,1:nyl,1:nzl)
  end if

  error=0.0d0

  do kk=2,nzl-1
     do jj=2,nyl-1
        do ii=2,nxl-1
           error(ii,jj,kk)=fl(ii,jj,kk)  &
  &                       -xat(ii,jj,kk)*(ul(ii+1,jj,kk)+ul(ii-1,jj,kk)-2.0d0*ul(ii,jj,kk))*dxi*dxi  &
  &                       -yat(ii,jj,kk)*(ul(ii,jj+1,kk)+ul(ii,jj-1,kk)-2.0d0*ul(ii,jj,kk))*dyi*dyi  &
  &                       -zat(ii,jj,kk)*(ul(ii,jj,kk+1)+ul(ii,jj,kk-1)-2.0d0*ul(ii,jj,kk))*dzi*dzi  &
  &                       -at(ii,jj,kk)*(ul(ii+1,jj+1,kk)+ul(ii-1,jj-1,kk)  &
  &                                    -(ul(ii-1,jj+1,kk)+ul(ii+1,jj-1,kk)))*0.25d0*dxi*dyi  &
  &                       -bt(ii,jj,kk)*(ul(ii,jj+1,kk+1)+ul(ii,jj-1,kk-1)  &
  &                                    -(ul(ii,jj-1,kk+1)+ul(ii,jj+1,kk-1)))*0.25d0*dyi*dzi  &
  &                       -ct(ii,jj,kk)*(ul(ii+1,jj,kk+1)+ul(ii-1,jj,kk-1)  &
  &                                    -(ul(ii+1,jj,kk-1)+ul(ii-1,jj,kk+1)))*0.25d0*dzi*dxi  &
  &                       -dt(ii,jj,kk)*(ul(ii+1,jj,kk)-ul(ii-1,jj,kk))*0.5d0*dxi  &
  &                       -et(ii,jj,kk)*(ul(ii,jj+1,kk)-ul(ii,jj-1,kk))*0.5d0*dyi  &
  &                       -ft(ii,jj,kk)*(ul(ii,jj,kk+1)-ul(ii,jj,kk-1))*0.5d0*dzi  &
  &                       -gt(ii,jj,kk)*ul(ii,jj,kk)
        end do
     end do
  end do

end subroutine calc_error_3d


end program
