module Poly_Function  ! 𑽍vZTu[`W

  use special_function

interface CHEBYSHEV

  module procedure CHEBYSHEV_f, CHEBYSHEV_d

end interface

interface GEGENBAUER

  module procedure GEGENBAUER_f, GEGENBAUER_d

end interface

interface HERMITE

  module procedure HERMITE_f, HERMITE_d

end interface

interface JACOBI_POLY

  module procedure JACOBI_POLY_f, JACOBI_POLY_d

end interface

interface LAGUERRE

  module procedure LAGUERRE_f, LAGUERRE_d

end interface

interface LEGENDRE

  module procedure LEGENDRE_f, LEGENDRE_d

end interface

interface AS_LEGENDRE

  module procedure AS_LEGENDRE_f, AS_LEGENDRE_d

end interface

interface SONINE

  module procedure SONINE_f, SONINE_d

end interface


contains
subroutine CHEBYSHEV_f(n, x, che)
!****************************************
!*** `FrVFtQ̃Tu[` ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! vZ`FrVFt̍ō
  real, intent(in) :: x(:)  ! `FrVFẗ
  real, intent(inout) :: che(0:n,size(x))  ! vZ`FrVFt
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     che(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end  subroutine

subroutine CHEBYSHEV_d(n, x, che)
!****************************************
!*** `FrVFtQ̃Tu[` ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! vZ`FrVFt̍ō
  double precision, intent(in) :: x(:)  ! `FrVFẗ
  double precision, intent(inout) :: che(0:n,size(x))
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     che(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0d0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine GEGENBAUER_f(n, x, p, lambda)
!************************************
!*  Q[QoEA[ vZTu[`  *
!************************************
!* g
!* n=(0w\)
!************************************
  implicit none
  integer, intent(in) :: n  ! vZQ[QoEA[̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: lambda  ! Q[QoEA[W
  real, intent(inout) :: p(0:n,size(x))  ! vZQ[QoEA[
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*lambda*x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(2.0*(lambda+real(j))*x(i)*p(j,i)  &
     &               -(2.0*lambda+real(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine

subroutine GEGENBAUER_d(n, x, p, lambda)
!************************************
!*  Q[QoEA[ vZTu[`  *
!************************************
!* g
!* n=(0w\)
!************************************
  implicit none
  integer, intent(in) :: n  ! vZQ[QoEA[̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: lambda  ! Q[QoEA[W
  double precision, intent(inout) :: p(0:n,size(x))  ! vZQ[QoEA[
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*lambda*x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(2.0d0*(lambda+dble(j))*x(i)*p(j,i)  &
     &               -(2.0d0*lambda+dble(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE_f(n, x, p)
!************************************
!*  Hermite vZTu[`  *
!************************************
!* g
!* n=(0w\)
!************************************
  implicit none
  integer, intent(in) :: n  ! vZ Hermite ̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! vZ Hermite 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0*(x(i)*p(j,i)-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE_d(n, x, p)
!************************************
!*  Hermite vZTu[`  *
!************************************
!* g
!* n=(0w\)
!************************************
  implicit none
  integer, intent(in) :: n  ! vZ Hermit ̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! vZ Hermit 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0d0*(x(i)*p(j,i)-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine JACOBI_POLY_f(n, x, p, alpha, beta)
!***********************************
!  Jacobi vZTu[`   *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  real, intent(in) :: alpha  ! 
  real, intent(in) :: beta  ! 
  real :: gamma, omega
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- W̐ݒ ---
  gamma=alpha+beta
  omega=alpha-beta

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5*((gamma+2.0)*x(i)+omega)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5/(real(j+1)*real(j+1+gamma)*real(2.0*j+gamma)))  &
     &                 *((2.0*j+gamma+1.0)  &
     &                 *(gamma*omega+(2.0*j+gamma)*(2.0*(j+1)+gamma)*x(i))  &
     &                 *p(j,i)  &
     &                 -2.0*(j+alpha)*(j+beta)*(2.0*(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine



subroutine JACOBI_POLY_d(n, x, p, alpha, beta)
!***********************************
!  Jacobi vZTu[`   *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  double precision, intent(in) :: alpha  ! 
  double precision, intent(in) :: beta  ! 
  double precision :: gamma, omega
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- W̐ݒ ---
  gamma=alpha+beta
  omega=alpha-beta

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5d0*((gamma+2.0d0)*x(i)+omega)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5d0/(dble(j+1)*dble(j+1+gamma)*dble(2.0*j+gamma)))  &
     &                 *((2.0d0*dble(j)+gamma+1.0d0)  &
     &                 *(gamma*omega+(2.0d0*dble(j)+gamma)  &
     &                 *(2.0d0*dble(j+1)+gamma)*x(i))*p(j,i)  &
     &                 -2.0d0*dble(j+alpha)*dble(j+beta)  &
     &                 *(2.0d0*dble(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE_f(n, x, p)
!***********************************
!  Laguerre vZTu[` *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0-x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0*real(j)+1.0-x(i))*p(j,i)  &
     &                 -((real(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE_d(n, x, p)
!***********************************
!  Laguerre vZTu[` *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0d0-x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -((dble(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE_f(n, x, p)
!***********************************
!  Legendre vZTu[` *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(p(j,i)*(2.0*real(j)+1.0)  &
     &                 *(p(1,i))-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE_d(n, x, p)
!***********************************
!  Legendre vZTu[` *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(p(j,i)*(2.0d0*dble(j)+1.0d0)  &
     &                 *(p(1,i))-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine

subroutine AS_LEGENDRE_f(n, m, x, p)
!***********************************
!  Legendre ֐vZTu[` *
!***********************************
! g
! n=(0w\)
! m=(n>=m)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  use special_function
  implicit none
  integer, intent(in) :: n  ! vZ legendre ֐̍ō
  integer, intent(in) :: m  ! vZ legendre ֐̐
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(abs(m):n,size(x))  ! vZ legendre ֐
  integer :: i, j, abm
  integer :: nmax  ! z x ̗vf
  real :: coe

  nmax=size(x)
  abm=abs(m)

  if(abm>n)then
     write(*,*) "### ERROR : subroutine AS_LEGENDRE ###"
     write(*,*) "P^m_n : m must be less than n, stop."
     stop
  end if

!-- m ɂĂ 2 KvZ

  coe=1.0

  if(abm>1)then
     do i=2,abm
        coe=(2.0*real(i)-1.0)*coe
     end do
  end if

!-- m=0 ̏ꍇ̓WhƓȂ̂, 𗬗p.

  if(m==0)then
     call Legendre_f( n, x, p(:,:) )
  else

  !-- ȉ, m/=0̏ꍇ̌vZ.
  !-- ̐ݒ ---

     do i=1,nmax
        p(abm,i)=sqrt(coe*(1.0-x(i)**2)**abm)
     end do

     if(abm<n)then  ! |m|<n ̏ꍇ̌vZ.

        do i=1,nmax
           p(abm+1,i)=p(abm,i)*(2.0*real(abm)+1.0)*x(i)
        end do

        if(abm+1<n)then  ! |m+1|<n ̏ꍇ̌vZ.

        !-- Q̌vZ ---
           do j=abm+1,n-1
              do i=1,nmax
                 p(j+1,i)=(1.0/real(j-abm+1))*(p(j,i)*(2.0*real(j)+1.0)  &
     &                      *x(i)-real(j+abm)*p(j-1,i))
              end do
           end do

        end if
     end if

     if(m<0)then  ! ̏ꍇ̒ǉvZ
        coe=real(kaijo_i(n-m))/real(kaijo_i(n+m))

        if(mod(m,2)==0)then
           do j=abm,n
              do i=1,nmax
                 p(j,i)=coe*p(j,i)
              end do
           end do
        else
           do j=abm,n
              do i=1,nmax
                 p(j,i)=-coe*p(j,i)
              end do
           end do
        end if

     end if

  end if

end subroutine


subroutine AS_LEGENDRE_d(n, m, x, p)
!***********************************
!  Legendre vZTu[` *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  use special_function
  implicit none
  integer, intent(in) :: n  ! vZ legendre ֐̍ō
  integer, intent(in) :: m  ! vZ legendre ֐̐
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(abs(m):n,size(x))  ! vZ legendre ֐
  integer :: i, j, abm
  integer :: nmax  ! z x ̗vf
  double precision :: coe

  nmax=size(x)
  abm=abs(m)

  if(abm>n)then
     write(*,*) "### ERROR : subroutine AS_LEGENDRE ###"
     write(*,*) "P^m_n : m must be less than n, stop."
     stop
  end if

!-- m ɂĂ 2 KvZ

  coe=1.0d0

  if(abm>1)then
     do i=2,abm
        coe=(2.0d0*dble(i)-1.0d0)*coe
     end do
  end if

!-- m=0 ̏ꍇ̓WhƓȂ̂, 𗬗p.

  if(m==0)then
     call Legendre_d( n, x, p(:,:) )
  else

  !-- ȉ, m/=0̏ꍇ̌vZ.
  !-- ̐ݒ ---

     do i=1,nmax
        p(abm,i)=dsqrt(coe*(1.0d0-x(i)**2)**abm)
     end do

     if(abm<n)then  ! |m|<n ̏ꍇ̌vZ.

        do i=1,nmax
           p(abm+1,i)=p(abm,i)*(2.0d0*dble(abm)+1.0d0)*x(i)
        end do

        if(abm+1<n)then  ! |m+1|<n ̏ꍇ̌vZ.

        !-- Q̌vZ ---
           do j=abm+1,n-1
              do i=1,nmax
                 p(j+1,i)=(1.0d0/dble(j-abm+1))*(p(j,i)*(2.0d0*dble(j)+1.0d0)  &
     &                      *x(i)-dble(j+abm)*p(j-1,i))
              end do
           end do

        end if
     end if

     if(m<0)then  ! ̏ꍇ̒ǉvZ
        coe=dble(kaijo_i(n-m))/dble(kaijo_i(n+m))

        if(mod(m,2)==0)then
           do j=abm,n
              do i=1,nmax
                 p(j,i)=coe*p(j,i)
              end do
           end do
        else
           do j=abm,n
              do i=1,nmax
                 p(j,i)=-coe*p(j,i)
              end do
           end do
        end if

     end if

  end if

end subroutine


subroutine SONINE_f(n, x, p, lambda)
!***********************************
!  Sonine vZTu[`  *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  real, intent(in) :: lambda  ! 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0-x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))  &
     &                 *((lambda+2.0*j+1.0-x(i))*p(j,i)  &
     &                 -(j+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine SONINE_d(n, x, p, lambda)
!***********************************
!  Sonine vZTu[`  *
!***********************************
! g
! n=(0w\)
! nmax=Ԋiq_
! p=p(0:n,nmax) 2z
!***********************************
  implicit none
  integer, intent(in) :: n  ! vZ jacobi ̍ō
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! vZ Jacobi 
  double precision, intent(in) :: lambda  ! 
  integer :: i, j
  integer :: nmax  ! z x ̗vf

  nmax=size(x)

!-- ̐ݒ ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0d0-x(i)
     end do

     if(n > 1)then
!-- Q̌vZ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))  &
     &                 *((lambda+2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -(dble(j)+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine ymn( n, m, x, y, p )
! ʒa֐vZ郋[`
  implicit none
  integer, intent(in) :: n  ! ܓx̔g
  integer, intent(in) :: m  ! ox̔g
  real, intent(in) :: x(:)  ! oxϐ [0<=x<=2*pi]
  real, intent(in) :: y(:)  ! ܓxϐ [-1<=y<=1]
  complex, intent(inout) :: p(0:n,-m:m,size(x),size(y))  ! ʒa֐
  integer :: nmax, mmax
  integer :: i, j, k, l
  complex, parameter :: img=(0.0,1.0)
  real :: pm(0:n,-m:m,size(y))

  nmax=size(x)
  mmax=size(y)

!-- Wh֐vZ.
  do j=-m,m
     call AS_Legendre( n, j, y, pm(abs(j):n,j,:) )
  end do

  do l=-m,m
     do k=abs(l),n
        do j=1,mmax
           do i=1,nmax
              p(k,l,i,j)=pm(k,l,j)*(cos(real(m)*x(i))+img*(sin(real(m)*x(i))))
           end do
        end do
     end do
  end do

end subroutine


subroutine gauss_lat( n, lat, eps )
! KEXܓxvZ郋[`
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! KEXܓx̕_̐
  real, intent(inout) :: lat(n)  ! KEXܓx̊e_ł̈ܓx [degree]
  real, intent(in), optional :: eps  ! j[g@ł̃[_l
                                ! ftHg 1.0e-6.
  real :: tmp(0:n,1)
  real :: nu(1)
  integer :: k
  real :: diff, eps_max

  if(present(eps))then
     eps_max=eps
  else
     eps_max=1.0e-6
  end if

  do k=1,n  ! k Ԗڂ̕_

     nu(1)=cos((pi*(4.0*real(k)-1.0))/(4.0*real(n)+2.0))
     call legendre( n, nu(1:1), tmp(0:n,1:1) )

     do while (eps_max<=tmp(n,1))
        diff=(1.0-nu(1)**2)/(real(n)*(tmp(n-1,1)-nu(1)*tmp(n,1)))
        nu(1)=nu(1)-tmp(n,1)*diff
        call legendre( n, nu(1:1), tmp(0:n,1:1) )
     end do

     lat(k)=asin(nu(1))*180.0/pi

  end do

end subroutine




end module
